/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sybase.plan;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.statements.BarrenStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.base.plan.AbstractExplainPlanProvider;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.sybase.plan.AsePlanModelBuilder;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AseExplainPlanProvider
extends AbstractExplainPlanProvider {
    public AseExplainPlanProvider() {
        super(Dbms.SYBASE);
    }

    @Override
    public AbstractPlanModelBuilder<?, ?> createBuilder(@NotNull Version version, boolean run2) {
        if (version == null) {
            AseExplainPlanProvider.$$$reportNull$$$0(0);
        }
        return new AsePlanModelBuilder();
    }

    public DdlBuilder sqlExplainPlan(@NotNull LocalDataSource dataSource, @NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (dataSource == null) {
            AseExplainPlanProvider.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            AseExplainPlanProvider.$$$reportNull$$$0(2);
        }
        if (statement == null) {
            AseExplainPlanProvider.$$$reportNull$$$0(3);
        }
        builder.keywords(new String[]{"set", "statement_cache", "off"}).newLine();
        builder.keywords(new String[]{"set", "showplan", "on"}).newLine();
        if (!analyze) {
            builder.keywords(new String[]{"set", "noexec", "on"}).newLine();
        }
        builder.keywords(new String[]{"go"}).newLine();
        builder.plain(statement).newLine();
        builder.keywords(new String[]{"go"}).newLine();
        return builder;
    }

    @Nullable
    public DataRequest.RawRequest sqlPostExplainPlan(@NotNull DataRequest.OwnerEx owner, final boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (owner == null) {
            AseExplainPlanProvider.$$$reportNull$$$0(4);
        }
        return new DataRequest.RawRequest(owner){

            public void processRaw(DataRequest.Context context, DatabaseConnection connection) throws Exception {
                BarrenStatement.QuietBarrenStatement stmt2 = SmartStatements.poweredBy((DatabaseConnection)connection).simple().barren().quiet();
                stmt2.execute((Object)((!analyze ? "set noexec off\n" : "") + "set showplan off"));
                stmt2.execute((Object)"set statement_cache on");
            }
        };
    }

    public boolean isSupported(@NotNull Version version, boolean run2) {
        if (version == null) {
            AseExplainPlanProvider.$$$reportNull$$$0(5);
        }
        return true;
    }

    public boolean isRawSupported(@NotNull Version version, boolean run2) {
        if (version == null) {
            AseExplainPlanProvider.$$$reportNull$$$0(6);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/sybase/plan/AseExplainPlanProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createBuilder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "sqlExplainPlan";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "sqlPostExplainPlan";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isRawSupported";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

