/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.dialects.sqlite.model.SqliteRoutine;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqliteDialect
extends AbstractDatabaseDialect {
    public SqliteDialect() {
        super(new TypeHelper.SQLiteTypeHelper());
    }

    @NotNull
    public String getDisplayName() {
        return "SQLite";
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.SQLITE;
        if (dbms == null) {
            SqliteDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @Override
    protected void sqlParameters(@NotNull DdlBuilder builder, @NotNull DasRoutine routine2, boolean longMode) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(1);
        }
        if (routine2 == null) {
            SqliteDialect.$$$reportNull$$$0(2);
        }
        super.sqlParameters(builder, routine2, longMode);
        if (routine2 instanceof SqliteRoutine && ((SqliteRoutine)routine2).isVariadic()) {
            builder.plain("...");
        }
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element) {
        if (element == null) {
            SqliteDialect.$$$reportNull$$$0(3);
        }
        Pair pair = Pair.create((Object)("select GROUP_CONCAT(s, ';\n') from (select sql as s from sqlite_master where tbl_name = '" + StringUtil.toLowerCase((String)element.getName()).replace("'", "''") + "' and (type = 'table' or type = 'index') order by type desc)"), (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            SqliteDialect.$$$reportNull$$$0(4);
        }
        return pair;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(5);
        }
        if (sequence == null) {
            SqliteDialect.$$$reportNull$$$0(6);
        }
        throw new UnsupportedOperationException(DatabaseBundle.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            SqliteDialect.$$$reportNull$$$0(7);
        }
        Pair pair = Pair.create((Object)("select sql as s from sqlite_master where tbl_name = '" + StringUtil.toLowerCase((String)element.getName()).replace("'", "''") + "' and type = 'view'"), (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            SqliteDialect.$$$reportNull$$$0(8);
        }
        return pair;
    }

    public boolean supportsProcedureDefinition() {
        return false;
    }

    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            SqliteDialect.$$$reportNull$$$0(9);
        }
        throw new UnsupportedOperationException(DatabaseBundle.message((String)"ddl.error.procedure.definition", (Object[])new Object[]{this.getDisplayName()}));
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(@NotNull DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(10);
        }
        if (identifier == null) {
            SqliteDialect.$$$reportNull$$$0(11);
        }
        if (qualifier == null) {
            SqliteDialect.$$$reportNull$$$0(12);
        }
        DdlBuilder ddlBuilder = builder.identifier(object, identifier);
        if (ddlBuilder == null) {
            SqliteDialect.$$$reportNull$$$0(13);
        }
        return ddlBuilder;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean hasRowId(@Nullable Version version) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/sqlite/SqliteDialect";
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/sqlite/SqliteDialect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTableDefinition";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlViewDefinition";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameters";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sqlTableDefinition";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

