/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.snowflake;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DatabaseDialectHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class SFlakeDialectHelper
extends DatabaseDialectHelper {
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) throws SQLException {
        String schema;
        String db;
        if (system == null) {
            SFlakeDialectHelper.$$$reportNull$$$0(0);
        }
        if (connection == null) {
            SFlakeDialectHelper.$$$reportNull$$$0(1);
        }
        try {
            db = connection.getRemoteConnection().getCatalog();
            schema = connection.getRemoteConnection().getSchema();
        }
        catch (RemoteException e2) {
            ExceptionUtil.rethrow((Throwable)RemoteUtil.unwrap((Throwable)e2));
            return null;
        }
        if (StringUtil.isEmpty((String)db)) {
            return null;
        }
        ObjectPath dbPath = ObjectPath.create((String)db, (ObjectKind)ObjectKind.DATABASE);
        if (StringUtil.isEmpty((String)schema)) {
            return SearchPath.of((ObjectPath)dbPath);
        }
        ObjectPath scPath = dbPath.append(schema, ObjectKind.SCHEMA);
        if ("PUBLIC".equals(schema)) {
            return SearchPath.of((ObjectPath)scPath);
        }
        return SearchPath.of(Arrays.asList(scPath, dbPath.append("PUBLIC", ObjectKind.SCHEMA)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "system";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/snowflake/SFlakeDialectHelper";
        objectArray[2] = "tryToLoadSearchPath";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

