/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redshift.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.postgresbase.model.PgBaseModelHelper;
import com.intellij.database.dialects.postgresbase.model.PgBaseObjectEditorFactory;
import com.intellij.database.dialects.redshift.model.RsExternalTable;
import com.intellij.database.dialects.redshift.model.properties.RsExternalTableStorageType;
import com.intellij.database.model.ModelHelperCore;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.schemaEditor.DbObjectEditorFactory;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/redshift/model/RsModelHelper;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModelHelper;", "()V", "oef", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseObjectEditorFactory;", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "Lcom/intellij/database/model/ModelHelperCore$ObjectKindVariant;", "vars", "", "", "getName", "kind", "Lcom/intellij/database/model/ObjectKind;", "getObjectEditorFactory", "Lcom/intellij/database/schemaEditor/DbObjectEditorFactory;", "intellij.database.dialects.redshift"})
public final class RsModelHelper
extends PgBaseModelHelper {
    private static final PgBaseObjectEditorFactory oef;
    @NotNull
    public static final RsModelHelper INSTANCE;

    @NotNull
    public String getName(@NotNull ObjectKind kind) {
        String string;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        ObjectKind objectKind = kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_TABLE)) {
            String string2 = DatabaseBundle.message((String)"ObjectKind.external.table", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DatabaseBundle.message(\"\u2026jectKind.external.table\")");
        } else {
            String string3 = super.getName(kind);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"super.getName(kind)");
        }
        return string;
    }

    public void fillPropertiesWithExamples(@NotNull BasicModElement e2, @NotNull ModelHelperCore.ObjectKindVariant variant, @NotNull Map<String, String> vars) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        super.fillPropertiesWithExamples(e2, variant, vars);
        if (e2 instanceof RsExternalTable) {
            this.setTemplateName(((RsExternalTable)e2).getSchema(), "schema_name");
            String string = ((RsExternalTable)e2).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.name");
            vars.put(string, "schema_name." + ((RsExternalTable)e2).getName());
            ((RsExternalTable)e2).setStorageType(RsExternalTableStorageType.PARQUET);
            vars.put("storage_type", "parquet");
            ((RsExternalTable)e2).setSerializationLib("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
            vars.put("serialisation_lib", ScriptGeneratorHelperKt.getSqlString("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe"));
        }
    }

    @NotNull
    public DbObjectEditorFactory getObjectEditorFactory() {
        return oef;
    }

    private RsModelHelper() {
    }

    static {
        RsModelHelper rsModelHelper;
        INSTANCE = rsModelHelper = new RsModelHelper();
        oef = new PgBaseObjectEditorFactory();
    }
}

