/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.plan;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.base.plan.RawPlanData;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PgBaseRawPlanData
extends RawPlanData {
    public final List<String> lines = new ArrayList<String>();

    @Override
    public void load(@NotNull DatabaseConnection connection, @NotNull String statement, boolean run2) {
        if (connection == null) {
            PgBaseRawPlanData.$$$reportNull$$$0(0);
        }
        if (statement == null) {
            PgBaseRawPlanData.$$$reportNull$$$0(1);
        }
        this.lines.clear();
        PgBaseRawPlanData.useStatementWithPreserved(connection, s -> s.noisy().execute((Object)("EXPLAIN " + (run2 ? "ANALYSE " : "") + statement), PgBaseRawPlanData.processing((ThrowableConsumer<? super RemoteResultSet, ? extends Exception>)((ThrowableConsumer)rs -> {
            if (!rs.next()) {
                PgBaseRawPlanData.failWithEmptyResultSetError();
            }
            if (rs.getMetaData().getColumnCount() != 1) {
                throw new PlanRetrievalException("Database returned data in unknown format");
            }
            do {
                String res2;
                if ((res2 = rs.getString(1)) == null) {
                    throw new PlanRetrievalException("Database returned null plan");
                }
                this.lines.add(res2);
            } while (rs.next());
        }))), new RawPlanData.StateSaver[0]);
    }

    @Override
    public void load(@NotNull String dump) {
        if (dump == null) {
            PgBaseRawPlanData.$$$reportNull$$$0(2);
        }
        this.lines.clear();
        ContainerUtil.addAll(this.lines, (Object[])Pattern.compile("\\r?\\n").split(dump));
    }

    @Override
    public String dump() {
        return StringUtil.join(this.lines, (String)"\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "statement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "dump";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/postgresbase/plan/PgBaseRawPlanData";
        objectArray[2] = "load";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MetaNode {
        final int line;
        final int end;
        int firstChild;
        int prematureEnd;
        public final int indent;
        String tp;

        public MetaNode(int line, int end, int indent) {
            this.line = line;
            this.end = end;
            this.firstChild = end;
            this.prematureEnd = end;
            this.indent = indent;
        }
    }
}

