/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase;

import com.google.common.collect.Iterables;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialectHelper;
import com.intellij.database.dialects.PgDialectHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.JBIterable;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PgDialectHelperBase
extends DatabaseDialectHelper {
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        if (table == null) {
            PgDialectHelperBase.$$$reportNull$$$0(0);
        }
        if (connection == null) {
            PgDialectHelperBase.$$$reportNull$$$0(1);
        }
        String string = PgDialectHelper.getTableDefinition((DasTable)table, (DatabaseConnection)connection);
        if (string == null) {
            PgDialectHelperBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            PgDialectHelperBase.$$$reportNull$$$0(3);
        }
        if (connection == null) {
            PgDialectHelperBase.$$$reportNull$$$0(4);
        }
        Dbms dbms = connection.getDbms();
        Map map2 = DbImplUtil.resultRowAsMap((DatabaseConnection)connection, (String)String.format("SELECT CAST(reltuples as INT) as rows FROM pg_catalog.pg_class C\n  LEFT JOIN pg_catalog.pg_namespace N ON (N.oid = C.relnamespace)\nWHERE (relkind = 'r' OR relkind = 'v') AND nspname LIKE '%s' ESCAPE '#' AND relname LIKE '%s' ESCAPE '#'", DbImplUtil.escapeSql((Object)DasUtil.getSchema((DasObject)element), (boolean)true, (Dbms)dbms), DbImplUtil.escapeSql((Object)element.getName(), (boolean)true, (Dbms)dbms)), (String[])new String[0]);
        if (map2 == null) {
            PgDialectHelperBase.$$$reportNull$$$0(5);
        }
        return map2;
    }

    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) throws SQLException {
        if (system == null) {
            PgDialectHelperBase.$$$reportNull$$$0(6);
        }
        if (connection == null) {
            PgDialectHelperBase.$$$reportNull$$$0(7);
        }
        Map map2 = DbImplUtil.resultRowAsMap((DatabaseConnection)connection, (String)"select current_database() as a, current_schemas(false) as b", (String[])new String[0]);
        String db = String.valueOf(map2.get("a"));
        Object[] schemas2 = (Object[])ObjectUtils.tryCast(map2.get("b"), Object[].class);
        if (StringUtil.isEmpty((String)db) || schemas2 == null || schemas2.length == 0) {
            return null;
        }
        ObjectPath dbPath = ObjectPath.create((String)db, (ObjectKind)ObjectKind.DATABASE);
        return SearchPath.of((List)JBIterable.of((Object[])schemas2).filter(String.class).transform(s -> dbPath.append(s, ObjectKind.SCHEMA)).toList());
    }

    @NotNull
    public String tryToLoadProcedureDefinition(@NotNull DasRoutine proc, @NotNull DatabaseConnection connection) throws Exception {
        DdlBuilder builder;
        Version curVersion;
        block6: {
            String string;
            if (proc == null) {
                PgDialectHelperBase.$$$reportNull$$$0(8);
            }
            if (connection == null) {
                PgDialectHelperBase.$$$reportNull$$$0(9);
            }
            Dbms dbms = connection.getDbms();
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((Dbms)dbms);
            curVersion = connection.getVersion();
            builder = new DdlBuilder().withDialect(dialect).qualifyReferences(true);
            try {
                if (!curVersion.isOrGreater(new int[]{8, 4})) break block6;
                string = DbImplUtil.concatStringResults((DatabaseConnection)connection, (Dbms)dbms, (String)("SELECT pg_get_functiondef(p.oid) FROM pg_proc p JOIN pg_namespace n ON n.oid=pronamespace WHERE proname = " + PgDialectHelper.str((String)proc.getName()) + " AND nspname = " + PgDialectHelper.str((String)DasUtil.getSchema((DasObject)proc))), (int)0, (DbImplUtilCore.ConcatenationProps)DbImplUtilCore.ConcatenationProps.LINES);
            }
            catch (Exception e2) {
                Logger.getInstance(((Object)((Object)this)).getClass()).info((Throwable)e2);
            }
            if (string == null) {
                PgDialectHelperBase.$$$reportNull$$$0(10);
            }
            return string;
        }
        boolean isPre81 = Version.of((int[])new int[]{8, 0}).isOrGreater(curVersion);
        int limit = Math.max(10, Iterables.size((Iterable)proc.getArguments())) + 5;
        String s = "SELECT proname, proisagg, prosecdef, proisstrict, proretset, provolatile, pronargs, prosrc, probin,\n       lanname, \n" + PgDialectHelper.typeArg((String)"tr", (String)"rettype", (String)"prorettype", (boolean)isPre81) + ",\n" + PgDialectHelper.select((int)limit, (boolean)isPre81) + "\n       " + (isPre81 ? "null dummy" : "proargmodes, pg_catalog.pg_get_expr(proargdefaults, 0) as proargdefaults") + "\n  FROM pg_proc\n  JOIN pg_namespace nsp ON nsp.oid=pronamespace\n  JOIN pg_language l ON l.oid=prolang\n" + PgDialectHelper.joinType((String)"tr", (String)"prorettype", (boolean)isPre81) + "\n" + PgDialectHelper.join((int)limit, (boolean)isPre81) + "  WHERE proname = " + PgDialectHelper.str((String)proc.getName()) + " AND nsp.nspname = " + PgDialectHelper.str((String)DasUtil.getSchema((DasObject)proc)) + "\n";
        SmartStatements.poweredBy((DatabaseConnection)connection).simple().noisy().execute((Object)s, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.results(rs -> {
            while (rs.next()) {
                builder.keywords(new String[]{"CREATE", "OR", "REPLACE", "FUNCTION"}).space().qualifiedRef((DasObject)proc).symbol("(");
                PgDialectHelper.SignatureBuilder signatureBuilder = new PgDialectHelper.SignatureBuilder(isPre81, rs);
                signatureBuilder.buildArguments(builder);
                builder.symbol(")").newLine().space(2).keyword("RETURNS").space();
                signatureBuilder.buildReturn(builder);
                String language = rs.getString("lanname");
                String src2 = ((String)ObjectUtils.notNull((Object)rs.getString("prosrc"), (Object)"")).trim();
                if ("c".equals(language)) {
                    builder.newLine().keyword("AS").newLine().symbol("'").plain(rs.getString("probin")).symbol("'").symbol(",").space().symbol("'").plain(src2).symbol("'");
                } else {
                    builder.newLine().keyword("AS").newLine().plain("$BODY$").newLine().plain(src2).newLine().plain("$BODY$").newLine().keyword("LANGUAGE").space().plain(language).space();
                }
                String provolatile = rs.getString("provolatile");
                if ("v".equals(provolatile)) {
                    builder.keyword("VOLATILE");
                } else if ("i".equals(provolatile)) {
                    builder.keyword("IMMUTABLE");
                } else {
                    builder.keyword("STABLE");
                }
                if (rs.getBoolean("proisstrict")) {
                    builder.space().keyword("STRICT");
                }
                if (rs.getBoolean("prosecdef")) {
                    builder.space().keyword("SECURITY DEFINER");
                }
                builder.newStatement();
            }
        }));
        String string = builder.getStatement();
        if (string == null) {
            PgDialectHelperBase.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection) throws SQLException {
        if (connection == null) {
            PgDialectHelperBase.$$$reportNull$$$0(12);
        }
        List list = (List)DbImplUtil.executeAndGetResult((DatabaseConnection)connection, (String)"SELECT datname as name FROM pg_database WHERE datistemplate = false", (ThrowableConvertor)DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            PgDialectHelperBase.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgresbase/PgDialectHelperBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgresbase/PgDialectHelperBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadProcedureDefinition";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadProcedureDefinition";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

