/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase;

import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PgDialectBase
extends AbstractDatabaseDialect {
    private static final int FRACTIONAL_SECONDS_PRECISION_MAX = 6;

    protected PgDialectBase(@NotNull TypeHelper typeHelper) {
        if (typeHelper == null) {
            PgDialectBase.$$$reportNull$$$0(0);
        }
        super(typeHelper);
    }

    @Override
    public String getBinaryLiteralString(byte @NotNull [] binaryData) {
        if (binaryData == null) {
            PgDialectBase.$$$reportNull$$$0(1);
        }
        return "E'\\\\x" + DialectUtils.toHexString((byte[])binaryData) + "'";
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            PgDialectBase.$$$reportNull$$$0(2);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                PgDialectBase.$$$reportNull$$$0(3);
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        if (jdbcType == -7 && "bool".equals(typeName)) {
            return "bool";
        }
        if (jdbcType == -5 && "oid".equals(typeName)) {
            return "oid";
        }
        if (jdbcType == 93 || jdbcType == 92) {
            int fractionalSecondsPrecision = dataType.getScale();
            String string = JdbcUtil.getJdbcTypeName((DataType)dataType, (boolean)false) + (String)(fractionalSecondsPrecision != 6 ? "(" + fractionalSecondsPrecision + ")" : "");
            if (string == null) {
                PgDialectBase.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (jdbcType == 2) {
            String string = "numeric" + (String)(dataType.getLength() == 131089 ? "" : "(" + dataType.getPrecision() + (String)(dataType.getScale() == 0 ? "" : ", " + dataType.getScale()) + ")");
            if (string == null) {
                PgDialectBase.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = super.getTypeName(dataType);
        if (string == null) {
            PgDialectBase.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            PgDialectBase.$$$reportNull$$$0(7);
        }
        if (procedure == null) {
            PgDialectBase.$$$reportNull$$$0(8);
        }
        String type = procedure.getRoutineKind().name();
        builder.keyword("DROP").space().keyword(type);
        builder.space();
        builder.qualifiedRef((DasObject)procedure).symbol("(");
        boolean first2 = true;
        for (DasArgument arg : DasUtil.getParameters((DasRoutine)procedure)) {
            ArgumentDirection direction = arg.getArgumentDirection();
            if (direction != ArgumentDirection.IN && direction != ArgumentDirection.INOUT) continue;
            if (first2) {
                first2 = false;
            } else {
                builder.symbol(",").space();
            }
            builder.type((DasTypedObject)arg);
        }
        builder.symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PgDialectBase.$$$reportNull$$$0(9);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition2) {
        if (builder == null) {
            PgDialectBase.$$$reportNull$$$0(10);
        }
        if (view == null) {
            PgDialectBase.$$$reportNull$$$0(11);
        }
        if (definition2 == null) {
            PgDialectBase.$$$reportNull$$$0(12);
        }
        builder.keywords(new String[]{"CREATE", "OR", "REPLACE", "VIEW"}).space().qualifiedRef((DasObject)view).space().keyword("AS").space().plain(definition2);
        return builder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            PgDialectBase.$$$reportNull$$$0(13);
        }
        if (view == null) {
            PgDialectBase.$$$reportNull$$$0(14);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL((DdlBuilder)builder, (DasTable)view, (Boolean)cascade);
        if (ddlBuilder == null) {
            PgDialectBase.$$$reportNull$$$0(15);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    public boolean supportsSearchPath() {
        return true;
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            PgDialectBase.$$$reportNull$$$0(16);
        }
        if (path.getCurrent().kind != ObjectKind.SCHEMA) {
            return null;
        }
        DdlBuilder builder = new DdlBuilder().plain("set search_path = ").quoteIdentifiers(true);
        boolean first2 = true;
        for (ObjectPath e2 : path.elements) {
            if (!first2) {
                builder.plain(", ");
            }
            first2 = false;
            builder.identifier(e2.getName());
        }
        return builder.getStatement();
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            PgDialectBase.$$$reportNull$$$0(17);
        }
        return Pair.create((Object)("select view_definition from information_schema.views where table_schema = '" + DasUtil.getSchema((DasObject)element) + "' and table_name = '" + element.getName() + "'"), (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            PgDialectBase.$$$reportNull$$$0(18);
        }
        Pair pair = Pair.create((Object)("select routine_definition from information_schema.routines where routine_schema = '" + DasUtil.getSchema((DasObject)element) + "' and routine_name = '" + element.getName() + "'"), (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            PgDialectBase.$$$reportNull$$$0(19);
        }
        return pair;
    }

    @Override
    public boolean supportsSequenceDefinition() {
        return true;
    }

    @Override
    public boolean supportsQualifiedAsteriskInCalls() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefinePrototype(@NotNull DdlBuilder builder, @NotNull DasRoutine routine2, boolean longMode, boolean withReturn) {
        if (builder == null) {
            PgDialectBase.$$$reportNull$$$0(20);
        }
        if (routine2 == null) {
            PgDialectBase.$$$reportNull$$$0(21);
        }
        JBIterable parameters2 = DasUtil.getParameters((DasRoutine)routine2);
        boolean returnsTypeExplicit = false;
        String returnsTypeSpec = null;
        DasArgument returnArg = routine2.getReturnArgument();
        if (returnArg != null) {
            returnsTypeExplicit = true;
            returnsTypeSpec = returnArg.getDataType().getSpecification();
        }
        int outs2 = 0;
        for (DasArgument parameter : parameters2) {
            if (!parameter.getArgumentDirection().isOut()) continue;
            ++outs2;
        }
        builder.symbol("(");
        boolean first2 = true;
        for (DasArgument parameter : parameters2) {
            if (first2) {
                first2 = false;
            } else {
                builder.symbol(",").space();
            }
            ArgumentDirection argumentDirection = parameter.getArgumentDirection();
            if (longMode || !argumentDirection.isIn()) {
                if (StringUtil.isNotEmpty((String)parameter.getName())) {
                    builder.identifier((DasObject)parameter, parameter.getName()).space();
                }
                if (argumentDirection.isOut()) {
                    if (argumentDirection.isIn()) {
                        builder.keyword("in").space();
                    }
                    builder.keyword("out").space();
                }
            }
            builder.type((DasTypedObject)parameter);
        }
        builder.symbol(")");
        if (!returnsTypeExplicit) {
            if (outs2 == 1) {
                for (DasArgument parameter : parameters2) {
                    if (!parameter.getArgumentDirection().isOut()) continue;
                    returnsTypeSpec = parameter.getDataType().getSpecification();
                }
            } else {
                returnsTypeSpec = "record";
            }
        }
        if (returnsTypeExplicit && withReturn && StringUtil.isNotEmpty((String)returnsTypeSpec)) {
            if (longMode) {
                builder.space().keyword("returns").space();
            } else {
                builder.plain(": ");
            }
            builder.type(returnsTypeSpec);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PgDialectBase.$$$reportNull$$$0(22);
        }
        return ddlBuilder;
    }

    @Override
    public int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName) {
        if (nativeColumnTypeName == null) {
            PgDialectBase.$$$reportNull$$$0(23);
        }
        if ("character_data".equalsIgnoreCase(nativeColumnTypeName)) {
            return 1;
        }
        if ("cardinal_number".equalsIgnoreCase(nativeColumnTypeName)) {
            return 4;
        }
        if ("xml".equalsIgnoreCase(nativeColumnTypeName)) {
            return 12;
        }
        return super.getJavaTypeForNativeType(nativeColumnTypeName);
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    @Nullable
    public String sqlResetSearchPath() {
        return "set search_path to default";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 15: 
            case 19: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 15: 
            case 19: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeHelper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 15: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgresbase/PgDialectBase";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeColumnTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgresbase/PgDialectBase";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropProcedure";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefinePrototype";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 15: 
            case 19: 
            case 22: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropProcedure";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefinePrototype";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getJavaTypeForNativeType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 15: 
            case 19: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

