/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectorSqlHelper;
import com.intellij.database.dialects.postgres.introspector.PgIntroQueries;
import com.intellij.database.dialects.postgres.model.PgAggregate;
import com.intellij.database.dialects.postgres.model.PgDatabase;
import com.intellij.database.dialects.postgres.model.PgDefType;
import com.intellij.database.dialects.postgres.model.PgEventTrigger;
import com.intellij.database.dialects.postgres.model.PgIndex;
import com.intellij.database.dialects.postgres.model.PgKey;
import com.intellij.database.dialects.postgres.model.PgLocalTable;
import com.intellij.database.dialects.postgres.model.PgLocalTableColumn;
import com.intellij.database.dialects.postgres.model.PgMatView;
import com.intellij.database.dialects.postgres.model.PgModelHelper;
import com.intellij.database.dialects.postgres.model.PgRole;
import com.intellij.database.dialects.postgres.model.PgRoot;
import com.intellij.database.dialects.postgres.model.PgRoutine;
import com.intellij.database.dialects.postgres.model.PgSchema;
import com.intellij.database.dialects.postgres.model.PgTable;
import com.intellij.database.dialects.postgres.model.PgTrigger;
import com.intellij.database.dialects.postgres.model.PgView;
import com.intellij.database.dialects.postgres.model.properties.PgCheckOption;
import com.intellij.database.dialects.postgres.model.properties.PgDataTypeSubCategory;
import com.intellij.database.dialects.postgres.model.properties.PgIdentityKind;
import com.intellij.database.dialects.postgres.model.properties.PgRoutineConcurrencyKind;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntroQueries;
import com.intellij.database.dialects.postgresbase.introspector.PgIntrospectorBaseKt;
import com.intellij.database.dialects.postgresbase.model.PgBaseAggregate;
import com.intellij.database.dialects.postgresbase.model.PgBaseDefType;
import com.intellij.database.dialects.postgresbase.model.PgBaseKey;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeColumn;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeStoredTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseTable;
import com.intellij.database.dialects.postgresgreenplumbase.introspector.PgGPlumBaseIntroQueries;
import com.intellij.database.dialects.postgresgreenplumbase.introspector.PgGPlumIntrospectorBase;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDatabase;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseModelHelper;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRole;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRoutine;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSchema;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTrigger;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.remote.jdba.sql.Scriptum;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.sql.psi.SqlCreateStatement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 !2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0004!\"#$B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u0012\u001a\u00060\u0013R\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0014J\u001c\u0010\u0017\u001a\u00060\u0018R\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0004H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0018\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014R\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumIntrospectorBase;", "Lcom/intellij/database/dialects/postgres/model/PgRoot;", "Lcom/intellij/database/dialects/postgres/model/PgDatabase;", "Lcom/intellij/database/dialects/postgres/model/PgSchema;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/ModelFactory;)V", "helper", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "getHelper", "()Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "queries", "Lcom/intellij/database/dialects/postgres/introspector/PgIntroQueries;", "getQueries", "()Lcom/intellij/database/dialects/postgres/introspector/PgIntroQueries;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$MyDatabaseRetriever;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$MySchemaRetriever;", "schema", "initConnectionRelatedState", "", "processRole", "role", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRole;", "r", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries$OneRole;", "Companion", "Factory", "MyDatabaseRetriever", "MySchemaRetriever", "intellij.database.dialects.postgres"})
public final class PgIntrospector
extends PgGPlumIntrospectorBase<PgRoot, PgDatabase, PgSchema> {
    @JvmField
    @NotNull
    public static final PgIntroQueries QUERIES;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    protected PgGPlumBaseModelHelper getHelper() {
        return PgModelHelper.INSTANCE;
    }

    @Override
    @NotNull
    protected PgIntroQueries getQueries() {
        return QUERIES;
    }

    @Override
    protected void initConnectionRelatedState() {
        super.initConnectionRelatedState();
        Companion.setVersionParameters(this.getServerVersion(), this.getParametersMap());
    }

    @Override
    protected void processRole(@NotNull PgGPlumBaseRole role, @NotNull PgGPlumBaseIntroQueries.OneRole r) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        super.processRole(role, r);
        if (!(role instanceof PgRole)) {
            return;
        }
        ((PgRole)role).setReplication(r.is_replication);
        ((PgRole)role).setBypassRls(r.bypass_rls);
    }

    @NotNull
    protected MyDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull PgDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new MyDatabaseRetriever(transaction, database);
    }

    @NotNull
    protected MySchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull PgSchema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return new MySchemaRetriever(transaction, schema);
    }

    public PgIntrospector(@NotNull Project project, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        Dbms dbms = Dbms.POSTGRES;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"Dbms.POSTGRES");
        super(dbms, project, modelFactory);
    }

    static {
        Companion = new Companion(null);
        Scriptum scriptum = Scriptum.of(PgIntroQueries.class);
        Intrinsics.checkNotNullExpressionValue((Object)scriptum, (String)"Scriptum.of(PgIntroQueries::class.java)");
        QUERIES = new PgIntroQueries(scriptum);
    }

    public static final /* synthetic */ Object access$parseStatement(PgIntrospector $this, String src2) {
        return $this.parseStatement(src2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "dbms", "Lcom/intellij/database/Dbms;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.postgres"})
    public static final class Factory
    implements DBIntrospector.Factory {
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return version.isOrGreater(new int[]{9});
        }

        @NotNull
        public DBIntrospector createIntrospector(@NotNull Dbms dbms, @NotNull Project project, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new PgIntrospector(project, modelFactory);
        }

        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        public boolean isOutdatedCheckSupported(@Nullable BasicElement e2) {
            return PgIntrospectorBaseKt.canCheckOutdated(e2);
        }

        public boolean isNative() {
            return DBIntrospector.Factory.DefaultImpls.isNative((DBIntrospector.Factory)this);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.postgres"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE;

            private VERSION() {
            }

            static {
                VERSION vERSION;
                INSTANCE = vERSION = new VERSION();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$MyDatabaseRetriever;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumIntrospectorBase$PgGPlumBaseDatabaseRetriever;", "Lcom/intellij/database/dialects/postgres/model/PgDatabase;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumIntrospectorBase;", "Lcom/intellij/database/dialects/postgres/model/PgRoot;", "Lcom/intellij/database/dialects/postgres/model/PgSchema;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgres/model/PgDatabase;)V", "getNativeDefinitionQuery", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "introspectDatabase", "", "retrieveEventTriggers", "db", "retrieveExtensions", "intellij.database.dialects.postgres"})
    protected final class MyDatabaseRetriever
    extends PgGPlumIntrospectorBase.PgGPlumBaseDatabaseRetriever<PgDatabase> {
        @Override
        @Nullable
        protected String getNativeDefinitionQuery(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            String string = super.getNativeDefinitionQuery(kind);
            if (string == null) {
                string = Intrinsics.areEqual((Object)kind, (Object)ObjectKind.ROUTINE) ? "select pg_get_functiondef(?)" : null;
            }
            return string;
        }

        @Override
        protected void introspectDatabase() {
            this.inDatabase((Function1)new Function1<PgDatabase, Unit>(this){
                final /* synthetic */ MyDatabaseRetriever this$0;

                public final void invoke(@NotNull PgDatabase it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    BasicRoot basicRoot = MyDatabaseRetriever.access$getModel$p(this.this$0).getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)basicRoot, (String)"model.root");
                    Version version = basicRoot.getServerVersion();
                    if (version != null) {
                        if (version.isOrGreater(new int[]{9, 3})) {
                            MyDatabaseRetriever.access$retrieveEventTriggers(this.this$0, it);
                            MyDatabaseRetriever.access$handleXidWrapAround(this.this$0);
                        }
                    }
                }
                {
                    this.this$0 = myDatabaseRetriever;
                    super(1);
                }
            });
            super.introspectDatabase();
        }

        @Override
        protected void retrieveExtensions() {
            if (PgIntrospector.this.getServerVersion().isOrGreater(new int[]{9, 1})) {
                super.retrieveExtensions();
            }
        }

        private final void retrieveEventTriggers(PgDatabase db) {
            PgIntrospector.this.reportRetrieving("event triggers", "introspection.retrieve.event.triggers");
            BaseIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this, QUERIES.getRetrieveEventTriggers(), 0, (Function1)new Function1<PgIntroQueries.OneEventTrigger, Unit>(db){
                final /* synthetic */ PgDatabase $db;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull PgIntroQueries.OneEventTrigger et) {
                    Object object;
                    PgEventTrigger pgEventTrigger;
                    PgEventTrigger $this$apply;
                    block3: {
                        block2: {
                            void it;
                            Intrinsics.checkNotNullParameter((Object)et, (String)"et");
                            BasicModNamedElement basicModNamedElement = this.$db.getEventTriggers().renew(et.id, et.name);
                            boolean bl = false;
                            boolean bl2 = false;
                            $this$apply = (PgEventTrigger)basicModNamedElement;
                            boolean bl3 = false;
                            $this$apply.setStateNumber(et.state_number);
                            pgEventTrigger = $this$apply;
                            object = et.tags;
                            if (et.tags == null) break block2;
                            String[] stringArray = object;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            String[] stringArray2 = stringArray;
                            PgEventTrigger pgEventTrigger2 = pgEventTrigger;
                            boolean bl6 = false;
                            void v2 = it;
                            Set set = SetsKt.setOf((Object[])((String[])Arrays.copyOf(v2, ((void)v2).length)));
                            pgEventTrigger = pgEventTrigger2;
                            object = set;
                            if (object != null) break block3;
                        }
                        object = SetsKt.emptySet();
                    }
                    pgEventTrigger.setTags((Set<String>)object);
                    $this$apply.setEvent(et.event);
                    $this$apply.setCallRoutineId(et.routine_id);
                }
                {
                    this.$db = pgDatabase;
                    super(1);
                }
            }, 2, null);
            db.getEventTriggers().sort();
        }

        public MyDatabaseRetriever(@NotNull DBTransaction tran, PgDatabase database) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((PgGPlumIntrospectorBase)PgIntrospector.this, tran, (PgGPlumBaseDatabase)database);
        }

        public static final /* synthetic */ BasicModModel access$getModel$p(MyDatabaseRetriever $this) {
            return $this.getModel();
        }

        public static final /* synthetic */ void access$retrieveEventTriggers(MyDatabaseRetriever $this, PgDatabase db) {
            $this.retrieveEventTriggers(db);
        }

        public static final /* synthetic */ void access$handleXidWrapAround(MyDatabaseRetriever $this) {
            $this.handleXidWrapAround();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0003B\u0017\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0014J\u0014\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fH\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0013H\u0014J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J0\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u000e\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0&2\u0006\u0010'\u001a\u00020(H\u0014J \u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010\b\u001a\u00020\u0002H\u0014J \u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u0002002\u0006\u0010'\u001a\u0002012\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u00102\u001a\u00020\u001b2\u0006\u0010'\u001a\u0002012\u0006\u00103\u001a\u000204H\u0014J\u0018\u00105\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(2\u0006\u00103\u001a\u000204H\u0014J \u00106\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(2\u0006\u0010\b\u001a\u00020\u00022\u0006\u00107\u001a\u000204H\u0014J\u0018\u00108\u001a\u00020\u001b2\u0006\u00109\u001a\u00020:2\u0006\u00103\u001a\u00020;H\u0014J\b\u0010<\u001a\u00020\u001bH\u0014J\b\u0010=\u001a\u00020\u001bH\u0014\u00a8\u0006>"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$MySchemaRetriever;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumIntrospectorBase$PgGPlumBaseSchemaRetriever;", "Lcom/intellij/database/dialects/postgres/model/PgSchema;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumIntrospectorBase;", "Lcom/intellij/database/dialects/postgres/model/PgRoot;", "Lcom/intellij/database/dialects/postgres/model/PgDatabase;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgres/model/PgSchema;)V", "createRoutine", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRoutine;", "r", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneRoutine;", "getSequencesQuery", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries$OneSequence;", "hasReference", "", "con", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneConstraint;", "incrementalViewSources", "isTableKind", "kind", "", "processAggregate", "", "agg", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneAggregate;", "aggregate", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseAggregate;", "processColumn", "col", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneColumn;", "column", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeColumn;", "columns", "Lcom/intellij/database/model/families/ModPositioningNamingFamily;", "table", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "processDataType", "dataType", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseDefType;", "oneType", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneDataType;", "processKey", "key", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseKey;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseTable;", "processModTable", "t", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;", "processModView", "processTable", "oneTable", "processTrigger", "trigger", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseTrigger;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries$OneTrigger;", "retrieveCollations", "retrieveForeignTables", "intellij.database.dialects.postgres"})
    protected final class MySchemaRetriever
    extends PgGPlumIntrospectorBase.PgGPlumBaseSchemaRetriever<PgSchema> {
        @Override
        @NotNull
        protected SqlQuery<List<PgGPlumBaseIntroQueries.OneSequence>> getSequencesQuery() {
            return PgIntrospector.this.getServerVersion().isOrGreater(new int[]{10, -10}) ? QUERIES.getRetrieveSequences10() : super.getSequencesQuery();
        }

        @Override
        protected void retrieveForeignTables() {
            if (!PgIntrospector.this.getServerVersion().isOrGreater(new int[]{9, 1})) {
                return;
            }
            super.retrieveForeignTables();
        }

        @Override
        protected void retrieveCollations() {
            if (!PgIntrospector.this.getServerVersion().isOrGreater(new int[]{9, 1})) {
                return;
            }
            super.retrieveCollations();
        }

        @Override
        protected void processDataType(@NotNull PgBaseDefType dataType, @NotNull PgBaseIntroQueries.OneDataType oneType, @NotNull PgSchema schema) {
            Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
            Intrinsics.checkNotNullParameter((Object)oneType, (String)"oneType");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super.processDataType(dataType, oneType, (PgGPlumBaseSchema)schema);
            if (!(dataType instanceof PgDefType)) {
                return;
            }
            ((PgDefType)dataType).setSubCategory(PgDataTypeSubCategory.of(oneType.type_category));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void processTable(@NotNull PgBaseLikeStoredTable table, @NotNull PgSchema schema, @NotNull PgBaseIntroQueries.OneTable oneTable) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)oneTable, (String)"oneTable");
            super.processTable(table, (PgGPlumBaseSchema)schema, oneTable);
            if (table instanceof PgMatView) {
                void it;
                long l = oneTable.tablespace_id;
                boolean bl = false;
                boolean bl2 = false;
                long l2 = l;
                PgMatView pgMatView = (PgMatView)table;
                boolean bl3 = false;
                long l3 = it == 0L ? Long.MIN_VALUE : it;
                pgMatView.setTablespaceId(l3);
            }
        }

        @Override
        protected void processModTable(@NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneTable t) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            super.processModTable(table, t);
            if (!(table instanceof PgTable)) {
                return;
            }
            ((PgTable)table).setPartitioned(t.table_kind == 'p');
            ((PgTable)table).setPartition(t.is_partition);
            ((PgTable)table).setPartitionKey(t.partition_key);
            ((PgTable)table).setPartitionExpression(t.partition_expression);
        }

        @Override
        protected void processModView(@NotNull PgBaseLikeStoredTable table, @NotNull PgBaseIntroQueries.OneTable t) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            if (!(table instanceof PgView)) {
                return;
            }
            ((PgView)table).setCheckOption(ArraysKt.contains((Object[])t.options, (Object)"check_option=local") ? PgCheckOption.LOCAL : (ArraysKt.contains((Object[])t.options, (Object)"check_option=cascaded") ? PgCheckOption.CASCADED : PgCheckOption.NONE));
        }

        @Override
        protected void processColumn(@NotNull PgBaseIntroQueries.OneColumn col, @NotNull PgBaseLikeColumn column2, @NotNull ModPositioningNamingFamily<? extends PgBaseLikeColumn> columns, @NotNull PgBaseLikeStoredTable table) {
            PgIdentityKind pgIdentityKind;
            Intrinsics.checkNotNullParameter((Object)col, (String)"col");
            Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            super.processColumn(col, column2, columns, table);
            if (!(column2 instanceof PgLocalTableColumn)) {
                return;
            }
            Character c = col.identity_kind;
            if (c != null) {
                Character c2 = c;
                boolean bl = false;
                boolean bl2 = false;
                char it = c2.charValue();
                boolean bl3 = false;
                pgIdentityKind = PgIdentityKind.Companion.valueFor(it);
            } else {
                pgIdentityKind = null;
            }
            PgIdentityKind kind = pgIdentityKind;
            ((PgLocalTableColumn)column2).setIdentityKind(kind);
            ((PgLocalTableColumn)column2).setComputed(kind == PgIdentityKind.ALWAYS);
        }

        @Override
        protected void processKey(@NotNull PgBaseKey key2, @NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneConstraint con) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
            super.processKey(key2, table, con);
            if (!(table instanceof PgLocalTable) || !(key2 instanceof PgKey)) {
                return;
            }
            PgIndex index2 = (PgIndex)((PgLocalTable)table).getIndices().getByObjectId(con.index_id);
            PgIndex pgIndex = index2;
            ((PgKey)key2).setUnderlyingIndexName(pgIndex != null ? pgIndex.getRealName() : null);
        }

        @Override
        protected boolean hasReference(@NotNull PgBaseIntroQueries.OneConstraint con) {
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
            return con.ref_table_id > 0L && con.index_id > 0L;
        }

        @Override
        @NotNull
        protected PgGPlumBaseRoutine createRoutine(@NotNull PgSchema schema, @NotNull PgBaseIntroQueries.OneRoutine r) {
            PgGPlumBaseRoutine routine2;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            PgGPlumBaseRoutine pgGPlumBaseRoutine = routine2 = super.createRoutine((PgGPlumBaseSchema)schema, r);
            if (pgGPlumBaseRoutine == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.postgres.model.PgRoutine");
            }
            PgRoutine cfr_ignored_0 = (PgRoutine)pgGPlumBaseRoutine;
            ((PgRoutine)routine2).setConcurrencyKind(PgRoutineConcurrencyKind.of(r.concurrency_kind));
            ((PgRoutine)routine2).setWindow(r.kind == 'w');
            ((PgRoutine)routine2).setRows(r.rows);
            return routine2;
        }

        @Override
        protected void processTrigger(@NotNull PgGPlumBaseTrigger trigger, @NotNull PgGPlumBaseIntroQueries.OneTrigger t) {
            SqlCreateStatement createTrigger;
            SqlCreateStatement sqlCreateStatement;
            Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            super.processTrigger(trigger, t);
            if (!(trigger instanceof PgTrigger)) {
                return;
            }
            ((PgTrigger)trigger).setDeferrable(t.is_deferrable);
            ((PgTrigger)trigger).setInitiallyDeferred(t.is_init_deferred);
            ((PgTrigger)trigger).setColumnIndices(PgIntrospector.this.parseListOfLongs(t.columns));
            ((PgTrigger)trigger).setConstraint(t.is_constraint);
            String string = t.source_code;
            if (string != null) {
                Object object;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                BaseIntrospector this_$iv = PgIntrospector.this;
                boolean $i$f$parseStatement = false;
                try {
                    IntrospectorSqlHelper this_$iv$iv = BaseIntrospector.access$getSqlHelper$p(this_$iv);
                    boolean $i$f$statements = false;
                    object = this_$iv$iv.statements(it, SqlCreateStatement.class).first();
                }
                catch (ProcessCanceledException pce$iv) {
                    throw (Throwable)pce$iv;
                }
                catch (Exception e$iv) {
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                    if (application.isUnitTestMode()) {
                        this_$iv.log.error((Throwable)e$iv);
                    }
                    this_$iv.log.warn("Failed to parse sources", (Throwable)e$iv);
                    object = null;
                }
                sqlCreateStatement = (SqlCreateStatement)object;
            } else {
                sqlCreateStatement = createTrigger = null;
            }
            if (createTrigger != null) {
                PgIntrospector.this.getSqlHelper().getBuilder().build((BasicModElement)trigger, (DasObject)createTrigger, SqlObjectBuilder.INTROSPECTOR);
            }
        }

        @Override
        protected void processAggregate(@NotNull PgBaseIntroQueries.OneAggregate agg, @NotNull PgBaseAggregate aggregate) {
            Intrinsics.checkNotNullParameter((Object)agg, (String)"agg");
            Intrinsics.checkNotNullParameter((Object)aggregate, (String)"aggregate");
            super.processAggregate(agg, aggregate);
            PgAggregate cfr_ignored_0 = (PgAggregate)aggregate;
            ((PgAggregate)aggregate).setStateSize(agg.state_size);
            ((PgAggregate)aggregate).setFinalExtra(agg.final_extra);
            ((PgAggregate)aggregate).setMovingTransitionId(agg.moving_transition_id);
            ((PgAggregate)aggregate).setMovingTransition(agg.moving_transition_name);
            ((PgAggregate)aggregate).setInverseTransitionId(agg.inverse_transition_id);
            ((PgAggregate)aggregate).setInverseTransition(agg.inverse_transition_name);
            PgAggregate pgAggregate = (PgAggregate)aggregate;
            DataType dataType = this.getMyTypes().get(agg.moving_state_type);
            if (dataType == null) {
                DataType dataType2 = DataType.UNKNOWN;
                dataType = dataType2;
                Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"DataType.UNKNOWN");
            }
            pgAggregate.setMovingStateType(dataType);
            ((PgAggregate)aggregate).setMovingStateSize(agg.moving_state_size);
            ((PgAggregate)aggregate).setMovingFinalId(agg.moving_final_id);
            ((PgAggregate)aggregate).setMovingFinal(agg.moving_final_name);
            ((PgAggregate)aggregate).setMovingFinalExtra(agg.moving_final_extra);
            ((PgAggregate)aggregate).setMovingInitialValue(agg.moving_initial_value);
            ((PgAggregate)aggregate).setCombine(agg.combine_function_name);
            ((PgAggregate)aggregate).setCombineId(agg.combine_function_id);
            ((PgAggregate)aggregate).setSerialization(agg.serialization_function_name);
            ((PgAggregate)aggregate).setSerializationId(agg.serialization_function_id);
            ((PgAggregate)aggregate).setDeserialization(agg.deserialization_function_name);
            ((PgAggregate)aggregate).setDeserializationId(agg.deserialization_function_id);
            ((PgAggregate)aggregate).setConcurrencyKind(PgRoutineConcurrencyKind.of(agg.concurrency_kind));
            ((PgAggregate)aggregate).setOwner(agg.getOwnerName());
        }

        @Override
        protected boolean incrementalViewSources() {
            return PgIntrospector.this.getServerVersion().isOrGreater(new int[]{9, 2});
        }

        @Override
        protected boolean isTableKind(char kind) {
            return super.isTableKind(kind) || kind == 'p';
        }

        public MySchemaRetriever(@NotNull DBTransaction transaction, PgSchema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super((PgGPlumIntrospectorBase)PgIntrospector.this, transaction, (PgGPlumBaseSchema)schema);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$Companion;", "", "()V", "QUERIES", "Lcom/intellij/database/dialects/postgres/introspector/PgIntroQueries;", "setVersionParameters", "", "version", "Lcom/intellij/database/util/Version;", "parameters", "", "", "intellij.database.dialects.postgres"})
    public static final class Companion {
        public final void setVersionParameters(@NotNull Version version, @NotNull Map<String, Object> parameters2) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
            int n = 1;
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 8, new IntRange(n, 4), parameters2);
            n = 0;
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 9, new IntRange(n, 9), parameters2);
            n = 0;
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 10, new IntRange(n, 0), parameters2);
            n = 0;
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 11, new IntRange(n, 0), parameters2);
            n = 0;
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 12, new IntRange(n, 0), parameters2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

