/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.types;

import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasTypeUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\b\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H$\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/oracle/types/OraIntervalType;", "Lcom/intellij/database/types/DasBuiltinType;", "()V", "getKind", "Lcom/intellij/database/types/DasBuiltinType$Kind;", "render", "", "renderSuffix", "DayToSecond", "YearToMonth", "Lcom/intellij/database/dialects/oracle/types/OraIntervalType$YearToMonth;", "Lcom/intellij/database/dialects/oracle/types/OraIntervalType$DayToSecond;", "intellij.database.dialects.oracle"})
public abstract class OraIntervalType
implements DasBuiltinType {
    @NotNull
    public DasBuiltinType.Kind getKind() {
        return DasBuiltinType.Kind.INTERVAL;
    }

    @NotNull
    protected abstract String renderSuffix();

    @NotNull
    public String render() {
        return "INTERVAL " + this.renderSuffix();
    }

    private OraIntervalType() {
    }

    public /* synthetic */ OraIntervalType(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\b\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0010\u001a\u00020\u000eH\u0014J\r\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/oracle/types/OraIntervalType$YearToMonth;", "Lcom/intellij/database/dialects/oracle/types/OraIntervalType;", "length", "", "(I)V", "getLength", "()I", "component1", "copy", "equals", "", "other", "", "getName", "", "hashCode", "renderSuffix", "toDataType", "Lcom/intellij/database/model/DataType;", "Lorg/jetbrains/annotations/NotNull;", "toString", "intellij.database.dialects.oracle"})
    public static final class YearToMonth
    extends OraIntervalType {
        private final int length;

        @NotNull
        public String getName() {
            return "INTERVAL YEAR TO MONTH";
        }

        @Override
        @NotNull
        protected String renderSuffix() {
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl5 = false;
            $this$buildString.append("YEAR");
            String string = DasTypeUtilsKt.renderSize((int)this.length);
            if (string != null) {
                String string2 = string;
                boolean bl6 = false;
                boolean bl7 = false;
                String it = string2;
                boolean bl8 = false;
                $this$buildString.append("(").append(it).append(")");
            }
            $this$buildString.append(" TO MONTH");
            String string3 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
            return string3;
        }

        @NotNull
        public DataType toDataType() {
            DataType dataType = DataTypeFactory.of(null, (String)"INTERVAL YEAR", (int)this.length, (int)0, null, (String)"TO MONTH", (boolean)false, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"DataTypeFactory.of(\n    \u2026ONTH\", false, false\n    )");
            return dataType;
        }

        public final int getLength() {
            return this.length;
        }

        public YearToMonth(int length) {
            super(null);
            this.length = length;
        }

        public /* synthetic */ YearToMonth(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = -1;
            }
            this(n);
        }

        public YearToMonth() {
            this(0, 1, null);
        }

        public final int component1() {
            return this.length;
        }

        @NotNull
        public final YearToMonth copy(int length) {
            return new YearToMonth(length);
        }

        public static /* synthetic */ YearToMonth copy$default(YearToMonth yearToMonth, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = yearToMonth.length;
            }
            return yearToMonth.copy(n);
        }

        @NotNull
        public String toString() {
            return "YearToMonth(length=" + this.length + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.length);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof YearToMonth)) break block3;
                    YearToMonth yearToMonth = (YearToMonth)object;
                    if (this.length != yearToMonth.length) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0013\u001a\u00020\u0011H\u0014J\r\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/oracle/types/OraIntervalType$DayToSecond;", "Lcom/intellij/database/dialects/oracle/types/OraIntervalType;", "dayLength", "", "secondLength", "(II)V", "getDayLength", "()I", "getSecondLength", "component1", "component2", "copy", "equals", "", "other", "", "getName", "", "hashCode", "renderSuffix", "toDataType", "Lcom/intellij/database/model/DataType;", "Lorg/jetbrains/annotations/NotNull;", "toString", "intellij.database.dialects.oracle"})
    public static final class DayToSecond
    extends OraIntervalType {
        private final int dayLength;
        private final int secondLength;

        @NotNull
        public String getName() {
            return "INTERVAL DAY TO SECOND";
        }

        @Override
        @NotNull
        protected String renderSuffix() {
            String it;
            boolean bl;
            boolean bl2;
            String string;
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl5 = false;
            boolean bl6 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl7 = false;
            $this$buildString.append("DAY");
            String string2 = DasTypeUtilsKt.renderSize((int)this.dayLength);
            if (string2 != null) {
                string = string2;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl8 = false;
                $this$buildString.append("(").append(it).append(")");
            }
            $this$buildString.append(" TO SECOND");
            String string3 = DasTypeUtilsKt.renderScale((int)this.secondLength);
            if (string3 != null) {
                string = string3;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl9 = false;
                $this$buildString.append("(").append(it).append(")");
            }
            String string4 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
            return string4;
        }

        @NotNull
        public DataType toDataType() {
            DataType dataType = DataTypeFactory.of(null, (String)"INTERVAL DAY", (int)(this.dayLength != -1 || this.secondLength == 0 ? this.dayLength : 2), (int)0, null, (String)(this.secondLength == 0 ? "TO SECOND" : "TO SECOND(" + this.secondLength + ')'), (boolean)false, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"DataTypeFactory.of(\n    \u2026 false,\n      false\n    )");
            return dataType;
        }

        public final int getDayLength() {
            return this.dayLength;
        }

        public final int getSecondLength() {
            return this.secondLength;
        }

        public DayToSecond(int dayLength, int secondLength) {
            super(null);
            this.dayLength = dayLength;
            this.secondLength = secondLength;
        }

        public /* synthetic */ DayToSecond(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = -1;
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            this(n, n2);
        }

        public DayToSecond() {
            this(0, 0, 3, null);
        }

        public final int component1() {
            return this.dayLength;
        }

        public final int component2() {
            return this.secondLength;
        }

        @NotNull
        public final DayToSecond copy(int dayLength, int secondLength) {
            return new DayToSecond(dayLength, secondLength);
        }

        public static /* synthetic */ DayToSecond copy$default(DayToSecond dayToSecond, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = dayToSecond.dayLength;
            }
            if ((n3 & 2) != 0) {
                n2 = dayToSecond.secondLength;
            }
            return dayToSecond.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "DayToSecond(dayLength=" + this.dayLength + ", secondLength=" + this.secondLength + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.dayLength) * 31 + Integer.hashCode(this.secondLength);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DayToSecond)) break block3;
                    DayToSecond dayToSecond = (DayToSecond)object;
                    if (this.dayLength != dayToSecond.dayLength || this.secondLength != dayToSecond.secondLength) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

