/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.tns;

import com.intellij.database.dialects.oracle.tns.OraTnsLexer;
import com.intellij.database.dialects.oracle.tns.OraTnsToken;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TnsNamesExtractor {
    private final OraTnsLexer myLexer = new OraTnsLexer();

    public static void extract(@NotNull CharSequence seq, @NotNull Consumer<String> consumer) {
        if (seq == null) {
            TnsNamesExtractor.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            TnsNamesExtractor.$$$reportNull$$$0(1);
        }
        new TnsNamesExtractor().run(seq, consumer);
    }

    private TnsNamesExtractor() {
    }

    private void run(@NotNull CharSequence seq, @NotNull Consumer<String> consumer) {
        if (seq == null) {
            TnsNamesExtractor.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            TnsNamesExtractor.$$$reportNull$$$0(3);
        }
        this.myLexer.start(seq);
        while (this.myLexer.getTokenType() != null) {
            this.consumeParameter(consumer);
        }
    }

    private static void optAdd(@NotNull List<String> list, @Nullable String s) {
        if (list == null) {
            TnsNamesExtractor.$$$reportNull$$$0(4);
        }
        if (s != null) {
            list.add(s);
        }
    }

    private void consumeParameter(@NotNull Consumer<String> consumer) {
        if (consumer == null) {
            TnsNamesExtractor.$$$reportNull$$$0(5);
        }
        ArrayList<String> aliases = new ArrayList<String>();
        TnsNamesExtractor.optAdd(aliases, this.getAlias());
        while (this.myLexer.getTokenType() == OraTnsToken.COMMA) {
            this.myLexer.advance();
            TnsNamesExtractor.optAdd(aliases, this.getAlias());
        }
        while (this.myLexer.getTokenType() != null && this.myLexer.getTokenType() != OraTnsToken.LPAREN && this.myLexer.getTokenType() != OraTnsToken.EQUALS) {
            this.myLexer.advance();
        }
        if (this.myLexer.getTokenType() == null) {
            return;
        }
        boolean tnsName = false;
        if (this.myLexer.getTokenType() == OraTnsToken.EQUALS) {
            this.myLexer.advance();
            tnsName = true;
        }
        if (tnsName &= this.consumeBraced()) {
            for (String alias : aliases) {
                consumer.consume((Object)alias);
            }
        }
    }

    private boolean consumeBraced() {
        int braceCount = 0;
        int tokenCount = 0;
        boolean tnsName = false;
        while (this.myLexer.getTokenType() != null && (braceCount != 0 || this.myLexer.getTokenType() != OraTnsToken.IDENTIFIER)) {
            if (tokenCount == 0) {
                tnsName = this.myLexer.getTokenType() == OraTnsToken.LPAREN;
            } else if (tokenCount == 1) {
                tnsName &= this.myLexer.getTokenType() == OraTnsToken.IDENTIFIER;
                tnsName &= this.myLexer.getTokenText().equalsIgnoreCase("description_list") || this.myLexer.getTokenText().equalsIgnoreCase("description");
            }
            ++tokenCount;
            if (this.myLexer.getTokenType() == OraTnsToken.LPAREN) {
                ++braceCount;
            }
            if (this.myLexer.getTokenType() == OraTnsToken.RPAREN) {
                --braceCount;
            }
            if (braceCount < 0) {
                braceCount = 0;
            }
            this.myLexer.advance();
        }
        return tnsName;
    }

    @Nullable
    private String getAlias() {
        if (this.myLexer.getTokenType() != OraTnsToken.IDENTIFIER) {
            return null;
        }
        String res2 = this.myLexer.getTokenText();
        this.myLexer.advance();
        return res2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seq";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/oracle/tns/TnsNamesExtractor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "extract";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "optAdd";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "consumeParameter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

