/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.oracle.generator.producers.OraMatViewProducersKt;
import com.intellij.database.dialects.oracle.model.OraCluster;
import com.intellij.database.dialects.oracle.model.OraClusterColumn;
import com.intellij.database.dialects.oracle.model.OraClusterIndex;
import com.intellij.database.dialects.oracle.model.OraDbLink;
import com.intellij.database.dialects.oracle.model.OraDescriptionService$WhenMappings;
import com.intellij.database.dialects.oracle.model.OraIndex;
import com.intellij.database.dialects.oracle.model.OraInnerRoutine;
import com.intellij.database.dialects.oracle.model.OraMatLog;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraSequence;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.dialects.oracle.model.OraSynonym;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraTableColumn;
import com.intellij.database.dialects.oracle.model.properties.OraTableType;
import com.intellij.database.dialects.oracle.model.properties.TableOrganization;
import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbSynonymImpl;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.StringFun;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.SimpleTextAttributes;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.apache.commons.lang.text.StrBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 C2\u00020\u0001:\u0001CB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\bH\u0003J \u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010&\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0007\u001a\u00020\bH\u0003J \u0010)\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020+H\u0002J\u0016\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010,\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020.H\u0002J.\u0010/\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u00100\u001a\u0006\u0012\u0002\b\u0003012\b\u00102\u001a\u0004\u0018\u000103H\u0016J\u0018\u00104\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u00105\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u00106\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00107\u001a\u0002082\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u00109\u001a\u0004\u0018\u00010\u0004*\u00020:2\u0006\u0010;\u001a\u00020<H\u0002J\f\u0010=\u001a\u00020\u0004*\u00020(H\u0003J\f\u0010>\u001a\u00020\u0004*\u00020\u000bH\u0003J\u000e\u0010?\u001a\u0004\u0018\u00010\u0004*\u00020\u000bH\u0003J\u001e\u0010@\u001a\u00020\u0004*\u00020+2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010A\u001a\u00020<H\u0003J\u0018\u0010B\u001a\u0004\u0018\u000108*\u00020+2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002\u00a8\u0006D"}, d2={"Lcom/intellij/database/dialects/oracle/model/OraDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeDbLink", "dbLink", "Lcom/intellij/database/dialects/oracle/model/OraDbLink;", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "describeOraCluster", "cluster", "Lcom/intellij/database/dialects/oracle/model/OraCluster;", "describeOraClusterColumn", "column", "Lcom/intellij/database/dialects/oracle/model/OraClusterColumn;", "describeOraClusterIndex", "index", "Lcom/intellij/database/dialects/oracle/model/OraClusterIndex;", "describeOraIndex", "Lcom/intellij/database/dialects/oracle/model/OraIndex;", "describeOraInnerRoutine", "routine", "Lcom/intellij/database/dialects/oracle/model/OraInnerRoutine;", "r", "project", "Lcom/intellij/openapi/project/Project;", "describeOraMatLog", "ml", "Lcom/intellij/database/dialects/oracle/model/OraMatLog;", "describeOraMatView", "view", "Lcom/intellij/database/dialects/oracle/model/OraMatView;", "describeOraSequence", "sequence", "Lcom/intellij/database/dialects/oracle/model/OraSequence;", "describeOraSynonym", "synonym", "Lcom/intellij/database/dialects/oracle/model/OraSynonym;", "describeOraTable", "table", "Lcom/intellij/database/dialects/oracle/model/OraTable;", "formatAdditionalPropertyValue", "property", "Lcom/intellij/database/model/meta/BasicMetaProperty;", "value", "", "options", "suffix", "updatePresentation", "o", "Lcom/intellij/database/model/DasObject;", "dependsOnNames", "Lcom/intellij/database/dialects/oracle/model/OraSourceAware;", "withSurrogates", "", "presentInfo", "presentRemote", "presentRemoteDB", "presentTarget", "forceKind", "resolveWithCache", "Companion", "intellij.database.dialects.oracle"})
public final class OraDescriptionService
extends DescriptionService {
    @Deprecated
    @NotNull
    private static final Set<RegexOption> REGEX_OPTIONS;
    @Deprecated
    @NotNull
    private static final Regex REMOTE_DESC_HOST_PATTERN;
    @Deprecated
    @NotNull
    private static final Regex REMOTE_DESC_PORT_PATTERN;
    @Deprecated
    @NotNull
    private static final Regex REMOTE_DESC_SERV_PATTERN;
    @Deprecated
    @NotNull
    private static final Regex SPACES_PATTERN;
    @Deprecated
    @NotNull
    private static final Regex HEX_PATTERN;
    @NotNull
    private static final Companion Companion;

    @NotNull
    public String suffix(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String s = "";
        if (e2 instanceof OraSourceAware) {
            Collection collection = context.getDescribed();
            BasicMetaProperty<Set<Long>> basicMetaProperty = OraSourceAware.DEPENDS_ON_IDS;
            boolean bl = false;
            collection.add(basicMetaProperty);
            String dep = this.dependsOnNames((OraSourceAware)e2, context.getWithSurrogates());
            if (dep != null) {
                s = context.getIndent() + this.getIndentStep() + "^ depends on " + dep + this.getEoln();
            }
        }
        s = s + super.suffix(e2, context);
        return s;
    }

    @NotNull
    public String options(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Collection collection = context.getDescribed();
        BasicMetaProperty<Boolean> basicMetaProperty = OraSourceAware.OBFUSCATED;
        boolean bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraMatView.PREBUILT;
        bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraSynonym.INVALID;
        bl = false;
        collection.add(basicMetaProperty);
        return super.options(e2, context) + (e2 instanceof OraSourceAware && ((OraSourceAware)e2).isObfuscated() ? " [obfuscated]" : "") + (e2 instanceof OraMatView && ((OraMatView)e2).isPrebuilt() ? " [prebuilt]" : "") + (e2 instanceof OraSynonym && ((OraSynonym)e2).isInvalid() ? " [invalid]" : "");
    }

    @NotNull
    public String content(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e2;
        return basicElement instanceof OraCluster ? this.describeOraCluster((OraCluster)e2, context) : (basicElement instanceof OraClusterColumn ? this.describeOraClusterColumn((OraClusterColumn)e2, context) : (basicElement instanceof OraTable ? this.describeOraTable((OraTable)e2, context) : (basicElement instanceof OraMatLog ? this.describeOraMatLog((OraMatLog)e2, context) : (basicElement instanceof OraMatView ? this.describeOraMatView((OraMatView)e2, context) : (basicElement instanceof OraIndex ? this.describeOraIndex((OraIndex)e2, context) : (basicElement instanceof OraClusterIndex ? this.describeOraClusterIndex((OraClusterIndex)e2, context) : (basicElement instanceof OraSequence ? this.describeOraSequence((OraSequence)e2, context) : (basicElement instanceof OraInnerRoutine ? this.describeOraInnerRoutine((OraInnerRoutine)e2, context) : (basicElement instanceof OraSynonym ? this.describeOraSynonym((OraSynonym)e2, context) : (basicElement instanceof OraDbLink ? this.describeDbLink((OraDbLink)e2, context) : super.content(e2, context)))))))))));
    }

    public void updatePresentation(@NotNull Project project, @NotNull DasObject o2, @NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        DasObject dasObject = o2;
        if (dasObject instanceof OraTable) {
            this.describeOraTable(presentation, (OraTable)o2);
        } else if (dasObject instanceof OraSequence) {
            this.describeOraSequence(presentation, (OraSequence)o2);
        } else if (dasObject instanceof OraInnerRoutine) {
            this.describeOraInnerRoutine(presentation, (OraInnerRoutine)o2, project);
        } else if (dasObject instanceof OraSynonym) {
            this.describeOraSynonym(project, presentation, (OraSynonym)o2);
        } else if (dasObject instanceof OraDbLink) {
            this.describeDbLink(presentation, (OraDbLink)o2);
        } else {
            super.updatePresentation(project, o2, presentation);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String formatAdditionalPropertyValue(@NotNull BasicElement e2, @NotNull DescriptionService.Context context, @NotNull BasicMetaProperty<?> property, @Nullable Object value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        BasicMetaProperty<?> basicMetaProperty = property;
        if (Intrinsics.areEqual(basicMetaProperty, OraDbLink.CONNECT_USER_PASSWORD) || Intrinsics.areEqual(basicMetaProperty, OraDbLink.AUTH_USER_PASSWORD)) {
            String s = String.valueOf(value);
            if (!context.getWithSurrogates()) {
                CharSequence charSequence = s;
                Regex regex = HEX_PATTERN;
                boolean bl = false;
                if (regex.matches(charSequence)) {
                    return "hashed password";
                }
            }
            string = s;
            return string;
        } else {
            string = super.formatAdditionalPropertyValue(e2, context, property, value);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String dependsOnNames(OraSourceAware $this$dependsOnNames, boolean withSurrogates) {
        void $this$mapNotNullTo$iv$iv;
        Set<Long> set = $this$dependsOnNames.getDependsOnIds();
        Intrinsics.checkNotNullExpressionValue(set, (String)"this.dependsOnIds");
        Set<Long> ids = set;
        if (ids.isEmpty()) {
            return null;
        }
        BasicDatabase basicDatabase = $this$dependsOnNames.getDatabase();
        Intrinsics.checkNotNull((Object)basicDatabase);
        Intrinsics.checkNotNullExpressionValue((Object)basicDatabase, (String)"this.database!!");
        BasicDatabase database = basicDatabase;
        BasicSchema basicSchema = $this$dependsOnNames.getSchema();
        Intrinsics.checkNotNull((Object)basicSchema);
        Intrinsics.checkNotNullExpressionValue((Object)basicSchema, (String)"this.schema!!");
        BasicSchema schema = basicSchema;
        Iterable $this$mapNotNull$iv = ids;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Long it = (Long)element$iv$iv;
            boolean bl2 = false;
            Long l = it;
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"it");
            BasicIdentifiedElement o2 = database.findIdentifiedElement(l.longValue());
            if (o2 == null) {
                string = withSurrogates ? String.valueOf(it) : null;
            } else if (o2.getSchema() == schema) {
                string = o2.getName();
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                Object object = o2.getSchema();
                if (object == null || (object = object.getName()) == null) {
                    object = "<unknown-schema>";
                }
                string = stringBuilder.append((String)object).append('.').append(o2.getName()).toString();
            }
            if (string == null) continue;
            String string2 = string;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List items = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        if (items.isEmpty()) {
            return null;
        }
        return CollectionsKt.joinToString$default((Iterable)items, null, null, null, (int)0, null, null, (int)63, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String describeOraCluster(OraCluster cluster, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaProperty basicMetaProperty = OraCluster.CLUSTER_TYPE;
        boolean bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraCluster.HASH_CARDINALITY;
        bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraCluster.HASH_EXPRESSION;
        bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraCluster.SINGLE_TABLE;
        bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraCluster.BLOCK_SIZE;
        bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraCluster.TABLESPACE_NAME;
        bl = false;
        collection.add(basicMetaProperty);
        ModPositioningNamingFamily<? extends OraClusterColumn> modPositioningNamingFamily = cluster.getColumns();
        Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"cluster.columns");
        List list = modPositioningNamingFamily.getNames();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"cluster.columns.names");
        String columns = CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null);
        String s = null;
        ClusterType clusterType = cluster.getClusterType();
        if (clusterType == null) return "cluster (" + columns + ')';
        switch (OraDescriptionService$WhenMappings.$EnumSwitchMapping$0[clusterType.ordinal()]) {
            case 1: {
                return "index cluster (" + columns + ") block size " + cluster.getBlockSize();
            }
            case 2: {
                String exp = cluster.getHashExpression();
                s = exp == null ? "hash cluster (" + columns + ") hash by column cardinality " + cluster.getHashCardinality() : "hash cluster (" + columns + ") hash by (" + exp + ") cardinality " + cluster.getHashCardinality();
                if (!cluster.isSingleTable()) return s;
                return s + " (single table)";
            }
            default: {
                return "cluster (" + columns + ')';
            }
        }
    }

    private final String describeOraClusterColumn(OraClusterColumn column2, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaProperty<Boolean> basicMetaProperty = OraClusterColumn.DATA_TYPE;
        boolean bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraClusterColumn.SORTED;
        bl = false;
        collection.add(basicMetaProperty);
        String s = this.typeSpec((BasicTypedElement)column2, context);
        if (column2.isSorted()) {
            s = s + " sort";
        }
        return s;
    }

    @NotNull
    public final String describeOraTable(@NotNull OraTable table, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Collection collection = context.getDescribed();
        BasicMetaProperty basicMetaProperty = OraTable.ORGANIZATION;
        boolean bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraTable.TEMPORARY;
        bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraTable.TEMPORARY_PRESERVE;
        bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraTable.TABLE_TYPE;
        bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraTable.SECONDARY;
        bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraTable.TABLESPACE_NAME;
        bl = false;
        collection.add(basicMetaProperty);
        String d = table.getOrganization() == TableOrganization.ORA_CLUSTERED_BY_INDEX ? "cluster table" : (table.getOrganization() == TableOrganization.ORA_CLUSTERED_BY_HASH ? "cluster table" : (table.isTemporary() && table.isTemporaryPreserve() ? "temporary table (preserve rows)" : (table.isTemporary() && !table.isTemporaryPreserve() ? "temporary table" : this.describeTable((BasicTable)table, context))));
        switch (OraDescriptionService$WhenMappings.$EnumSwitchMapping$1[table.getTableType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                d = d + " (mat.log)";
                break;
            }
            case 3: {
                d = d + " (mat.log.temp)";
                break;
            }
            case 4: {
                d = d + " (mat.view)";
                break;
            }
        }
        if (table.isSecondary()) {
            d = d + " secondary";
        }
        return d;
    }

    private final void describeOraTable(PresentationData presentation, OraTable table) {
        switch (OraDescriptionService$WhenMappings.$EnumSwitchMapping$2[table.getTableType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                presentation.setIcon(DatabaseIcons.MaterializedView);
                break;
            }
            case 3: {
                presentation.setIcon(DatabaseIcons.MaterializedLog);
                break;
            }
            case 4: {
                presentation.setIcon(DatabaseIcons.MaterializedLog);
                break;
            }
        }
        if (table.getTableType() == OraTableType.MAT_VIEW) {
            boolean pb;
            ModNamingIdentifyingFamily<? extends OraMatView> schema = table.getSchema();
            ModNamingIdentifyingFamily<? extends OraMatView> modNamingIdentifyingFamily = schema;
            OraMatView mv = modNamingIdentifyingFamily != null && (modNamingIdentifyingFamily = modNamingIdentifyingFamily.getMatViews()) != null ? (OraMatView)modNamingIdentifyingFamily.get(table.getName()) : null;
            boolean bl = pb = mv != null && mv.isPrebuilt();
            if (pb) {
                presentation.addText("(pre-built)", DbPresentationCore.INFO_ATTRS);
            }
        }
    }

    private final String describeOraMatLog(OraMatLog ml, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaProperty<Boolean> basicMetaProperty = OraMatLog.WITH_NEW_VALUES;
        boolean bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraMatLog.WITH_OBJECT_ID;
        bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraMatLog.WITH_PRIMARY_KEY;
        bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraMatLog.WITH_ROW_ID;
        bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraMatLog.WITH_SEQUENCE;
        bl = false;
        collection.add(basicMetaProperty);
        String s = ml.withOptions();
        if (ml.isWithNewValues()) {
            s = s + " including new values";
        }
        String string = s;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"s");
        return string;
    }

    private final String describeOraMatView(OraMatView view, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        Object object = OraMatView.REFRESH_METHOD;
        boolean bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = OraMatView.REFRESH_MODE;
        bl = false;
        collection.add(object);
        return this.describeView((BasicView)view, context) + " " + OraMatViewProducersKt.getRefreshSpecification(view);
    }

    private final String describeOraIndex(OraIndex index2, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaProperty basicMetaProperty = OraIndex.INDEXTYPE_NAME;
        boolean bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraIndex.INDEXTYPE_OWNER;
        bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraIndex.TABLESPACE_NAME;
        bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraIndex.FUNCTION_BASED;
        bl = false;
        collection.add(basicMetaProperty);
        String desc = super.describeIndex((BasicIndex)index2, context);
        if (index2.getIndextypeName() != null) {
            desc = desc + " indextype: ";
            if (index2.getIndextypeOwner() != null) {
                desc = desc + index2.getIndextypeOwner() + ".";
            }
            desc = desc + index2.getIndextypeName();
        }
        return desc;
    }

    private final String describeOraClusterIndex(OraClusterIndex index2, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaProperty basicMetaProperty = OraIndex.TABLESPACE_NAME;
        boolean bl = false;
        collection.add(basicMetaProperty);
        return super.describeBasicElement((BasicElement)index2);
    }

    private final String describeOraSequence(OraSequence sequence, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaProperty basicMetaProperty = OraSequence.SEQUENCE_IDENTITY;
        boolean bl = false;
        collection.add(basicMetaProperty);
        return "sequence: " + this.presentInfo(sequence);
    }

    private final void describeOraSequence(PresentationData presentation, OraSequence sequence) {
        presentation.addText(this.presentInfo(sequence), DbPresentationCore.INFO_ATTRS);
    }

    @NlsSafe
    private final String presentInfo(OraSequence $this$presentInfo) {
        Object object = $this$presentInfo.getSequenceIdentity();
        if (object == null || (object = object.getSpecification()) == null) {
            object = "???";
        }
        Object s = object;
        OraTableColumn hostColumn = $this$presentInfo.getHostTableColumn();
        if (hostColumn != null) {
            s = (String)s + " (for " + hostColumn.getTableName() + '.' + hostColumn.getName() + ')';
        }
        return s;
    }

    @NlsSafe
    private final String describeOraInnerRoutine(OraInnerRoutine routine2, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaProperty<Short> basicMetaProperty = OraInnerRoutine.OVERLOAD_NR;
        boolean bl = false;
        collection.add(basicMetaProperty);
        return this.describeRoutine((BasicRoutine)routine2, context);
    }

    private final void describeOraInnerRoutine(PresentationData presentation, OraInnerRoutine r, Project project) {
        short ovr = r.getOverloadNr();
        if (ovr > 0) {
            presentation.addText("" + '[' + ovr + "] ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        this.describeRoutine(presentation, (DasRoutine)r, project);
    }

    @NlsSafe
    private final String describeOraSynonym(OraSynonym synonym2, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaProperty basicMetaProperty = OraSynonym.TARGET_SCHEMA_NAME;
        boolean bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraSynonym.TARGET_DB_LINK_NAME;
        bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraSynonym.TARGET_OBJECT_NAME;
        bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraSynonym.TARGET_OBJECT_KIND;
        bl = false;
        collection.add(basicMetaProperty);
        return "synonym -> " + this.presentTarget(synonym2, null, true);
    }

    private final void describeOraSynonym(Project project, PresentationData presentation, OraSynonym synonym2) {
        String text = DbPresentation.arrow() + " " + this.presentTarget(synonym2, project, false);
        presentation.addText(text, DbPresentationCore.INFO_ATTRS);
    }

    @NlsSafe
    private final String presentTarget(OraSynonym $this$presentTarget, Project project, boolean forceKind) {
        String x;
        DasObject targetObject = this.resolveWithCache($this$presentTarget, project);
        if (targetObject != null) {
            return targetObject.getKind().code() + ' ' + targetObject.getName();
        }
        String dbLinkName = $this$presentTarget.getTargetDbLinkName();
        String schemaName = $this$presentTarget.getTargetSchemaName() != null && Intrinsics.areEqual((Object)$this$presentTarget.getTargetSchemaName(), (Object)$this$presentTarget.getSchemaName()) ^ true ? $this$presentTarget.getTargetSchemaName() : null;
        String string = $this$presentTarget.getTargetObjectName();
        if (string == null) {
            string = "<unnamed-object>";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.targetObjectName ?: \"<unnamed-object>\"");
        String objectName = string;
        String string2 = x = schemaName != null ? schemaName + '.' + objectName : objectName;
        if (dbLinkName != null) {
            x = x + '@' + dbLinkName;
        }
        ObjectKind objectKind = $this$presentTarget.getTargetObjectKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"this.targetObjectKind");
        ObjectKind kind = objectKind;
        if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.NONE) ^ true) {
            x = kind.code() + ' ' + x;
        } else if (forceKind) {
            x = "<unknown> " + x;
        }
        return x;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final DasObject resolveWithCache(OraSynonym $this$resolveWithCache, Project project) {
        Object v6;
        boolean bl;
        Iterable iterable;
        block4: {
            if (project == null) return (DasObject)$this$resolveWithCache.getTargetObject();
            BasicModModel basicModModel = (BasicModModel)$this$resolveWithCache.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)basicModModel, (String)"model");
            BasicModModel m = basicModModel;
            DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)dbPsiFacade, (String)"DbPsiFacade.getInstance(project)");
            List list = dbPsiFacade.getDataSources();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"DbPsiFacade.getInstance(project).dataSources");
            iterable = list;
            bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                DbDataSource it = (DbDataSource)t;
                boolean bl3 = false;
                DbDataSource dbDataSource = it;
                Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"it");
                DatabaseSystem databaseSystem = dbDataSource.getDelegate();
                if (!(databaseSystem instanceof LocalDataSource)) {
                    databaseSystem = null;
                }
                LocalDataSource localDataSource = (LocalDataSource)databaseSystem;
                if (!Intrinsics.areEqual((Object)(localDataSource != null ? localDataSource.getModel() : null), (Object)m)) continue;
                v6 = t;
                break block4;
            }
            v6 = null;
        }
        DbDataSource dbDataSource = v6;
        if (dbDataSource == null) return (DasObject)$this$resolveWithCache.getTargetObject();
        iterable = dbDataSource;
        bl = false;
        boolean bl4 = false;
        Iterable ds = iterable;
        boolean bl5 = false;
        DbElement dbElement = DbImplUtil.findElement((DbDataSource)ds, (DasObject)((DasObject)$this$resolveWithCache));
        Object object = dbElement;
        if (dbElement == null) return null;
        DbElement $this$castSafelyTo$iv = object;
        boolean $i$f$castSafelyTo = false;
        DbElement dbElement2 = $this$castSafelyTo$iv;
        if (!(dbElement2 instanceof DbSynonymImpl)) {
            dbElement2 = null;
        }
        DbSynonymImpl dbSynonymImpl = (DbSynonymImpl)dbElement2;
        object = dbSynonymImpl;
        if (dbSynonymImpl == null) return null;
        DbElement dbElement3 = object.resolveTarget();
        object = dbElement3;
        if (dbElement3 == null) return null;
        Object object = object.getDelegate();
        object = object;
        if (object2 == null) return null;
        $this$castSafelyTo$iv = object;
        $i$f$castSafelyTo = false;
        DbElement dbElement4 = $this$castSafelyTo$iv;
        if (!(dbElement4 instanceof DasObject)) {
            dbElement4 = null;
        }
        DasObject dasObject = (DasObject)dbElement4;
        return dasObject;
    }

    private final String describeDbLink(OraDbLink dbLink, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaProperty<String> basicMetaProperty = OraDbLink.CONNECT_USER_NAME;
        boolean bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = OraDbLink.REMOTE_DATABASE_STRING;
        bl = false;
        collection.add(basicMetaProperty);
        return "DB link -> " + this.presentRemote(dbLink);
    }

    private final void describeDbLink(PresentationData presentation, OraDbLink dbLink) {
        String text = DbPresentation.arrow() + " " + this.presentRemote(dbLink);
        presentation.addText(text, DbPresentationCore.INFO_ATTRS);
    }

    @NlsSafe
    private final String presentRemote(OraDbLink $this$presentRemote) {
        StringBuilder stringBuilder = new StringBuilder().append($this$presentRemote.getConnectUserName() != null ? $this$presentRemote.getConnectUserName() + '@' : "");
        String string = this.presentRemoteDB($this$presentRemote);
        if (string == null) {
            string = "???";
        }
        return stringBuilder.append(string).toString();
    }

    @NlsSafe
    private final String presentRemoteDB(OraDbLink $this$presentRemoteDB) {
        String string = $this$presentRemoteDB.getRemoteDatabaseString();
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.remoteDatabaseString ?: return null");
        String rdb = string;
        if (StringsKt.startsWith$default((CharSequence)rdb, (char)'(', (boolean)false, (int)2, null)) {
            String host = StringFun.extract((CharSequence)rdb, (Regex)REMOTE_DESC_HOST_PATTERN, (int)1);
            String port = StringFun.extract((CharSequence)rdb, (Regex)REMOTE_DESC_PORT_PATTERN, (int)1);
            String serv = StringFun.extract((CharSequence)rdb, (Regex)REMOTE_DESC_SERV_PATTERN, (int)2);
            if (host == null && port == null && serv == null) {
                CharSequence charSequence = rdb;
                Regex regex = SPACES_PATTERN;
                String string2 = " ";
                boolean bl = false;
                return regex.replace(charSequence, string2);
            }
            StrBuilder b = new StrBuilder();
            if (host != null) {
                b.append(host);
            }
            if (port != null || serv != null) {
                b.append(':');
            }
            if (port != null) {
                b.append(port);
            }
            if (serv != null) {
                b.append(':').append(serv);
            }
            return b.toString();
        }
        return rdb;
    }

    static {
        Companion = new Companion(null);
        REGEX_OPTIONS = SetsKt.setOf((Object[])new RegexOption[]{RegexOption.IGNORE_CASE, RegexOption.DOT_MATCHES_ALL});
        REMOTE_DESC_HOST_PATTERN = new Regex("\\(\\s*HOST\\s*=\\s*(.+?)\\s*\\)", REGEX_OPTIONS);
        REMOTE_DESC_PORT_PATTERN = new Regex("\\(\\s*PORT\\s*=\\s*(.+?)\\s*\\)", REGEX_OPTIONS);
        REMOTE_DESC_SERV_PATTERN = new Regex("\\(\\s*S(ID|ERVICE_NAME)\\s*=\\s*(.+?)\\s*\\)", REGEX_OPTIONS);
        SPACES_PATTERN = new Regex("\\s+", RegexOption.DOT_MATCHES_ALL);
        HEX_PATTERN = new Regex("[0-9A-Fa-f]+");
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006R\u0011\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0006R\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0006R\u0011\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/oracle/model/OraDescriptionService$Companion;", "", "()V", "HEX_PATTERN", "Lkotlin/text/Regex;", "getHEX_PATTERN", "()Lkotlin/text/Regex;", "REGEX_OPTIONS", "", "Lkotlin/text/RegexOption;", "getREGEX_OPTIONS", "()Ljava/util/Set;", "REMOTE_DESC_HOST_PATTERN", "getREMOTE_DESC_HOST_PATTERN", "REMOTE_DESC_PORT_PATTERN", "getREMOTE_DESC_PORT_PATTERN", "REMOTE_DESC_SERV_PATTERN", "getREMOTE_DESC_SERV_PATTERN", "SPACES_PATTERN", "getSPACES_PATTERN", "intellij.database.dialects.oracle"})
    private static final class Companion {
        @NotNull
        public final Set<RegexOption> getREGEX_OPTIONS() {
            return REGEX_OPTIONS;
        }

        @NotNull
        public final Regex getREMOTE_DESC_HOST_PATTERN() {
            return REMOTE_DESC_HOST_PATTERN;
        }

        @NotNull
        public final Regex getREMOTE_DESC_PORT_PATTERN() {
            return REMOTE_DESC_PORT_PATTERN;
        }

        @NotNull
        public final Regex getREMOTE_DESC_SERV_PATTERN() {
            return REMOTE_DESC_SERV_PATTERN;
        }

        @NotNull
        public final Regex getSPACES_PATTERN() {
            return SPACES_PATTERN;
        }

        @NotNull
        public final Regex getHEX_PATTERN() {
            return HEX_PATTERN;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

