/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.generator.producers;

import com.intellij.database.dialects.base.generator.AbstractScriptGeneratorKt;
import com.intellij.database.dialects.base.generator.BaseProducer;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.BaseProducersKt;
import com.intellij.database.dialects.base.generator.producers.CreateTable;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.properties.OraTableType;
import com.intellij.database.dialects.oracle.model.properties.TableOrganization;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0014J\u0010\u0010\u0012\u001a\u00020\u000b*\u00060\u0013R\u00020\u0004H\u0014\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/oracle/generator/producers/OraCreateTable;", "Lcom/intellij/database/dialects/base/generator/producers/CreateTable;", "Lcom/intellij/database/dialects/oracle/model/OraTable;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/dialects/oracle/model/OraTable;)V", "canComment", "Lcom/intellij/database/script/generator/ScriptingCapabilities$VersionedCapability;", "", "generateObjectTable", "", "produceComment", "exists", "comment", "", "produceCreate", "produceFooter", "produceHeader", "Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "intellij.database.dialects.oracle"})
public final class OraCreateTable
extends CreateTable<OraTable> {
    @Override
    public void produceCreate() {
        if (((OraTable)this.getElement()).getRowTypeObjectName() != null) {
            this.generateObjectTable();
        } else {
            super.produceCreate();
        }
    }

    private final void generateObjectTable() {
        String string;
        String $this$scr$iv;
        boolean $i$f$getScr;
        BaseProducer this_$iv;
        String objectSchemaName = ((OraTable)this.getElement()).getRowTypeSchemaName();
        if (Intrinsics.areEqual((Object)objectSchemaName, (Object)((OraTable)this.getElement()).getSchemaName())) {
            objectSchemaName = null;
        }
        String string2 = ((OraTable)this.getElement()).getRowTypeObjectName();
        Intrinsics.checkNotNull((Object)string2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"element.rowTypeObjectName!!");
        String objectName = string2;
        if (objectSchemaName == null) {
            String string3 = objectName;
            this_$iv = this;
            $i$f$getScr = false;
            string = this_$iv.getContext().getNaming().catToScript($this$scr$iv, null, ((SqlCodeStyleSettings)this_$iv.getOptions().get(ScriptingOptionStatic.CODE_STYLE)).getQuotesPriority());
        } else {
            $this$scr$iv = objectSchemaName;
            this_$iv = this;
            $i$f$getScr = false;
            StringBuilder stringBuilder = new StringBuilder().append(this_$iv.getContext().getNaming().catToScript($this$scr$iv, null, ((SqlCodeStyleSettings)this_$iv.getOptions().get(ScriptingOptionStatic.CODE_STYLE)).getQuotesPriority())).append('.');
            $this$scr$iv = objectName;
            this_$iv = this;
            $i$f$getScr = false;
            string = stringBuilder.append(this_$iv.getContext().getNaming().catToScript($this$scr$iv, null, ((SqlCodeStyleSettings)this_$iv.getOptions().get(ScriptingOptionStatic.CODE_STYLE)).getQuotesPriority())).toString();
        }
        String n = string;
        this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)new Function1<ScriptingContext.NewCodingAdapter, Unit>(this, n){
            final /* synthetic */ OraCreateTable this$0;
            final /* synthetic */ String $n;

            public final void invoke(@NotNull ScriptingContext.NewCodingAdapter $this$newCoding) {
                Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$receiver");
                $this$newCoding.plus($this$newCoding.plus($this$newCoding.plus($this$newCoding.unaryPlus("create table"), this.this$0.fqName()), "of"), this.$n);
            }
            {
                this.this$0 = oraCreateTable;
                this.$n = string;
                super(1);
            }
        }));
    }

    @Override
    protected void produceHeader(@NotNull ScriptingContext.NewCodingAdapter $this$produceHeader) {
        Intrinsics.checkNotNullParameter((Object)$this$produceHeader, (String)"$this$produceHeader");
        if (((OraTable)this.getElement()).isTemporary()) {
            ScriptingContext.NewCodingAdapter newCodingAdapter = $this$produceHeader.unaryPlus("create global temporary table");
            ObjectKind objectKind = ((OraTable)this.getElement()).getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"element.kind");
            $this$produceHeader.plus($this$produceHeader.plus(newCodingAdapter, BaseProducersKt.ifNotExists(this, objectKind, false)), this.fqName());
        } else {
            ScriptingContext.NewCodingAdapter newCodingAdapter = $this$produceHeader.unaryPlus("create table");
            ObjectKind objectKind = ((OraTable)this.getElement()).getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"element.kind");
            $this$produceHeader.plus($this$produceHeader.plus(newCodingAdapter, BaseProducersKt.ifNotExists(this, objectKind, false)), this.fqName());
        }
    }

    @Override
    protected void produceFooter() {
        this.sqlClause((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)new Function1<ScriptingContext.NewCodingAdapter, Unit>(this){
            final /* synthetic */ OraCreateTable this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ScriptingContext.NewCodingAdapter $this$sqlClause) {
                block3: {
                    OraTable tab;
                    block4: {
                        block2: {
                            void $this$scr$iv;
                            Intrinsics.checkNotNullParameter((Object)$this$sqlClause, (String)"$receiver");
                            tab = (OraTable)this.this$0.getElement();
                            if (tab.getClusterName() == null) break block2;
                            String string = tab.getClusterName();
                            Intrinsics.checkNotNull((Object)string);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tab.clusterName!!");
                            String string2 = string;
                            BaseProducer this_$iv = this.this$0;
                            boolean $i$f$getScr = false;
                            String cn = this_$iv.getContext().getNaming().catToScript((String)$this$scr$iv, null, ((SqlCodeStyleSettings)this_$iv.getOptions().get(ScriptingOptionStatic.CODE_STYLE)).getQuotesPriority());
                            List<String> list = tab.getClusterColNames();
                            Intrinsics.checkNotNullExpressionValue(list, (String)"tab.clusterColNames");
                            String cols2 = OraCreateTable.access$getScr$p(this.this$0, list);
                            $this$sqlClause.minus($this$sqlClause.minus($this$sqlClause.plus($this$sqlClause.plus($this$sqlClause.unaryPlus("cluster"), cn), "("), cols2), ")");
                            break block3;
                        }
                        if (tab.getOrganization() != TableOrganization.INDEX) break block4;
                        $this$sqlClause.unaryPlus("organization index");
                        break block3;
                    }
                    if (!tab.isTemporary()) break block3;
                    if (tab.isTemporaryPreserve()) {
                        $this$sqlClause.unaryPlus("on commit preserve rows");
                    } else {
                        $this$sqlClause.unaryPlus("on commit delete rows");
                    }
                }
            }
            {
                this.this$0 = oraCreateTable;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    protected ScriptingCapabilities.VersionedCapability<Boolean> canComment() {
        return ((OraTable)this.getElement()).getTableType() == OraTableType.BASIC ? AbstractScriptGeneratorKt.getSUPPORTED() : AbstractScriptGeneratorKt.getUNSUPPORTED();
    }

    @Override
    public void produceComment(boolean exists, @Nullable String comment) {
        BaseProducersKt.commentStatement$default(this, "table", comment, null, 4, null);
    }

    public OraCreateTable(@NotNull ScriptingContext context, @NotNull OraTable element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(context, (BasicTable)element);
    }

    public static final /* synthetic */ String access$getScr$p(OraCreateTable $this, Iterable $this$access_u24scr_u24p) {
        return $this.getScr($this$access_u24scr_u24p);
    }
}

