/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.generator;

import com.intellij.database.dialects.base.generator.AbstractCodeGenerator;
import com.intellij.database.dialects.base.generator.BaseExecuteGenerator;
import com.intellij.database.dialects.base.generator.ElementProducer;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.oracle.generator.OraExecuteGenerator$WhenMappings;
import com.intellij.database.dialects.oracle.generator.OraRoutineArgumentsAnalyzer;
import com.intellij.database.dialects.oracle.generator.OraScriptGeneratorHelper;
import com.intellij.database.dialects.oracle.model.OraArgument;
import com.intellij.database.dialects.oracle.model.OraPackage;
import com.intellij.database.dialects.oracle.model.OraPackageRoutine;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.dialects.oracle.model.OraSingleRoutine;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasBuiltinTypeWithPrecision;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.sql.dialects.oracle.OraTypeService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0003 !\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002\u00a8\u0006#"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator;", "Lcom/intellij/database/dialects/base/generator/BaseExecuteGenerator;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;)V", "argumentName", "", "argument", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "dataType", "generateRoutine", "", "producer", "Lcom/intellij/database/dialects/base/generator/ElementProducer;", "Lcom/intellij/database/model/basic/BasicRoutine;", "guessDefaultValue", "dt", "Lcom/intellij/database/types/DasType;", "makeExecuteOperation", "Lcom/intellij/database/dialects/base/generator/Operation;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "root", "makeExecutePackage", "Lcom/intellij/database/dialects/oracle/model/OraPackage;", "mustSpecifyPrecision", "", "type", "Lcom/intellij/database/model/DataType;", "precision", "", "typeName", "AsResultSets", "DataProducingWay", "DbmsOutput", "intellij.database.dialects.oracle"})
public final class OraExecuteGenerator
extends BaseExecuteGenerator {
    @Override
    @Nullable
    public Operation makeExecuteOperation(@NotNull BasicElement element, @NotNull Operation root2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        BasicElement basicElement = element;
        return basicElement instanceof OraPackage ? this.makeExecutePackage((OraPackage)element, root2) : super.makeExecuteOperation(element, root2);
    }

    private final Operation makeExecutePackage(OraPackage element, Operation root2) {
        ModNamingFamily<? extends OraPackageRoutine> modNamingFamily = element.getRoutines();
        Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"element.routines");
        Iterable $this$forEach$iv = (Iterable)modNamingFamily;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OraPackageRoutine it = (OraPackageRoutine)element$iv;
            boolean bl = false;
            OraPackageRoutine oraPackageRoutine = it;
            Intrinsics.checkNotNullExpressionValue((Object)oraPackageRoutine, (String)"it");
            BaseExecuteGenerator.prepareElement$default(this, (BasicElement)oraPackageRoutine, root2, false, 4, null);
        }
        return null;
    }

    @Override
    protected void generateRoutine(@NotNull ElementProducer<BasicRoutine> producer) {
        String string;
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        BasicRoutine basicRoutine = producer.getElement();
        if (basicRoutine == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraRoutine");
        }
        OraRoutine routine2 = (OraRoutine)basicRoutine;
        OraRoutine oraRoutine = routine2;
        if (oraRoutine instanceof OraSingleRoutine) {
            string = AbstractCodeGenerator.currentScopeName$default(this, (BasicElement)routine2, null, 1, null);
        } else if (oraRoutine instanceof OraPackageRoutine) {
            StringBuilder stringBuilder = new StringBuilder();
            OraPackage oraPackage = ((OraPackageRoutine)routine2).getPackage();
            Intrinsics.checkNotNull((Object)oraPackage);
            Intrinsics.checkNotNullExpressionValue((Object)oraPackage, (String)"routine.`package`!!");
            string = stringBuilder.append(AbstractCodeGenerator.currentScopeName$default(this, (BasicElement)oraPackage, null, 1, null)).append('.').append(AbstractCodeGenerator.quote$default(this, (BasicElement)routine2, null, 2, null)).toString();
        } else {
            return;
        }
        String callName = string;
        ModPositioningNamingFamily<? extends OraArgument> modPositioningNamingFamily = routine2.getArguments();
        Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"routine.arguments");
        List arguments = CollectionsKt.toList((Iterable)((Iterable)modPositioningNamingFamily));
        int n = arguments.size();
        OraRoutineArgumentsAnalyzer analyzer = new OraRoutineArgumentsAnalyzer(routine2);
        OraArgument ret = analyzer.getReturnArgument();
        List<OraArgument> cursors = analyzer.getCursorArguments();
        List<OraArgument> associative = analyzer.getAssociativeArrayArguments();
        List<OraArgument> sqlArrays = analyzer.getSqlTypeArrayArguments();
        List<OraArgument> plArrays = analyzer.getPlTypeArrayArguments();
        List<OraArgument> sqlTables = analyzer.getSqlTypeNestedTableArguments();
        List<OraArgument> plTables = analyzer.getPlTypeNestedTableArguments();
        List<OraRoutineArgumentsAnalyzer.PrimitivesPack> primitives = analyzer.getPrimitives(this.getContext().getTask().getVersion());
        DataProducingWay way = (Boolean)this.getContext().getOptions().get(ScriptingOptionStatic.CALL) != false ? (DataProducingWay)new AsResultSets(this) : (DataProducingWay)new DbmsOutput(this);
        this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)new Function1<ScriptingContext.NewCodingAdapter, Unit>(this, arguments, n, ret, callName, way, plArrays, plTables, associative, cursors, sqlArrays, sqlTables, primitives){
            final /* synthetic */ OraExecuteGenerator this$0;
            final /* synthetic */ List $arguments;
            final /* synthetic */ int $n;
            final /* synthetic */ OraArgument $ret;
            final /* synthetic */ String $callName;
            final /* synthetic */ DataProducingWay $way;
            final /* synthetic */ List $plArrays;
            final /* synthetic */ List $plTables;
            final /* synthetic */ List $associative;
            final /* synthetic */ List $cursors;
            final /* synthetic */ List $sqlArrays;
            final /* synthetic */ List $sqlTables;
            final /* synthetic */ List $primitives;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ScriptingContext.NewCodingAdapter $this$newCoding) {
                boolean $i$f$withNewLines;
                boolean nl$iv;
                Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$receiver");
                ScriptingContext.NewCodingAdapter this_$iv = $this$newCoding;
                boolean nl$iv2 = true;
                boolean $i$f$withNewLines22 = false;
                boolean prev$iv = this_$iv.getStartWithNewLine();
                this_$iv.setStartWithNewLine(nl$iv2);
                boolean bl = false;
                Collection collection = this.$arguments;
                boolean bl2 = false;
                if (!collection.isEmpty()) {
                    $this$newCoding.unaryPlus("declare");
                    ScriptingContext.NewCodingAdapter this_$iv2 = $this$newCoding;
                    boolean $i$f$indenting = false;
                    boolean prev$iv2 = this_$iv2.getOnNewLine();
                    int length$iv = this_$iv2.getBuilder().getLength();
                    this_$iv2.newLine();
                    this_$iv2.indent();
                    boolean bl3 = false;
                    Iterator<E> iterator = this.$arguments.iterator();
                    while (iterator.hasNext()) {
                        String string;
                        ArgumentDirection dir;
                        OraArgument a;
                        OraArgument oraArgument = a = (OraArgument)iterator.next();
                        Intrinsics.checkNotNullExpressionValue((Object)oraArgument, (String)"a");
                        Intrinsics.checkNotNullExpressionValue((Object)oraArgument.getArgumentDirection(), (String)"a.argumentDirection");
                        Intrinsics.checkNotNullExpressionValue((Object)a.getDasType(), (String)"a.dasType");
                        String specification = OraExecuteGenerator.access$dataType(this.this$0, a);
                        switch (OraExecuteGenerator$WhenMappings.$EnumSwitchMapping$0[dir.ordinal()]) {
                            case 1: 
                            case 2: {
                                DasType dt;
                                String defaultValue = OraExecuteGenerator.access$guessDefaultValue(this.this$0, dt);
                                string = OraExecuteGenerator.access$argumentName(this.this$0, a) + ' ' + specification + " := " + defaultValue + ';';
                                break;
                            }
                            case 3: 
                            case 4: {
                                string = OraExecuteGenerator.access$argumentName(this.this$0, a) + ' ' + specification + ';';
                                break;
                            }
                            default: {
                                string = null;
                            }
                        }
                        String line = string;
                        $this$newCoding.unaryPlus(line);
                    }
                    this_$iv2.unindent();
                    if (length$iv == this_$iv2.getBuilder().getLength()) {
                        this_$iv2.setOnNewLine(prev$iv2);
                    }
                }
                $this$newCoding.unaryPlus("begin");
                this_$iv.setStartWithNewLine(prev$iv);
                ArrayList<String> passing = new ArrayList<String>(this.$n);
                Iterator<E> $i$f$withNewLines22 = this.$arguments.iterator();
                while ($i$f$withNewLines22.hasNext()) {
                    OraArgument a;
                    OraArgument oraArgument = a = (OraArgument)$i$f$withNewLines22.next();
                    Intrinsics.checkNotNullExpressionValue((Object)oraArgument, (String)"a");
                    switch (OraExecuteGenerator$WhenMappings.$EnumSwitchMapping$1[oraArgument.getArgumentDirection().ordinal()]) {
                        case 1: 
                        case 2: 
                        case 3: {
                            passing.add(OraExecuteGenerator.access$argumentName(this.this$0, a) + " => " + OraExecuteGenerator.access$argumentName(this.this$0, a));
                            break;
                        }
                    }
                }
                String retClause = this.$ret != null ? "result :=" : null;
                ScriptingContext.NewCodingAdapter this_$iv3 = $this$newCoding;
                boolean $i$f$indenting = false;
                boolean prev$iv3 = this_$iv3.getOnNewLine();
                int length$iv = this_$iv3.getBuilder().getLength();
                this_$iv3.newLine();
                this_$iv3.indent();
                boolean bl4 = false;
                $this$newCoding.unaryPlus(retClause);
                if (passing.size() == 0) {
                    $this$newCoding.unaryPlus(this.$callName + ';');
                } else if (passing.size() == 1) {
                    String passingText = (String)CollectionsKt.first((List)passing);
                    $this$newCoding.unaryPlus(this.$callName + '(' + passingText + ");");
                } else {
                    $this$newCoding.unaryPlus(this.$callName + '(');
                    ScriptingContext.NewCodingAdapter this_$iv4 = $this$newCoding;
                    nl$iv = true;
                    $i$f$withNewLines = false;
                    boolean prev$iv4 = this_$iv4.getStartWithNewLine();
                    this_$iv4.setStartWithNewLine(nl$iv);
                    boolean bl5 = false;
                    ScriptingContext.NewCodingAdapter this_$iv5 = $this$newCoding;
                    boolean $i$f$indenting2 = false;
                    boolean prev$iv5 = this_$iv5.getOnNewLine();
                    int length$iv2 = this_$iv5.getBuilder().getLength();
                    this_$iv5.newLine();
                    this_$iv5.indent();
                    boolean bl6 = false;
                    boolean bl7 = false;
                    for (String p : (Iterable)passing) {
                        void i2;
                        $this$newCoding.unaryPlus(i2 + true < passing.size() ? p + ',' : p);
                        ++i2;
                    }
                    this_$iv5.unindent();
                    if (length$iv2 == this_$iv5.getBuilder().getLength()) {
                        this_$iv5.setOnNewLine(prev$iv5);
                    }
                    $this$newCoding.unaryPlus(");");
                    this_$iv4.setStartWithNewLine(prev$iv4);
                }
                ScriptingContext.NewCodingAdapter this_$iv6 = $this$newCoding;
                nl$iv = true;
                $i$f$withNewLines = false;
                boolean prev$iv6 = this_$iv6.getStartWithNewLine();
                this_$iv6.setStartWithNewLine(nl$iv);
                boolean bl8 = false;
                this.$way.producePlArrays($this$newCoding, this.$plArrays);
                this.$way.producePlTables($this$newCoding, this.$plTables);
                this.$way.produceAssociativeArrays($this$newCoding, this.$associative);
                this.$way.produceCursors($this$newCoding, this.$cursors);
                this.$way.produceSqlArrays($this$newCoding, this.$sqlArrays);
                this.$way.produceSqlTables($this$newCoding, this.$sqlTables);
                this.$way.producePrimitives($this$newCoding, this.$primitives);
                this_$iv6.setStartWithNewLine(prev$iv6);
                this_$iv3.unindent();
                if (length$iv == this_$iv3.getBuilder().getLength()) {
                    this_$iv3.setOnNewLine(prev$iv3);
                }
                this_$iv3 = $this$newCoding;
                boolean nl$iv3 = true;
                boolean $i$f$withNewLines3 = false;
                boolean prev$iv7 = this_$iv3.getStartWithNewLine();
                this_$iv3.setStartWithNewLine(nl$iv3);
                boolean bl9 = false;
                $this$newCoding.unaryPlus("end;");
                this_$iv3.setStartWithNewLine(prev$iv7);
            }
            {
                this.this$0 = oraExecuteGenerator;
                this.$arguments = list;
                this.$n = n;
                this.$ret = oraArgument;
                this.$callName = string;
                this.$way = dataProducingWay;
                this.$plArrays = list2;
                this.$plTables = list3;
                this.$associative = list4;
                this.$cursors = list5;
                this.$sqlArrays = list6;
                this.$sqlTables = list7;
                this.$primitives = list8;
                super(1);
            }
        }));
    }

    private final String argumentName(OraArgument argument) {
        return argument.getArgumentDirection() == ArgumentDirection.RETURN ? "result" : AbstractCodeGenerator.quote$default(this, (BasicElement)argument, null, 2, null);
    }

    private final String dataType(OraArgument argument) {
        String string;
        DataType dataType = argument.getDataType();
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"argument.dataType");
        DataType type = dataType;
        if (StringsKt.equals((String)type.typeName, (String)"ref cursor", (boolean)true)) {
            string = "sys_refcursor";
        } else if (this.mustSpecifyPrecision(type)) {
            ScriptingOptions scriptingOptions = this.getContext().getOptions();
            StringBuilder stringBuilder = new StringBuilder().append(type.typeName).append('(');
            String string2 = type.typeName;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"type.typeName");
            string = OraScriptGeneratorHelper.INSTANCE.optionsDependentSpecification(type, scriptingOptions, stringBuilder.append(this.precision(string2)).append(')').toString());
        } else {
            string = this.script(type);
        }
        return string;
    }

    private final int precision(String typeName) {
        boolean bl;
        block1: {
            String[] $this$any$iv = new String[]{"char", "nchar"};
            boolean $i$f$any = false;
            String[] stringArray = $this$any$iv;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String element$iv;
                String it = element$iv = stringArray[j];
                boolean bl2 = false;
                if (!StringsKt.equals((String)it, (String)typeName, (boolean)true)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl ? 50 : 4000;
    }

    private final boolean mustSpecifyPrecision(DataType type) {
        boolean bl;
        block1: {
            String[] $this$any$iv = new String[]{"varchar", "char", "varchar2", "nchar", "nvarchar2"};
            boolean $i$f$any = false;
            String[] stringArray = $this$any$iv;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String element$iv;
                String it = element$iv = stringArray[j];
                boolean bl2 = false;
                if (!StringsKt.equals((String)it, (String)type.typeName, (boolean)true)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl && !type.custom && type.schemaName == null && type.packageName == null && type.size < 0 && type.enumValues == null && type.vagueArg == null && type.suffix == null;
    }

    private final String guessDefaultValue(DasType dt) {
        if (!(dt instanceof DasBuiltinType)) {
            return "null";
        }
        switch (OraExecuteGenerator$WhenMappings.$EnumSwitchMapping$2[((DasBuiltinType)dt).getKind().ordinal()]) {
            case 1: {
                DasBuiltinType unwrappedDt = DasTypeUtilsKt.unwrap((DasBuiltinType)((DasBuiltinType)dt));
                if (unwrappedDt instanceof DasBuiltinTypeWithPrecision && ((DasBuiltinTypeWithPrecision)unwrappedDt).getScale() != 0) {
                    return "0.0";
                }
                if (OraTypeService.floatingPointTypeNames.contains(unwrappedDt.getName())) {
                    return "0.0";
                }
                return "0";
            }
            case 2: {
                return "sysdate";
            }
            case 3: {
                return "''";
            }
        }
        return "null";
    }

    public OraExecuteGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    public static final /* synthetic */ String access$dataType(OraExecuteGenerator $this, OraArgument argument) {
        return $this.dataType(argument);
    }

    public static final /* synthetic */ String access$guessDefaultValue(OraExecuteGenerator $this, DasType dt) {
        return $this.guessDefaultValue(dt);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\bb\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH&J\"\u0010\n\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\bH&J\"\u0010\f\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bH&J\"\u0010\u000e\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bH&J\"\u0010\u000f\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bH&J\"\u0010\u0012\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bH&J\"\u0010\u0013\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bH&\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator$DataProducingWay;", "", "produceAssociativeArrays", "", "adapter", "Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "associative", "", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "produceCursors", "cursors", "producePlArrays", "arrays", "producePlTables", "producePrimitives", "primitives", "Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$PrimitivesPack;", "produceSqlArrays", "produceSqlTables", "intellij.database.dialects.oracle"})
    private static interface DataProducingWay {
        public void producePrimitives(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<OraRoutineArgumentsAnalyzer.PrimitivesPack> var2);

        public void produceCursors(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);

        public void produceSqlArrays(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);

        public void producePlArrays(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);

        public void produceSqlTables(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);

        public void producePlTables(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);

        public void produceAssociativeArrays(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u000f\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0011\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0013\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0014\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\rH\u0016J\"\u0010\u0017\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0018\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator$AsResultSets;", "Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator$DataProducingWay;", "generator", "Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator;", "(Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator;)V", "commentMaybe", "", "produceAssociativeArrays", "", "adapter", "Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "associative", "", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "produceCursors", "cursors", "producePlArrays", "arrays", "producePlTables", "producePrimitives", "primitives", "Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$PrimitivesPack;", "produceSqlArrays", "produceSqlTables", "intellij.database.dialects.oracle"})
    private static final class AsResultSets
    implements DataProducingWay {
        private final OraExecuteGenerator generator;

        @Override
        public void producePrimitives(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<OraRoutineArgumentsAnalyzer.PrimitivesPack> primitives) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(primitives, (String)"primitives");
            if (primitives.isEmpty()) {
                return;
            }
            ScriptingContext.NewCodingAdapter newCodingAdapter = adapter;
            boolean bl = false;
            boolean bl2 = false;
            ScriptingContext.NewCodingAdapter $this$apply = newCodingAdapter;
            boolean bl3 = false;
            for (OraRoutineArgumentsAnalyzer.PrimitivesPack pack : primitives) {
                $this$apply.plus($this$apply.plus($this$apply.unaryPlus((pack.getEnabled() ? "" : "-- ") + "open ? for select "), CollectionsKt.joinToString$default((Iterable)pack.getArguments(), null, null, null, (int)0, null, (Function1)((Function1)new Function1<OraArgument, CharSequence>(this, primitives){
                    final /* synthetic */ AsResultSets this$0;
                    final /* synthetic */ List $primitives$inlined;
                    {
                        this.this$0 = asResultSets;
                        this.$primitives$inlined = list;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull OraArgument it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        String argumentName = OraExecuteGenerator.access$argumentName(AsResultSets.access$getGenerator$p(this.this$0), it);
                        return argumentName + " as " + argumentName;
                    }
                }), (int)31, null)), "from dual;");
            }
        }

        @Override
        public void produceCursors(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> cursors) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(cursors, (String)"cursors");
            ScriptingContext.NewCodingAdapter newCodingAdapter = adapter;
            boolean bl = false;
            boolean bl2 = false;
            ScriptingContext.NewCodingAdapter $this$apply = newCodingAdapter;
            boolean bl3 = false;
            for (OraArgument oraArgument : cursors) {
                $this$apply.unaryPlus("? := " + this.generator.argumentName(oraArgument) + ';');
            }
        }

        @Override
        public void produceSqlArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            ScriptingContext.NewCodingAdapter newCodingAdapter = adapter;
            boolean bl = false;
            boolean bl2 = false;
            ScriptingContext.NewCodingAdapter $this$apply = newCodingAdapter;
            boolean bl3 = false;
            for (OraArgument oraArgument : arrays) {
                $this$apply.unaryPlus("open ? for select * from table(" + this.generator.argumentName(oraArgument) + ");");
            }
        }

        @Override
        public void producePlArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            ScriptingContext.NewCodingAdapter newCodingAdapter = adapter;
            boolean bl = false;
            boolean bl2 = false;
            ScriptingContext.NewCodingAdapter $this$apply = newCodingAdapter;
            boolean bl3 = false;
            for (OraArgument oraArgument : arrays) {
                $this$apply.unaryPlus(this.commentMaybe() + "open ? for select * from table(" + this.generator.argumentName(oraArgument) + ");");
            }
        }

        @Override
        public void produceSqlTables(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            ScriptingContext.NewCodingAdapter newCodingAdapter = adapter;
            boolean bl = false;
            boolean bl2 = false;
            ScriptingContext.NewCodingAdapter $this$apply = newCodingAdapter;
            boolean bl3 = false;
            for (OraArgument oraArgument : arrays) {
                $this$apply.unaryPlus("open ? for select * from table(" + this.generator.argumentName(oraArgument) + ");");
            }
        }

        @Override
        public void producePlTables(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            ScriptingContext.NewCodingAdapter newCodingAdapter = adapter;
            boolean bl = false;
            boolean bl2 = false;
            ScriptingContext.NewCodingAdapter $this$apply = newCodingAdapter;
            boolean bl3 = false;
            for (OraArgument oraArgument : arrays) {
                $this$apply.unaryPlus(this.commentMaybe() + "open ? for select * from table(" + this.generator.argumentName(oraArgument) + ");");
            }
        }

        @Override
        public void produceAssociativeArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> associative) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(associative, (String)"associative");
            ScriptingContext.NewCodingAdapter newCodingAdapter = adapter;
            boolean bl = false;
            boolean bl2 = false;
            ScriptingContext.NewCodingAdapter $this$apply = newCodingAdapter;
            boolean bl3 = false;
            for (OraArgument oraArgument : associative) {
                $this$apply.unaryPlus("-- open ? for select * from table(" + this.generator.argumentName(oraArgument) + ");");
            }
        }

        private final String commentMaybe() {
            return OraRoutineArgumentsAnalyzer.Companion.supportPlTypesInSql(this.generator.getContext().getTask().getVersion()) ? "" : "-- ";
        }

        public AsResultSets(@NotNull OraExecuteGenerator generator) {
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            this.generator = generator;
        }

        public static final /* synthetic */ OraExecuteGenerator access$getGenerator$p(AsResultSets $this) {
            return $this.generator;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\"\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\"\u0010\u000f\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\"\u0010\u0010\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0012\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0014\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0016\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0017\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\rH\u0016J\"\u0010\u001a\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u001b\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator$DbmsOutput;", "Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator$DataProducingWay;", "generator", "Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator;", "(Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator;)V", "print", "", "adapter", "Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "prefix", "", "arguments", "", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "printCommented", "produceAssociativeArrays", "associative", "produceCursors", "cursors", "producePlArrays", "arrays", "producePlTables", "producePrimitives", "primitives", "Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$PrimitivesPack;", "produceSqlArrays", "produceSqlTables", "intellij.database.dialects.oracle"})
    private static final class DbmsOutput
    implements DataProducingWay {
        private final OraExecuteGenerator generator;

        /*
         * WARNING - void declaration
         */
        @Override
        public void producePrimitives(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<OraRoutineArgumentsAnalyzer.PrimitivesPack> primitives) {
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Object it;
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(primitives, (String)"primitives");
            Iterable $this$flatMap$iv = primitives;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (OraRoutineArgumentsAnalyzer.PrimitivesPack)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = ((OraRoutineArgumentsAnalyzer.PrimitivesPack)it).getArguments();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List arguments = (List)destination$iv$iv;
            $this$flatMap$iv = arguments;
            ScriptingContext.NewCodingAdapter newCodingAdapter = adapter;
            DbmsOutput dbmsOutput = this;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (OraArgument)element$iv$iv;
                boolean bl = false;
                if (!it.getDataType().custom) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            dbmsOutput.printCommented(newCodingAdapter, list);
            $this$filter$iv = arguments;
            newCodingAdapter = adapter;
            dbmsOutput = this;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (OraArgument)element$iv$iv;
                boolean bl = false;
                if (!(!it.getDataType().custom)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
            dbmsOutput.print(newCodingAdapter, list);
        }

        @Override
        public void produceCursors(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> cursors) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(cursors, (String)"cursors");
            this.printCommented(adapter, cursors);
        }

        @Override
        public void produceSqlArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            this.printCommented(adapter, arrays);
        }

        @Override
        public void producePlArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            this.printCommented(adapter, arrays);
        }

        @Override
        public void producePlTables(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            this.printCommented(adapter, arrays);
        }

        @Override
        public void produceSqlTables(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            this.printCommented(adapter, arrays);
        }

        @Override
        public void produceAssociativeArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> associative) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(associative, (String)"associative");
            this.printCommented(adapter, associative);
        }

        private final void printCommented(ScriptingContext.NewCodingAdapter adapter, List<? extends OraArgument> arguments) {
            this.print(adapter, "-- ", arguments);
        }

        private final void print(ScriptingContext.NewCodingAdapter adapter, List<? extends OraArgument> arguments) {
            this.print(adapter, "", arguments);
        }

        private final void print(ScriptingContext.NewCodingAdapter adapter, String prefix, List<? extends OraArgument> arguments) {
            ScriptingContext.NewCodingAdapter newCodingAdapter = adapter;
            boolean bl = false;
            boolean bl2 = false;
            ScriptingContext.NewCodingAdapter $this$apply = newCodingAdapter;
            boolean bl3 = false;
            for (OraArgument oraArgument : arguments) {
                String argumentName = this.generator.argumentName(oraArgument);
                $this$apply.unaryPlus(prefix + "dbms_output.put_line('" + argumentName + " = ' || " + argumentName + ");");
            }
        }

        public DbmsOutput(@NotNull OraExecuteGenerator generator) {
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            this.generator = generator;
        }
    }
}

