/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.debugger.SqlProgramSource;
import com.intellij.database.dialects.oracle.debugger.OraNamespace;
import com.intellij.database.dialects.oracle.debugger.OraProgram;
import com.intellij.database.dialects.oracle.debugger.OraProgramSources$WhenMappings;
import com.intellij.database.dialects.oracle.model.OraBody;
import com.intellij.database.dialects.oracle.model.OraMajorObject;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraMatViewTrigger;
import com.intellij.database.dialects.oracle.model.OraModel;
import com.intellij.database.dialects.oracle.model.OraObjectType;
import com.intellij.database.dialects.oracle.model.OraPackage;
import com.intellij.database.dialects.oracle.model.OraRoot;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraSingleRoutine;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraTableTrigger;
import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.dialects.oracle.model.OraView;
import com.intellij.database.dialects.oracle.model.OraViewTrigger;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.util.containers.SLRUCache;
import java.util.Iterator;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\u000bJ\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\"\u0010 \u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001eH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u001c2\u0006\u0010%\u001a\u00020\u001eH\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraProgramSources;", "", "project", "Lcom/intellij/openapi/project/Project;", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;)V", "getDs", "()Lcom/intellij/database/dataSource/LocalDataSource;", "programCache", "Lcom/intellij/util/containers/SLRUCache;", "Lcom/intellij/database/dialects/oracle/debugger/OraProgram;", "Ljava/util/Optional;", "Lcom/intellij/database/debugger/SqlProgramSource;", "getProject", "()Lcom/intellij/openapi/project/Project;", "psiManager", "Lcom/intellij/psi/PsiManager;", "findAssociatedVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "modelElement", "Lcom/intellij/database/dialects/oracle/model/OraSourceAware;", "findProgramSource", "program", "getProgramSource", "resolveBodyObject", "Lcom/intellij/database/dialects/oracle/model/OraBody;", "schema", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "name", "", "resolveModelElement", "resolveModelProgramObject", "namespace", "Lcom/intellij/database/dialects/oracle/debugger/OraNamespace;", "programName", "resolveModelSchemaObject", "schemaName", "resolveTopLevelProgramObject", "resolveTriggerObject", "Lcom/intellij/database/dialects/oracle/model/OraTrigger;", "intellij.database.dialects.oracle"})
public final class OraProgramSources {
    private final PsiManager psiManager;
    private final SLRUCache<OraProgram, Optional<SqlProgramSource>> programCache;
    @NotNull
    private final Project project;
    @NotNull
    private final LocalDataSource ds;

    @Nullable
    public final SqlProgramSource getProgramSource(@NotNull OraProgram program) {
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        return ((Optional)this.programCache.get((Object)program)).orElse(null);
    }

    private final Optional<SqlProgramSource> findProgramSource(OraProgram program) {
        OraSourceAware oraSourceAware = this.resolveModelElement(program);
        if (oraSourceAware == null) {
            Optional<SqlProgramSource> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"Optional.empty()");
            return optional;
        }
        OraSourceAware modelElement = oraSourceAware;
        VirtualFile virtualFile = this.findAssociatedVirtualFile(modelElement);
        if (virtualFile == null) {
            Optional<SqlProgramSource> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"Optional.empty()");
            return optional;
        }
        VirtualFile virtualFile2 = virtualFile;
        PsiFile psiFile = this.psiManager.findFile(virtualFile2);
        ObjectKind objectKind = modelElement.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"modelElement.kind");
        Optional<SqlProgramSource> optional = Optional.of(new SqlProgramSource(objectKind, (BasicSourceAware)modelElement, virtualFile2, psiFile));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"Optional.of(SqlProgramSo\u2026t, virtualFile, psiFile))");
        return optional;
    }

    private final OraSourceAware resolveModelElement(OraProgram program) {
        OraSchema oraSchema = this.resolveModelSchemaObject(program.getSchemaName());
        if (oraSchema == null) {
            return null;
        }
        OraSchema schema = oraSchema;
        return this.resolveModelProgramObject(schema, program.getNamespace(), program.getProgramName());
    }

    private final OraSchema resolveModelSchemaObject(String schemaName) {
        DasModel dasModel = this.ds.getModel();
        if (!(dasModel instanceof OraModel)) {
            dasModel = null;
        }
        OraModel oraModel = (OraModel)dasModel;
        if (oraModel == null) {
            return null;
        }
        OraModel model = oraModel;
        OraRoot oraRoot = model.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)oraRoot, (String)"model.root");
        OraRoot database = oraRoot;
        return (OraSchema)database.getSchemas().get(schemaName);
    }

    private final OraSourceAware resolveModelProgramObject(OraSchema schema, OraNamespace namespace, String programName) {
        OraSourceAware oraSourceAware;
        switch (OraProgramSources$WhenMappings.$EnumSwitchMapping$0[namespace.ordinal()]) {
            case 1: 
            case 2: {
                oraSourceAware = null;
                break;
            }
            case 3: {
                oraSourceAware = this.resolveTopLevelProgramObject(schema, programName);
                break;
            }
            case 4: {
                oraSourceAware = this.resolveBodyObject(schema, programName);
                break;
            }
            case 5: {
                oraSourceAware = this.resolveTriggerObject(schema, programName);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return oraSourceAware;
    }

    private final OraSourceAware resolveTopLevelProgramObject(OraSchema schema, String name2) {
        OraSingleRoutine routine2 = (OraSingleRoutine)schema.getRoutines().get(name2);
        if (routine2 != null) {
            return routine2;
        }
        OraPackage oraPackage = (OraPackage)schema.getPackages().get(name2);
        if (oraPackage != null) {
            return oraPackage;
        }
        OraObjectType objectType = (OraObjectType)schema.getObjectTypes().get(name2);
        if (objectType != null) {
            return objectType;
        }
        return null;
    }

    private final OraBody resolveBodyObject(OraSchema schema, String name2) {
        OraPackage oraPackage = (OraPackage)schema.getPackages().get(name2);
        if (oraPackage != null) {
            return (OraBody)oraPackage.getBodies().get();
        }
        OraObjectType objectType = (OraObjectType)schema.getObjectTypes().get(name2);
        if (objectType != null) {
            return (OraBody)objectType.getBodies().get();
        }
        return null;
    }

    private final OraTrigger resolveTriggerObject(OraSchema schema, String name2) {
        OraTrigger trigger;
        Iterator iterator = schema.getTables().iterator();
        while (iterator.hasNext()) {
            OraTable table;
            OraTable oraTable = table = (OraTable)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)oraTable, (String)"table");
            trigger = (OraTableTrigger)oraTable.getTriggers().get(name2);
            if (!(trigger instanceof OraTrigger)) continue;
            return trigger;
        }
        for (OraMajorObject view : schema.getMatViews()) {
            OraMatView oraMatView = view;
            Intrinsics.checkNotNullExpressionValue((Object)oraMatView, (String)"view");
            trigger = (OraMatViewTrigger)oraMatView.getTriggers().get(name2);
            if (!(trigger instanceof OraTrigger)) continue;
            return trigger;
        }
        iterator = schema.getViews().iterator();
        while (iterator.hasNext()) {
            OraMajorObject view;
            OraMajorObject oraMajorObject = view = (OraView)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)oraMajorObject, (String)"view");
            trigger = (OraViewTrigger)oraMajorObject.getTriggers().get(name2);
            if (!(trigger instanceof OraTrigger)) continue;
            return trigger;
        }
        return null;
    }

    private final VirtualFile findAssociatedVirtualFile(OraSourceAware modelElement) {
        return DbSrcUtils.findDbSrcFile((Project)this.project, (LocalDataSource)this.ds, (DasObject)((DasObject)modelElement), null, (boolean)true);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final LocalDataSource getDs() {
        return this.ds;
    }

    public OraProgramSources(@NotNull Project project, @NotNull LocalDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        this.project = project;
        this.ds = ds;
        PsiManager psiManager = PsiManagerImpl.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManagerImpl.getInstance(project)");
        this.psiManager = psiManager;
        this.programCache = (SLRUCache)new SLRUCache<OraProgram, Optional<SqlProgramSource>>(this, 7, 7){
            final /* synthetic */ OraProgramSources this$0;

            @NotNull
            public Optional<SqlProgramSource> createValue(@NotNull OraProgram key2) {
                Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
                return OraProgramSources.access$findProgramSource(this.this$0, key2);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2);
            }
        };
    }

    public static final /* synthetic */ Optional access$findProgramSource(OraProgramSources $this, OraProgram program) {
        return $this.findProgramSource(program);
    }
}

