/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.oracle.debugger.OraDebuggerSettings;
import com.intellij.database.dialects.oracle.debugger.SteppingMode;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggerSteppingConfigurableUI;", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lcom/intellij/database/dialects/oracle/debugger/OraDebuggerSettings;", "()V", "steppingAtBeginCb", "Ljavax/swing/JCheckBox;", "steppingModeSelector", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/database/dialects/oracle/debugger/SteppingMode;", "apply", "", "settings", "getComponent", "Ljavax/swing/JComponent;", "isModified", "", "reset", "intellij.database.dialects.oracle"})
public final class OraDebuggerSteppingConfigurableUI
implements ConfigurableUi<OraDebuggerSettings> {
    private final ComboBox<SteppingMode> steppingModeSelector;
    private final JCheckBox steppingAtBeginCb;

    public void reset(@NotNull OraDebuggerSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.steppingModeSelector.setSelectedItem((Object)settings.getSteppingMode());
        this.steppingAtBeginCb.setSelected(settings.getSteppingPauseAtBegin());
    }

    public boolean isModified(@NotNull OraDebuggerSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return this.steppingModeSelector.getSelectedItem() != settings.getSteppingMode() || this.steppingAtBeginCb.isSelected() != settings.getSteppingPauseAtBegin();
    }

    public void apply(@NotNull OraDebuggerSettings settings) {
        SteppingMode steppingMode;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Object object = this.steppingModeSelector.getSelectedItem();
        if (!(object instanceof SteppingMode)) {
            object = null;
        }
        if ((steppingMode = (SteppingMode)((Object)object)) == null) {
            steppingMode = SteppingMode.STEPPING_GRACEFUL;
        }
        settings.setSteppingMode(steppingMode);
        settings.setSteppingPauseAtBegin(this.steppingAtBeginCb.isSelected());
    }

    @NotNull
    public JComponent getComponent() {
        JLabel jLabel = new JLabel(DatabaseBundle.message((String)"database.settings.debugger.steppingMode.label", (Object[])new Object[0]));
        boolean bl = false;
        boolean bl2 = false;
        JLabel $this$apply22 = jLabel;
        boolean bl3 = false;
        $this$apply22.setLabelFor((Component)this.steppingModeSelector);
        $this$apply22.setToolTipText(DatabaseBundle.message((String)"database.settings.debugger.steppingMode.explanation", (Object[])new Object[0]));
        JLabel steppingModeLabel = jLabel;
        JLabel jLabel2 = new JLabel(DatabaseBundle.message((String)"database.settings.debugger.pauseAtBegin.label", (Object[])new Object[0]));
        bl2 = false;
        boolean $this$apply22 = false;
        JLabel $this$apply = jLabel2;
        boolean bl4 = false;
        $this$apply.setLabelFor(this.steppingAtBeginCb);
        $this$apply.setToolTipText(DatabaseBundle.message((String)"database.settings.debugger.pauseAtBegin.explanation", (Object[])new Object[0]));
        JLabel steppingAtBeginLabel = jLabel2;
        JPanel grid = new JPanel(new GridBagLayout());
        grid.add((Component)steppingModeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        grid.add((Component)this.steppingModeSelector, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        grid.add((Component)steppingAtBeginLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        grid.add((Component)this.steppingAtBeginCb, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel corner = new JPanel(new FlowLayout(0));
        corner.add(grid);
        JBScrollPane scroller = new JBScrollPane((Component)corner);
        return (JComponent)scroller;
    }

    public OraDebuggerSteppingConfigurableUI() {
        Object $this$apply;
        Object object = new ComboBox((Object[])SteppingMode.values());
        boolean bl = false;
        boolean bl2 = false;
        ComboBox comboBox = object;
        OraDebuggerSteppingConfigurableUI oraDebuggerSteppingConfigurableUI = this;
        boolean bl3 = false;
        $this$apply.setToolTipText(DatabaseBundle.message((String)"database.settings.debugger.steppingMode.explanation", (Object[])new Object[0]));
        Unit unit = Unit.INSTANCE;
        oraDebuggerSteppingConfigurableUI.steppingModeSelector = object;
        object = new JCheckBox("");
        bl = false;
        bl2 = false;
        $this$apply = object;
        oraDebuggerSteppingConfigurableUI = this;
        boolean bl4 = false;
        ((JComponent)$this$apply).setToolTipText(DatabaseBundle.message((String)"database.settings.debugger.pauseAtBegin.explanation", (Object[])new Object[0]));
        unit = Unit.INSTANCE;
        oraDebuggerSteppingConfigurableUI.steppingAtBeginCb = object;
    }
}

