/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.statements.CallableStatementBasis;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.IndexedOutParameter;
import com.intellij.database.dataSource.connection.statements.NoisyStatement;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.oracle.debugger.CallDefinition;
import com.intellij.database.dialects.oracle.debugger.DebuggerUnableException;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang.text.StrBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u008a\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u001b\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010\u001a)\u0010\u000b\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0013\u001a&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001aO\u0010\u001b\u001a\u0002H\u001c\"\b\b\u0000\u0010\u001d*\u00020\u001e\"\u0004\b\u0001\u0010\u001c*\u00020\u00162\u0006\u0010\u001f\u001a\u0002H\u001d2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002H\u001c0!\u00a2\u0006\u0002\u0010#\u001a_\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H&0$\"\u0004\b\u0000\u0010%\"\u0004\b\u0001\u0010&*\u00020\u00162\u0006\u0010'\u001a\u00020\b2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H%0\u00042\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H&0\u00042\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010*\u001a?\u0010\u001b\u001a\u0002H+\"\u0004\b\u0000\u0010+*\u00020\u00162\u0006\u0010'\u001a\u00020\b2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H+0\u00042\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010-\u001a?\u0010.\u001a\u0002H+\"\u0004\b\u0000\u0010+*\u00020\u00162\u0006\u0010/\u001a\u00020\b2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H+0\u00042\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010-\u001a+\u00100\u001a\u000201*\u00020\u00162\u0006\u00102\u001a\u00020\b2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u00103\u001a\u0010\u00104\u001a\b\u0012\u0004\u0012\u00020605*\u00020\u0016\u001a+\u00107\u001a\u000201*\u00020\u00162\u0006\u0010'\u001a\u00020\b2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u00103\u001a\u0016\u00108\u001a\u00020\b*\u0002092\n\b\u0002\u0010:\u001a\u0004\u0018\u00010\b\u001a\n\u0010;\u001a\u000209*\u000209\"'\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006<"}, d2={"indices", "Ljava/util/SortedSet;", "", "", "Lcom/intellij/database/dataSource/connection/statements/IndexedOutParameter;", "getIndices", "(Ljava/util/List;)Ljava/util/SortedSet;", "checkForProblems", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "decorateInParameters", "Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "parameters", "", "", "([Ljava/lang/Object;)Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "skip", "", "(Ljava/util/Set;[Ljava/lang/Object;)Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "obtainGuardedConnection", "Lcom/intellij/database/util/GuardedRef;", "Lcom/intellij/database/dataSource/DatabaseConnection;", "project", "Lcom/intellij/openapi/project/Project;", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "call", "R", "D", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "definition", "handler", "Lkotlin/Function1;", "Lcom/intellij/database/dataSource/connection/statements/ResultsProducer;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;[Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lkotlin/Pair;", "V1", "V2", "statementText", "outParam1", "outParam2", "(Lcom/intellij/database/dataSource/DatabaseConnection;Ljava/lang/String;Lcom/intellij/database/dataSource/connection/statements/IndexedOutParameter;Lcom/intellij/database/dataSource/connection/statements/IndexedOutParameter;[Ljava/lang/Object;)Lkotlin/Pair;", "V", "resultParam", "(Lcom/intellij/database/dataSource/DatabaseConnection;Ljava/lang/String;Lcom/intellij/database/dataSource/connection/statements/IndexedOutParameter;[Ljava/lang/Object;)Ljava/lang/Object;", "callFunction", "function", "callProcedure", "", "procedure", "(Lcom/intellij/database/dataSource/DatabaseConnection;Ljava/lang/String;[Ljava/lang/Object;)V", "executor", "Lcom/intellij/database/dataSource/connection/statements/NoisyStatement;", "Lcom/intellij/database/dataSource/connection/statements/CallableStatementData;", "perform", "prepareGoodMessage", "", "prefix", "unwrapException", "intellij.database.dialects.oracle"})
public final class OraConnectionHelperKt {
    @NotNull
    public static final GuardedRef<DatabaseConnection> obtainGuardedConnection(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DatabaseDepartment department) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)department, (String)"department");
        String problem = OraConnectionHelperKt.checkForProblems(dataSource);
        if (problem != null) {
            throw (Throwable)new DebuggerUnableException(problem);
        }
        return DatabaseSessionManager.facade((Project)project, (LocalDataSource)dataSource, null, null, (boolean)false, null, (DatabaseDepartment)department).connect();
    }

    @Nullable
    public static final String checkForProblems(@NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        if (dataSource.isSingleConnection()) {
            return "Debugging in the single connection mode is not possible";
        }
        Version version = dataSource.getExactDriverVersion();
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"dataSource.exactDriverVersion");
        Version driverVersion = version;
        int driverMajor = driverVersion.get(0);
        int driverMinor = driverVersion.get(1);
        Version version2 = dataSource.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"dataSource.version");
        Version serverVersion = version2;
        int serverMajor = serverVersion.get(0);
        int serverMinor = serverVersion.get(1);
        if (driverMajor < 12 || serverMajor < 10) {
            if (driverMajor != serverMajor) {
                return "Driver version must be the same as the server version.\n" + "\tServer version: " + serverVersion + '\n' + "\tDriver version: " + driverVersion + '\n';
            }
            if (driverMinor < serverMinor) {
                return "Driver is not up to date.\n" + "\tServer version: " + serverVersion + '\n' + "\tDriver version: " + driverVersion + '\n';
            }
        }
        return null;
    }

    public static final void callProcedure(@NotNull DatabaseConnection $this$callProcedure, @NotNull String procedure, Object ... parameters2) {
        Intrinsics.checkNotNullParameter((Object)$this$callProcedure, (String)"$this$callProcedure");
        Intrinsics.checkNotNullParameter((Object)procedure, (String)"procedure");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        String statementText = "{ call " + procedure + " }";
        OraConnectionHelperKt.perform($this$callProcedure, statementText, Arrays.copyOf(parameters2, parameters2.length));
    }

    public static final <V> V callFunction(@NotNull DatabaseConnection $this$callFunction, @NotNull String function, @NotNull IndexedOutParameter<V> resultParam, Object ... parameters2) {
        Intrinsics.checkNotNullParameter((Object)$this$callFunction, (String)"$this$callFunction");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter(resultParam, (String)"resultParam");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        String statementText = "{ ? = call " + function + " }";
        return OraConnectionHelperKt.call($this$callFunction, statementText, resultParam, Arrays.copyOf(parameters2, parameters2.length));
    }

    public static final <V> V call(@NotNull DatabaseConnection $this$call, @NotNull String statementText, @NotNull IndexedOutParameter<V> resultParam, Object ... parameters2) {
        Intrinsics.checkNotNullParameter((Object)$this$call, (String)"$this$call");
        Intrinsics.checkNotNullParameter((Object)statementText, (String)"statementText");
        Intrinsics.checkNotNullParameter(resultParam, (String)"resultParam");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        CallableStatementBasis basis = new CallableStatementBasis(statementText, Integer.MAX_VALUE, CollectionsKt.listOf(resultParam));
        ParameterizedStatementDecoration decor = OraConnectionHelperKt.decorateInParameters(SetsKt.setOf((Object)resultParam.getIndex()), parameters2);
        CallableStatementData csd = new CallableStatementData(basis, decor);
        NoisyStatement<CallableStatementData> executor = OraConnectionHelperKt.executor($this$call);
        return (V)executor.execute((Object)csd, new Function1<ResultsProducer, V>(resultParam){
            final /* synthetic */ IndexedOutParameter $resultParam;

            public final V invoke(@NotNull ResultsProducer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (V)it.getParameterValue((OutParameter)this.$resultParam);
            }
            {
                this.$resultParam = indexedOutParameter;
                super(1);
            }
        });
    }

    @NotNull
    public static final <V1, V2> Pair<V1, V2> call(@NotNull DatabaseConnection $this$call, @NotNull String statementText, @NotNull IndexedOutParameter<V1> outParam1, @NotNull IndexedOutParameter<V2> outParam2, Object ... parameters2) {
        Intrinsics.checkNotNullParameter((Object)$this$call, (String)"$this$call");
        Intrinsics.checkNotNullParameter((Object)statementText, (String)"statementText");
        Intrinsics.checkNotNullParameter(outParam1, (String)"outParam1");
        Intrinsics.checkNotNullParameter(outParam2, (String)"outParam2");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        List outParameters = CollectionsKt.listOf((Object[])new IndexedOutParameter[]{outParam1, outParam2});
        CallableStatementBasis basis = new CallableStatementBasis(statementText, Integer.MAX_VALUE, outParameters);
        ParameterizedStatementDecoration decor = OraConnectionHelperKt.decorateInParameters((Set<Integer>)OraConnectionHelperKt.getIndices(outParameters), parameters2);
        CallableStatementData csd = new CallableStatementData(basis, decor);
        NoisyStatement<CallableStatementData> executor = OraConnectionHelperKt.executor($this$call);
        return (Pair)executor.execute((Object)csd, new Function1<ResultsProducer, Pair<? extends V1, ? extends V2>>(outParam1, outParam2){
            final /* synthetic */ IndexedOutParameter $outParam1;
            final /* synthetic */ IndexedOutParameter $outParam2;

            @NotNull
            public final Pair<V1, V2> invoke(@NotNull ResultsProducer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object value1 = it.getParameterValue((OutParameter)this.$outParam1);
                Object value2 = it.getParameterValue((OutParameter)this.$outParam2);
                return new Pair(value1, value2);
            }
            {
                this.$outParam1 = indexedOutParameter;
                this.$outParam2 = indexedOutParameter2;
                super(1);
            }
        });
    }

    public static final <D extends CallDefinition, R> R call(@NotNull DatabaseConnection $this$call, @NotNull D definition2, @NotNull Object[] parameters2, @NotNull Function1<? super ResultsProducer, ? extends R> handler) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)$this$call, (String)"$this$call");
        Intrinsics.checkNotNullParameter(definition2, (String)"definition");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        CallableStatementBasis basis = new CallableStatementBasis(definition2.getText(), Integer.MAX_VALUE, definition2.getOutParams());
        ParameterizedStatementDecoration decor = OraConnectionHelperKt.decorateInParameters((Set<Integer>)OraConnectionHelperKt.getIndices(definition2.getOutParams()), parameters2);
        CallableStatementData csd = new CallableStatementData(basis, decor);
        NoisyStatement<CallableStatementData> executor = OraConnectionHelperKt.executor($this$call);
        return (R)executor.execute((Object)csd, handler);
    }

    public static final void perform(@NotNull DatabaseConnection $this$perform, @NotNull String statementText, Object ... parameters2) {
        Intrinsics.checkNotNullParameter((Object)$this$perform, (String)"$this$perform");
        Intrinsics.checkNotNullParameter((Object)statementText, (String)"statementText");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        CallableStatementBasis basis = new CallableStatementBasis(statementText, Integer.MAX_VALUE, CollectionsKt.emptyList());
        ParameterizedStatementDecoration decor = OraConnectionHelperKt.decorateInParameters(parameters2);
        CallableStatementData csd = new CallableStatementData(basis, decor);
        NoisyStatement<CallableStatementData> executor = OraConnectionHelperKt.executor($this$perform);
        NoisyStatement.execute$default(executor, (Object)csd, null, (int)2, null);
    }

    @NotNull
    public static final NoisyStatement<CallableStatementData> executor(@NotNull DatabaseConnection $this$executor) {
        Intrinsics.checkNotNullParameter((Object)$this$executor, (String)"$this$executor");
        return SmartStatements.Companion.poweredBy($this$executor).call(Configuration.Companion.sourced(SmartStatements.Source.SYSTEM)).noisy();
    }

    @NotNull
    public static final ParameterizedStatementDecoration decorateInParameters(@NotNull Object[] parameters2) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        return OraConnectionHelperKt.decorateInParameters(SetsKt.emptySet(), parameters2);
    }

    @NotNull
    public static final ParameterizedStatementDecoration decorateInParameters(@NotNull Set<Integer> skip, @NotNull Object[] parameters2) {
        Intrinsics.checkNotNullParameter(skip, (String)"skip");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        StatementParameters x = new StatementParameters();
        int k = 0;
        for (Object p : parameters2) {
            ++k;
            while (skip.contains(k)) {
                ++k;
            }
            Object object = p;
            if (object instanceof Boolean) {
                x.integer(k, Integer.valueOf((Boolean)p != false ? 1 : 0));
                continue;
            }
            if (object instanceof Byte) {
                x.byteValue(k, (Byte)p);
                continue;
            }
            if (object instanceof Short) {
                x.shortValue(k, (Short)p);
                continue;
            }
            if (object instanceof Integer) {
                x.integer(k, (Integer)p);
                continue;
            }
            if (object instanceof String) {
                x.text(k, (String)p);
                continue;
            }
            x.obj(k, p);
        }
        return x.asDecoration();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SortedSet<Integer> getIndices(@NotNull List<? extends IndexedOutParameter<?>> $this$indices) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$indices, (String)"$this$indices");
        Iterable $this$map$iv = $this$indices;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void receiver;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = ((IndexedOutParameter)receiver).getIndex();
            collection.add(n);
        }
        return CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final Throwable unwrapException(@NotNull Throwable $this$unwrapException) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrapException, (String)"$this$unwrapException");
        Throwable e2 = $this$unwrapException;
        while (e2 instanceof RuntimeException && e2.getCause() != null) {
            Intrinsics.checkNotNull((Object)e2.getCause());
        }
        return e2;
    }

    @NotNull
    public static final String prepareGoodMessage(@NotNull Throwable $this$prepareGoodMessage, @Nullable String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareGoodMessage, (String)"$this$prepareGoodMessage");
        StrBuilder b = new StrBuilder(256);
        if (prefix != null) {
            b.append(prefix).append(':').append(' ');
        }
        if ($this$prepareGoodMessage instanceof SQLException) {
            b.append("Error ").append(((SQLException)$this$prepareGoodMessage).getErrorCode()).append(" SQL state ").append(((SQLException)$this$prepareGoodMessage).getSQLState());
        } else {
            b.append("Exception ").append($this$prepareGoodMessage.getClass().getSimpleName());
        }
        boolean wasMessage = false;
        for (Throwable e2 = $this$prepareGoodMessage; e2 != null; e2 = e2.getCause()) {
            String m = e2.getMessage();
            if (m == null || b.contains(m)) continue;
            b.append(':').append(' ').append(m);
            wasMessage = true;
        }
        if (!wasMessage) {
            b.append(" (no message)");
        }
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"b.toString()");
        return string;
    }

    public static /* synthetic */ String prepareGoodMessage$default(Throwable throwable, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return OraConnectionHelperKt.prepareGoodMessage(throwable, string);
    }
}

