/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.CustomPlaceholder;
import com.intellij.database.data.types.DasColumnRef;
import com.intellij.database.data.types.FormatTester;
import com.intellij.database.data.types.JdbcPlaceholder;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.Placeholder;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.dialects.oracle.model.OraIndex;
import com.intellij.database.dialects.oracle.model.OraLikeTable;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J&\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/oracle/OraPredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "ftsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "columnRef", "Lcom/intellij/database/data/types/ColumnRef;", "value", "Lcom/intellij/database/data/types/PredicateValue;", "alias", "", "version", "Lcom/intellij/database/util/Version;", "getFormatTester", "Lcom/intellij/database/data/types/FormatTester;", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "getFtsIndextype", "Lcom/intellij/database/dialects/oracle/OraPredicatesHelper$FtsIndextype;", "index", "Lcom/intellij/database/dialects/oracle/model/OraIndex;", "FtsIndextype", "intellij.database.dialects.oracle"})
public final class OraPredicatesHelper
extends BasePredicatesHelper {
    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer ftsPredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable String alias, @Nullable Version version) {
        void indextype;
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(columnRef instanceof DasColumnRef) || !(value instanceof StringPredicateValue) && !(value instanceof Placeholder)) {
            return null;
        }
        DasColumn column2 = ((DasColumnRef)columnRef).getCol();
        DasTable dasTable = column2.getTable();
        if (!(dasTable instanceof OraLikeTable)) {
            dasTable = null;
        }
        OraLikeTable oraLikeTable = (OraLikeTable)dasTable;
        if (oraLikeTable == null) {
            return null;
        }
        OraLikeTable table = oraLikeTable;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Iterator iterator = table.getIndices().iterator();
        while (iterator.hasNext()) {
            List indexCols;
            BasicModIndex index2;
            BasicModIndex basicModIndex = index2 = (BasicModIndex)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)basicModIndex, (String)"index");
            Intrinsics.checkNotNullExpressionValue((Object)basicModIndex.getCols(), (String)"index.cols");
            if (indexCols.size() != 1 || !Intrinsics.areEqual((Object)((BasicLikeColumn)indexCols.get(0)), (Object)column2) || !(index2 instanceof OraIndex)) continue;
            indextype.element = this.getFtsIndextype((OraIndex)index2);
            if ((FtsIndextype)((Object)indextype.element) == null) continue;
            break;
        }
        if ((FtsIndextype)((Object)indextype.element) == null) {
            return null;
        }
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)columnRef), value, (Function1)new Function1<DdlBuilder, Unit>(this, (Ref.ObjectRef)indextype, alias, columnRef, value){
            final /* synthetic */ OraPredicatesHelper this$0;
            final /* synthetic */ Ref.ObjectRef $indextype;
            final /* synthetic */ String $alias;
            final /* synthetic */ ColumnRef $columnRef;
            final /* synthetic */ PredicateValue $value;

            public final void invoke(@NotNull DdlBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                DdlBuilder ddlBuilder = builder.identifier(((FtsIndextype)((Object)this.$indextype.element)).getOperator()).symbol("(");
                Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"builder.identifier(indextype.operator).symbol(\"(\")");
                PredicatesUtilKt.identifier((DdlBuilder)ddlBuilder, (String)this.$alias, (ColumnRef)this.$columnRef).symbol(",").space();
                PredicateValue predicateValue = this.$value;
                if (Intrinsics.areEqual((Object)predicateValue, (Object)JdbcPlaceholder.INSTANCE)) {
                    builder.placeholder();
                } else if (predicateValue instanceof CustomPlaceholder) {
                    builder.plain(((CustomPlaceholder)this.$value).getPlaceholder());
                } else if (predicateValue instanceof StringPredicateValue) {
                    builder.literal(DbImplUtil.StringLiteralDecorator.MATCHES.decorate(((StringPredicateValue)this.$value).getStr(), this.this$0.getDbms()));
                }
                if ((FtsIndextype)((Object)this.$indextype.element) == FtsIndextype.CTXCAT) {
                    builder.symbol(",").space().plain("''");
                }
                builder.symbol(")").space().symbol(">").space().number(0);
            }
            {
                this.this$0 = oraPredicatesHelper;
                this.$indextype = objectRef;
                this.$alias = string;
                this.$columnRef = columnRef;
                this.$value = predicateValue;
                super(1);
            }
        });
    }

    private final FtsIndextype getFtsIndextype(OraIndex index2) {
        FtsIndextype ftsIndextype;
        block1: {
            FtsIndextype[] ftsIndextypeArray = FtsIndextype.values();
            boolean bl = false;
            FtsIndextype[] ftsIndextypeArray2 = ftsIndextypeArray;
            boolean bl2 = false;
            FtsIndextype[] ftsIndextypeArray3 = ftsIndextypeArray2;
            int n = ftsIndextypeArray3.length;
            for (int j = 0; j < n; ++j) {
                FtsIndextype ftsIndextype2;
                FtsIndextype indexType = ftsIndextype2 = ftsIndextypeArray3[j];
                boolean bl3 = false;
                if (!(Intrinsics.areEqual((Object)index2.getIndextypeName(), (Object)indexType.name()) && Intrinsics.areEqual((Object)index2.getIndextypeOwner(), (Object)indexType.getOwner()))) continue;
                ftsIndextype = ftsIndextype2;
                break block1;
            }
            ftsIndextype = null;
        }
        return ftsIndextype;
    }

    @Override
    @Nullable
    protected FormatTester getFormatTester(@NotNull ColumnRef columnRef, @Nullable Domain domain, @Nullable Version version) {
        LogicalType type;
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Domain domain2 = domain;
        Object object = type = domain2 != null ? domain2.getLogicType() : null;
        if (type != null && ArraysKt.contains((Object[])new LogicalType[]{LogicalType.TIME_WITH_TIMEZONE, LogicalType.TIMESTAMP_WITH_TIMEZONE, LogicalType.TIMESTAMP, LogicalType.TIME, LogicalType.DATE}, (Object)type)) {
            return PredicatesUtilKt.getFormatTester((ColumnRef)columnRef, (Dbms)this.getDbms(), (LogicalType)type);
        }
        return null;
    }

    public OraPredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/oracle/OraPredicatesHelper$FtsIndextype;", "", "owner", "", "operator", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getOperator", "()Ljava/lang/String;", "getOwner", "CONTEXT", "CTXRULE", "CTXCAT", "intellij.database.dialects.oracle"})
    private static final class FtsIndextype
    extends Enum<FtsIndextype> {
        public static final /* enum */ FtsIndextype CONTEXT;
        public static final /* enum */ FtsIndextype CTXRULE;
        public static final /* enum */ FtsIndextype CTXCAT;
        private static final /* synthetic */ FtsIndextype[] $VALUES;
        @NotNull
        private final String owner;
        @NotNull
        private final String operator;

        static {
            FtsIndextype[] ftsIndextypeArray = new FtsIndextype[3];
            FtsIndextype[] ftsIndextypeArray2 = ftsIndextypeArray;
            ftsIndextypeArray[0] = CONTEXT = new FtsIndextype("CTXSYS", "CONTAINS");
            ftsIndextypeArray[1] = CTXRULE = new FtsIndextype("CTXSYS", "MATCHES");
            ftsIndextypeArray[2] = CTXCAT = new FtsIndextype("CTXSYS", "CATSEARCH");
            $VALUES = ftsIndextypeArray;
        }

        @NotNull
        public final String getOwner() {
            return this.owner;
        }

        @NotNull
        public final String getOperator() {
            return this.operator;
        }

        private FtsIndextype(String owner, String operator2) {
            this.owner = owner;
            this.operator = operator2;
        }

        public static FtsIndextype[] values() {
            return (FtsIndextype[])$VALUES.clone();
        }

        public static FtsIndextype valueOf(String string) {
            return Enum.valueOf(FtsIndextype.class, string);
        }
    }
}

