/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialectHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OraDialectHelper
extends DatabaseDialectHelper {
    @NotNull
    public String tryToLoadSynonymDefinition(DasTable table, DatabaseConnection connection) throws Exception {
        Dbms dbms = connection.getDbms();
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((Dbms)dbms);
        Pair pair = dialect.sqlSynonymDefinition((DasObject)table);
        String string = DbImplUtil.concatStringResults((DatabaseConnection)connection, (Dbms)dbms, (String)((String)pair.first), (int)1, (DbImplUtilCore.ConcatenationProps)((DbImplUtilCore.ConcatenationProps)pair.second));
        if (string == null) {
            OraDialectHelper.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        if (table == null) {
            OraDialectHelper.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            OraDialectHelper.$$$reportNull$$$0(2);
        }
        Dbms dbms = connection.getDbms();
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((Dbms)dbms);
        Pair pair = dialect.sqlTableDefinition((DasObject)table);
        String string = DbImplUtil.concatStringResults((DatabaseConnection)connection, (Dbms)dbms, (String)((String)pair.first), (int)1, (DbImplUtilCore.ConcatenationProps)((DbImplUtilCore.ConcatenationProps)pair.second));
        if (string == null) {
            OraDialectHelper.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            OraDialectHelper.$$$reportNull$$$0(4);
        }
        if (connection == null) {
            OraDialectHelper.$$$reportNull$$$0(5);
        }
        Dbms dbms = connection.getDbms();
        Map map2 = DbImplUtil.resultRowAsMap((DatabaseConnection)connection, (String)String.format("SELECT NUM_ROWS as \"rows\",  TABLESPACE_NAME as \"tablespace\",  LAST_ANALYZED as \"analyzed on\" FROM SYS.all_tables WHERE owner LIKE '%s' ESCAPE '#' AND table_name LIKE '%s' ESCAPE '#'", DbImplUtil.escapeSql((Object)DasUtil.getSchema((DasObject)element), (boolean)true, (Dbms)dbms), DbImplUtil.escapeSql((Object)element.getName(), (boolean)true, (Dbms)dbms)), (String[])new String[0]);
        if (map2 == null) {
            OraDialectHelper.$$$reportNull$$$0(6);
        }
        return map2;
    }

    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) throws SQLException {
        Dbms dbms;
        String s;
        if (system == null) {
            OraDialectHelper.$$$reportNull$$$0(7);
        }
        if (connection == null) {
            OraDialectHelper.$$$reportNull$$$0(8);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults((DatabaseConnection)connection, (Dbms)(dbms = connection.getDbms()), (String)"select sys_context('userenv', 'current_schema') x from dual", (int)1, (DbImplUtilCore.ConcatenationProps)DbImplUtilCore.ConcatenationProps.NO_CONCAT))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/OraDialectHelper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadSynonymDefinition";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/OraDialectHelper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

