/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    protected OraDialect() {
        super(new TypeHelper.OraTypeHelper());
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.ORACLE;
        if (dbms == null) {
            OraDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @NotNull
    public String getDisplayName() {
        return "Oracle";
    }

    @Override
    public int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName) {
        if (nativeColumnTypeName == null) {
            OraDialect.$$$reportNull$$$0(1);
        }
        if (StringUtil.toLowerCase((String)nativeColumnTypeName).equals("nvarchar2")) {
            return -9;
        }
        if (StringUtil.toLowerCase((String)nativeColumnTypeName).equals("nchar")) {
            return -15;
        }
        if (StringUtil.toLowerCase((String)nativeColumnTypeName).equals("nclob")) {
            return 2011;
        }
        if (StringUtil.toLowerCase((String)nativeColumnTypeName).startsWith("timestamp")) {
            return 93;
        }
        return super.getJavaTypeForNativeType(nativeColumnTypeName);
    }

    @Override
    public boolean supportsSynonymDefinition() {
        return true;
    }

    @Override
    protected void sqlParameter(@NotNull DdlBuilder builder, DasArgument parameter, boolean longMode) {
        if (builder == null) {
            OraDialect.$$$reportNull$$$0(2);
        }
        DialectUtils.sqlParameter((DdlBuilder)builder, (DasArgument)parameter, (boolean)longMode, (int)1, (boolean)true);
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlSynonymDefinition(@NotNull DasObject element) {
        if (element == null) {
            OraDialect.$$$reportNull$$$0(3);
        }
        Pair pair = Pair.create((Object)("select dbms_metadata.get_ddl('SYNONYM', '" + element.getName() + "', '" + DasUtil.getSchema((DasObject)element) + "') from dual"), (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            OraDialect.$$$reportNull$$$0(4);
        }
        return pair;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element) {
        if (element == null) {
            OraDialect.$$$reportNull$$$0(5);
        }
        Pair pair = Pair.create((Object)("select dbms_metadata.get_ddl('TABLE', '" + element.getName() + "', '" + DasUtil.getSchema((DasObject)element) + "') from dual"), (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            OraDialect.$$$reportNull$$$0(6);
        }
        return pair;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            OraDialect.$$$reportNull$$$0(7);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        String schema = this.getNamingService().catToScript(current.getDisplayName(), current.kind, this.getCodeStyle().getQuotesPriority());
        return String.format("alter session set current_schema = %s", schema);
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            OraDialect.$$$reportNull$$$0(8);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                OraDialect.$$$reportNull$$$0(9);
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        if ("NUMBER".equals(typeName)) {
            String string = "number" + (String)(precision == 0 && scale == -127 ? "" : "(" + precision + (String)(scale == 0 ? "" : ", " + scale) + ")");
            if (string == null) {
                OraDialect.$$$reportNull$$$0(10);
            }
            return string;
        }
        if ("LONG".equals(typeName) && jdbcType == -1 && precision == 0 && scale == 0) {
            return "long";
        }
        if ("DATE".equals(typeName) && jdbcType == 93 && precision == 7 && scale == 0) {
            return "date";
        }
        if ("ROWID".equals(typeName) && jdbcType == 1111 && precision == 10 && scale == 0) {
            return "rowid";
        }
        if ("UROWID".equals(typeName) && jdbcType == 1111 && precision == 4000 && scale == 0) {
            return "urowid";
        }
        String string = super.getTypeName(dataType);
        if (string == null) {
            OraDialect.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            OraDialect.$$$reportNull$$$0(12);
        }
        if (sequence == null) {
            OraDialect.$$$reportNull$$$0(13);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropSequenceSQL((DdlBuilder)builder, (DasObject)sequence, null);
        if (ddlBuilder == null) {
            OraDialect.$$$reportNull$$$0(14);
        }
        return ddlBuilder;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlPackageBodyDefinition(@NotNull DasObject element) {
        if (element == null) {
            OraDialect.$$$reportNull$$$0(15);
        }
        Pair pair = Pair.create((Object)OraDialect.getPackageDefinitionQuery(element, "PACKAGE BODY"), (Object)DbImplUtilCore.ConcatenationProps.TIGHT);
        if (pair == null) {
            OraDialect.$$$reportNull$$$0(16);
        }
        return pair;
    }

    @Override
    public boolean supportsPackageDefinition() {
        return true;
    }

    private static String getPackageDefinitionQuery(DasObject element, String type) {
        return "select TEXT FROM SYS.ALL_SOURCE WHERE OWNER = '" + DasUtil.getSchema((DasObject)element) + "' AND NAME = '" + element.getName() + "' AND TYPE = '" + type + "' ORDER BY LINE";
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlPackageDefinition(@NotNull DasObject element) {
        if (element == null) {
            OraDialect.$$$reportNull$$$0(17);
        }
        Pair pair = Pair.create((Object)OraDialect.getPackageDefinitionQuery(element, "PACKAGE"), (Object)DbImplUtilCore.ConcatenationProps.TIGHT);
        if (pair == null) {
            OraDialect.$$$reportNull$$$0(18);
        }
        return pair;
    }

    @Override
    public boolean supportsSequenceDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlSequenceDefinition(@NotNull DasObject element) {
        if (element == null) {
            OraDialect.$$$reportNull$$$0(19);
        }
        Pair pair = Pair.create((Object)("select dbms_metadata.get_ddl('SEQUENCE', '" + element.getName() + "', '" + DasUtil.getSchema((DasObject)element) + "') from dual"), (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            OraDialect.$$$reportNull$$$0(20);
        }
        return pair;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            OraDialect.$$$reportNull$$$0(21);
        }
        return Pair.create((Object)("select TEXT FROM SYS.ALL_VIEWS WHERE OWNER = '" + DasUtil.getSchema((DasObject)element) + "' AND VIEW_NAME = '" + element.getName() + "'"), (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            OraDialect.$$$reportNull$$$0(22);
        }
        StringBuilder result2 = new StringBuilder();
        result2.append("select TEXT ");
        result2.append("FROM SYS.ALL_SOURCE ");
        result2.append("WHERE OWNER = ");
        result2.append("'");
        result2.append(DasUtil.getSchema((DasObject)element));
        result2.append("'");
        result2.append(" AND NAME = ");
        result2.append("'");
        result2.append(element.getName());
        result2.append("'");
        String type = StringUtil.toUpperCase((String)element.getRoutineKind().name());
        result2.append(" AND TYPE = ");
        result2.append("'");
        result2.append(StringUtil.toUpperCase((String)type));
        result2.append("'");
        result2.append(" ORDER BY LINE");
        Pair pair = Pair.create((Object)result2.toString(), (Object)DbImplUtilCore.ConcatenationProps.TIGHT);
        if (pair == null) {
            OraDialect.$$$reportNull$$$0(23);
        }
        return pair;
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            OraDialect.$$$reportNull$$$0(24);
        }
        if (qualifier == null) {
            OraDialect.$$$reportNull$$$0(25);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        String pkgName = qualifier instanceof DasRoutine ? ((DasRoutine)qualifier).getPackageName() : null;
        DasObject pkg = pkgName == null ? null : qualifier.getDasParent();
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, pkg, pkgName);
        if (ddlBuilder == null) {
            OraDialect.$$$reportNull$$$0(26);
        }
        return ddlBuilder;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean hasRowId(@Nullable Version version) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/OraDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeColumnTypeName";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: 
            case 5: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/OraDialect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSynonymDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTableDefinition";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSequence";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPackageBodyDefinition";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPackageDefinition";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSequenceDefinition";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getJavaTypeForNativeType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sqlSynonymDefinition";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sqlTableDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageBodyDefinition";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageDefinition";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceDefinition";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

