/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialectHelper;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.mysqlbase.MysqlBaseDialect;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConvertor;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MysqlBaseDialectHelper
extends DatabaseDialectHelper {
    @NotNull
    public String tryToLoadProcedureDefinition(@NotNull DasRoutine procedure, @NotNull DatabaseConnection connection) throws Exception {
        if (procedure == null) {
            MysqlBaseDialectHelper.$$$reportNull$$$0(0);
        }
        if (connection == null) {
            MysqlBaseDialectHelper.$$$reportNull$$$0(1);
        }
        Dbms dbms = connection.getDbms();
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((Dbms)dbms);
        String type = procedure.getRoutineKind().name();
        String query = new DdlBuilder().withDialect(dialect).qualifyReferences(true).keywords(new String[]{"SHOW", "CREATE", type}).space().qualifiedRef((DasObject)procedure).getStatement();
        String string = (String)SmartStatements.poweredBy((DatabaseConnection)connection).simple().noisy().execute((Object)query, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.throwableResultsTransformer(rs -> {
            if (!rs.next()) {
                return "-- failed to load definition";
            }
            DdlBuilder builder = new DdlBuilder().withDialect(dialect).qualifyReferences(true).splitStatements(true);
            dialect.sqlDropProcedure(builder, procedure).newStatement().plain(rs.getString(3));
            return DialectUtils.sqlConcat((List)builder.getStatements());
        }, (Object)""));
        if (string == null) {
            MysqlBaseDialectHelper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            MysqlBaseDialectHelper.$$$reportNull$$$0(3);
        }
        if (connection == null) {
            MysqlBaseDialectHelper.$$$reportNull$$$0(4);
        }
        Map map2 = DbImplUtil.resultRowAsMap((DatabaseConnection)connection, (String)String.format("show table status from `%s` like '%s'", MysqlBaseDialect.getDBName((DasObject)element), DbImplUtil.escapeStr((String)element.getName())), (String[])new String[]{"TABLE_ROWS", "rows", "ENGINE", "engine", "TABLE_COLLATION", "collation", "CREATE_TIME", "created"});
        if (map2 == null) {
            MysqlBaseDialectHelper.$$$reportNull$$$0(5);
        }
        return map2;
    }

    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        if (table == null) {
            MysqlBaseDialectHelper.$$$reportNull$$$0(6);
        }
        if (connection == null) {
            MysqlBaseDialectHelper.$$$reportNull$$$0(7);
        }
        Dbms dbms = connection.getDbms();
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((Dbms)dbms);
        Pair pair = dialect.sqlTableDefinition((DasObject)table);
        String string = DbImplUtil.concatStringResults((DatabaseConnection)connection, (Dbms)dbms, (String)((String)pair.first), (int)2, (DbImplUtilCore.ConcatenationProps)((DbImplUtilCore.ConcatenationProps)pair.second));
        if (string == null) {
            MysqlBaseDialectHelper.$$$reportNull$$$0(8);
        }
        return string;
    }

    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) throws SQLException {
        Dbms dbms;
        String s;
        if (system == null) {
            MysqlBaseDialectHelper.$$$reportNull$$$0(9);
        }
        if (connection == null) {
            MysqlBaseDialectHelper.$$$reportNull$$$0(10);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults((DatabaseConnection)connection, (Dbms)(dbms = connection.getDbms()), (String)"select database()", (int)1, (DbImplUtilCore.ConcatenationProps)DbImplUtilCore.ConcatenationProps.NO_CONCAT))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection) throws SQLException {
        if (connection == null) {
            MysqlBaseDialectHelper.$$$reportNull$$$0(11);
        }
        List list = (List)DbImplUtil.executeAndGetResult((DatabaseConnection)connection, (String)"SHOW DATABASES", (ThrowableConvertor)DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            MysqlBaseDialectHelper.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDialectHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDialectHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadProcedureDefinition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadProcedureDefinition";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

