/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MysqlBaseDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public MysqlBaseDialect() {
        super(new TypeHelper.MySQLTypeHelper());
    }

    @Override
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition2) {
        if (builder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(0);
        }
        if (view == null) {
            MysqlBaseDialect.$$$reportNull$$$0(1);
        }
        if (definition2 == null) {
            MysqlBaseDialect.$$$reportNull$$$0(2);
        }
        builder.keywords(new String[]{"CREATE", "OR", "REPLACE", "VIEW"}).space();
        builder.qualifiedRef((DasObject)view).space();
        builder.keyword("AS").space();
        builder.plain(definition2);
        return builder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(3);
        }
        if (view == null) {
            MysqlBaseDialect.$$$reportNull$$$0(4);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL((DdlBuilder)builder, (DasTable)view, (Boolean)cascade);
        if (ddlBuilder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(5);
        }
        return ddlBuilder;
    }

    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            MysqlBaseDialect.$$$reportNull$$$0(6);
        }
        return Pair.create((Object)("SELECT view_definition FROM information_schema.views WHERE table_name = '" + element.getName() + "' AND table_schema = '" + MysqlBaseDialect.getDBName(element) + "'"), (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            MysqlBaseDialect.$$$reportNull$$$0(7);
        }
        Pair pair = Pair.create((Object)("SELECT routine_definition FROM information_schema.routines WHERE routine_name = '" + element.getName() + "' AND routine_schema = '" + MysqlBaseDialect.getDBName((DasObject)element) + "'"), (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            MysqlBaseDialect.$$$reportNull$$$0(8);
        }
        return pair;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public boolean supportsSystemViewDefinition() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(9);
        }
        if (procedure == null) {
            MysqlBaseDialect.$$$reportNull$$$0(10);
        }
        DdlBuilder ddlBuilder = DialectUtils.sqlDropProcedure((DdlBuilder)builder, (DasRoutine)procedure, (boolean)true);
        if (ddlBuilder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(11);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            MysqlBaseDialect.$$$reportNull$$$0(12);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                MysqlBaseDialect.$$$reportNull$$$0(13);
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        if ("DOUBLE".equals(typeName) && jdbcType == 8 && precision == 22 && scale == 0) {
            return "double";
        }
        if ("MEDIUMINT".equals(typeName) && jdbcType == 4 && precision == 7 && scale == 0) {
            return "mediumint";
        }
        if ("MEDIUMINT UNSIGNED".equals(typeName) && jdbcType == 4 && precision == 7 && scale == 0) {
            return "mediumint unsigned";
        }
        if ("MEDIUMBLOB".equals(typeName) && jdbcType == -4 && precision == 0xFFFFFF && scale == 0) {
            return "mediumblob";
        }
        if ("TINYBLOB".equals(typeName) && jdbcType == -2 && precision == 255 && scale == 0) {
            return "tinyblob";
        }
        if ("DATETIME".equals(typeName) && jdbcType == 93 && precision == 19 && scale == 0) {
            return "datetime";
        }
        String name2 = super.getTypeName(dataType);
        String unsigned = "unsigned";
        Object object = StringUtil.endsWithIgnoreCase((String)typeName, (String)unsigned) && !StringUtil.endsWithIgnoreCase((String)name2, (String)unsigned) ? name2 + " " + unsigned : name2;
        if (object == null) {
            MysqlBaseDialect.$$$reportNull$$$0(14);
        }
        return object;
    }

    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(15);
        }
        if (sequence == null) {
            MysqlBaseDialect.$$$reportNull$$$0(16);
        }
        throw new UnsupportedOperationException(DatabaseBundle.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element) {
        if (element == null) {
            MysqlBaseDialect.$$$reportNull$$$0(17);
        }
        DdlBuilder builder = new DdlBuilder().withDialect((DatabaseDialectEx)this).qualifyReferences(true);
        Pair pair = Pair.create((Object)("SHOW CREATE TABLE " + builder.qualifiedRef(element).getStatement()), (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            MysqlBaseDialect.$$$reportNull$$$0(18);
        }
        return pair;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            MysqlBaseDialect.$$$reportNull$$$0(19);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        String schema = this.getNamingService().catToScript(current.getDisplayName(), current.kind, this.getCodeStyle().getQuotesPriority());
        return String.format("use %s", schema);
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @NotNull
    public static String getDBName(@NotNull DasObject qualifier) {
        if (qualifier == null) {
            MysqlBaseDialect.$$$reportNull$$$0(20);
        }
        String string = DasUtil.getName((DasObject)MysqlBaseDialect.getDB(qualifier));
        if (string == null) {
            MysqlBaseDialect.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Nullable
    private static DasObject getDB(@NotNull DasObject qualifier) {
        DasObject schema;
        if (qualifier == null) {
            MysqlBaseDialect.$$$reportNull$$$0(22);
        }
        return (schema = DasUtil.getSchemaObject((DasObject)qualifier)) != null && !StringUtil.isEmpty((String)schema.getName()) ? schema : DasUtil.getCatalogObject((DasObject)qualifier);
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            MysqlBaseDialect.$$$reportNull$$$0(23);
        }
        if (qualifier == null) {
            MysqlBaseDialect.$$$reportNull$$$0(24);
        }
        DasObject db = MysqlBaseDialect.getDB(qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, db, DasUtil.getName((DasObject)db), null, null, null, null);
        if (ddlBuilder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(25);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getBinaryLiteralString(byte @NotNull [] binaryData) {
        if (binaryData == null) {
            MysqlBaseDialect.$$$reportNull$$$0(26);
        }
        String string = "0x" + DialectUtils.toHexString((byte[])binaryData);
        if (string == null) {
            MysqlBaseDialect.$$$reportNull$$$0(27);
        }
        return string;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    public boolean similarTo(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            MysqlBaseDialect.$$$reportNull$$$0(28);
        }
        return dialect instanceof MysqlBaseDialect;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 21: 
            case 25: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 21: 
            case 25: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 21: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDialect";
                break;
            }
            case 6: 
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDialect";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropProcedure";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTableDefinition";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDBName";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryLiteralString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 21: 
            case 25: 
            case 27: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropProcedure";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sqlTableDefinition";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDBName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDB";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "similarTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 21: 
            case 25: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

