/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.ssrp;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.mssql.ssrp.LocalDb;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.util.AsyncTask;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalDbInterceptor
implements DatabaseConnectionInterceptor {
    public @Nullable CompletionStage<// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull DatabaseConnectionInterceptor.ProtoConnection> intercept(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent) {
        if (proto2 == null) {
            LocalDbInterceptor.$$$reportNull$$$0(0);
        }
        DatabaseConnectionPoint connectionPoint = proto2.getConnectionPoint();
        String localDbInst = (String)connectionPoint.getAdditionalProperties().get("LOCAL_DB_INSTANCE");
        String localDbExec = (String)connectionPoint.getAdditionalProperties().get("LOCAL_DB_EXECUTABLE");
        if (localDbExec == null || localDbInst == null) {
            return null;
        }
        JdbcUrlParser parser = JdbcUrlParserUtil.parsed((RawConnectionConfig)connectionPoint, (String)proto2.getUrl());
        if (parser == null || !parser.getParameters().contains("localdb_pipe")) {
            return null;
        }
        return AsyncTask.withBgIndicatorIfNeeded((AsyncTask.Frame)AsyncTask.frame((String)DatabaseBundle.message((String)"progress.title.actualizing.localdb.instance.info", (Object[])new Object[0])), (Project)proto2.getRunConfiguration().getProject(), null).compute(null, () -> LocalDb.getPipeForInstance(localDbInst, localDbExec, Objects.requireNonNull(ProgressIndicatorProvider.getGlobalProgressIndicator()))).apply(null, pipe -> {
            if (StringUtil.isNotEmpty((String)pipe)) {
                parser.setParameter("localdb_pipe", pipe);
                proto2.setUrl(parser.getUrlText());
            }
            return proto2;
        }).unwrap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "com/intellij/database/dialects/mssql/ssrp/LocalDbInterceptor", "intercept"));
    }
}

