/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.model.properties;

import com.intellij.database.dialects.mssql.model.MsCustomType;
import com.intellij.database.dialects.mssql.model.MsDatabase;
import com.intellij.database.dialects.mssql.model.MsLogin;
import com.intellij.database.dialects.mssql.model.MsPrincipal;
import com.intellij.database.dialects.mssql.model.MsRoot;
import com.intellij.database.dialects.mssql.model.properties.MsObjectGrant;
import com.intellij.database.dialects.mssql.model.properties.MsObjectGrantKt;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.util.DasUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TObjectHashingStrategy;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00032\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\b\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\rH\u0016J\u001e\u0010\u0019\u001a\u0004\u0018\u00010\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\rH\u0016J \u0010\u001a\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u001c0\u001b2\b\u0010\u0018\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\rH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00022\u0006\u0010!\u001a\u00020\rH\u0016J\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150#2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%H\u0016J\u001f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%H\u0016\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0010\u0010+\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0018\u0010,\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010-\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u0002H\u0016J*\u0010/\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u00100\u001a\u00020\u00152\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020(H\u0016J\u0018\u00104\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u00103\u001a\u00020(H\u0016J\u0018\u00105\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\rH\u0016J\u0018\u00106\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u0002H\u0016J\u0018\u00107\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u00108\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0013\u00109\u001a\u0004\u0018\u00010:*\u00020\rH\u0002\u00a2\u0006\u0002\u0010;J\u0014\u0010<\u001a\n >*\u0004\u0018\u00010=0=*\u00020=H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006?"}, d2={"Lcom/intellij/database/dialects/mssql/model/properties/MsObjectGrantController;", "Lcom/intellij/database/model/properties/Grants$Controller;", "Lcom/intellij/database/dialects/mssql/model/properties/MsObjectGrant;", "Lcom/intellij/database/dialects/mssql/model/MsPrincipal;", "()V", "granteeStrategy", "Lgnu/trove/TObjectHashingStrategy;", "getGranteeStrategy", "()Lgnu/trove/TObjectHashingStrategy;", "targetStrategy", "getTargetStrategy", "asGrantee", "u", "Lcom/intellij/database/model/basic/BasicElement;", "compare", "", "o1", "o2", "create", "deserialize", "text", "", "findGrantee", "g", "h", "findTarget", "granteeFamiliesFor", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/families/Family;", "holdsItsGrants", "", "element", "lower", "e", "possiblePrivileges", "", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "possibleStates", "", "Lcom/intellij/database/model/properties/Grants$State;", "(Lcom/intellij/database/model/meta/BasicMetaObject;)[Lcom/intellij/database/model/properties/Grants$State;", "serialize", "upper", "withGrantee", "withGranteeFrom", "src", "withPermission", "perm", "subs", "Ljava/util/BitSet;", "state", "withState", "withTarget", "withTargetFrom", "withUnresolvedGrantee", "withUnresolvedTarget", "extractObjectId", "", "(Lcom/intellij/database/model/basic/BasicElement;)Ljava/lang/Long;", "grantObjectClass", "Lcom/intellij/database/model/ObjectKind;", "kotlin.jvm.PlatformType", "intellij.database.dialects.mssql"})
public final class MsObjectGrantController
extends Grants.Controller<MsObjectGrant, MsPrincipal> {
    @NotNull
    private static final TObjectHashingStrategy<MsObjectGrant> granteeStrategy;
    @NotNull
    private static final TObjectHashingStrategy<MsObjectGrant> targetStrategy;
    @NotNull
    public static final MsObjectGrantController INSTANCE;

    @NotNull
    public MsObjectGrant deserialize(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List params = StringsKt.split$default((CharSequence)text, (char[])new char[]{'|'}, (boolean)false, (int)0, (int)6, null);
        long l = Grants.Controller.Companion.deserializeId((String)CollectionsKt.getOrNull((List)params, (int)0));
        ObjectKind objectKind = Grants.Controller.Companion.deserializeKind((String)CollectionsKt.getOrNull((List)params, (int)1));
        BitSet bitSet = Grants.Controller.Companion.deserializeSubs((String)CollectionsKt.getOrNull((List)params, (int)2));
        long l2 = Grants.Controller.Companion.deserializeId((String)CollectionsKt.getOrNull((List)params, (int)3));
        String string = (String)CollectionsKt.getOrNull((List)params, (int)4);
        if (string == null) {
            string = "";
        }
        return new MsObjectGrant(l, objectKind, bitSet, l2, string, Grants.Controller.Companion.deserializeState((String)CollectionsKt.getOrNull((List)params, (int)5)));
    }

    @NotNull
    public String serialize(@NotNull MsObjectGrant g) {
        Intrinsics.checkNotNullParameter((Object)((Object)g), (String)"g");
        return "" + g.getObjectId() + '|' + Grants.Controller.Companion.serializeKind(g.getKind()) + '|' + g.serializeSubs() + '|' + g.getGranteeId() + '|' + g.getPermission() + '|' + this.serializeState(g);
    }

    @Nullable
    public MsPrincipal asGrantee(@Nullable BasicElement u) {
        BasicElement basicElement = u;
        if (!(basicElement instanceof MsPrincipal)) {
            basicElement = null;
        }
        return (MsPrincipal)basicElement;
    }

    public boolean holdsItsGrants(@NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof MsDatabase || element instanceof MsRoot;
    }

    @Nullable
    public MsPrincipal findGrantee(@Nullable MsObjectGrant g, @Nullable BasicElement h) {
        if (g == null || h == null || g.getGranteeId() == Long.MIN_VALUE) {
            return null;
        }
        MsDatabase db = (MsDatabase)DasUtil.getParentOfClass((DasObject)((DasObject)h), MsDatabase.class, (boolean)false);
        if (db != null) {
            return (MsPrincipal)db.getRoles().getByObjectId(g.getGranteeId());
        }
        ModNamingIdentifyingFamily<? extends MsLogin> modNamingIdentifyingFamily = (ModNamingIdentifyingFamily<? extends MsLogin>)DasUtil.getParentOfClass((DasObject)((DasObject)h), MsRoot.class, (boolean)false);
        return modNamingIdentifyingFamily != null && (modNamingIdentifyingFamily = modNamingIdentifyingFamily.getLogins()) != null ? (MsLogin)modNamingIdentifyingFamily.getByObjectId(g.getGranteeId()) : null;
    }

    @Nullable
    public BasicElement findTarget(@Nullable MsObjectGrant g, @Nullable BasicElement h) {
        MsDatabase db;
        if (g == null || h == null) {
            return null;
        }
        if (Intrinsics.areEqual((Object)g.getKind(), (Object)ObjectKind.ROOT)) {
            return (BasicElement)DasUtil.getParentOfClass((DasObject)((DasObject)h), MsRoot.class, (boolean)false);
        }
        if (Intrinsics.areEqual((Object)g.getKind(), (Object)ObjectKind.DATABASE)) {
            ModNamingIdentifyingFamily<? extends MsDatabase> root2 = (ModNamingIdentifyingFamily<? extends MsDatabase>)DasUtil.getParentOfClass((DasObject)((DasObject)h), MsRoot.class, (boolean)false);
            ModNamingIdentifyingFamily<? extends MsDatabase> modNamingIdentifyingFamily = root2;
            return (BasicElement)(modNamingIdentifyingFamily != null && (modNamingIdentifyingFamily = modNamingIdentifyingFamily.getDatabases()) != null ? (MsDatabase)modNamingIdentifyingFamily.getByObjectId(g.getObjectId()) : null);
        }
        MsDatabase msDatabase = db = (MsDatabase)DasUtil.getParentOfClass((DasObject)((DasObject)h), MsDatabase.class, (boolean)false);
        return (BasicElement)(msDatabase != null ? msDatabase.findIdentifiedElement(g.getObjectId()) : null);
    }

    @NotNull
    public JBIterable<Family<? extends MsPrincipal>> granteeFamiliesFor(@Nullable BasicElement h) {
        MsDatabase db = (MsDatabase)DasUtil.getParentOfClass((DasObject)((DasObject)h), MsDatabase.class, (boolean)false);
        MsRoot rt = (MsRoot)DasUtil.getParentOfClass((DasObject)((DasObject)h), MsRoot.class, (boolean)false);
        MsDatabase msDatabase = db;
        MsRoot msRoot = rt;
        JBIterable jBIterable = JBIterable.of(msDatabase != null ? msDatabase.getRoles() : null).append(msRoot != null ? msRoot.getLogins() : null);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.of<Family<out\u2026roles).append(rt?.logins)");
        return jBIterable;
    }

    @NotNull
    public MsObjectGrant withTarget(@NotNull MsObjectGrant g, @NotNull BasicElement e2) {
        Intrinsics.checkNotNullParameter((Object)((Object)g), (String)"g");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Long l = this.extractObjectId(e2);
        long l2 = l != null ? l : -9223372036854775807L;
        ObjectKind objectKind = e2.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"e.kind");
        ObjectKind objectKind2 = this.grantObjectClass(objectKind);
        Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"e.kind.grantObjectClass()");
        return MsObjectGrant.copy$default(g, l2, objectKind2, null, 0L, null, null, 60, null);
    }

    @NotNull
    public MsObjectGrant withTargetFrom(@NotNull MsObjectGrant g, @NotNull MsObjectGrant src2) {
        Intrinsics.checkNotNullParameter((Object)((Object)g), (String)"g");
        Intrinsics.checkNotNullParameter((Object)((Object)src2), (String)"src");
        return MsObjectGrant.copy$default(g, src2.getObjectId(), src2.getKind(), null, 0L, null, null, 60, null);
    }

    @NotNull
    public MsObjectGrant withUnresolvedTarget(@NotNull MsObjectGrant g, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)((Object)g), (String)"g");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ObjectKind objectKind = ObjectKind.NONE;
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"NONE");
        return MsObjectGrant.copy$default(g, -9223372036854775807L, objectKind, null, 0L, null, null, 60, null);
    }

    @NotNull
    public MsObjectGrant withPermission(@NotNull MsObjectGrant g, @NotNull String perm, @Nullable BitSet subs2, @NotNull Grants.State state2) {
        Intrinsics.checkNotNullParameter((Object)((Object)g), (String)"g");
        Intrinsics.checkNotNullParameter((Object)perm, (String)"perm");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        return MsObjectGrant.copy$default(g, 0L, null, subs2, 0L, perm, state2, 11, null);
    }

    @NotNull
    public MsObjectGrant withState(@NotNull MsObjectGrant g, @NotNull Grants.State state2) {
        Intrinsics.checkNotNullParameter((Object)((Object)g), (String)"g");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        return MsObjectGrant.copy$default(g, 0L, null, null, 0L, null, state2, 31, null);
    }

    @NotNull
    public TObjectHashingStrategy<MsObjectGrant> getGranteeStrategy() {
        return granteeStrategy;
    }

    @NotNull
    public TObjectHashingStrategy<MsObjectGrant> getTargetStrategy() {
        return targetStrategy;
    }

    @NotNull
    public MsObjectGrant withGrantee(@NotNull MsObjectGrant g, @NotNull MsPrincipal u) {
        Intrinsics.checkNotNullParameter((Object)((Object)g), (String)"g");
        Intrinsics.checkNotNullParameter((Object)u, (String)"u");
        return MsObjectGrant.copy$default(g, 0L, null, null, u.getObjectId(), null, null, 55, null);
    }

    @NotNull
    public MsObjectGrant withGranteeFrom(@NotNull MsObjectGrant g, @NotNull MsObjectGrant src2) {
        Intrinsics.checkNotNullParameter((Object)((Object)g), (String)"g");
        Intrinsics.checkNotNullParameter((Object)((Object)src2), (String)"src");
        return MsObjectGrant.copy$default(g, 0L, null, null, src2.getGranteeId(), null, null, 55, null);
    }

    @NotNull
    public MsObjectGrant withUnresolvedGrantee(@NotNull MsObjectGrant g, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)((Object)g), (String)"g");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return MsObjectGrant.copy$default(g, 0L, null, null, -9223372036854775807L, null, null, 55, null);
    }

    /*
     * WARNING - void declaration
     */
    public int compare(@NotNull MsObjectGrant o1, @NotNull MsObjectGrant o2) {
        int n;
        void $this$thenCompare$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)o1), (String)"o1");
        Intrinsics.checkNotNullParameter((Object)((Object)o2), (String)"o2");
        MsObjectGrantController msObjectGrantController = this;
        int n2 = this.thenCompare(ComparisonsKt.compareValues((Comparable)((Comparable)o1.getKind()), (Comparable)((Comparable)o2.getKind())), Long.valueOf(o1.getObjectId()), Long.valueOf(o2.getObjectId()));
        Grants.Controller this_$iv = this;
        boolean $i$f$thenCompare = false;
        Integer n3 = (int)$this$thenCompare$iv;
        boolean bl = false;
        boolean bl2 = false;
        int it$iv = ((Number)n3).intValue();
        boolean bl3 = false;
        Integer n4 = it$iv != 0 ? n3 : null;
        if (n4 != null) {
            n = n4;
        } else {
            MsObjectGrantController msObjectGrantController2 = msObjectGrantController;
            boolean bl4 = false;
            int n5 = super.compare((Grants.Grant)o1, (Grants.Grant)o2);
            msObjectGrantController = msObjectGrantController2;
            n = n5;
        }
        return msObjectGrantController.thenCompare(n, Long.valueOf(o1.getGranteeId()), Long.valueOf(o2.getGranteeId()));
    }

    private final Long extractObjectId(BasicElement $this$extractObjectId) {
        BasicElement basicElement = $this$extractObjectId;
        return basicElement instanceof MsCustomType ? Long.valueOf(((MsCustomType)$this$extractObjectId).getTypeId()) : (basicElement instanceof MsRoot ? Long.valueOf(0L) : (basicElement instanceof BasicIdentifiedElement ? Long.valueOf(((BasicIdentifiedElement)$this$extractObjectId).getObjectId()) : null));
    }

    private final ObjectKind grantObjectClass(ObjectKind $this$grantObjectClass) {
        ObjectKind objectKind = $this$grantObjectClass;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.DATABASE) || Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SCHEMA) || Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROLE) || Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ALIAS_TYPE) || Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROOT) || Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.LOGIN) ? $this$grantObjectClass : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE_TYPE) ? ObjectKind.ALIAS_TYPE : ObjectKind.NONE);
    }

    @NotNull
    public MsObjectGrant create() {
        ObjectKind objectKind = ObjectKind.NONE;
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"NONE");
        return new MsObjectGrant(-9223372036854775807L, objectKind, null, Grants.Controller.Companion.minId(), "", Grants.Controller.Companion.minState());
    }

    @Nullable
    public MsObjectGrant lower(@NotNull BasicElement e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Long l = this.extractObjectId(e2);
        if (l == null) {
            return null;
        }
        long objectId = l;
        ObjectKind objectKind = e2.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"e.kind");
        ObjectKind objectKind2 = this.grantObjectClass(objectKind);
        Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"e.kind.grantObjectClass()");
        return new MsObjectGrant(objectId, objectKind2, null, Grants.Controller.Companion.minId(), "", Grants.Controller.Companion.minState());
    }

    @NotNull
    public MsObjectGrant upper(@NotNull MsObjectGrant g) {
        Intrinsics.checkNotNullParameter((Object)((Object)g), (String)"g");
        return new MsObjectGrant(Grants.Controller.Companion.nextId(g.getObjectId()), g.getKind(), null, Grants.Controller.Companion.minId(), "", Grants.Controller.Companion.minState());
    }

    @NotNull
    public Iterable<String> possiblePrivileges(@NotNull BasicMetaObject<?> meta) {
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        JBIterable jBIterable = JBIterable.from((Iterable)MsObjectGrantKt.access$getAllPrivileges$p()).filterMap((Function)new Function<Pair<? extends String, ? extends List<? extends ObjectKind>>, String>(meta){
            final /* synthetic */ BasicMetaObject $meta;

            public final String fun(Pair<String, ? extends List<? extends ObjectKind>> p) {
                Object object = p.getFirst();
                boolean bl = false;
                boolean bl2 = false;
                String it = (String)object;
                boolean bl3 = false;
                return (String)(((List)p.getSecond()).contains(this.$meta.kind) ? object : null);
            }
            {
                this.$meta = basicMetaObject;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(allPrivi\u2026meta.kind in p.second } }");
        return (Iterable)jBIterable;
    }

    @NotNull
    public Grants.State[] possibleStates(@NotNull BasicMetaObject<?> meta) {
        Grants.State[] stateArray;
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        if (Intrinsics.areEqual((Object)meta.kind, (Object)ObjectKind.COLUMN)) {
            Grants.State[] stateArray2 = new Grants.State[4];
            stateArray2[0] = Grants.State.GRANT;
            stateArray2[1] = Grants.State.GRANT_WITH_GRANT_OPTION;
            stateArray2[2] = Grants.State.DENY;
            stateArray = stateArray2;
            stateArray2[3] = Grants.State.REVOKE;
        } else {
            Grants.State[] stateArray3 = new Grants.State[3];
            stateArray3[0] = Grants.State.GRANT;
            stateArray3[1] = Grants.State.GRANT_WITH_GRANT_OPTION;
            stateArray = stateArray3;
            stateArray3[2] = Grants.State.DENY;
        }
        return stateArray;
    }

    private MsObjectGrantController() {
    }

    static {
        MsObjectGrantController msObjectGrantController;
        INSTANCE = msObjectGrantController = new MsObjectGrantController();
        granteeStrategy = (TObjectHashingStrategy)new TObjectHashingStrategy<MsObjectGrant>(){

            public boolean equals(@Nullable MsObjectGrant o1, @Nullable MsObjectGrant o2) {
                MsObjectGrant msObjectGrant = o1;
                MsObjectGrant msObjectGrant2 = o2;
                return Intrinsics.areEqual((Object)(msObjectGrant != null ? Long.valueOf(msObjectGrant.getGranteeId()) : null), (Object)(msObjectGrant2 != null ? Long.valueOf(msObjectGrant2.getGranteeId()) : null));
            }

            public int computeHashCode(@Nullable MsObjectGrant object) {
                MsObjectGrant msObjectGrant = object;
                Long l = msObjectGrant != null ? Long.valueOf(msObjectGrant.getGranteeId()) : null;
                boolean bl = false;
                Long l2 = l;
                return l2 != null ? ((Object)l2).hashCode() : 0;
            }
        };
        targetStrategy = (TObjectHashingStrategy)new TObjectHashingStrategy<MsObjectGrant>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(@Nullable MsObjectGrant o1, @Nullable MsObjectGrant o2) {
                MsObjectGrant msObjectGrant = o1;
                MsObjectGrant msObjectGrant2 = o2;
                if (!Intrinsics.areEqual((Object)(msObjectGrant != null ? Long.valueOf(msObjectGrant.getObjectId()) : null), (Object)(msObjectGrant2 != null ? Long.valueOf(msObjectGrant2.getObjectId()) : null))) return false;
                MsObjectGrant msObjectGrant3 = o1;
                MsObjectGrant msObjectGrant4 = o2;
                if (!Intrinsics.areEqual((Object)(msObjectGrant3 != null ? msObjectGrant3.getKind() : null), (Object)(msObjectGrant4 != null ? msObjectGrant4.getKind() : null))) return false;
                return true;
            }

            public int computeHashCode(@Nullable MsObjectGrant object) {
                Object[] objectArray = new Object[2];
                MsObjectGrant msObjectGrant = object;
                objectArray[0] = msObjectGrant != null ? Long.valueOf(msObjectGrant.getObjectId()) : null;
                MsObjectGrant msObjectGrant2 = object;
                objectArray[1] = msObjectGrant2 != null ? msObjectGrant2.getKind() : null;
                return Objects.hash(objectArray);
            }
        };
    }
}

