/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.model;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.mssql.model.MsAliasType;
import com.intellij.database.dialects.mssql.model.MsLogin;
import com.intellij.database.dialects.mssql.model.MsModelHelper$WhenMappings;
import com.intellij.database.dialects.mssql.model.MsObjectEditorFactory;
import com.intellij.database.dialects.mssql.model.MsRole;
import com.intellij.database.dialects.mssql.model.MsStoredColumn;
import com.intellij.database.dialects.mssql.model.MsTableType;
import com.intellij.database.dialects.mssql.model.MsTableTypeColumn;
import com.intellij.database.dialects.mssql.model.MsTrigger;
import com.intellij.database.dialects.mssql.model.properties.MsObjectGrantController;
import com.intellij.database.dialects.mssql.model.properties.MsServerPrincipalType;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ModelHelperCore;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.schemaEditor.DbObjectEditorFactory;
import com.intellij.icons.AllIcons;
import icons.DatabaseIcons;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dialects/mssql/model/MsModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "()V", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "Lcom/intellij/database/model/ModelHelperCore$ObjectKindVariant;", "vars", "", "", "getGrantController", "Lcom/intellij/database/dialects/mssql/model/properties/MsObjectGrantController;", "getIcon", "Ljavax/swing/Icon;", "c", "Lcom/intellij/database/model/DasObject;", "getName", "kind", "Lcom/intellij/database/model/ObjectKind;", "getObjectEditorFactory", "Lcom/intellij/database/schemaEditor/DbObjectEditorFactory;", "mustParticipateInInsert", "", "column", "Lcom/intellij/database/model/DasColumn;", "intellij.database.dialects.mssql"})
public final class MsModelHelper
extends ModelHelper {
    public boolean mustParticipateInInsert(@NotNull DasColumn column2) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        return (!(column2 instanceof MsStoredColumn) || !((MsStoredColumn)column2).isHidden()) && super.mustParticipateInInsert(column2);
    }

    public void fillPropertiesWithExamples(@NotNull BasicModElement e2, @NotNull ModelHelperCore.ObjectKindVariant variant, @NotNull Map<String, String> vars) {
        block1: {
            BasicModElement basicModElement;
            block3: {
                block2: {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                        Intrinsics.checkNotNullParameter(vars, (String)"vars");
                        super.fillPropertiesWithExamples(e2, variant, vars);
                        basicModElement = e2;
                        if (!(basicModElement instanceof MsLogin)) break block0;
                        ((MsLogin)e2).setPassword(new OneTimeString(""));
                        vars.put("password", "''");
                        break block1;
                    }
                    if (!(basicModElement instanceof MsTrigger)) break block2;
                    vars.put("turn", "for");
                    break block1;
                }
                if (!(basicModElement instanceof MsAliasType)) break block3;
                ((MsAliasType)e2).setDataType(DataTypeFactory.of((String)"varchar"));
                vars.put("target_type", "varchar");
                break block1;
            }
            if (!(basicModElement instanceof MsTableType)) break block1;
            MsTableTypeColumn col = (MsTableTypeColumn)((MsTableType)e2).getColumns().createNewOne();
            this.setTemplateName(col, "type_column");
            MsTableTypeColumn msTableTypeColumn = col;
            Intrinsics.checkNotNullExpressionValue((Object)msTableTypeColumn, (String)"col");
            msTableTypeColumn.setDataType(DataTypeFactory.of((String)"int"));
            vars.put("type_columns", "type_column int");
        }
    }

    @NotNull
    public DbObjectEditorFactory getObjectEditorFactory() {
        return MsObjectEditorFactory.INSTANCE;
    }

    @Nullable
    public Icon getIcon(@NotNull DasObject c) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        DasObject dasObject = c;
        if (dasObject instanceof MsLogin) {
            icon = ((MsLogin)c).getType() == MsServerPrincipalType.SERVER_ROLE ? DatabaseIcons.Role : super.getIcon(c);
        } else if (dasObject instanceof MsRole) {
            switch (MsModelHelper$WhenMappings.$EnumSwitchMapping$0[((MsRole)c).getType().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    icon = AllIcons.General.User;
                    break;
                }
                default: {
                    icon = super.getIcon(c);
                    break;
                }
            }
        } else {
            icon = super.getIcon(c);
        }
        return icon;
    }

    @NotNull
    public String getName(@NotNull ObjectKind kind) {
        String string;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        ObjectKind objectKind = kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.LOGIN)) {
            String string2 = DatabaseBundle.message((String)"ObjectKind.server.principal", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DatabaseBundle.message(\"\u2026ctKind.server.principal\")");
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROLE)) {
            String string3 = DatabaseBundle.message((String)"ObjectKind.database.principal", (Object[])new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"com.intellij.database.Da\u2026Kind.database.principal\")");
        } else {
            String string4 = super.getName(kind);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"super.getName(kind)");
        }
        return string;
    }

    @NotNull
    public MsObjectGrantController getGrantController() {
        return MsObjectGrantController.INSTANCE;
    }
}

