/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.mssql.MsObjectBuilder$WhenMappings;
import com.intellij.database.dialects.mssql.model.MsArgument;
import com.intellij.database.dialects.mssql.model.MsIndex;
import com.intellij.database.dialects.mssql.model.MsRoutine;
import com.intellij.database.dialects.mssql.model.MsTableColumn;
import com.intellij.database.dialects.mssql.model.MsTrigger;
import com.intellij.database.dialects.mssql.model.properties.MsRoutineType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModView;
import com.intellij.database.script.CompositeText;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.mssql.MsTypes;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlDefinitionStub;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J$\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dialects/mssql/MsObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "buildMsIndex", "Lcom/intellij/database/dialects/mssql/model/MsIndex;", "buildRoutine", "Lcom/intellij/database/dialects/mssql/model/MsRoutine;", "buildRoutineKind", "Lcom/intellij/database/model/basic/BasicModRoutine;", "buildTableColumn", "Lcom/intellij/database/dialects/mssql/model/MsTableColumn;", "buildTrigger", "Lcom/intellij/database/dialects/mssql/model/MsTrigger;", "buildViewSource", "Lcom/intellij/database/model/basic/BasicModView;", "getCompactDefinition", "Lcom/intellij/openapi/util/TextRange;", "path", "Lcom/intellij/database/util/ObjectPath;", "text", "Lcom/intellij/database/script/CompositeText;", "def", "Lcom/intellij/database/model/PsiObject;", "intellij.database.dialects.mssql"})
public final class MsObjectBuilder
extends SqlObjectBuilderImpl {
    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof MsTrigger) {
            this.buildTrigger((MsTrigger)obj2, source, context);
        } else if (basicModElement instanceof MsRoutine) {
            this.buildRoutine((MsRoutine)obj2, source, context);
        } else if (basicModElement instanceof MsTableColumn) {
            this.buildTableColumn((MsTableColumn)obj2, source, context);
        } else if (basicModElement instanceof MsIndex) {
            this.buildMsIndex((MsIndex)obj2, source, context);
        } else {
            super.build(obj2, source, context);
        }
    }

    @Override
    @Nullable
    public TextRange getCompactDefinition(@NotNull ObjectPath path, @NotNull CompositeText text, @Nullable PsiObject def) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ObjectKind objectKind = path.kind;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW) ? this.getViewQueryRange(def) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE) ? this.getRoutineBodyRange(def) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TRIGGER) ? this.getTriggerBodyRange(def) : super.getCompactDefinition(path, text, def)));
    }

    /*
     * WARNING - void declaration
     */
    private final void buildMsIndex(MsIndex obj2, DasObject source, SqlObjectBuilder.Context context) {
        boolean bl;
        BasicElement basicElement;
        void $this$stubbed$iv;
        super.buildIndex(obj2, source, context);
        if (context.isStubBuilder()) {
            return;
        }
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbed = false;
        void var7_7 = $this$stubbed$iv;
        if (var7_7 instanceof MsIndex) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (var7_7 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof MsIndex)) {
                object = null;
            }
            basicElement = (BasicElement)((MsIndex)object);
        } else {
            basicElement = null;
        }
        MsIndex msIndex = (MsIndex)basicElement;
        if (msIndex != null) {
            bl = msIndex.isFulltext();
        } else {
            DasObject dasObject2 = source;
            if (!(dasObject2 instanceof SqlCreateIndexStatement)) {
                dasObject2 = null;
            }
            bl = SqlImplUtil.getChildOfType((PsiElement)((PsiElement)((SqlCreateIndexStatement)dasObject2)), (IElementType)MsTypes.MSSQL_FULLTEXT) != null;
        }
        obj2.setFulltext(bl);
    }

    private final void buildTableColumn(MsTableColumn obj2, DasObject source, SqlObjectBuilder.Context context) {
        String string;
        this.buildBasicElement((BasicModElement)obj2, source, context);
        MsTableColumn msTableColumn = obj2;
        String string2 = obj2.getDefaultExpression();
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String string4 = string3;
            MsTableColumn msTableColumn2 = msTableColumn;
            boolean bl3 = false;
            String string5 = "default_for_" + obj2.getName();
            msTableColumn = msTableColumn2;
            string = string5;
        } else {
            string = null;
        }
        msTableColumn.setDefaultConstraintName(string);
    }

    private final void buildRoutine(MsRoutine obj2, DasObject source, SqlObjectBuilder.Context context) {
        Object object;
        MsRoutine msRoutine = obj2;
        if (msRoutine == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicModRoutine");
        }
        this.buildRoutine((BasicModRoutine)msRoutine, source, context);
        if (!context.isStubBuilder() && obj2.getRoutineType() == MsRoutineType.TAB_FUN && (object = obj2.getReturnArgument()) != null) {
            BasicArgument $this$castSafelyTo$iv = object;
            boolean $i$f$castSafelyTo = false;
            BasicArgument basicArgument = $this$castSafelyTo$iv;
            if (!(basicArgument instanceof MsArgument)) {
                basicArgument = null;
            }
            if ((object = (MsArgument)basicArgument) != null) {
                object.drop();
            }
        }
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(this, source){
            final /* synthetic */ MsObjectBuilder this$0;
            final /* synthetic */ DasObject $source;

            @Nullable
            public final CompositeText invoke() {
                Object object;
                DasObject dasObject = this.$source;
                if (!(dasObject instanceof SqlCreateProcedureStatement)) {
                    dasObject = null;
                }
                return (CompositeText)((object = (SqlCreateProcedureStatement)dasObject) != null && (object = this.this$0.wholeStatement((SqlRoutineDefinition)object)) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null);
            }
            {
                this.this$0 = msObjectBuilder;
                this.$source = dasObject;
                super(0);
            }
        }));
    }

    @Override
    public void buildRoutineKind(@NotNull BasicModRoutine obj2, @NotNull DasObject source) {
        MsRoutineType msRoutineType;
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        MsRoutine cfr_ignored_0 = (MsRoutine)obj2;
        DasRoutine.Kind k = this.extractRoutineKind(source);
        MsRoutine msRoutine = (MsRoutine)obj2;
        switch (MsObjectBuilder$WhenMappings.$EnumSwitchMapping$0[k.ordinal()]) {
            case 1: {
                msRoutineType = MsRoutineType.PROC;
                break;
            }
            case 2: {
                DasRoutine dasRoutine;
                DasObject $this$castSafelyTo$iv = source;
                boolean $i$f$castSafelyTo = false;
                DasObject dasObject = $this$castSafelyTo$iv;
                if (!(dasObject instanceof DasRoutine)) {
                    dasObject = null;
                }
                if (StringsKt.equals((dasRoutine = (DasRoutine)dasObject) != null && (dasRoutine = dasRoutine.getReturnArgument()) != null && (dasRoutine = dasRoutine.getDataType()) != null ? dasRoutine.typeName : null, (String)"table", (boolean)true)) {
                    msRoutineType = MsRoutineType.TAB_FUN;
                    break;
                }
                msRoutineType = MsRoutineType.SCALAR_FUN;
                break;
            }
            default: {
                msRoutineType = MsRoutineType.CLR_PROC;
            }
        }
        msRoutine.setRoutineType(msRoutineType);
    }

    private final void buildTrigger(MsTrigger obj2, DasObject source, SqlObjectBuilder.Context context) {
        MsTrigger msTrigger = obj2;
        if (msTrigger == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicModTrigger");
        }
        this.buildTrigger((BasicModTrigger)msTrigger, source, context);
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(this, source){
            final /* synthetic */ MsObjectBuilder this$0;
            final /* synthetic */ DasObject $source;

            @Nullable
            public final CompositeText invoke() {
                Object object;
                DasObject dasObject = this.$source;
                if (!(dasObject instanceof SqlCreateTriggerStatement)) {
                    dasObject = null;
                }
                return (CompositeText)((object = (SqlCreateTriggerStatement)dasObject) != null && (object = object.getText()) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null);
            }
            {
                this.this$0 = msObjectBuilder;
                this.$source = dasObject;
                super(0);
            }
        }));
    }

    @Override
    protected void buildViewSource(@NotNull BasicModView obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.assignSources((BasicModSourceAware)obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(this, source){
            final /* synthetic */ MsObjectBuilder this$0;
            final /* synthetic */ DasObject $source;

            @Nullable
            public final CompositeText invoke() {
                Object object;
                DasObject dasObject = this.$source;
                if (!(dasObject instanceof SqlCreateViewStatement)) {
                    dasObject = null;
                }
                return (CompositeText)((object = (SqlCreateViewStatement)dasObject) != null && (object = this.this$0.wholeStatement((SqlTableDefinition)object)) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null);
            }
            {
                this.this$0 = msObjectBuilder;
                this.$source = dasObject;
                super(0);
            }
        }));
    }
}

