/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.mssql.AbstractTsqlDialectHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsDialectHelper
extends AbstractTsqlDialectHelper {
    private static boolean isMax(@Nullable String type, @Nullable String length) {
        return type != null && length != null && StringUtil.equals((CharSequence)"-1", (CharSequence)length) && !MsDialectHelper.isLargeType(type);
    }

    private static boolean isLargeType(@Nullable String type) {
        return StringUtil.findIgnoreCase((String)type, (String[])new String[]{"xml", "image", "text", "ntext"});
    }

    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            MsDialectHelper.$$$reportNull$$$0(0);
        }
        if (connection == null) {
            MsDialectHelper.$$$reportNull$$$0(1);
        }
        Map map2 = DbImplUtil.resultRowAsMap((DatabaseConnection)connection, (String)String.format("EXEC sp_spaceused '%s'", DbImplUtil.escapeStr((String)QNameUtil.getQualifiedName((DbElement)element))), (String[])new String[]{"rows", "rows"});
        if (map2 == null) {
            MsDialectHelper.$$$reportNull$$$0(2);
        }
        return map2;
    }

    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        if (table == null) {
            MsDialectHelper.$$$reportNull$$$0(3);
        }
        if (connection == null) {
            MsDialectHelper.$$$reportNull$$$0(4);
        }
        String tableName = table.getName().replace("'", "''");
        String tableSchema = DasUtil.getSchema((DasObject)table).replace("'", "''");
        String tableCatalog = DasUtil.getCatalog((DasObject)table).replace("'", "''");
        String columns = String.format("SELECT * FROM INFORMATION_SCHEMA.TABLES AS T INNER JOIN     INFORMATION_SCHEMA.COLUMNS AS C ON \n                                    T.TABLE_NAME = C.TABLE_NAME                                    AND T.TABLE_SCHEMA = C.TABLE_SCHEMA                                    AND T.TABLE_CATALOG = C.TABLE_CATALOG  WHERE      T.TABLE_NAME = N'%s'  AND T.TABLE_SCHEMA = N'%s'  AND T.TABLE_CATALOG = N'%s'", tableName, tableSchema, tableCatalog);
        String pkColumnsQuery = String.format("SELECT U.COLUMN_NAME FROM  INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS C  INNER JOIN  INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE AS U ON U.CONSTRAINT_NAME = C.CONSTRAINT_NAME  WHERE C.CONSTRAINT_TYPE = 'PRIMARY KEY'  AND C.TABLE_NAME = N'%s'  AND C.TABLE_SCHEMA = N'%s'  AND C.TABLE_CATALOG = N'%s'", tableName, tableSchema, tableCatalog);
        SmartStatements statements2 = SmartStatements.poweredBy((DatabaseConnection)connection);
        List pkColumns = (List)statements2.simple().noisy().execute((Object)pkColumnsQuery, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.listOfStrings((String)"column_name"));
        boolean isSinglePk = pkColumns.size() == 1;
        int spaces = 2;
        AbstractDatabaseDialect dialect = (AbstractDatabaseDialect)DbImplUtil.getDatabaseDialect((Dbms)Dbms.MSSQL);
        DdlBuilder ddl = table instanceof DbElement ? DatabaseDialogsHelper.createDdlBuilder((DbElement)((DbElement)table), (boolean)false) : new DdlBuilder().withDialect((DatabaseDialectEx)dialect);
        ddl.keywords(new String[]{"create", "table"}).space().qualifiedRef((DasObject)table).space().symbol("(");
        statements2.simple().noisy().execute((Object)columns, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.results(rs -> {
            boolean first2 = true;
            while (rs.next()) {
                if (first2) {
                    first2 = false;
                } else {
                    ddl.symbol(",");
                }
                String name2 = (String)JdbcNativeUtil.computeSafe(() -> rs.getString("column_name"));
                String defaults = (String)JdbcNativeUtil.computeSafe(() -> rs.getString("column_default"));
                String type = (String)JdbcNativeUtil.computeSafe(() -> rs.getString("data_type"));
                String length = (String)JdbcNativeUtil.computeSafe(() -> rs.getString("character_maximum_length"));
                String precision = (String)JdbcNativeUtil.computeSafe(() -> rs.getString("numeric_precision"));
                String scale = (String)JdbcNativeUtil.computeSafe(() -> rs.getString("numeric_scale"));
                String isNullableStr = (String)JdbcNativeUtil.computeSafe(() -> rs.getString("is_nullable"));
                boolean isNotNull = "NO".equals(isNullableStr);
                length = MsDialectHelper.isMax(type, length) ? String.valueOf(Integer.MAX_VALUE) : length;
                String substitution = dialect.getTypeWithSubstitution(type != null ? type : "<type>", StringUtil.parseInt((String)length, (int)-1), StringUtil.parseInt((String)precision, (int)-1), StringUtil.parseInt((String)scale, (int)-1));
                ddl.newLine().space(spaces).columnRef(name2 != null ? name2 : "<name>").space().type(substitution);
                if (isSinglePk && ((String)pkColumns.iterator().next()).equals(name2)) {
                    ddl.space().keywords(new String[]{"primary", "key"});
                }
                if (defaults != null) {
                    ddl.space().keywords(new String[]{"default"}).space().literal(defaults);
                }
                if (!isNotNull) continue;
                ddl.space().keywords(new String[]{"not", "null"});
            }
        }));
        if (pkColumns.size() > 1) {
            ddl.symbol(",").newLine().space(spaces).keywords(new String[]{"primary", "key"}).space().symbol("(");
            boolean f = true;
            for (Object pk : pkColumns) {
                if (f) {
                    f = false;
                } else {
                    ddl.symbol(",").space();
                }
                ddl.identifier((String)pk);
            }
            ddl.symbol(")");
        }
        String fkQuery = String.format("SELECT C.CONSTRAINT_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS C WHERE      C.CONSTRAINT_TYPE = 'FOREIGN KEY'  AND C.TABLE_NAME = N'%s'  AND C.TABLE_SCHEMA = N'%s'  AND C.TABLE_CATALOG = N'%s'", tableName, tableSchema, tableCatalog);
        List fkNames = (List)statements2.simple().noisy().execute((Object)fkQuery, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.throwableResultsTransformer(rs -> {
            SmartList result2 = new SmartList();
            while (rs.next()) {
                result2.add(rs.getString("constraint_name"));
            }
            return result2;
        }, (Object)ContainerUtil.emptyList()));
        for (String fkName : fkNames) {
            String fkCols = String.format("SELECT\n    U.COLUMN_NAME AS FROM_COL,    K.TABLE_NAME,    K.COLUMN_NAME  FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS C   INNER JOIN INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE AS U ON U.CONSTRAINT_NAME = C.CONSTRAINT_NAME  INNER JOIN INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS R ON R.CONSTRAINT_NAME = C.CONSTRAINT_NAME  INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE K ON K.CONSTRAINT_NAME = R.UNIQUE_CONSTRAINT_NAME  WHERE C.CONSTRAINT_NAME = '%s'", fkName);
            LinkedHashSet fromCols = new LinkedHashSet();
            LinkedHashSet toCols = new LinkedHashSet();
            String refTableName = "<ref_table>";
            try (ClosableResultsProducer producer = statements2.simple().noisy().execute((Object)fkCols, (ExecutionMode)StandardExecutionMode.QUERY);){
                RemoteResultSet rs2;
                RemoteResultSet remoteResultSet = rs2 = producer.advance() ? (RemoteResultSet)producer.processCurrent((ResultsProducer.Processor)StandardResultsProcessors.RESULT_SET) : null;
                if (rs2 != null) {
                    while (rs2.next()) {
                        refTableName = rs2.getString("table_name");
                        ContainerUtil.addIfNotNull(fromCols, (Object)rs2.getString("from_col"));
                        ContainerUtil.addIfNotNull(toCols, (Object)rs2.getString("column_name"));
                    }
                }
            }
            ddl.symbol(",").newLine().space(spaces).keywords(new String[]{"foreign", "key"}).space().symbol("(");
            DialectUtils.appendStringList((DdlBuilder)ddl, fromCols);
            ddl.symbol(")");
            ddl.space().keyword("references").space().identifier(refTableName).space().symbol("(");
            DialectUtils.appendStringList((DdlBuilder)ddl, toCols);
            ddl.symbol(")");
        }
        ddl.newLine().symbol(")").symbol(";");
        String indices = String.format("select  ind.name as index_name,  t.name as table_name,  col.name as col_name,  ind.is_unique from sys.indexes ind  inner join sys.index_columns ic on ind.object_id = ic.object_id and ind.index_id = ic.index_id  inner join sys.columns col on ic.object_id = col.object_id and ic.column_id = col.column_id  inner join sys.tables t on ind.object_id = t.object_id where ind.is_primary_key = 0 and t.is_ms_shipped = 0  and t.name = N'%s'", tableName);
        MultiMap indexColumns = new MultiMap();
        HashMap<String, Boolean> indexUnique = new HashMap<String, Boolean>();
        try (ClosableResultsProducer producer = statements2.simple().noisy().execute((Object)indices, (ExecutionMode)StandardExecutionMode.QUERY);){
            RemoteResultSet rs3;
            RemoteResultSet remoteResultSet = rs3 = producer.advance() ? (RemoteResultSet)producer.processCurrent((ResultsProducer.Processor)StandardResultsProcessors.RESULT_SET) : null;
            if (rs3 != null) {
                while (rs3.next()) {
                    String indexName = rs3.getString("index_name");
                    String columnName = rs3.getString("col_name");
                    boolean isUnique = rs3.getBoolean("is_unique");
                    indexColumns.putValue((Object)indexName, (Object)columnName);
                    indexUnique.put(indexName, isUnique);
                }
            }
        }
        for (String i2 : indexColumns.keySet()) {
            Collection colNames = indexColumns.get((Object)i2);
            Boolean isUnique = (Boolean)indexUnique.get(i2);
            ddl.newLine().keywords(new String[]{"create"}).space();
            if (isUnique.booleanValue()) {
                ddl.keyword("unique").space();
            }
            ddl.keyword("index").space().identifier(i2).space().keyword("on").space().identifier(tableName).space().symbol("(");
            boolean first2 = true;
            for (String col : colNames) {
                if (first2) {
                    first2 = false;
                } else {
                    ddl.symbol(",").space();
                }
                ddl.identifier(col);
            }
            ddl.symbol(")").symbol(";");
        }
        String string = ddl.getStatement();
        if (string == null) {
            MsDialectHelper.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection) throws SQLException {
        if (connection == null) {
            MsDialectHelper.$$$reportNull$$$0(6);
        }
        List list = (List)DbImplUtil.executeAndGetResult((DatabaseConnection)connection, (String)"SELECT [name] FROM sys.databases d WHERE d.database_id > 4", (ThrowableConvertor)DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            MsDialectHelper.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/MsDialectHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/MsDialectHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

