/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.dialects.mssql.AbstractTsqlDialect;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.mssql.MsTypes;
import com.intellij.sql.dialects.mssql.psi.MssqlAlterDatabaseStatement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.impl.SqlImplUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsDialect
extends AbstractTsqlDialect
implements DatabaseDialect {
    private final Dbms myDbms;

    public MsDialect(@NotNull Dbms dbms) {
        if (dbms == null) {
            MsDialect.$$$reportNull$$$0(0);
        }
        super(new TypeHelper.MsTypeHelper());
        this.myDbms = dbms;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myDbms;
        if (dbms == null) {
            MsDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @NotNull
    public String getDisplayName() {
        return "SQL Server";
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        String sqlType;
        if (dataType == null) {
            MsDialect.$$$reportNull$$$0(2);
        }
        if ("money".equals(sqlType = dataType.getSpecification())) {
            return "money";
        }
        String string = super.getTypeName(dataType);
        if (string == null) {
            MsDialect.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            MsDialect.$$$reportNull$$$0(4);
        }
        Pair pair = Pair.create((Object)("use [" + DasUtil.getCatalog((DasObject)element) + "]\nexec sp_helptext '" + QNameUtil.getQualifiedName((DasObject)element, (NamingService)this.getNamingService()) + "'"), (Object)DbImplUtilCore.ConcatenationProps.TIGHT);
        if (pair == null) {
            MsDialect.$$$reportNull$$$0(5);
        }
        return pair;
    }

    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            MsDialect.$$$reportNull$$$0(6);
        }
        Pair pair = Pair.create((Object)("use [" + DasUtil.getCatalog((DasObject)element) + "]\nexec sp_helptext '" + QNameUtil.getQualifiedName((DasObject)element, (NamingService)this.getNamingService()) + "'"), (Object)DbImplUtilCore.ConcatenationProps.TIGHT);
        if (pair == null) {
            MsDialect.$$$reportNull$$$0(7);
        }
        return pair;
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            MsDialect.$$$reportNull$$$0(8);
        }
        if (qualifier == null) {
            MsDialect.$$$reportNull$$$0(9);
        }
        boolean needQualify = this.qualify(qualifier);
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DasObject catalog = DasUtil.getCatalogObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), (DasObject)(needQualify ? catalog : null), needQualify ? DasUtil.getName((DasObject)catalog) : null, null, null);
        if (ddlBuilder == null) {
            MsDialect.$$$reportNull$$$0(10);
        }
        return ddlBuilder;
    }

    public boolean qualify(DasObject qualifier) {
        if (!(qualifier instanceof DasTable)) {
            return false;
        }
        ObjectKind kind = qualifier.getKind();
        return kind == ObjectKind.TABLE;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean hasRowId(@Nullable Version version) {
        return this.myDbms == Dbms.MSSQL && MsDialect.isMsSql2008(version);
    }

    @Override
    public boolean similarTo(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            MsDialect.$$$reportNull$$$0(11);
        }
        return dialect instanceof MsDialect;
    }

    @Override
    public boolean triggersIntrospection(@NotNull PsiElement element) {
        if (element == null) {
            MsDialect.$$$reportNull$$$0(12);
        }
        if (element instanceof MssqlAlterDatabaseStatement) {
            for (PsiElement child : SqlImplUtil.sqlChildren((PsiElement)element)) {
                IElementType elementType;
                if (PsiUtilCore.getElementType((PsiElement)child) != SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE || (elementType = PsiUtilCore.getElementType((PsiElement)child.getFirstChild())) != MsTypes.MSSQL_ONLINE && elementType != MsTypes.MSSQL_OFFLINE) continue;
                return true;
            }
        }
        return super.triggersIntrospection(element);
    }

    public static boolean isMsSql2008(@Nullable Version version) {
        return version == null || version.isOrGreater(new int[]{10, 50});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/MsDialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 4: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/MsDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlViewDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "similarTo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "triggersIntrospection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

