/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseArtifactList;
import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProvider;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.dialects.base.BaseDatabaseErrorHandler;
import com.intellij.database.util.Version;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MsAzureAuthProviderBase
extends DatabaseConfigValidator<LocalDataSource>
implements DatabaseAuthProvider {
    private static final Logger LOG = Logger.getInstance(MsAzureAuthProviderBase.class);
    private static final RequiredArtifact ADAL4J = new RequiredArtifact("Active Directory"){

        @Override
        protected boolean checkFile(String u) {
            return u.contains("adal4j");
        }
    };
    private static final RequiredArtifact MSAL4J = new RequiredArtifact("MSAL4J"){

        @Override
        protected boolean checkFile(String u) {
            return u.contains("msal4j");
        }
    };

    protected static String setAuthentication(@NotNull DatabaseConnectionInterceptor.ProtoConnection p, String authentication) {
        if (p == null) {
            MsAzureAuthProviderBase.$$$reportNull$$$0(0);
        }
        return (String)DataSourceUiUtil.putOrRemove((Map)p.getConnectionProperties(), (Object)"authentication", (Object)authentication);
    }

    public boolean isApplicable(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            MsAzureAuthProviderBase.$$$reportNull$$$0(1);
        }
        return JdbcEngine.isMs((DatabaseDriver)dataSource.getDatabaseDriver());
    }

    public void setNewPassword(DatabaseConnectionInterceptor.ProtoConnection proto2, String newPass) {
        DatabaseCredentialsAuthProvider.applyNewPassword((DatabaseConnectionInterceptor.ProtoConnection)proto2, (String)newPass);
    }

    public Class<? extends LocalDataSource> getTargetClass() {
        return LocalDataSource.class;
    }

    @Nullable
    public CompletionStage<DatabaseConnectionInterceptor.ProtoConnection> handleConnectionFailure(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, @NotNull SQLException e2, boolean silent, int attempt) {
        if (proto2 == null) {
            MsAzureAuthProviderBase.$$$reportNull$$$0(2);
        }
        if (e2 == null) {
            MsAzureAuthProviderBase.$$$reportNull$$$0(3);
        }
        String message2 = e2.getMessage();
        DatabaseDriver driver = proto2.getConnectionPoint().getDatabaseDriver();
        if (driver != null && message2 != null) {
            RequiredArtifact ra;
            RequiredArtifact requiredArtifact = message2.contains("Failed to load ADAL4J") ? ADAL4J : (ra = message2.contains("Failed to load MSAL4J") ? MSAL4J : null);
            if (ra != null) {
                return AsyncUtil.exceptional((Throwable)new DatabaseErrorHandler.KnownException(e2.getMessage(), Collections.singletonList(ra.createSetUpFix(driver, true)), (Throwable)e2));
            }
        }
        return super.handleConnectionFailure(proto2, e2, silent, attempt);
    }

    public void collectProblems(@NotNull Project project, @NotNull LocalDataSource target2, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable DatabaseConfigEditor editor) {
        if (project == null) {
            MsAzureAuthProviderBase.$$$reportNull$$$0(4);
        }
        if (target2 == null) {
            MsAzureAuthProviderBase.$$$reportNull$$$0(5);
        }
        if (problems == null) {
            MsAzureAuthProviderBase.$$$reportNull$$$0(6);
        }
        this.getRequiredArtifact(target2).validateRequired(project, target2, problems, editor, DatabaseBundle.message((String)"notification.title.azure.active.directory.authentication", (Object[])new Object[0]));
    }

    @NotNull
    protected RequiredArtifact getRequiredArtifact(@NotNull LocalDataSource target2) {
        if (target2 == null) {
            MsAzureAuthProviderBase.$$$reportNull$$$0(7);
        }
        RequiredArtifact requiredArtifact = MSAL4J;
        if (requiredArtifact == null) {
            MsAzureAuthProviderBase.$$$reportNull$$$0(8);
        }
        return requiredArtifact;
    }

    protected static RequiredArtifact guessRequired(@NotNull LocalDataSource target2) {
        Version version;
        DatabaseDriver driver;
        if (target2 == null) {
            MsAzureAuthProviderBase.$$$reportNull$$$0(9);
        }
        DatabaseDriver databaseDriver = driver = (version = Version.parse((String)target2.getDriverVersion().version)) != null ? null : target2.getDatabaseDriver();
        if (driver != null) {
            DatabaseDriver.ArtifactRef artifact = RequiredArtifact.findArtifact(driver, "SQL Server");
            version = artifact == null ? null : artifact.getArtifactVersion();
        }
        return version == null || version.isOrGreater(new int[]{9}) ? MSAL4J : ADAL4J;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proto";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/MsAzureAuthProviderBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/MsAzureAuthProviderBase";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredArtifact";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setAuthentication";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleConnectionFailure";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectProblems";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredArtifact";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "guessRequired";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class RequiredArtifact {
        public final String artifactId;

        public RequiredArtifact(String artifactId) {
            this.artifactId = artifactId;
        }

        @Nullable
        public DatabaseArtifactList.ArtifactVersion findArtifact() {
            return DatabaseArtifactManager.getArtifacts().resolve(this.artifactId, null, "stable", null);
        }

        public boolean usesArtifact(@NotNull LocalDataSource target2) {
            DatabaseDriver driver;
            if (target2 == null) {
                RequiredArtifact.$$$reportNull$$$0(0);
            }
            if ((driver = target2.getDatabaseDriver()) != null && this.usesArtifact(driver)) {
                return true;
            }
            return JBIterable.from((Iterable)target2.getClasspathElements()).flatten(SimpleClasspathElement::getClassesRootUrls).find(this::checkFile) != null;
        }

        public boolean usesArtifact(DatabaseDriver driver) {
            DatabaseDriver.ArtifactRef artifactRef = RequiredArtifact.findArtifact(driver, this.artifactId);
            return artifactRef != null;
        }

        public static DatabaseDriver.ArtifactRef findArtifact(DatabaseDriver driver, String artifactId) {
            return (DatabaseDriver.ArtifactRef)ContainerUtil.find((Iterable)driver.getArtifacts(), a -> a.getId().equals(artifactId));
        }

        protected abstract boolean checkFile(String var1);

        public void validateRequired(final @NotNull Project project, @NotNull LocalDataSource target2, @NotNull Consumer<? super DataSourceProblem> problems, final @Nullable DatabaseConfigEditor editor, @NotNull @Nls String title) {
            DatabaseDriver driver;
            if (project == null) {
                RequiredArtifact.$$$reportNull$$$0(1);
            }
            if (target2 == null) {
                RequiredArtifact.$$$reportNull$$$0(2);
            }
            if (problems == null) {
                RequiredArtifact.$$$reportNull$$$0(3);
            }
            if (title == null) {
                RequiredArtifact.$$$reportNull$$$0(4);
            }
            if ((driver = target2.getDatabaseDriver()) != null && !this.usesArtifact(target2)) {
                final DatabaseErrorHandler.Fix setUpFix = this.createSetUpFix(driver, false);
                NamedProgressive fix = new NamedProgressive(setUpFix.getName()){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ApplicationManager.getApplication().invokeAndWait(() -> DataSourceUiUtil.applyFix((Project)project, (DatabaseErrorHandler.Fix)setUpFix, (DatabaseConfigEditor)editor));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dialects/mssql/MsAzureAuthProviderBase$RequiredArtifact$1", "run"));
                    }
                };
                problems.consume((Object)new DataSourceProblem((Object)target2, (Object)this, DataSourceProblem.Level.WARNING, new DataSourceProblem.HyperText(title, DatabaseBundle.message((String)"notification.content.extra.libraries.required.href.action0.download", (Object[])new Object[0]), DatabaseBundle.message((String)"notification.content.extra.libraries.required", (Object[])new Object[0]), new Object[]{fix}), fix));
            }
        }

        @NotNull
        public DatabaseErrorHandler.Fix createSetUpFix(DatabaseDriver driver, boolean navigate) {
            DatabaseErrorHandler.Fix fix = BaseDatabaseErrorHandler.createSetUpArtifactFix(driver, navigate, () -> {
                DatabaseArtifactList.ArtifactVersion adal = this.findArtifact();
                if (adal == null) {
                    LOG.error(this.artifactId + " artifact not found");
                    return null;
                }
                return adal;
            });
            if (fix == null) {
                RequiredArtifact.$$$reportNull$$$0(5);
            }
            return fix;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problems";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/mssql/MsAzureAuthProviderBase$RequiredArtifact";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/mssql/MsAzureAuthProviderBase$RequiredArtifact";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createSetUpFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "usesArtifact";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "validateRequired";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

