/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo.translator.tree_creator.builder;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.mongo.translator.MongoToDatabaseScriptTranslator;
import com.intellij.database.dialects.mongo.translator.tree.MongoIdentifier;
import com.intellij.database.dialects.mongo.translator.tree.expression.MongoConstructorOperator;
import com.intellij.database.dialects.mongo.translator.tree.expression.MongoFunctionOperator;
import com.intellij.database.dialects.mongo.translator.tree.expression.function.IMongoArgumentList;
import com.intellij.database.dialects.mongo.translator.tree.expression.function.IMongoFunction;
import com.intellij.database.dialects.mongo.translator.tree.expression.function.MongoFunction;
import com.intellij.database.dialects.mongo.translator.tree.expression.literal.MongoConstructorArgumentList;
import com.intellij.database.dialects.mongo.translator.tree.expression.literal.MongoLiteralConstructed;
import com.intellij.database.dialects.mongo.translator.tree_creator.builder.IMongoFunctionBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\t\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\fH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dialects/mongo/translator/tree_creator/builder/MongoFunctionBuilder;", "Lcom/intellij/database/dialects/mongo/translator/tree_creator/builder/IMongoFunctionBuilder;", "o", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "root", "Lcom/intellij/sql/psi/SqlElement;", "(Lcom/intellij/sql/psi/SqlFunctionCallExpression;Lcom/intellij/sql/psi/SqlElement;)V", "argumentList", "Lcom/intellij/database/dialects/mongo/translator/tree/expression/function/IMongoArgumentList;", "callableIdentifier", "Lcom/intellij/database/dialects/mongo/translator/tree/MongoIdentifier;", "isAggregateCall", "", "getO", "()Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "getRoot", "()Lcom/intellij/sql/psi/SqlElement;", "withNew", "v", "build", "Lcom/intellij/database/dialects/mongo/translator/tree/expression/function/IMongoFunction;", "convertConstructorOpName", "Lcom/intellij/database/dialects/mongo/translator/tree/expression/MongoConstructorOperator;", "name", "", "convertFunctionOpName", "Lcom/intellij/database/dialects/mongo/translator/tree/expression/MongoFunctionOperator;", "intellij.database.dialects.mongo"})
public final class MongoFunctionBuilder
implements IMongoFunctionBuilder {
    private boolean isAggregateCall;
    private boolean withNew;
    private MongoIdentifier callableIdentifier;
    private IMongoArgumentList argumentList;
    @NotNull
    private final SqlFunctionCallExpression o;
    @NotNull
    private final SqlElement root;

    @Override
    @NotNull
    public IMongoFunction build() {
        MongoIdentifier mongoIdentifier = this.callableIdentifier;
        if (mongoIdentifier == null) {
            throw (Throwable)MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
        }
        MongoIdentifier callableIdentifier = mongoIdentifier;
        IMongoArgumentList iMongoArgumentList = this.argumentList;
        if (iMongoArgumentList == null) {
            throw (Throwable)MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
        }
        IMongoArgumentList argumentList = iMongoArgumentList;
        MongoFunctionOperator functionOp = this.convertFunctionOpName(callableIdentifier.getName());
        MongoConstructorOperator constructorOp = this.convertConstructorOpName(callableIdentifier.getName());
        if (functionOp != MongoFunctionOperator.UNKNOWN || functionOp == MongoFunctionOperator.UNKNOWN && constructorOp == MongoConstructorOperator.UNKNOWN && !this.withNew) {
            if (this.withNew) {
                String string = DatabaseBundle.message((String)"MongoTranslator.errors.after.new.a.literal.constructor.is.expected.instead.of.a.function.call", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DatabaseBundle.message(\"\u2026tead.of.a.function.call\")");
                throw (Throwable)MongoToDatabaseScriptTranslator.Companion.createTranslationException(string, (PsiElement)this.o, (PsiElement)this.root);
            }
            if (functionOp == MongoFunctionOperator.COUNT) {
                Collection collection = argumentList.getArguments();
                boolean bl = false;
                if (!collection.isEmpty()) {
                    String string = DatabaseBundle.message((String)"MongoTranslator.errors.only.count.star.is.supported", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DatabaseBundle.message(\"\u2026count.star.is.supported\")");
                    throw (Throwable)MongoToDatabaseScriptTranslator.Companion.createTranslationException(string, (PsiElement)this.o, (PsiElement)this.root);
                }
            }
            if (functionOp == MongoFunctionOperator.REDUCE || functionOp == MongoFunctionOperator.MAP || functionOp == MongoFunctionOperator.FILTER || functionOp == MongoFunctionOperator.LET) {
                String string = DatabaseBundle.message((String)"MongoTranslator.errors.function.0.is.unsupported", (Object[])new Object[]{callableIdentifier.getName()});
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DatabaseBundle.message(\"\u2026 callableIdentifier.name)");
                throw (Throwable)MongoToDatabaseScriptTranslator.Companion.createTranslationException(string, (PsiElement)this.o, (PsiElement)this.root);
            }
            String string = this.o.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"o.text");
            return new MongoFunction(this.isAggregateCall, functionOp, callableIdentifier, argumentList, string);
        }
        if (constructorOp != MongoConstructorOperator.UNKNOWN || constructorOp == MongoConstructorOperator.UNKNOWN && functionOp == MongoFunctionOperator.UNKNOWN && this.withNew) {
            if (this.isAggregateCall) {
                throw (Throwable)MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
            }
            if (!(argumentList instanceof MongoConstructorArgumentList)) {
                String string = DatabaseBundle.message((String)"MongoTranslator.errors.literal.constructor.require.literal.arguments", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DatabaseBundle.message(\"\u2026quire.literal.arguments\")");
                throw (Throwable)MongoToDatabaseScriptTranslator.Companion.createTranslationException(string, (PsiElement)this.o, (PsiElement)this.root);
            }
            MongoConstructorArgumentList mongoConstructorArgumentList = (MongoConstructorArgumentList)argumentList;
            String string = this.o.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"o.text");
            return new MongoLiteralConstructed(this.withNew, constructorOp, callableIdentifier, mongoConstructorArgumentList, string);
        }
        throw (Throwable)MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
    }

    @Override
    @NotNull
    public MongoFunctionBuilder isAggregateCall(boolean v2) {
        MongoFunctionBuilder mongoFunctionBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        MongoFunctionBuilder $this$apply = mongoFunctionBuilder;
        boolean bl3 = false;
        $this$apply.isAggregateCall = v2;
        return mongoFunctionBuilder;
    }

    @Override
    @NotNull
    public MongoFunctionBuilder withNew(boolean v2) {
        MongoFunctionBuilder mongoFunctionBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        MongoFunctionBuilder $this$apply = mongoFunctionBuilder;
        boolean bl3 = false;
        $this$apply.withNew = v2;
        return mongoFunctionBuilder;
    }

    @Override
    @NotNull
    public MongoFunctionBuilder callableIdentifier(@NotNull MongoIdentifier v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        MongoFunctionBuilder mongoFunctionBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        MongoFunctionBuilder $this$apply = mongoFunctionBuilder;
        boolean bl3 = false;
        $this$apply.callableIdentifier = v2;
        return mongoFunctionBuilder;
    }

    @Override
    @NotNull
    public MongoFunctionBuilder argumentList(@NotNull IMongoArgumentList v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        MongoFunctionBuilder mongoFunctionBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        MongoFunctionBuilder $this$apply = mongoFunctionBuilder;
        boolean bl3 = false;
        $this$apply.argumentList = v2;
        return mongoFunctionBuilder;
    }

    private final MongoFunctionOperator convertFunctionOpName(String name2) {
        MongoFunctionOperator mongoFunctionOperator;
        String string = name2;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
        switch (string3) {
            case "ABS": {
                mongoFunctionOperator = MongoFunctionOperator.ABS;
                break;
            }
            case "ACCUMULATOR": {
                mongoFunctionOperator = MongoFunctionOperator.ACCUMULATOR;
                break;
            }
            case "ACOS": {
                mongoFunctionOperator = MongoFunctionOperator.ACOS;
                break;
            }
            case "ACOSH": {
                mongoFunctionOperator = MongoFunctionOperator.ACOSH;
                break;
            }
            case "ADD": {
                mongoFunctionOperator = MongoFunctionOperator.ADD;
                break;
            }
            case "ADDTOSET": {
                mongoFunctionOperator = MongoFunctionOperator.ADD_TO_SET;
                break;
            }
            case "ALLELEMENTSTRUE": {
                mongoFunctionOperator = MongoFunctionOperator.ALL_ELEMENTS_TRUE;
                break;
            }
            case "AND": {
                mongoFunctionOperator = MongoFunctionOperator.AND;
                break;
            }
            case "ANYELEMENTTRUE": {
                mongoFunctionOperator = MongoFunctionOperator.ANY_ELEMENT_TRUE;
                break;
            }
            case "ARRAYELEMAT": {
                mongoFunctionOperator = MongoFunctionOperator.ARRAY_ELEM_AT;
                break;
            }
            case "ARRAYTOOBJECT": {
                mongoFunctionOperator = MongoFunctionOperator.ARRAY_TO_OBJECT;
                break;
            }
            case "ASIN": {
                mongoFunctionOperator = MongoFunctionOperator.ASIN;
                break;
            }
            case "ASINH": {
                mongoFunctionOperator = MongoFunctionOperator.ASINH;
                break;
            }
            case "ATAN": {
                mongoFunctionOperator = MongoFunctionOperator.ATAN;
                break;
            }
            case "ATAN2": {
                mongoFunctionOperator = MongoFunctionOperator.ATAN2;
                break;
            }
            case "ATANH": {
                mongoFunctionOperator = MongoFunctionOperator.ATANH;
                break;
            }
            case "AVG": {
                mongoFunctionOperator = MongoFunctionOperator.AVG;
                break;
            }
            case "BINARYSIZE": {
                mongoFunctionOperator = MongoFunctionOperator.BINARY_SIZE;
                break;
            }
            case "BSONSIZE": {
                mongoFunctionOperator = MongoFunctionOperator.BSON_SIZE;
                break;
            }
            case "CEIL": {
                mongoFunctionOperator = MongoFunctionOperator.CEIL;
                break;
            }
            case "CMP": {
                mongoFunctionOperator = MongoFunctionOperator.CMP;
                break;
            }
            case "CONCAT": {
                mongoFunctionOperator = MongoFunctionOperator.CONCAT;
                break;
            }
            case "CONCATARRAYS": {
                mongoFunctionOperator = MongoFunctionOperator.CONCAT_ARRAYS;
                break;
            }
            case "COND": {
                mongoFunctionOperator = MongoFunctionOperator.COND;
                break;
            }
            case "CONVERT": {
                mongoFunctionOperator = MongoFunctionOperator.CONVERT;
                break;
            }
            case "COS": {
                mongoFunctionOperator = MongoFunctionOperator.COS;
                break;
            }
            case "COUNT": {
                mongoFunctionOperator = MongoFunctionOperator.COUNT;
                break;
            }
            case "DATEFROMPARTS": {
                mongoFunctionOperator = MongoFunctionOperator.DATE_FROM_PARTS;
                break;
            }
            case "DATETOPARTS": {
                mongoFunctionOperator = MongoFunctionOperator.DATE_TO_PARTS;
                break;
            }
            case "DATEFROMSTRING": {
                mongoFunctionOperator = MongoFunctionOperator.DATE_FROM_STRING;
                break;
            }
            case "DATETOSTRING": {
                mongoFunctionOperator = MongoFunctionOperator.DATE_TO_STRING;
                break;
            }
            case "DAYOFMONTH": {
                mongoFunctionOperator = MongoFunctionOperator.DAY_OF_MONTH;
                break;
            }
            case "DAYOFWEEK": {
                mongoFunctionOperator = MongoFunctionOperator.DAY_OF_WEEK;
                break;
            }
            case "DAYOFYEAR": {
                mongoFunctionOperator = MongoFunctionOperator.DAY_OF_YEAR;
                break;
            }
            case "DEGREESTORADIANS": {
                mongoFunctionOperator = MongoFunctionOperator.DEGREES_TO_RADIANS;
                break;
            }
            case "DIVIDE": {
                mongoFunctionOperator = MongoFunctionOperator.DIVIDE;
                break;
            }
            case "EQ": {
                mongoFunctionOperator = MongoFunctionOperator.EQ;
                break;
            }
            case "EXP": {
                mongoFunctionOperator = MongoFunctionOperator.EXP;
                break;
            }
            case "FILTER": {
                mongoFunctionOperator = MongoFunctionOperator.FILTER;
                break;
            }
            case "FIRST": {
                mongoFunctionOperator = MongoFunctionOperator.FIRST;
                break;
            }
            case "FLOOR": {
                mongoFunctionOperator = MongoFunctionOperator.FLOOR;
                break;
            }
            case "FUNCTION": {
                mongoFunctionOperator = MongoFunctionOperator.FUNCTION;
                break;
            }
            case "GT": {
                mongoFunctionOperator = MongoFunctionOperator.GT;
                break;
            }
            case "GTE": {
                mongoFunctionOperator = MongoFunctionOperator.GTE;
                break;
            }
            case "HOUR": {
                mongoFunctionOperator = MongoFunctionOperator.HOUR;
                break;
            }
            case "IFNULL": {
                mongoFunctionOperator = MongoFunctionOperator.IF_NULL;
                break;
            }
            case "IN": {
                mongoFunctionOperator = MongoFunctionOperator.IN;
                break;
            }
            case "INDEXOFARRAY": {
                mongoFunctionOperator = MongoFunctionOperator.INDEX_OF_ARRAY;
                break;
            }
            case "INDEXOFBYTES": {
                mongoFunctionOperator = MongoFunctionOperator.INDEX_OF_BYTES;
                break;
            }
            case "INDEXOFCP": {
                mongoFunctionOperator = MongoFunctionOperator.INDEX_OF_CP;
                break;
            }
            case "ISARRAY": {
                mongoFunctionOperator = MongoFunctionOperator.IS_ARRAY;
                break;
            }
            case "ISNUMBER": {
                mongoFunctionOperator = MongoFunctionOperator.IS_NUMBER;
                break;
            }
            case "ISODAYOFWEEK": {
                mongoFunctionOperator = MongoFunctionOperator.ISO_DAY_OF_WEEK;
                break;
            }
            case "ISOWEEK": {
                mongoFunctionOperator = MongoFunctionOperator.ISO_WEEK;
                break;
            }
            case "ISOWEEKYEAR": {
                mongoFunctionOperator = MongoFunctionOperator.ISO_WEEK_YEAR;
                break;
            }
            case "LAST": {
                mongoFunctionOperator = MongoFunctionOperator.LAST;
                break;
            }
            case "LET": {
                mongoFunctionOperator = MongoFunctionOperator.LET;
                break;
            }
            case "LITERAL": {
                mongoFunctionOperator = MongoFunctionOperator.LITERAL;
                break;
            }
            case "LN": {
                mongoFunctionOperator = MongoFunctionOperator.LN;
                break;
            }
            case "LOG": {
                mongoFunctionOperator = MongoFunctionOperator.LOG;
                break;
            }
            case "LOG10": {
                mongoFunctionOperator = MongoFunctionOperator.LOG10;
                break;
            }
            case "LT": {
                mongoFunctionOperator = MongoFunctionOperator.LT;
                break;
            }
            case "LTE": {
                mongoFunctionOperator = MongoFunctionOperator.LTE;
                break;
            }
            case "LTRIM": {
                mongoFunctionOperator = MongoFunctionOperator.LTRIM;
                break;
            }
            case "MAP": {
                mongoFunctionOperator = MongoFunctionOperator.MAP;
                break;
            }
            case "MAX": {
                mongoFunctionOperator = MongoFunctionOperator.MAX;
                break;
            }
            case "MERGEOBJECTS": {
                mongoFunctionOperator = MongoFunctionOperator.MERGE_OBJECTS;
                break;
            }
            case "META": {
                mongoFunctionOperator = MongoFunctionOperator.META;
                break;
            }
            case "MIN": {
                mongoFunctionOperator = MongoFunctionOperator.MIN;
                break;
            }
            case "MILLISECOND": {
                mongoFunctionOperator = MongoFunctionOperator.MILLISECOND;
                break;
            }
            case "MINUTE": {
                mongoFunctionOperator = MongoFunctionOperator.MINUTE;
                break;
            }
            case "MOD": {
                mongoFunctionOperator = MongoFunctionOperator.MOD;
                break;
            }
            case "MONTH": {
                mongoFunctionOperator = MongoFunctionOperator.MONTH;
                break;
            }
            case "MULTIPLY": {
                mongoFunctionOperator = MongoFunctionOperator.MULTIPLY;
                break;
            }
            case "NE": {
                mongoFunctionOperator = MongoFunctionOperator.NE;
                break;
            }
            case "NOT": {
                mongoFunctionOperator = MongoFunctionOperator.NOT;
                break;
            }
            case "OBJECTTOARRAY": {
                mongoFunctionOperator = MongoFunctionOperator.OBJECT_TO_ARRAY;
                break;
            }
            case "OR": {
                mongoFunctionOperator = MongoFunctionOperator.OR;
                break;
            }
            case "POW": {
                mongoFunctionOperator = MongoFunctionOperator.POW;
                break;
            }
            case "PUSH": {
                mongoFunctionOperator = MongoFunctionOperator.PUSH;
                break;
            }
            case "RADIANSTODEGREES": {
                mongoFunctionOperator = MongoFunctionOperator.RADIANS_TO_DEGREES;
                break;
            }
            case "RANGE": {
                mongoFunctionOperator = MongoFunctionOperator.RANGE;
                break;
            }
            case "REDUCE": {
                mongoFunctionOperator = MongoFunctionOperator.REDUCE;
                break;
            }
            case "REGEXFIND": {
                mongoFunctionOperator = MongoFunctionOperator.REGEX_FIND;
                break;
            }
            case "REGEXFINDALL": {
                mongoFunctionOperator = MongoFunctionOperator.REGEX_FIND_ALL;
                break;
            }
            case "REGEXMATCH": {
                mongoFunctionOperator = MongoFunctionOperator.REGEX_MATCH;
                break;
            }
            case "REPLACEONE": {
                mongoFunctionOperator = MongoFunctionOperator.REPLACE_ONE;
                break;
            }
            case "REPLACEALL": {
                mongoFunctionOperator = MongoFunctionOperator.REPLACE_ALL;
                break;
            }
            case "REVERSEARRAY": {
                mongoFunctionOperator = MongoFunctionOperator.REVERSE_ARRAY;
                break;
            }
            case "ROUND": {
                mongoFunctionOperator = MongoFunctionOperator.ROUND;
                break;
            }
            case "RTRIM": {
                mongoFunctionOperator = MongoFunctionOperator.RTRIM;
                break;
            }
            case "SECOND": {
                mongoFunctionOperator = MongoFunctionOperator.SECOND;
                break;
            }
            case "SETDIFFERENCE": {
                mongoFunctionOperator = MongoFunctionOperator.SET_DIFFERENCE;
                break;
            }
            case "SETEQUALS": {
                mongoFunctionOperator = MongoFunctionOperator.SET_EQUALS;
                break;
            }
            case "SETINTERSECTION": {
                mongoFunctionOperator = MongoFunctionOperator.SET_INTERSECTION;
                break;
            }
            case "SETISSUBSET": {
                mongoFunctionOperator = MongoFunctionOperator.SET_IS_SUBSET;
                break;
            }
            case "SETUNION": {
                mongoFunctionOperator = MongoFunctionOperator.SET_UNION;
                break;
            }
            case "SIZE": {
                mongoFunctionOperator = MongoFunctionOperator.SIZE;
                break;
            }
            case "SIN": {
                mongoFunctionOperator = MongoFunctionOperator.SIN;
                break;
            }
            case "SLICE": {
                mongoFunctionOperator = MongoFunctionOperator.SLICE;
                break;
            }
            case "SPLIT": {
                mongoFunctionOperator = MongoFunctionOperator.SPLIT;
                break;
            }
            case "SQRT": {
                mongoFunctionOperator = MongoFunctionOperator.SQRT;
                break;
            }
            case "STDDEVPOP": {
                mongoFunctionOperator = MongoFunctionOperator.STD_DEV_POP;
                break;
            }
            case "STDDEVSAMP": {
                mongoFunctionOperator = MongoFunctionOperator.STD_DEV_SAMP;
                break;
            }
            case "STRCASECMP": {
                mongoFunctionOperator = MongoFunctionOperator.STRCASECMP;
                break;
            }
            case "STRLENBYTES": {
                mongoFunctionOperator = MongoFunctionOperator.STR_LEN_BYTES;
                break;
            }
            case "STRLENCP": {
                mongoFunctionOperator = MongoFunctionOperator.STR_LEN_CP;
                break;
            }
            case "SUBSTR": {
                mongoFunctionOperator = MongoFunctionOperator.SUBSTR;
                break;
            }
            case "SUBSTRBYTES": {
                mongoFunctionOperator = MongoFunctionOperator.SUBSTR_BYTES;
                break;
            }
            case "SUBSTRCP": {
                mongoFunctionOperator = MongoFunctionOperator.SUBSTR_CP;
                break;
            }
            case "SUBTRACT": {
                mongoFunctionOperator = MongoFunctionOperator.SUBTRACT;
                break;
            }
            case "SUM": {
                mongoFunctionOperator = MongoFunctionOperator.SUM;
                break;
            }
            case "SWITCH": {
                mongoFunctionOperator = MongoFunctionOperator.SWITCH;
                break;
            }
            case "TAN": {
                mongoFunctionOperator = MongoFunctionOperator.TAN;
                break;
            }
            case "TOBOOL": {
                mongoFunctionOperator = MongoFunctionOperator.TO_BOOL;
                break;
            }
            case "TODATE": {
                mongoFunctionOperator = MongoFunctionOperator.TO_DATE;
                break;
            }
            case "TODECIMAL": {
                mongoFunctionOperator = MongoFunctionOperator.TO_DECIMAL;
                break;
            }
            case "TODOUBLE": {
                mongoFunctionOperator = MongoFunctionOperator.TO_DOUBLE;
                break;
            }
            case "TOINT": {
                mongoFunctionOperator = MongoFunctionOperator.TO_INT;
                break;
            }
            case "TOLONG": {
                mongoFunctionOperator = MongoFunctionOperator.TO_LONG;
                break;
            }
            case "TOOBJECTID": {
                mongoFunctionOperator = MongoFunctionOperator.TO_OBJECT_ID;
                break;
            }
            case "TOSTRING": {
                mongoFunctionOperator = MongoFunctionOperator.TO_STRING;
                break;
            }
            case "TOLOWER": {
                mongoFunctionOperator = MongoFunctionOperator.TO_LOWER;
                break;
            }
            case "TOUPPER": {
                mongoFunctionOperator = MongoFunctionOperator.TO_UPPER;
                break;
            }
            case "TRIM": {
                mongoFunctionOperator = MongoFunctionOperator.TRIM;
                break;
            }
            case "TRUNC": {
                mongoFunctionOperator = MongoFunctionOperator.TRUNC;
                break;
            }
            case "TYPE": {
                mongoFunctionOperator = MongoFunctionOperator.TYPE;
                break;
            }
            case "WEEK": {
                mongoFunctionOperator = MongoFunctionOperator.WEEK;
                break;
            }
            case "YEAR": {
                mongoFunctionOperator = MongoFunctionOperator.YEAR;
                break;
            }
            case "ZIP": {
                mongoFunctionOperator = MongoFunctionOperator.ZIP;
                break;
            }
            default: {
                mongoFunctionOperator = MongoFunctionOperator.UNKNOWN;
            }
        }
        return mongoFunctionOperator;
    }

    private final MongoConstructorOperator convertConstructorOpName(String name2) {
        MongoConstructorOperator mongoConstructorOperator;
        String string = name2;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
        switch (string3) {
            case "BINDATA": {
                mongoConstructorOperator = MongoConstructorOperator.BIN_DATA;
                break;
            }
            case "HEXDATA": {
                mongoConstructorOperator = MongoConstructorOperator.HEX_DATA;
                break;
            }
            case "UUID": {
                mongoConstructorOperator = MongoConstructorOperator.UUID;
                break;
            }
            case "MD5": {
                mongoConstructorOperator = MongoConstructorOperator.MD5;
                break;
            }
            case "OBJECTID": {
                mongoConstructorOperator = MongoConstructorOperator.OBJECT_ID;
                break;
            }
            case "DATE": {
                mongoConstructorOperator = MongoConstructorOperator.DATE;
                break;
            }
            case "ISODATE": {
                mongoConstructorOperator = MongoConstructorOperator.ISO_DATE;
                break;
            }
            case "CODE": {
                mongoConstructorOperator = MongoConstructorOperator.CODE;
                break;
            }
            case "DBREF": {
                mongoConstructorOperator = MongoConstructorOperator.DBREF;
                break;
            }
            case "REGEXP": {
                mongoConstructorOperator = MongoConstructorOperator.REG_EXP;
                break;
            }
            case "NUMBERINT": {
                mongoConstructorOperator = MongoConstructorOperator.NUMBER_INT;
                break;
            }
            case "NUMBERLONG": {
                mongoConstructorOperator = MongoConstructorOperator.NUMBER_LONG;
                break;
            }
            case "NUMBERDECIMAL": {
                mongoConstructorOperator = MongoConstructorOperator.NUMBER_DECIMAL;
                break;
            }
            case "TIMESTAMP": {
                mongoConstructorOperator = MongoConstructorOperator.TIMESTAMP;
                break;
            }
            case "MINKEY": {
                mongoConstructorOperator = MongoConstructorOperator.MIN_KEY;
                break;
            }
            case "MAXKEY": {
                mongoConstructorOperator = MongoConstructorOperator.MAX_KEY;
                break;
            }
            default: {
                mongoConstructorOperator = MongoConstructorOperator.UNKNOWN;
            }
        }
        return mongoConstructorOperator;
    }

    @NotNull
    public final SqlFunctionCallExpression getO() {
        return this.o;
    }

    @NotNull
    public final SqlElement getRoot() {
        return this.root;
    }

    public MongoFunctionBuilder(@NotNull SqlFunctionCallExpression o2, @NotNull SqlElement root2) {
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        this.o = o2;
        this.root = root2;
    }
}

