/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ComparePredicateOperation;
import com.intellij.database.data.types.CustomPlaceholder;
import com.intellij.database.data.types.EqualsPredicateOperation;
import com.intellij.database.data.types.FormatTestResult;
import com.intellij.database.data.types.FormatTester;
import com.intellij.database.data.types.GreaterPredicateOperation;
import com.intellij.database.data.types.JdbcPlaceholder;
import com.intellij.database.data.types.LessPredicateOperation;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.NotEqualsPredicateOperation;
import com.intellij.database.data.types.NullPredicateValue;
import com.intellij.database.data.types.ObjectPredicateValue;
import com.intellij.database.data.types.Placeholder;
import com.intellij.database.data.types.PredicateOperation;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.LikeOpType;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.dialects.mongo.MongoPredicatesHelper;
import com.intellij.database.dialects.mongo.MongoScriptUtilKt;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.remote.jdbc.helpers.MongoJdbcHelper;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J<\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J$\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J&\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001e\u001a\u00020\u00112\b\u0010!\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014JP\u0010\"\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010!\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0014\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010%\u001a\u00020\u0017H\u0014J\"\u0010&\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J2\u0010(\u001a\u00020 2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001b0*2\u0006\u0010+\u001a\u00020\u00172\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020.0-H\u0002J-\u0010/\u001a\u000200*\u0002012\u0006\u0010\u0014\u001a\u0002022\u0017\u00103\u001a\u0013\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u0002000-\u00a2\u0006\u0002\b4H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/database/dialects/mongo/MongoPredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "idPattern", "Lkotlin/text/Regex;", "mode", "Lcom/intellij/database/extractors/ObjectFormatter$Mode;", "getMode", "()Lcom/intellij/database/extractors/ObjectFormatter$Mode;", "objectFormatter", "Lcom/intellij/database/extractors/ObjectFormatter;", "uuidPattern", "equalsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/data/types/ColumnRef;", "value", "Lcom/intellij/database/data/types/PredicateValue;", "op", "Lcom/intellij/database/data/types/ComparePredicateOperation;", "quote", "", "version", "Lcom/intellij/database/util/Version;", "alias", "", "getDomain", "Lcom/intellij/database/data/types/domain/Domain;", "columnRef", "getFormatTester", "Lcom/intellij/database/data/types/FormatTester;", "domain", "likePredicate", "Lcom/intellij/database/data/types/LikePredicateOperation;", "canCastToText", "inUpdate", "literal", "Lcom/intellij/database/data/types/StringPredicateValue;", "typeWithConstructor", "classNames", "", "isQuotedValue", "testUnwrapped", "Lkotlin/Function1;", "Lcom/intellij/database/data/types/FormatTestResult;", "operation", "", "Lcom/intellij/database/util/DdlBuilder;", "Lcom/intellij/database/data/types/PredicateOperation;", "rightOperand", "Lkotlin/ExtensionFunctionType;", "intellij.database.dialects.mongo"})
public final class MongoPredicatesHelper
extends BasePredicatesHelper {
    private final ObjectFormatter objectFormatter;
    private final Regex idPattern;
    private final Regex uuidPattern;
    @NotNull
    private final ObjectFormatter.Mode mode;

    @Override
    @NotNull
    public ObjectFormatter.Mode getMode() {
        return this.mode;
    }

    @Override
    @NotNull
    protected PredicatesHelper.PredicateProducer equalsPredicate(@NotNull ColumnRef column2, @NotNull PredicateValue value, @NotNull ComparePredicateOperation op, boolean quote, @Nullable Version version, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)column2), value, (Function1)new Function1<DdlBuilder, Unit>(this, column2, op, value, quote, version){
            final /* synthetic */ MongoPredicatesHelper this$0;
            final /* synthetic */ ColumnRef $column;
            final /* synthetic */ ComparePredicateOperation $op;
            final /* synthetic */ PredicateValue $value;
            final /* synthetic */ boolean $quote;
            final /* synthetic */ Version $version;

            public final void invoke(@NotNull DdlBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                PredicatesUtilKt.identifier((DdlBuilder)builder, null, (ColumnRef)this.$column).symbol(":").space();
                MongoPredicatesHelper.access$operation(this.this$0, builder, (PredicateOperation)this.$op, (Function1)new Function1<DdlBuilder, Unit>(this, builder){
                    final /* synthetic */ equalsPredicate.1 this$0;
                    final /* synthetic */ DdlBuilder $builder;

                    public final void invoke(@NotNull DdlBuilder $this$operation) {
                        block5: {
                            PredicateValue predicateValue;
                            block8: {
                                block7: {
                                    block6: {
                                        block4: {
                                            Intrinsics.checkNotNullParameter((Object)$this$operation, (String)"$receiver");
                                            predicateValue = this.this$0.$value;
                                            if (!Intrinsics.areEqual((Object)predicateValue, (Object)NullPredicateValue.INSTANCE)) break block4;
                                            $this$operation.literal("null");
                                            break block5;
                                        }
                                        if (!Intrinsics.areEqual((Object)predicateValue, (Object)JdbcPlaceholder.INSTANCE)) break block6;
                                        $this$operation.plain("$placeholder$");
                                        break block5;
                                    }
                                    if (!(predicateValue instanceof CustomPlaceholder)) break block7;
                                    $this$operation.plain(((CustomPlaceholder)this.this$0.$value).getPlaceholder());
                                    break block5;
                                }
                                if (!(predicateValue instanceof StringPredicateValue)) break block8;
                                $this$operation.literal(this.this$0.$quote ? MongoPredicatesHelper.access$literal(this.this$0.this$0, (StringPredicateValue)this.this$0.$value, this.this$0.$column, this.this$0.$version) : ((StringPredicateValue)this.this$0.$value).getStr());
                                break block5;
                            }
                            if (!(predicateValue instanceof ObjectPredicateValue)) break block5;
                            String literal = MongoPredicatesHelper.access$getObjectFormatter$p(this.this$0.this$0).getValueLiteral(((ObjectPredicateValue)this.this$0.$value).getO(), PredicatesUtilKt.toConsumerColumn((ColumnRef)this.this$0.$column), this.this$0.this$0.getDbms(), ObjectFormatter.Mode.JS_SCRIPT);
                            if (literal == null) {
                                this.$builder.plain("null");
                            } else if (this.this$0.$quote) {
                                this.$builder.plain(DbImplUtil.StringLiteralDecorator.PLAIN.decorate(literal, this.this$0.this$0.getDbms()));
                            } else {
                                this.$builder.plain(literal);
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$builder = ddlBuilder;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = mongoPredicatesHelper;
                this.$column = columnRef;
                this.$op = comparePredicateOperation;
                this.$value = predicateValue;
                this.$quote = bl;
                this.$version = version;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void operation(DdlBuilder $this$operation, PredicateOperation op, Function1<? super DdlBuilder, Unit> rightOperand) {
        void rightOperand2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = rightOperand;
        if (op instanceof EqualsPredicateOperation) {
            ((Function1)rightOperand2.element).invoke((Object)$this$operation);
        } else {
            String string;
            PredicateOperation predicateOperation = op;
            if (predicateOperation instanceof NotEqualsPredicateOperation) {
                string = "$ne";
            } else if (predicateOperation instanceof LessPredicateOperation) {
                string = "$lt";
            } else if (predicateOperation instanceof GreaterPredicateOperation) {
                string = "$gt";
            } else if (predicateOperation instanceof LikePredicateOperation) {
                if (((LikePredicateOperation)op).isNotLike()) {
                    Function1 operand = (Function1)rightOperand2.element;
                    rightOperand2.element = (Function1)new Function1<DdlBuilder, Unit>(this, op, operand){
                        final /* synthetic */ MongoPredicatesHelper this$0;
                        final /* synthetic */ PredicateOperation $op;
                        final /* synthetic */ Function1 $operand;

                        public final void invoke(@NotNull DdlBuilder $receiver) {
                            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                            MongoPredicatesHelper.access$operation(this.this$0, $receiver, (PredicateOperation)new LikePredicateOperation(((LikePredicateOperation)this.$op).getLikeType(), ((LikePredicateOperation)this.$op).getMatchCase(), false), this.$operand);
                        }
                        {
                            this.this$0 = mongoPredicatesHelper;
                            this.$op = predicateOperation;
                            this.$operand = function1;
                            super(1);
                        }
                    };
                    string = "$ne";
                } else {
                    string = "$regex";
                }
            } else {
                string = "unknown_operation_" + op;
            }
            String operator2 = string;
            MongoScriptUtilKt.inCurly$default($this$operation, false, false, (Function0)new Function0<Unit>($this$operation, (Ref.ObjectRef)rightOperand2, operator2){
                final /* synthetic */ DdlBuilder $this_operation;
                final /* synthetic */ Ref.ObjectRef $rightOperand;
                final /* synthetic */ String $operator;

                public final void invoke() {
                    Function1 function1 = (Function1)this.$rightOperand.element;
                    DdlBuilder ddlBuilder = this.$this_operation.plain(this.$operator).symbol(":").space();
                    Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"this.plain(operator).symbol(\":\").space()");
                    function1.invoke((Object)ddlBuilder);
                }
                {
                    this.$this_operation = ddlBuilder;
                    this.$rightOperand = objectRef;
                    this.$operator = string;
                    super(0);
                }
            }, 3, null);
        }
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer likePredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable Domain domain, @NotNull LikePredicateOperation op, boolean canCastToText, @Nullable String alias, @Nullable Version version, boolean inUpdate) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        if (!(value instanceof StringPredicateValue) && !(value instanceof Placeholder) || op.getLikeType() == LikeOpType.MATCHES || value instanceof ObjectPredicateValue) {
            return null;
        }
        Domain domain2 = domain;
        if (domain2 == null || !domain2.supports(OperationKt.LIKE_OPERATION)) {
            return null;
        }
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)columnRef), value, (Function1)new Function1<DdlBuilder, Unit>(this, columnRef, op, value){
            final /* synthetic */ MongoPredicatesHelper this$0;
            final /* synthetic */ ColumnRef $columnRef;
            final /* synthetic */ LikePredicateOperation $op;
            final /* synthetic */ PredicateValue $value;

            public final void invoke(@NotNull DdlBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                PredicatesUtilKt.identifier((DdlBuilder)builder, null, (ColumnRef)this.$columnRef).symbol(":").space();
                MongoPredicatesHelper.access$operation(this.this$0, builder, (PredicateOperation)this.$op, (Function1)new Function1<DdlBuilder, Unit>(this){
                    final /* synthetic */ likePredicate.1 this$0;

                    public final void invoke(@NotNull DdlBuilder $this$operation) {
                        block1: {
                            PredicateValue predicateValue;
                            block3: {
                                block2: {
                                    block0: {
                                        Intrinsics.checkNotNullParameter((Object)$this$operation, (String)"$receiver");
                                        predicateValue = this.this$0.$value;
                                        if (!Intrinsics.areEqual((Object)predicateValue, (Object)NullPredicateValue.INSTANCE)) break block0;
                                        $this$operation.literal("null");
                                        break block1;
                                    }
                                    if (!Intrinsics.areEqual((Object)predicateValue, (Object)JdbcPlaceholder.INSTANCE)) break block2;
                                    $this$operation.plain("$placeholder$");
                                    break block1;
                                }
                                if (!(predicateValue instanceof CustomPlaceholder)) break block3;
                                $this$operation.plain(((CustomPlaceholder)this.this$0.$value).getPlaceholder());
                                break block1;
                            }
                            if (!(predicateValue instanceof StringPredicateValue)) break block1;
                            $this$operation.literal(this.this$0.$op.getLikeType().getDecorator().decorate(((StringPredicateValue)this.this$0.$value).getStr(), this.this$0.this$0.getDbms()));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = mongoPredicatesHelper;
                this.$columnRef = columnRef;
                this.$op = likePredicateOperation;
                this.$value = predicateValue;
                super(1);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String literal(StringPredicateValue value, ColumnRef columnRef, Version version) {
        String string;
        Domain domain;
        String str = value.getStr();
        Domain domain2 = domain = this.getDomain(columnRef, (PredicateValue)value, version);
        String string2 = domain2 != null ? domain2.simpleName() : null;
        if (string2 != null) {
            switch (string2) {
                case "ObjectId": {
                    string = "new ObjectId(\"" + StringUtil.escapeStringCharacters((String)str) + "\")";
                    return string;
                }
                case "ISODate": {
                    string = "new ISODate(\"" + StringUtil.escapeStringCharacters((String)str) + "\")";
                    return string;
                }
                case "Decimal128": 
                case "decimal128": {
                    string = "new NumberDecimal(\"" + StringUtil.escapeStringCharacters((String)str) + "\")";
                    return string;
                }
                case "UUID": {
                    string = "new UUID(\"" + str + "\")";
                    return string;
                }
                case "BinData": {
                    string = "new BinData(\"" + str + "\")";
                    return string;
                }
            }
        }
        string = "\"" + StringUtil.escapeStringCharacters((String)str) + "\"";
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    protected FormatTester getFormatTester(@NotNull ColumnRef columnRef, @Nullable Domain domain, @Nullable Version version) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Domain domain2 = domain;
        if (domain2 == null) return null;
        String string = domain2.simpleName();
        if (string == null) return null;
        switch (string) {
            case "Regexp": {
                FormatTester formatTester2 = new FormatTester(false, false, (Function1)getFormatTester.1.INSTANCE, 2, null);
                return formatTester2;
            }
            case "Decimal128": {
                FormatTester formatTester2 = this.typeWithConstructor(CollectionsKt.listOf((Object)"NumberDecimal"), true, (Function1<? super String, ? extends FormatTestResult>)((Function1)getFormatTester.2.INSTANCE));
                return formatTester2;
            }
            case "Int64": 
            case "Int32": {
                FormatTester formatTester2 = this.typeWithConstructor(CollectionsKt.listOf((Object[])new String[]{"NumberLong", "NumberInt"}), false, (Function1<? super String, ? extends FormatTestResult>)((Function1)getFormatTester.3.INSTANCE));
                return formatTester2;
            }
            case "ObjectId": {
                FormatTester formatTester2 = this.typeWithConstructor(CollectionsKt.listOf((Object)"ObjectId"), true, (Function1<? super String, ? extends FormatTestResult>)((Function1)new Function1<String, FormatTestResult>(this){
                    final /* synthetic */ MongoPredicatesHelper this$0;

                    @NotNull
                    public final FormatTestResult invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return MongoPredicatesHelper.access$getIdPattern$p(this.this$0).matches((CharSequence)it) ? FormatTestResult.QUOTE : FormatTestResult.NOT_MATCHED;
                    }
                    {
                        this.this$0 = mongoPredicatesHelper;
                        super(1);
                    }
                }));
                return formatTester2;
            }
            case "UUID": {
                FormatTester formatTester2 = this.typeWithConstructor(CollectionsKt.listOf((Object)"UUID"), true, (Function1<? super String, ? extends FormatTestResult>)((Function1)new Function1<String, FormatTestResult>(this){
                    final /* synthetic */ MongoPredicatesHelper this$0;

                    @NotNull
                    public final FormatTestResult invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return MongoPredicatesHelper.access$getUuidPattern$p(this.this$0).matches((CharSequence)it) ? FormatTestResult.QUOTE : FormatTestResult.NOT_MATCHED;
                    }
                    {
                        this.this$0 = mongoPredicatesHelper;
                        super(1);
                    }
                }));
                return formatTester2;
            }
            case "BinData": {
                FormatTester formatTester2 = this.typeWithConstructor(CollectionsKt.listOf((Object)"BinData"), true, (Function1<? super String, ? extends FormatTestResult>)((Function1)getFormatTester.6.INSTANCE));
                return formatTester2;
            }
            case "Boolean": {
                FormatTester formatTester2 = new FormatTester(false, false, (Function1)getFormatTester.7.INSTANCE, 2, null);
                return formatTester2;
            }
            case "Array": 
            case "Object": {
                FormatTester formatTester2 = new FormatTester(false, false, (Function1)getFormatTester.8.INSTANCE, 2, null);
                return formatTester2;
            }
            case "Timestamp": {
                FormatTester formatTester2 = new FormatTester(false, false, (Function1)getFormatTester.9.INSTANCE, 2, null);
                return formatTester2;
            }
            case "ISODate": {
                List list = CollectionsKt.listOf((Object)"ISODate");
                FormatTester formatTester = PredicatesUtilKt.getFormatTester((ColumnRef)columnRef, (Dbms)this.getDbms(), (LogicalType)LogicalType.TIMESTAMP);
                Intrinsics.checkNotNull((Object)formatTester);
                FormatTester formatTester2 = this.typeWithConstructor(list, true, (Function1<? super String, ? extends FormatTestResult>)formatTester.getTest());
                return formatTester2;
            }
            default: {
                return null;
            }
        }
    }

    private final FormatTester typeWithConstructor(List<String> classNames, boolean isQuotedValue, Function1<? super String, ? extends FormatTestResult> testUnwrapped) {
        return new FormatTester(isQuotedValue, false, (Function1)new Function1<String, FormatTestResult>(classNames, testUnwrapped){
            final /* synthetic */ List $classNames;
            final /* synthetic */ Function1 $testUnwrapped;

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final FormatTestResult invoke(@NotNull String it) {
                FormatTestResult formatTestResult;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (StringsKt.endsWith$default((String)it, (String)")", (boolean)false, (int)2, null)) {
                    boolean bl;
                    block5: {
                        Iterable $this$any$iv = this.$classNames;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                String name2 = (String)element$iv;
                                boolean bl2 = false;
                                if (!(StringsKt.startsWith$default((String)it, (String)(name2 + '('), (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)("new " + name2 + '('), (boolean)false, (int)2, null))) continue;
                                bl = true;
                                break block5;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        formatTestResult = FormatTestResult.NOT_QUOTE;
                        return formatTestResult;
                    }
                }
                formatTestResult = (FormatTestResult)this.$testUnwrapped.invoke((Object)it);
                return formatTestResult;
            }
            {
                this.$classNames = list;
                this.$testUnwrapped = function1;
                super(1);
            }
        }, 2, null);
    }

    @Override
    @Nullable
    protected Domain getDomain(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable Version version) {
        Domain domain;
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof ObjectPredicateValue) {
            String string = MongoJdbcHelper.getTypeName((Object)((ObjectPredicateValue)value).getO());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTypeName(value.o)");
            String typeName = string;
            Object object = BaseDomainRegistry.get((Dbms)this.getDbms(), (Version)version);
            if (object != null && (object = object.getDomains()) != null) {
                Object v2;
                block5: {
                    Iterable iterable = (Iterable)object;
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (Object t : iterable2) {
                        Domain it = (Domain)t;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.simpleName(), (Object)typeName)) continue;
                        v2 = t;
                        break block5;
                    }
                    v2 = null;
                }
                domain = v2;
            } else {
                domain = null;
            }
        } else {
            domain = super.getDomain(columnRef, value, version);
        }
        return domain;
    }

    public MongoPredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
        this.objectFormatter = new ObjectFormatter();
        this.idPattern = new Regex("[0-9a-f]{24}", RegexOption.IGNORE_CASE);
        this.uuidPattern = new Regex("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}", RegexOption.IGNORE_CASE);
        this.mode = ObjectFormatter.Mode.JS_SCRIPT;
    }

    public static final /* synthetic */ void access$operation(MongoPredicatesHelper $this, DdlBuilder $this$access_u24operation, PredicateOperation op, Function1 rightOperand) {
        $this.operation($this$access_u24operation, op, (Function1<? super DdlBuilder, Unit>)rightOperand);
    }

    public static final /* synthetic */ String access$literal(MongoPredicatesHelper $this, StringPredicateValue value, ColumnRef columnRef, Version version) {
        return $this.literal(value, columnRef, version);
    }

    public static final /* synthetic */ ObjectFormatter access$getObjectFormatter$p(MongoPredicatesHelper $this) {
        return $this.objectFormatter;
    }

    public static final /* synthetic */ Regex access$getIdPattern$p(MongoPredicatesHelper $this) {
        return $this.idPattern;
    }

    public static final /* synthetic */ Regex access$getUuidPattern$p(MongoPredicatesHelper $this) {
        return $this.uuidPattern;
    }
}

