/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.UnknownDomain;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class MongoDomains
extends BaseDomainRegistry {
    public MongoDomains() {
        this.add(new SimpleDomain("Object", ConversionPoint.JSON, PhysicalDomainType.UNKNOWN){

            public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
                if (descriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                return super.isSuitable(descriptor) || StringUtil.equalsIgnoreCase((CharSequence)"Map", (CharSequence)descriptor.getTypeName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/mongo/MongoDomains$1", "isSuitable"));
            }
        }.withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new TextDomain("String", ConversionPoint.TEXT, Integer.MAX_VALUE));
        this.add((Domain)new IntegerDomain("Int32", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9){

            public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
                if (descriptor == null) {
                    2.$$$reportNull$$$0(0);
                }
                return super.isSuitable(descriptor) || StringUtil.equalsIgnoreCase((CharSequence)"Integer", (CharSequence)descriptor.getTypeName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/mongo/MongoDomains$2", "isSuitable"));
            }
        });
        this.add((Domain)new IntegerDomain("Int64", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18){

            public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
                if (descriptor == null) {
                    3.$$$reportNull$$$0(0);
                }
                return super.isSuitable(descriptor) || StringUtil.equalsIgnoreCase((CharSequence)"Long", (CharSequence)descriptor.getTypeName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/mongo/MongoDomains$3", "isSuitable"));
            }
        });
        this.add((Domain)new Number2Domain("Decimal128", ConversionPoint.BIG_DECIMAL, Integer.MAX_VALUE, Integer.MAX_VALUE, false));
        this.add((Domain)new BooleanDomain("Boolean", ConversionPoint.BOOLEAN));
        this.add((Domain)new FloatDomain("Double", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add((Domain)new SimpleDomain("Array", ConversionPoint.JSON, PhysicalDomainType.UNKNOWN){

            public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
                if (descriptor == null) {
                    4.$$$reportNull$$$0(0);
                }
                return super.isSuitable(descriptor) || StringUtil.equalsIgnoreCase((CharSequence)"List", (CharSequence)descriptor.getTypeName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/mongo/MongoDomains$4", "isSuitable"));
            }
        });
        this.add((Domain)new SimpleDomain("ObjectId", ConversionPoint.UUID, PhysicalDomainType.UNKNOWN));
        this.add((Domain)new SimpleDomain("UUID", ConversionPoint.UUID, PhysicalDomainType.UNKNOWN));
        this.add((Domain)new SimpleDomain("ISODate", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP){

            public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
                if (descriptor == null) {
                    5.$$$reportNull$$$0(0);
                }
                return super.isSuitable(descriptor) || StringUtil.equalsIgnoreCase((CharSequence)"Date", (CharSequence)descriptor.getTypeName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/mongo/MongoDomains$5", "isSuitable"));
            }
        });
        this.add((Domain)new UnknownDomain("Timestamp"));
        this.add((Domain)new BinaryDomain("BinData", ConversionPoint.BLOB, Integer.MAX_VALUE));
        this.add((Domain)new UnknownDomain("MaxKey"));
        this.add((Domain)new UnknownDomain("MinKey"));
        this.add((Domain)new UnknownDomain("Regexp"){

            public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
                if (descriptor == null) {
                    6.$$$reportNull$$$0(0);
                }
                return super.isSuitable(descriptor) || StringUtil.equalsIgnoreCase((CharSequence)"BsonRegularExpression", (CharSequence)descriptor.getTypeName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/mongo/MongoDomains$6", "isSuitable"));
            }
        });
    }
}

