/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hivebase.model;

import com.intellij.database.dialects.hivebase.model.HiveBaseDescriptionService;
import com.intellij.database.dialects.hivebase.model.HiveBaseLikeTable;
import com.intellij.database.dialects.hivebase.model.HiveBaseTable;
import com.intellij.database.dialects.hivebase.model.HiveBaseTableColumn;
import com.intellij.database.dialects.hivebase.model.HiveBaseView;
import com.intellij.database.dialects.hivebase.model.properties.HiveTableColumnSortingOrder;
import com.intellij.database.dialects.hivebase.model.properties.HiveTableColumnType;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.meta.BasicMetaProperty;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0004J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0004J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\u0012\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dialects/hivebase/model/HiveBaseDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "appendProperties", "", "e", "Lcom/intellij/database/dialects/hivebase/model/HiveBaseLikeTable;", "desc", "content", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeTable", "Lcom/intellij/database/dialects/hivebase/model/HiveBaseTable;", "describeTableColumn", "Lcom/intellij/database/dialects/hivebase/model/HiveBaseTableColumn;", "describeView", "Lcom/intellij/database/dialects/hivebase/model/HiveBaseView;", "joinProperties", "properties", "", "Lcom/intellij/database/model/NameValue;", "intellij.database.dialects.hivebase"})
public class HiveBaseDescriptionService
extends DescriptionService {
    @NotNull
    public String content(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e2;
        return basicElement instanceof HiveBaseTable ? this.describeTable((HiveBaseTable)e2, context) : (basicElement instanceof HiveBaseTableColumn ? this.describeTableColumn((HiveBaseTableColumn)e2, context) : (basicElement instanceof HiveBaseView ? this.describeView((HiveBaseView)e2, context) : super.content(e2, context)));
    }

    private final String describeView(HiveBaseView e2, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaProperty basicMetaProperty = HiveBaseView.PROPERTIES;
        boolean bl = false;
        collection.add(basicMetaProperty);
        String desc = super.describeView((BasicView)e2, context);
        return this.appendProperties(e2, desc);
    }

    @NotNull
    protected final String appendProperties(@NotNull HiveBaseLikeTable e2, @NotNull String desc) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        List list = e2.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.properties");
        List nonIgnoredProperties = list;
        Collection collection = nonIgnoredProperties;
        boolean bl = false;
        if (!collection.isEmpty()) {
            return desc + " properties: " + this.joinProperties(nonIgnoredProperties);
        }
        return desc;
    }

    private final String joinProperties(List<? extends NameValue> properties2) {
        return CollectionsKt.joinToString$default((Iterable)properties2, null, null, null, (int)0, null, (Function1)joinProperties.1.INSTANCE, (int)31, null);
    }

    private final String describeTableColumn(HiveBaseTableColumn e2, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        Object object = HiveBaseTableColumn.TYPE;
        boolean bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = HiveBaseTableColumn.SORTING;
        bl = false;
        collection.add(object);
        String desc = super.describeColumn((BasicLikeColumn)e2, context);
        if (e2.getType() != HiveTableColumnType.REGULAR) {
            desc = desc + ' ' + (Object)((Object)e2.getType());
        }
        if (e2.getSorting() != HiveTableColumnSortingOrder.NONE) {
            desc = desc + ' ' + (Object)((Object)e2.getSorting());
        }
        return desc;
    }

    @NotNull
    protected final String describeTable(@NotNull HiveBaseTable e2, @NotNull DescriptionService.Context context) {
        String desc;
        block6: {
            Object it;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Collection collection = context.getDescribed();
            Object object = HiveBaseTable.BUCKETS_NUM;
            boolean bl2 = false;
            collection.add(object);
            collection = context.getDescribed();
            object = HiveBaseTable.ROW_FORMAT_SERDE;
            bl2 = false;
            collection.add(object);
            collection = context.getDescribed();
            object = HiveBaseTable.SERDE_PROPERTIES;
            bl2 = false;
            collection.add(object);
            collection = context.getDescribed();
            object = HiveBaseTable.INPUT_FORMAT;
            bl2 = false;
            collection.add(object);
            collection = context.getDescribed();
            object = HiveBaseTable.OUTPUT_FORMAT;
            bl2 = false;
            collection.add(object);
            collection = context.getDescribed();
            object = HiveBaseTable.INPUT_DRIVER;
            bl2 = false;
            collection.add(object);
            collection = context.getDescribed();
            object = HiveBaseTable.OUTPUT_DRIVER;
            bl2 = false;
            collection.add(object);
            collection = context.getDescribed();
            object = HiveBaseTable.PROPERTIES;
            bl2 = false;
            collection.add(object);
            desc = super.describeTable((BasicTable)e2, context);
            if (e2.getBucketsNum() != 0) {
                desc = desc + " buckets: " + e2.getBucketsNum();
            }
            String string = e2.getRowFormatSerde();
            if (string != null) {
                object = string;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl3 = false;
                desc = desc + " serde: " + (String)it;
            }
            List<NameValue> list = e2.getSerdeProperties();
            Intrinsics.checkNotNullExpressionValue(list, (String)"e.serdeProperties");
            object = list;
            bl2 = false;
            if (!object.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder().append(desc).append(" serdeproperties: ");
                List<NameValue> list2 = e2.getSerdeProperties();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"e.serdeProperties");
                desc = stringBuilder.append(this.joinProperties(list2)).toString();
            }
            String string2 = e2.getInputFormat();
            if (string2 != null) {
                object = string2;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl4 = false;
                desc = desc + " inputformat: " + (String)it;
            }
            String string3 = e2.getOutputFormat();
            if (string3 != null) {
                object = string3;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl5 = false;
                desc = desc + " outputformat: " + (String)it;
            }
            String string4 = e2.getInputDriver();
            if (string4 != null) {
                object = string4;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl6 = false;
                desc = desc + " inputdriver: " + (String)it;
            }
            String string5 = e2.getOutputDriver();
            if (string5 == null) break block6;
            object = string5;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl7 = false;
            desc = desc + " outputdriver: " + (String)it;
        }
        return this.appendProperties(e2, desc);
    }
}

