/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hive;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.hive.introspector.HiveIntrospector;
import com.intellij.database.dialects.hive.model.HiveFunction;
import com.intellij.database.dialects.hive.model.HiveFunctionBase;
import com.intellij.database.dialects.hive.model.HiveIndex;
import com.intellij.database.dialects.hive.model.HiveLikeColumn;
import com.intellij.database.dialects.hive.model.HiveMatView;
import com.intellij.database.dialects.hive.model.HiveSchema;
import com.intellij.database.dialects.hive.model.HiveTable;
import com.intellij.database.dialects.hive.model.HiveTableColumn;
import com.intellij.database.dialects.hivebase.model.properties.HiveTableColumnSortingOrder;
import com.intellij.database.dialects.hivebase.model.properties.HiveTableColumnType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.hive.HiveTypes;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import com.intellij.sql.psi.stubs.SqlDefinitionStub;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0007\u001a\u00020\u0019H\u0002J\u001b\u0010\u001a\u001a\r\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\u0002\b\u001d2\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J$\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00192\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00040!H\u0002J$\u0010#\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00192\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00040!H\u0002J$\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016\u00a8\u0006-"}, d2={"Lcom/intellij/database/dialects/hive/HiveObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "buildFunction", "Lcom/intellij/database/dialects/hive/model/HiveFunctionBase;", "buildIndex", "Lcom/intellij/database/dialects/hive/model/HiveIndex;", "buildLikeColumn", "Lcom/intellij/database/dialects/hive/model/HiveLikeColumn;", "buildMatView", "Lcom/intellij/database/dialects/hive/model/HiveMatView;", "buildSchema", "Lcom/intellij/database/dialects/hive/model/HiveSchema;", "buildTable", "Lcom/intellij/database/dialects/hive/model/HiveTable;", "findAndUnescapeString", "", "Lcom/intellij/psi/PsiElement;", "findProperties", "", "Lcom/intellij/database/model/NameValue;", "Lorg/jetbrains/annotations/NotNull;", "el", "forEachColumnDef", "action", "Lkotlin/Function1;", "Lcom/intellij/sql/psi/SqlColumnDefinition;", "forEachColumnRef", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "getCompactDefinition", "Lcom/intellij/openapi/util/TextRange;", "path", "Lcom/intellij/database/util/ObjectPath;", "text", "Lcom/intellij/database/script/CompositeText;", "def", "Lcom/intellij/database/model/PsiObject;", "intellij.database.dialects.hive"})
public final class HiveObjectBuilder
extends SqlObjectBuilderImpl {
    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof HiveSchema) {
            this.buildSchema((HiveSchema)obj2, source, context);
        } else if (basicModElement instanceof HiveTable) {
            this.buildTable((HiveTable)obj2, source, context);
        } else if (basicModElement instanceof HiveLikeColumn) {
            this.buildLikeColumn((HiveLikeColumn)obj2, source, context);
        } else if (basicModElement instanceof HiveMatView) {
            this.buildMatView((HiveMatView)obj2, source, context);
        } else if (basicModElement instanceof HiveFunctionBase) {
            this.buildFunction((HiveFunctionBase)obj2, source, context);
        } else if (basicModElement instanceof HiveIndex) {
            this.buildIndex((HiveIndex)obj2, source, context);
        } else {
            super.build(obj2, source, context);
        }
    }

    @Override
    @Nullable
    public TextRange getCompactDefinition(@NotNull ObjectPath path, @NotNull CompositeText text, @Nullable PsiObject def) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ObjectKind objectKind = path.kind;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE) ? TextRange.EMPTY_RANGE : super.getCompactDefinition(path, text, def);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildIndex(HiveIndex obj2, DasObject source, SqlObjectBuilder.Context context) {
        HiveIndex stubbed;
        BasicElement basicElement;
        void $this$stubbed$iv;
        super.buildIndex(obj2, source, context);
        if (context.isStubBuilder()) {
            return;
        }
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbed2 = false;
        void var8_8 = $this$stubbed$iv;
        if (var8_8 instanceof HiveIndex) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (var8_8 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof HiveIndex)) {
                object = null;
            }
            basicElement = (BasicElement)((HiveIndex)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (HiveIndex)basicElement) != null) {
            obj2.setType(stubbed.getType());
            obj2.setIndexTableName(stubbed.getIndexTableName());
        } else {
            void this_$iv2;
            String type = null;
            String indexTableName = null;
            SqlObjectBuilderImpl $i$f$stubbed2 = this;
            DasObject dasObject2 = source;
            if (!(dasObject2 instanceof SqlCreateIndexStatement)) {
                dasObject2 = null;
            }
            PsiElement el$iv = (PsiElement)((SqlCreateIndexStatement)dasObject2);
            boolean $i$f$forEachChild = false;
            void var10_11 = this_$iv2;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement first2;
                PsiElement el = tmp$iv$iv;
                boolean bl = false;
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)el);
                if (!Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_CLAUSE)) continue;
                if (el.getFirstChild() == null) {
                    continue;
                }
                IElementType iElementType2 = PsiTreeUtilKt.getElementType((PsiElement)first2);
                if (Intrinsics.areEqual((Object)iElementType2, (Object)HiveTypes.HIVE_AS)) {
                    type = this.findString(first2);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType2, (Object)HiveTypes.HIVE_IN)) continue;
                indexTableName = this.findString(first2);
            }
            obj2.setType(type);
            obj2.setIndexTableName(indexTableName);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildFunction(HiveFunctionBase obj2, DasObject source, SqlObjectBuilder.Context context) {
        block13: {
            void this_$iv;
            block12: {
                HiveFunctionBase stubbed;
                BasicElement basicElement;
                void $this$stubbed$iv;
                super.buildRoutine(obj2, source, context);
                DasObject dasObject = source;
                SqlObjectBuilderImpl this_$iv2 = this;
                boolean $i$f$stubbed = false;
                void var8_9 = $this$stubbed$iv;
                if (var8_9 instanceof HiveFunctionBase) {
                    basicElement = (BasicElement)$this$stubbed$iv;
                } else if (var8_9 instanceof SqlStubbedElement) {
                    StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
                    if (!(stubElement instanceof SqlDefinitionStub)) {
                        stubElement = null;
                    }
                    SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
                    Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
                    if (!(object instanceof HiveFunctionBase)) {
                        object = null;
                    }
                    basicElement = (BasicElement)((HiveFunctionBase)object);
                } else {
                    basicElement = null;
                }
                if ((stubbed = (HiveFunctionBase)basicElement) == null) break block12;
                obj2.setClassName(stubbed.getClassName());
                HiveFunctionBase hiveFunctionBase = obj2;
                if (!(hiveFunctionBase instanceof HiveFunction)) {
                    hiveFunctionBase = null;
                }
                HiveFunction hiveFunction = (HiveFunction)hiveFunctionBase;
                if (hiveFunction == null) break block13;
                HiveFunctionBase hiveFunctionBase2 = stubbed;
                if (!(hiveFunctionBase2 instanceof HiveFunction)) {
                    hiveFunctionBase2 = null;
                }
                HiveFunction hiveFunction2 = (HiveFunction)hiveFunctionBase2;
                hiveFunction.setTemporary(hiveFunction2 != null && hiveFunction2.isTemporary());
                break block13;
            }
            String className = null;
            boolean isTemporary = false;
            SqlObjectBuilderImpl $i$f$stubbed = this;
            DasObject dasObject = source;
            if (!(dasObject instanceof SqlCreateFunctionStatementImpl)) {
                dasObject = null;
            }
            PsiElement el$iv = (PsiElement)((SqlCreateFunctionStatementImpl)dasObject);
            boolean $i$f$forEachChild = false;
            void var10_12 = this_$iv;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement el = tmp$iv$iv;
                boolean bl = false;
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)el);
                if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_CLAUSE)) {
                    if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)el.getFirstChild()), (Object)HiveTypes.HIVE_AS)) continue;
                    SqlStringLiteralExpression sqlStringLiteralExpression = (SqlStringLiteralExpression)PsiTreeUtil.getChildOfType((PsiElement)el, SqlStringLiteralExpression.class);
                    className = sqlStringLiteralExpression != null ? sqlStringLiteralExpression.getValue() : null;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_TEMPORARY)) continue;
                isTemporary = true;
            }
            obj2.setClassName(className);
            HiveFunctionBase hiveFunctionBase = obj2;
            if (!(hiveFunctionBase instanceof HiveFunction)) {
                hiveFunctionBase = null;
            }
            HiveFunction hiveFunction = (HiveFunction)hiveFunctionBase;
            if (hiveFunction == null) break block13;
            hiveFunction.setTemporary(isTemporary);
        }
    }

    private final void buildMatView(HiveMatView obj2, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement((BasicModElement)obj2, source, context);
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(this, source){
            final /* synthetic */ HiveObjectBuilder this$0;
            final /* synthetic */ DasObject $source;

            @Nullable
            public final CompositeText invoke() {
                return (CompositeText)HiveObjectBuilder.access$getViewQuery(this.this$0, this.$source, CompositeText.Kind.ORIGINAL_TEXT);
            }
            {
                this.this$0 = hiveObjectBuilder;
                this.$source = dasObject;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void buildLikeColumn(HiveLikeColumn obj2, DasObject source, SqlObjectBuilder.Context context) {
        HiveLikeColumn stubbed;
        BasicElement basicElement;
        void $this$stubbed$iv2;
        super.buildBasicElement((BasicModElement)obj2, source, context);
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbed2 = false;
        SqlObjectBuilderImpl sqlObjectBuilderImpl = $this$stubbed$iv2;
        if (sqlObjectBuilderImpl instanceof HiveLikeColumn) {
            basicElement = (BasicElement)$this$stubbed$iv2;
        } else if (sqlObjectBuilderImpl instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv2).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof HiveLikeColumn)) {
                object = null;
            }
            basicElement = (BasicElement)((HiveLikeColumn)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (HiveLikeColumn)basicElement) != null) {
            obj2.setComment(stubbed.getComment());
            if (stubbed instanceof HiveTableColumn && obj2 instanceof HiveTableColumn) {
                ((HiveTableColumn)obj2).setType(((HiveTableColumn)stubbed).getType());
            }
        } else {
            String string;
            HiveLikeColumn hiveLikeColumn = obj2;
            DasObject dasObject2 = source;
            if (!(dasObject2 instanceof PsiElement)) {
                dasObject2 = null;
            }
            PsiElement psiElement = (PsiElement)dasObject2;
            IElementType iElementType = HiveTypes.HIVE_COMMENT_CLAUSE;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"HIVE_COMMENT_CLAUSE");
            PsiElement psiElement2 = this.findChild(psiElement, iElementType);
            if (psiElement2 != null) {
                void it;
                this_$iv = psiElement2;
                boolean $this$stubbed$iv2 = false;
                $i$f$stubbed2 = false;
                sqlObjectBuilderImpl = this_$iv;
                HiveLikeColumn hiveLikeColumn2 = hiveLikeColumn;
                boolean bl = false;
                PsiElement psiElement3 = it.getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"it.firstChild");
                String string2 = this.findAndUnescapeString(psiElement3);
                hiveLikeColumn = hiveLikeColumn2;
                string = string2;
            } else {
                string = null;
            }
            hiveLikeColumn.setComment(string);
            if (obj2 instanceof HiveTableColumn) {
                void sorting;
                void type;
                void this_$iv2;
                this_$iv = new Ref.ObjectRef();
                ((Ref.ObjectRef)this_$iv).element = HiveTableColumnType.REGULAR;
                Ref.ObjectRef $this$stubbed$iv2 = new Ref.ObjectRef();
                $this$stubbed$iv2.element = HiveTableColumnSortingOrder.NONE;
                SqlObjectBuilderImpl $i$f$stubbed2 = this;
                DasObject dasObject3 = source;
                if (!(dasObject3 instanceof PsiElement)) {
                    dasObject3 = null;
                }
                PsiElement el$iv = PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)dasObject3), SqlCreateTableStatement.class);
                boolean $i$f$forEachChild = false;
                void var10_15 = this_$iv2;
                PsiElement psiElement4 = el$iv;
                PsiElement first$iv$iv = psiElement4 != null ? psiElement4.getFirstChild() : null;
                boolean $i$f$forEachSibling = false;
                for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    IElementType iElementType2;
                    PsiElement el = tmp$iv$iv;
                    boolean bl = false;
                    PsiElement psiElement5 = el.getFirstChild();
                    Object object = iElementType2 = psiElement5 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement5) : null;
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)HiveTypes.HIVE_PARTITIONED)) {
                        this.forEachColumnDef(el, (Function1<? super SqlColumnDefinition, Unit>)((Function1)new Function1<SqlColumnDefinition, Unit>(this, obj2, (Ref.ObjectRef)type, (Ref.ObjectRef)sorting){
                            final /* synthetic */ HiveObjectBuilder this$0;
                            final /* synthetic */ HiveLikeColumn $obj$inlined;
                            final /* synthetic */ Ref.ObjectRef $type$inlined;
                            final /* synthetic */ Ref.ObjectRef $sorting$inlined;
                            {
                                this.this$0 = hiveObjectBuilder;
                                this.$obj$inlined = hiveLikeColumn;
                                this.$type$inlined = objectRef;
                                this.$sorting$inlined = objectRef2;
                                super(1);
                            }

                            public final void invoke(@NotNull SqlColumnDefinition c) {
                                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                                if (StringsKt.equals((String)c.getName(), (String)((HiveTableColumn)this.$obj$inlined).getName(), (boolean)true)) {
                                    this.$type$inlined.element = HiveTableColumnType.PARTITIONING;
                                }
                            }
                        }));
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType2, (Object)HiveTypes.HIVE_CLUSTERED)) continue;
                    this.forEachColumnRef(el, (Function1<? super SqlReferenceExpression, Unit>)((Function1)new Function1<SqlReferenceExpression, Unit>(this, obj2, (Ref.ObjectRef)type, (Ref.ObjectRef)sorting){
                        final /* synthetic */ HiveObjectBuilder this$0;
                        final /* synthetic */ HiveLikeColumn $obj$inlined;
                        final /* synthetic */ Ref.ObjectRef $type$inlined;
                        final /* synthetic */ Ref.ObjectRef $sorting$inlined;
                        {
                            this.this$0 = hiveObjectBuilder;
                            this.$obj$inlined = hiveLikeColumn;
                            this.$type$inlined = objectRef;
                            this.$sorting$inlined = objectRef2;
                            super(1);
                        }

                        public final void invoke(@NotNull SqlReferenceExpression c) {
                            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                            if (StringsKt.equals((String)c.getName(), (String)((HiveTableColumn)this.$obj$inlined).getName(), (boolean)true)) {
                                this.$type$inlined.element = HiveTableColumnType.CLUSTERING;
                            }
                        }
                    }));
                    SqlObjectBuilderImpl this_$iv3 = this;
                    boolean $i$f$forEachChild2 = false;
                    SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this_$iv3;
                    PsiElement first$iv$iv2 = el.getFirstChild();
                    boolean $i$f$forEachSibling2 = false;
                    for (PsiElement tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                        IElementType iElementType3;
                        PsiElement innerEl = tmp$iv$iv2;
                        boolean bl2 = false;
                        PsiElement psiElement6 = innerEl.getFirstChild();
                        Object object2 = iElementType3 = psiElement6 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement6) : null;
                        if (!Intrinsics.areEqual((Object)iElementType3, (Object)HiveTypes.HIVE_SORTED)) continue;
                        this.forEachColumnRef(innerEl, (Function1<? super SqlReferenceExpression, Unit>)((Function1)new Function1<SqlReferenceExpression, Unit>(this, obj2, (Ref.ObjectRef)type, (Ref.ObjectRef)sorting){
                            final /* synthetic */ HiveObjectBuilder this$0;
                            final /* synthetic */ HiveLikeColumn $obj$inlined;
                            final /* synthetic */ Ref.ObjectRef $type$inlined;
                            final /* synthetic */ Ref.ObjectRef $sorting$inlined;
                            {
                                this.this$0 = hiveObjectBuilder;
                                this.$obj$inlined = hiveLikeColumn;
                                this.$type$inlined = objectRef;
                                this.$sorting$inlined = objectRef2;
                                super(1);
                            }

                            public final void invoke(@NotNull SqlReferenceExpression ref2) {
                                Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref");
                                if (StringsKt.equals((String)ref2.getName(), (String)((HiveTableColumn)this.$obj$inlined).getName(), (boolean)true)) {
                                    PsiElement psiElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)((PsiElement)ref2));
                                    HiveTableColumnSortingOrder s = Intrinsics.areEqual((Object)(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null), (Object)HiveTypes.HIVE_DESC) ? HiveTableColumnSortingOrder.DESC : HiveTableColumnSortingOrder.ASC;
                                    this.$sorting$inlined.element = s;
                                }
                            }
                        }));
                    }
                }
                ((HiveTableColumn)obj2).setType((HiveTableColumnType)((Object)type.element));
                ((HiveTableColumn)obj2).setSorting((HiveTableColumnSortingOrder)((Object)sorting.element));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildTable(HiveTable obj2, DasObject source, SqlObjectBuilder.Context context) {
        BasicElement basicElement;
        void $this$stubbed$iv$iv;
        void $this$stubbedOrBuild$iv;
        super.buildBasicElement((BasicModElement)obj2, source, context);
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbedOrBuild = false;
        void var8_7 = $this$stubbedOrBuild$iv;
        SqlObjectBuilderImpl this_$iv$iv = this_$iv;
        boolean $i$f$stubbed = false;
        void var11_11 = $this$stubbed$iv$iv;
        if (var11_11 instanceof HiveTable) {
            basicElement = (BasicElement)$this$stubbed$iv$iv;
        } else if (var11_11 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof HiveTable)) {
                object = null;
            }
            basicElement = (BasicElement)((HiveTable)object);
        } else {
            basicElement = null;
        }
        BasicElement basicElement2 = basicElement;
        if (basicElement == null) {
            void this_$iv2;
            BasicModElement basicModElement = ((BasicElement)obj2).getMetaObject().newDataObject();
            if (basicModElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.hive.model.HiveTable");
            }
            BasicElement basicElement3 = (BasicElement)((HiveTable)basicModElement);
            boolean bl = false;
            boolean bl2 = false;
            HiveTable $this$stubbedOrBuild = (HiveTable)basicElement3;
            boolean bl3 = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
            DasObject dasObject2 = source;
            if (!(dasObject2 instanceof PsiElement)) {
                dasObject2 = null;
            }
            PsiElement el$iv = (PsiElement)dasObject2;
            boolean $i$f$forEachChild = false;
            void var17_17 = this_$iv2;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                IElementType iElementType;
                PsiElement tmp$iv$iv2;
                boolean $i$f$forEachSibling2;
                Object first$iv$iv2;
                boolean $i$f$forEachChild2;
                SqlObjectBuilderImpl this_$iv3;
                IElementType iElementType2;
                PsiElement el = tmp$iv$iv;
                boolean bl4 = false;
                if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)el), (Object)HiveTypes.HIVE_EXTERNAL)) {
                    $this$stubbedOrBuild.setExternal(true);
                } else if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)el), (Object)HiveTypes.HIVE_TEMPORARY)) {
                    $this$stubbedOrBuild.setTemporary(true);
                }
                PsiElement psiElement2 = el.getFirstChild();
                Object object = iElementType2 = psiElement2 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement2) : null;
                if (Intrinsics.areEqual((Object)iElementType2, (Object)HiveTypes.HIVE_COMMENT)) {
                    PsiElement psiElement3 = el.getFirstChild();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"el.firstChild");
                    $this$stubbedOrBuild.setComment(this.findAndUnescapeString(psiElement3));
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType2, (Object)HiveTypes.HIVE_CLUSTERED)) {
                    this_$iv3 = this;
                    $i$f$forEachChild2 = false;
                    SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this_$iv3;
                    first$iv$iv2 = el.getFirstChild();
                    $i$f$forEachSibling2 = false;
                    for (tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                        PsiElement innerEl = tmp$iv$iv2;
                        boolean bl5 = false;
                        PsiElement psiElement4 = innerEl.getFirstChild();
                        Object object2 = iElementType = psiElement4 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement4) : null;
                        if (!Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_INTO)) continue;
                        Integer n = this.findInt(innerEl);
                        $this$stubbedOrBuild.setBucketsNum(n != null ? n : 0);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType2, (Object)HiveTypes.HIVE_SKEWED)) {
                    SqlClause it;
                    Iterator $this$mapTo$iv$iv22;
                    SqlReferenceList refList = (SqlReferenceList)PsiTreeUtil.getChildOfType((PsiElement)el, SqlReferenceList.class);
                    Object object3 = refList;
                    if (object3 != null && (object3 = object3.getReferenceList()) != null) {
                        Iterable $this$map$iv = (Iterable)object3;
                        boolean $i$f$map = false;
                        first$iv$iv2 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator innerEl = $this$mapTo$iv$iv22.iterator();
                        while (innerEl.hasNext()) {
                            Object item$iv$iv = innerEl.next();
                            iElementType = (SqlReferenceExpression)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl6 = false;
                            void v15 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"it");
                            String string = v15.getName();
                            collection.add(string);
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        $i$f$map = false;
                        boolean $this$mapTo$iv$iv22 = false;
                        Iterable it2 = $this$map$iv;
                        boolean bl7 = false;
                        $this$stubbedOrBuild.setSkewedByColumns((List<String>)it2);
                    }
                    List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)el, SqlClause.class);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"PsiTreeUtil.getChildrenO\u2026l, SqlClause::class.java)");
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    $this$mapTo$iv$iv22 = $this$forEach$iv.iterator();
                    while ($this$mapTo$iv$iv22.hasNext()) {
                        IElementType item$iv$iv;
                        Object element$iv = $this$mapTo$iv$iv22.next();
                        SqlClause clause = (SqlClause)element$iv;
                        boolean bl8 = false;
                        SqlClause sqlClause = clause;
                        Intrinsics.checkNotNullExpressionValue((Object)sqlClause, (String)"clause");
                        PsiElement psiElement5 = sqlClause.getFirstChild();
                        Object object4 = item$iv$iv = psiElement5 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement5) : null;
                        if (Intrinsics.areEqual((Object)item$iv$iv, (Object)HiveTypes.HIVE_ON)) {
                            if ((SqlClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)clause), SqlClause.class) != null) {
                                boolean bl9 = false;
                                boolean bl10 = false;
                                SqlClause it3 = it;
                                boolean bl11 = false;
                                SqlClause sqlClause2 = it3;
                                Intrinsics.checkNotNullExpressionValue((Object)sqlClause2, (String)"it");
                                $this$stubbedOrBuild.setSkewedByValues(sqlClause2.getText());
                            }
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)item$iv$iv, (Object)HiveTypes.HIVE_STORED)) continue;
                        $this$stubbedOrBuild.setStoredAsDirictories(true);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType2, (Object)HiveTypes.HIVE_ROW)) {
                    $this$stubbedOrBuild.setRowFormatSerde(this.findString(el.getFirstChild()));
                    this_$iv3 = this;
                    $i$f$forEachChild2 = false;
                    SqlObjectBuilderImpl $i$f$forEach = this_$iv3;
                    first$iv$iv2 = el.getFirstChild();
                    $i$f$forEachSibling2 = false;
                    for (tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                        PsiElement it = tmp$iv$iv2;
                        boolean bl12 = false;
                        if (!(it instanceof SqlClause)) continue;
                        PsiElement psiElement6 = ((SqlClause)it).getFirstChild();
                        if (!Intrinsics.areEqual((Object)(psiElement6 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement6) : null), (Object)HiveTypes.HIVE_SERDEPROPERTIES)) continue;
                        $this$stubbedOrBuild.setSerdeProperties(this.findProperties(it));
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType2, (Object)HiveTypes.HIVE_STORED)) {
                    this_$iv3 = this;
                    $i$f$forEachChild2 = false;
                    SqlObjectBuilderImpl this_$iv$iv2 = this_$iv3;
                    first$iv$iv2 = el.getFirstChild();
                    $i$f$forEachSibling2 = false;
                    for (tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                        IElementType iElementType3;
                        PsiElement first2;
                        PsiElement it = tmp$iv$iv2;
                        boolean bl13 = false;
                        if (!(it instanceof SqlClause)) continue;
                        PsiElement psiElement7 = first2 = ((SqlClause)it).getFirstChild();
                        Object object5 = iElementType3 = psiElement7 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement7) : null;
                        if (Intrinsics.areEqual((Object)iElementType3, (Object)HiveTypes.HIVE_INPUTFORMAT)) {
                            $this$stubbedOrBuild.setInputFormat(this.findString(first2));
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType3, (Object)HiveTypes.HIVE_OUTPUTFORMAT)) {
                            $this$stubbedOrBuild.setOutputFormat(this.findString(first2));
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType3, (Object)HiveTypes.HIVE_OUTPUTDRIVER)) {
                            $this$stubbedOrBuild.setOutputDriver(this.findString(first2));
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)iElementType3, (Object)HiveTypes.HIVE_INPUTDRIVER)) continue;
                        $this$stubbedOrBuild.setInputDriver(this.findString(first2));
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType2, (Object)HiveTypes.HIVE_LOCATION)) {
                    PsiElement psiElement8 = el.getFirstChild();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement8, (String)"el.firstChild");
                    $this$stubbedOrBuild.setLocation(this.findAndUnescapeString(psiElement8));
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType2, (Object)HiveTypes.HIVE_TBLPROPERTIES)) continue;
                $this$stubbedOrBuild.setProperties(this.findProperties(el));
            }
            basicElement2 = basicElement3;
        }
        HiveTable stubbed = (HiveTable)basicElement2;
        obj2.setComment(stubbed.getComment());
        obj2.setExternal(stubbed.isExternal());
        obj2.setTemporary(stubbed.isTemporary());
        obj2.setBucketsNum(stubbed.getBucketsNum());
        obj2.setSkewedByColumns(stubbed.getSkewedByColumns());
        obj2.setSkewedByValues(stubbed.getSkewedByValues());
        obj2.setStoredAsDirictories(stubbed.isStoredAsDirictories());
        obj2.setRowFormatSerde(stubbed.getRowFormatSerde());
        obj2.setSerdeProperties(stubbed.getSerdeProperties());
        obj2.setInputFormat(stubbed.getInputFormat());
        obj2.setOutputFormat(stubbed.getOutputFormat());
        obj2.setInputDriver(stubbed.getInputDriver());
        obj2.setOutputDriver(stubbed.getOutputDriver());
        obj2.setLocation(stubbed.getLocation());
        obj2.setProperties(stubbed.getProperties());
    }

    private final List<NameValue> findProperties(PsiElement el) {
        boolean bl = false;
        List properties2 = new ArrayList();
        SqlSetAssignment[] sqlSetAssignmentArray = (SqlSetAssignment[])PsiTreeUtil.getChildrenOfType((PsiElement)el, SqlSetAssignment.class);
        if (sqlSetAssignmentArray != null) {
            SqlSetAssignment[] $this$forEach$iv = sqlSetAssignmentArray;
            boolean $i$f$forEach = false;
            SqlSetAssignment[] sqlSetAssignmentArray2 = $this$forEach$iv;
            int n = sqlSetAssignmentArray2.length;
            for (int j = 0; j < n; ++j) {
                String value;
                SqlSetAssignment element$iv;
                SqlSetAssignment prop = element$iv = sqlSetAssignmentArray2[j];
                boolean bl2 = false;
                SqlSetAssignment sqlSetAssignment = prop;
                Intrinsics.checkNotNullExpressionValue((Object)sqlSetAssignment, (String)"prop");
                SqlElement sqlElement = sqlSetAssignment.getLValue();
                if (!(sqlElement instanceof SqlStringLiteralExpression)) {
                    sqlElement = null;
                }
                SqlStringLiteralExpression sqlStringLiteralExpression = (SqlStringLiteralExpression)sqlElement;
                String key2 = sqlStringLiteralExpression != null ? sqlStringLiteralExpression.getValue() : null;
                SqlElement sqlElement2 = prop.getRValue();
                if (!(sqlElement2 instanceof SqlStringLiteralExpression)) {
                    sqlElement2 = null;
                }
                SqlStringLiteralExpression sqlStringLiteralExpression2 = (SqlStringLiteralExpression)sqlElement2;
                String string = value = sqlStringLiteralExpression2 != null ? sqlStringLiteralExpression2.getValue() : null;
                if (key2 == null || value == null || HiveIntrospector.Companion.getIGNORED_PROPERTIES().contains(key2)) continue;
                properties2.add(new NameValue(key2, value));
            }
        }
        return properties2;
    }

    private final void forEachColumnDef(PsiElement el, Function1<? super SqlColumnDefinition, Unit> action) {
        SqlColumnDefinition[] sqlColumnDefinitionArray = (SqlColumnDefinition[])PsiTreeUtil.getChildrenOfType((PsiElement)el, SqlColumnDefinition.class);
        if (sqlColumnDefinitionArray != null) {
            SqlColumnDefinition[] $this$forEach$iv = sqlColumnDefinitionArray;
            boolean $i$f$forEach = false;
            SqlColumnDefinition[] sqlColumnDefinitionArray2 = $this$forEach$iv;
            int n = sqlColumnDefinitionArray2.length;
            for (int j = 0; j < n; ++j) {
                SqlColumnDefinition element$iv;
                SqlColumnDefinition c = element$iv = sqlColumnDefinitionArray2[j];
                boolean bl = false;
                SqlColumnDefinition sqlColumnDefinition = c;
                Intrinsics.checkNotNullExpressionValue((Object)sqlColumnDefinition, (String)"c");
                action.invoke((Object)sqlColumnDefinition);
            }
        }
    }

    private final void forEachColumnRef(PsiElement el, Function1<? super SqlReferenceExpression, Unit> action) {
        SqlReferenceList refList = (SqlReferenceList)PsiTreeUtil.getChildOfType((PsiElement)el, SqlReferenceList.class);
        if (refList == null) {
            return;
        }
        Iterator iterator = refList.getReferenceList().iterator();
        while (iterator.hasNext()) {
            SqlReferenceExpression ref2;
            SqlReferenceExpression sqlReferenceExpression = ref2 = (SqlReferenceExpression)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceExpression, (String)"ref");
            action.invoke((Object)sqlReferenceExpression);
        }
    }

    private final String findAndUnescapeString(PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_STRING_LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SqlElementTypes.SQL_STRING_LITERAL");
        PsiElement psiElement = this.findSibling(source, (IElementType)sqlCompositeElementType);
        if (!(psiElement instanceof SqlStringLiteralExpressionImpl)) {
            psiElement = null;
        }
        SqlStringLiteralExpressionImpl sqlStringLiteralExpressionImpl = (SqlStringLiteralExpressionImpl)psiElement;
        if (sqlStringLiteralExpressionImpl == null) {
            return null;
        }
        SqlStringLiteralExpressionImpl stringLiteral = sqlStringLiteralExpressionImpl;
        return StringUtil.unescapeChar((String)StringUtil.unescapeChar((String)StringUtil.unquoteString((String)stringLiteral.getText()), (char)'\"'), (char)'\'');
    }

    /*
     * WARNING - void declaration
     */
    private final void buildSchema(HiveSchema obj2, DasObject source, SqlObjectBuilder.Context context) {
        HiveSchema stubbed;
        BasicElement basicElement;
        void $this$stubbed$iv;
        if (!context.isIntrospector()) {
            super.buildNamespace((BasicModNamespace)obj2, source, context);
        }
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbed = false;
        SqlObjectBuilderImpl sqlObjectBuilderImpl = $this$stubbed$iv;
        if (sqlObjectBuilderImpl instanceof HiveSchema) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (sqlObjectBuilderImpl instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof HiveSchema)) {
                object = null;
            }
            basicElement = (BasicElement)((HiveSchema)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (HiveSchema)basicElement) != null) {
            obj2.setOwner(stubbed.getOwner());
            obj2.setProperties(stubbed.getProperties());
            obj2.setLocation(stubbed.getLocation());
            obj2.setComment(stubbed.getComment());
        } else {
            void this_$iv2;
            List<NameValue> properties2 = CollectionsKt.emptyList();
            String location = null;
            String comment = null;
            sqlObjectBuilderImpl = this;
            DasObject dasObject2 = source;
            if (!(dasObject2 instanceof SqlCreateStatement)) {
                dasObject2 = null;
            }
            PsiElement el$iv = (PsiElement)((SqlCreateStatement)dasObject2);
            boolean $i$f$forEachChild = false;
            void var11_12 = this_$iv2;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                IElementType iElementType;
                PsiElement el = tmp$iv$iv;
                boolean bl = false;
                PsiElement psiElement2 = el.getFirstChild();
                Object object = iElementType = psiElement2 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement2) : null;
                if (Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_DBPROPERTIES)) {
                    properties2 = this.findProperties(el);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_LOCATION)) {
                    PsiElement psiElement3 = el.getFirstChild();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"el.firstChild");
                    location = this.findAndUnescapeString(psiElement3);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_COMMENT)) continue;
                PsiElement psiElement4 = el.getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"el.firstChild");
                comment = this.findAndUnescapeString(psiElement4);
            }
            obj2.setOwner(null);
            obj2.setProperties(properties2);
            obj2.setLocation(location);
            obj2.setComment(comment);
        }
    }

    public static final /* synthetic */ SimpleCompositeText access$getViewQuery(HiveObjectBuilder $this, DasObject source, CompositeText.Kind kind) {
        return $this.getViewQuery(source, kind);
    }
}

