/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelper;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.SizeAndScale;
import com.intellij.database.dialects.base.generator.producers.AlterProducer;
import com.intellij.database.dialects.base.generator.producers.BaseProducersKt;
import com.intellij.database.dialects.base.generator.producers.CreateProducer;
import com.intellij.database.dialects.base.generator.producers.DropProducer;
import com.intellij.database.dialects.h2.generator.producers.H2AlterAggregate;
import com.intellij.database.dialects.h2.generator.producers.H2AlterArgument;
import com.intellij.database.dialects.h2.generator.producers.H2AlterCheck;
import com.intellij.database.dialects.h2.generator.producers.H2AlterConstant;
import com.intellij.database.dialects.h2.generator.producers.H2AlterDatabase;
import com.intellij.database.dialects.h2.generator.producers.H2AlterDomain;
import com.intellij.database.dialects.h2.generator.producers.H2AlterForeignKey;
import com.intellij.database.dialects.h2.generator.producers.H2AlterIndex;
import com.intellij.database.dialects.h2.generator.producers.H2AlterKey;
import com.intellij.database.dialects.h2.generator.producers.H2AlterRole;
import com.intellij.database.dialects.h2.generator.producers.H2AlterRoutine;
import com.intellij.database.dialects.h2.generator.producers.H2AlterSchema;
import com.intellij.database.dialects.h2.generator.producers.H2AlterSequence;
import com.intellij.database.dialects.h2.generator.producers.H2AlterSynonym;
import com.intellij.database.dialects.h2.generator.producers.H2AlterTable;
import com.intellij.database.dialects.h2.generator.producers.H2AlterTableColumn;
import com.intellij.database.dialects.h2.generator.producers.H2AlterTrigger;
import com.intellij.database.dialects.h2.generator.producers.H2AlterUser;
import com.intellij.database.dialects.h2.generator.producers.H2AlterView;
import com.intellij.database.dialects.h2.generator.producers.H2AlterViewColumn;
import com.intellij.database.dialects.h2.generator.producers.H2CreateAggregate;
import com.intellij.database.dialects.h2.generator.producers.H2CreateCheck;
import com.intellij.database.dialects.h2.generator.producers.H2CreateConstant;
import com.intellij.database.dialects.h2.generator.producers.H2CreateDomain;
import com.intellij.database.dialects.h2.generator.producers.H2CreateForeignKey;
import com.intellij.database.dialects.h2.generator.producers.H2CreateIndex;
import com.intellij.database.dialects.h2.generator.producers.H2CreateKey;
import com.intellij.database.dialects.h2.generator.producers.H2CreateLikeColumn;
import com.intellij.database.dialects.h2.generator.producers.H2CreateRole;
import com.intellij.database.dialects.h2.generator.producers.H2CreateRoutine;
import com.intellij.database.dialects.h2.generator.producers.H2CreateSchema;
import com.intellij.database.dialects.h2.generator.producers.H2CreateSequence;
import com.intellij.database.dialects.h2.generator.producers.H2CreateSynonym;
import com.intellij.database.dialects.h2.generator.producers.H2CreateTable;
import com.intellij.database.dialects.h2.generator.producers.H2CreateTableColumn;
import com.intellij.database.dialects.h2.generator.producers.H2CreateTrigger;
import com.intellij.database.dialects.h2.generator.producers.H2CreateUser;
import com.intellij.database.dialects.h2.generator.producers.H2CreateView;
import com.intellij.database.dialects.h2.generator.producers.H2DropAggregate;
import com.intellij.database.dialects.h2.generator.producers.H2DropConstant;
import com.intellij.database.dialects.h2.generator.producers.H2DropDomain;
import com.intellij.database.dialects.h2.generator.producers.H2DropForeignKey;
import com.intellij.database.dialects.h2.generator.producers.H2DropIndex;
import com.intellij.database.dialects.h2.generator.producers.H2DropKey;
import com.intellij.database.dialects.h2.generator.producers.H2DropRole;
import com.intellij.database.dialects.h2.generator.producers.H2DropRoutine;
import com.intellij.database.dialects.h2.generator.producers.H2DropSchema;
import com.intellij.database.dialects.h2.generator.producers.H2DropSequence;
import com.intellij.database.dialects.h2.generator.producers.H2DropSynonym;
import com.intellij.database.dialects.h2.generator.producers.H2DropTable;
import com.intellij.database.dialects.h2.generator.producers.H2DropTableColumn;
import com.intellij.database.dialects.h2.generator.producers.H2DropTrigger;
import com.intellij.database.dialects.h2.generator.producers.H2DropUser;
import com.intellij.database.dialects.h2.generator.producers.H2DropView;
import com.intellij.database.dialects.h2.model.H2Aggregate;
import com.intellij.database.dialects.h2.model.H2Argument;
import com.intellij.database.dialects.h2.model.H2Check;
import com.intellij.database.dialects.h2.model.H2Constant;
import com.intellij.database.dialects.h2.model.H2Database;
import com.intellij.database.dialects.h2.model.H2Domain;
import com.intellij.database.dialects.h2.model.H2ForeignKey;
import com.intellij.database.dialects.h2.model.H2Index;
import com.intellij.database.dialects.h2.model.H2Key;
import com.intellij.database.dialects.h2.model.H2LikeColumn;
import com.intellij.database.dialects.h2.model.H2Role;
import com.intellij.database.dialects.h2.model.H2Routine;
import com.intellij.database.dialects.h2.model.H2Schema;
import com.intellij.database.dialects.h2.model.H2Sequence;
import com.intellij.database.dialects.h2.model.H2Synonym;
import com.intellij.database.dialects.h2.model.H2Table;
import com.intellij.database.dialects.h2.model.H2TableColumn;
import com.intellij.database.dialects.h2.model.H2Trigger;
import com.intellij.database.dialects.h2.model.H2User;
import com.intellij.database.dialects.h2.model.H2View;
import com.intellij.database.dialects.h2.model.H2ViewColumn;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.script.generator.ScriptLocus;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0016J \u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\f\u001a\u00020\r2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u001c\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0018\u0010!\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\rH\u0016R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/database/dialects/h2/generator/H2ScriptGeneratorHelper;", "Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;", "()V", "defaultPrimitiveSizes", "", "", "Lcom/intellij/database/dialects/base/generator/SizeAndScale;", "getDefaultPrimitiveSizes", "()Ljava/util/Map;", "defaultPrimitiveSizes199", "canGenerateHere", "", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "locus", "Lcom/intellij/database/script/generator/ScriptLocus;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "commentStr", "comment", "createAlterProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/AlterProducer;", "elements", "Lcom/intellij/database/model/ElementAlteration;", "createDropProducer", "Lcom/intellij/database/dialects/base/generator/producers/DropProducer;", "createProducer", "Lcom/intellij/database/dialects/base/generator/producers/CreateProducer;", "getDefaultPrimitiveSize", "d", "Lcom/intellij/database/model/DataType;", "v", "Lcom/intellij/database/util/Version;", "script", "intellij.database.dialects.h2"})
public final class H2ScriptGeneratorHelper
extends ScriptGeneratorHelper {
    @NotNull
    private static final Map<String, SizeAndScale> defaultPrimitiveSizes;
    private static final Map<String, SizeAndScale> defaultPrimitiveSizes199;
    @NotNull
    public static final H2ScriptGeneratorHelper INSTANCE;

    @Override
    @NotNull
    public Map<String, SizeAndScale> getDefaultPrimitiveSizes() {
        return defaultPrimitiveSizes;
    }

    @Override
    @Nullable
    protected SizeAndScale getDefaultPrimitiveSize(@NotNull DataType d, @NotNull Version v2) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        if (v2.isOrGreater(new int[]{1, 4, 199})) {
            SizeAndScale sizeAndScale = defaultPrimitiveSizes199.get(StringUtil.toLowerCase((String)d.typeName));
            if (sizeAndScale != null) {
                SizeAndScale sizeAndScale2 = sizeAndScale;
                boolean bl = false;
                boolean bl2 = false;
                SizeAndScale it = sizeAndScale2;
                boolean bl3 = false;
                return it;
            }
        }
        return super.getDefaultPrimitiveSize(d, v2);
    }

    @Override
    @NotNull
    public String script(@NotNull DataType d, @NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return d.scale == 0 && d.size != -1 && StringsKt.equals((String)d.typeName, (String)"timestamp", (boolean)true) ? d.typeName + '(' + d.getPrecision() + ", 0)" : super.script(d, context);
    }

    @Override
    @NotNull
    public String commentStr(@Nullable String comment) {
        String string = comment;
        if (string == null || (string = ScriptGeneratorHelperKt.getSqlString(string)) == null) {
            string = "null";
        }
        return string;
    }

    @Override
    public boolean canGenerateHere(@NotNull ScriptingContext context, @NotNull ScriptLocus locus, @Nullable BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)locus, (String)"locus");
        if (locus == ScriptLocus.IN_COLUMN) {
            if (element instanceof H2ForeignKey && ScriptGeneratorHelperKt.useName(element, context)) {
                return false;
            }
            if (element instanceof H2Key && ((H2Key)element).isPrimary() && ScriptGeneratorHelperKt.useName(element, context)) {
                return false;
            }
        }
        return super.canGenerateHere(context, locus, element);
    }

    @Override
    @NotNull
    public CreateProducer<?> createProducer(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof H2Schema ? (CreateProducer)new H2CreateSchema(context, (H2Schema)element) : (basicElement instanceof H2Sequence ? (CreateProducer)new H2CreateSequence(context, (H2Sequence)element) : (basicElement instanceof H2Table ? (CreateProducer)new H2CreateTable(context, (H2Table)element) : (basicElement instanceof H2Index ? (CreateProducer)new H2CreateIndex(context, (H2Index)element) : (basicElement instanceof H2Trigger ? (CreateProducer)new H2CreateTrigger(context, (H2Trigger)element) : (basicElement instanceof H2Key ? (CreateProducer)new H2CreateKey(context, (H2Key)element) : (basicElement instanceof H2ForeignKey ? (CreateProducer)new H2CreateForeignKey(context, (H2ForeignKey)element) : (basicElement instanceof H2Check ? (CreateProducer)new H2CreateCheck(context, (H2Check)element) : (basicElement instanceof H2View ? (CreateProducer)new H2CreateView(context, (H2View)element) : (basicElement instanceof H2TableColumn ? (CreateProducer)new H2CreateTableColumn(context, (H2TableColumn)element) : (basicElement instanceof H2LikeColumn ? (CreateProducer)new H2CreateLikeColumn<H2LikeColumn>(context, (H2LikeColumn)element) : (basicElement instanceof H2Routine ? (CreateProducer)new H2CreateRoutine(context, (H2Routine)element) : (basicElement instanceof H2Aggregate ? (CreateProducer)new H2CreateAggregate(context, (H2Aggregate)element) : (basicElement instanceof H2Domain ? (CreateProducer)new H2CreateDomain(context, (H2Domain)element) : (basicElement instanceof H2Constant ? (CreateProducer)new H2CreateConstant(context, (H2Constant)element) : (basicElement instanceof H2Synonym ? (CreateProducer)new H2CreateSynonym(context, (H2Synonym)element) : (basicElement instanceof H2Role ? (CreateProducer)new H2CreateRole(context, (H2Role)element) : (basicElement instanceof H2User ? (CreateProducer)new H2CreateUser(context, (H2User)element) : super.createProducer(context, element))))))))))))))))));
    }

    @Override
    @NotNull
    public DropProducer<?> createDropProducer(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof H2Schema ? (DropProducer)new H2DropSchema(context, (H2Schema)element) : (basicElement instanceof H2Table ? (DropProducer)new H2DropTable(context, (H2Table)element) : (basicElement instanceof H2TableColumn ? (DropProducer)new H2DropTableColumn(context, (H2TableColumn)element) : (basicElement instanceof H2Key ? (DropProducer)new H2DropKey(context, (H2Key)element) : (basicElement instanceof H2ForeignKey ? (DropProducer)new H2DropForeignKey(context, (H2ForeignKey)element) : (basicElement instanceof H2Index ? (DropProducer)new H2DropIndex(context, (H2Index)element) : (basicElement instanceof H2Sequence ? (DropProducer)new H2DropSequence(context, (H2Sequence)element) : (basicElement instanceof H2Trigger ? (DropProducer)new H2DropTrigger(context, (H2Trigger)element) : (basicElement instanceof H2View ? (DropProducer)new H2DropView(context, (H2View)element) : (basicElement instanceof H2Routine ? (DropProducer)new H2DropRoutine(context, (H2Routine)element) : (basicElement instanceof H2Aggregate ? (DropProducer)new H2DropAggregate(context, (H2Aggregate)element) : (basicElement instanceof H2Domain ? (DropProducer)new H2DropDomain(context, (H2Domain)element) : (basicElement instanceof H2Constant ? (DropProducer)new H2DropConstant(context, (H2Constant)element) : (basicElement instanceof H2Synonym ? (DropProducer)new H2DropSynonym(context, (H2Synonym)element) : (basicElement instanceof H2Role ? (DropProducer)new H2DropRole(context, (H2Role)element) : (basicElement instanceof H2User ? (DropProducer)new H2DropUser(context, (H2User)element) : super.createDropProducer(context, element))))))))))))))));
    }

    @Override
    @NotNull
    public AlterProducer<?> createAlterProducerImpl(@NotNull ScriptingContext context, @NotNull ElementAlteration<?> elements2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        BasicElement basicElement = elements2.getSourceElement();
        boolean bl = false;
        boolean bl2 = false;
        BasicElement it = basicElement;
        boolean bl3 = false;
        BasicElement basicElement2 = it;
        return basicElement2 instanceof H2Database ? (AlterProducer)new H2AlterDatabase(context, (ElementAlteration<? extends H2Database>)BaseProducersKt.cast(elements2, it)) : (basicElement2 instanceof H2Schema ? (AlterProducer)new H2AlterSchema(context, (ElementAlteration<? extends H2Schema>)BaseProducersKt.cast(elements2, it)) : (basicElement2 instanceof H2View ? (AlterProducer)new H2AlterView(context, (ElementAlteration<? extends H2View>)BaseProducersKt.cast(elements2, it)) : (basicElement2 instanceof H2Table ? (AlterProducer)new H2AlterTable(context, (ElementAlteration<? extends H2Table>)BaseProducersKt.cast(elements2, it)) : (basicElement2 instanceof H2Index ? (AlterProducer)new H2AlterIndex(context, (ElementAlteration<? extends H2Index>)BaseProducersKt.cast(elements2, it)) : (basicElement2 instanceof H2ForeignKey ? (AlterProducer)new H2AlterForeignKey(context, (ElementAlteration<? extends H2ForeignKey>)BaseProducersKt.cast(elements2, it)) : (basicElement2 instanceof H2Key ? (AlterProducer)new H2AlterKey(context, (ElementAlteration<? extends H2Key>)BaseProducersKt.cast(elements2, it)) : (basicElement2 instanceof H2Check ? (AlterProducer)new H2AlterCheck(context, (ElementAlteration<? extends H2Check>)BaseProducersKt.cast(elements2, it)) : (basicElement2 instanceof H2TableColumn ? (AlterProducer)new H2AlterTableColumn(context, (ElementAlteration<? extends H2TableColumn>)BaseProducersKt.cast(elements2, it)) : (basicElement2 instanceof H2ViewColumn ? (AlterProducer)new H2AlterViewColumn(context, (ElementAlteration<? extends H2ViewColumn>)BaseProducersKt.cast(elements2, it)) : (basicElement2 instanceof H2Routine ? (AlterProducer)new H2AlterRoutine(context, (ElementAlteration<? extends H2Routine>)BaseProducersKt.cast(elements2, it)) : (basicElement2 instanceof H2Argument ? (AlterProducer)new H2AlterArgument(context, (ElementAlteration<? extends H2Argument>)BaseProducersKt.cast(elements2, it)) : (basicElement2 instanceof H2Aggregate ? (AlterProducer)new H2AlterAggregate(context, (ElementAlteration<? extends H2Aggregate>)BaseProducersKt.cast(elements2, it)) : (basicElement2 instanceof H2Sequence ? (AlterProducer)new H2AlterSequence(context, (ElementAlteration<? extends H2Sequence>)BaseProducersKt.cast(elements2, it)) : (basicElement2 instanceof H2Trigger ? (AlterProducer)new H2AlterTrigger(context, (ElementAlteration<? extends H2Trigger>)BaseProducersKt.cast(elements2, it)) : (basicElement2 instanceof H2Domain ? (AlterProducer)new H2AlterDomain(context, (ElementAlteration<? extends H2Domain>)BaseProducersKt.cast(elements2, it)) : (basicElement2 instanceof H2Constant ? (AlterProducer)new H2AlterConstant(context, (ElementAlteration<? extends H2Constant>)BaseProducersKt.cast(elements2, it)) : (basicElement2 instanceof H2Synonym ? (AlterProducer)new H2AlterSynonym(context, (ElementAlteration<? extends H2Synonym>)BaseProducersKt.cast(elements2, it)) : (basicElement2 instanceof H2Role ? (AlterProducer)new H2AlterRole(context, (ElementAlteration<? extends H2Role>)BaseProducersKt.cast(elements2, it)) : (basicElement2 instanceof H2User ? (AlterProducer)new H2AlterUser(context, (ElementAlteration<? extends H2User>)BaseProducersKt.cast(elements2, it)) : super.createAlterProducerImpl(context, elements2))))))))))))))))))));
    }

    private H2ScriptGeneratorHelper() {
        Dbms dbms = Dbms.H2;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"H2");
        super(dbms);
    }

    static {
        H2ScriptGeneratorHelper h2ScriptGeneratorHelper;
        INSTANCE = h2ScriptGeneratorHelper = new H2ScriptGeneratorHelper();
        defaultPrimitiveSizes = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"boolean", (Object)new SizeAndScale(1, 0, 2, null)), TuplesKt.to((Object)"tinyint", (Object)new SizeAndScale(3, 0, 2, null)), TuplesKt.to((Object)"smallint", (Object)new SizeAndScale(5, 0, 2, null)), TuplesKt.to((Object)"integer", (Object)new SizeAndScale(10, 0, 2, null)), TuplesKt.to((Object)"bigint", (Object)new SizeAndScale(19, 0, 2, null)), TuplesKt.to((Object)"real", (Object)new SizeAndScale(7, 0, 2, null)), TuplesKt.to((Object)"double", (Object)new SizeAndScale(17, 0, 2, null)), TuplesKt.to((Object)"date", (Object)new SizeAndScale(8, 0, 2, null)), TuplesKt.to((Object)"time", (Object)new SizeAndScale(6, 0, 2, null)), TuplesKt.to((Object)"timestamp", (Object)new SizeAndScale(23, 10)), TuplesKt.to((Object)"timestamp with timezone", (Object)new SizeAndScale(30, 10)), TuplesKt.to((Object)"blob", (Object)new SizeAndScale(Integer.MAX_VALUE, 0, 2, null)), TuplesKt.to((Object)"clob", (Object)new SizeAndScale(Integer.MAX_VALUE, 0, 2, null))});
        defaultPrimitiveSizes199 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"date", (Object)new SizeAndScale(10, 0, 2, null)), TuplesKt.to((Object)"time", (Object)new SizeAndScale(8, 0, 2, null)), TuplesKt.to((Object)"timestamp", (Object)new SizeAndScale(26, 6))});
    }
}

