/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.greenplum.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.greenplum.model.GPlumExternalTable;
import com.intellij.database.dialects.greenplum.model.GPlumExternalTableColumn;
import com.intellij.database.dialects.greenplum.model.properties.GPlumExternalTableFormat;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseModelHelper;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseObjectEditorFactory;
import com.intellij.database.model.ModelHelperCore;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.schemaEditor.DbObjectEditorFactory;
import com.intellij.openapi.util.text.StringUtil;
import icons.DatabaseIcons;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/greenplum/model/GPlumModelHelper;", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "()V", "oef", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseObjectEditorFactory;", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "Lcom/intellij/database/model/ModelHelperCore$ObjectKindVariant;", "vars", "", "", "getIcon", "Ljavax/swing/Icon;", "kind", "Lcom/intellij/database/model/ObjectKind;", "getName", "getObjectEditorFactory", "Lcom/intellij/database/schemaEditor/DbObjectEditorFactory;", "intellij.database.dialects.greenplum"})
public final class GPlumModelHelper
extends PgGPlumBaseModelHelper {
    private static final PgGPlumBaseObjectEditorFactory oef;
    @NotNull
    public static final GPlumModelHelper INSTANCE;

    @NotNull
    public String getName(@NotNull ObjectKind kind) {
        String string;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        ObjectKind objectKind = kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_TABLE)) {
            String string2 = DatabaseBundle.message((String)"ObjectKind.external.table", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DatabaseBundle.message(\"\u2026jectKind.external.table\")");
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIRTUAL_TABLE)) {
            String string3 = DatabaseBundle.message((String)"ObjectKind.foreign.table", (Object[])new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DatabaseBundle.message(\"ObjectKind.foreign.table\")");
        } else {
            String string4 = super.getName(kind);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"super.getName(kind)");
        }
        return string;
    }

    @Nullable
    public Icon getIcon(@NotNull ObjectKind kind) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.VIRTUAL_TABLE)) {
            return DatabaseIcons.Foreign_table;
        }
        return super.getIcon(kind);
    }

    @Override
    public void fillPropertiesWithExamples(@NotNull BasicModElement e2, @NotNull ModelHelperCore.ObjectKindVariant variant, @NotNull Map<String, String> vars) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        super.fillPropertiesWithExamples(e2, variant, vars);
        if (e2 instanceof GPlumExternalTable) {
            GPlumExternalTableColumn col = (GPlumExternalTableColumn)((GPlumExternalTable)e2).getColumns().createNewOne();
            this.setTemplateName((BasicModNamedElement)col, "col");
            GPlumExternalTableColumn gPlumExternalTableColumn = col;
            Intrinsics.checkNotNullExpressionValue((Object)gPlumExternalTableColumn, (String)"col");
            gPlumExternalTableColumn.setDataType(DataTypeFactory.of((String)"int"));
            vars.put("cols", "col int");
            ((GPlumExternalTable)e2).setFormat(GPlumExternalTableFormat.PARQUET);
            String string = StringUtil.toLowerCase((String)GPlumExternalTableFormat.PARQUET.name());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.toLowerCase(G\u2026TableFormat.PARQUET.name)");
            vars.put("format", ScriptGeneratorHelperKt.getSqlString(string));
        }
    }

    @NotNull
    public DbObjectEditorFactory getObjectEditorFactory() {
        return oef;
    }

    private GPlumModelHelper() {
    }

    static {
        GPlumModelHelper gPlumModelHelper;
        INSTANCE = gPlumModelHelper = new GPlumModelHelper();
        oef = new PgGPlumBaseObjectEditorFactory();
    }
}

