/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.greenplum;

import com.intellij.database.dialects.greenplum.model.GPlumLocalTable;
import com.intellij.database.dialects.greenplum.model.GPlumPartition;
import com.intellij.database.dialects.greenplum.model.properties.GPlumPartitionTree;
import com.intellij.database.dialects.postgresgreenplumbase.PgGPlumBaseViewStructureProvider;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GPlumDatabaseViewStructureProvider
extends PgGPlumBaseViewStructureProvider {
    @Override
    @NotNull
    public JBIterable<? extends BasicElement> getChildren(@NotNull BasicElement element, @NotNull ObjectKind kind, @NotNull DatabaseViewOptions viewOptions) {
        if (element == null) {
            GPlumDatabaseViewStructureProvider.$$$reportNull$$$0(0);
        }
        if (kind == null) {
            GPlumDatabaseViewStructureProvider.$$$reportNull$$$0(1);
        }
        if (viewOptions == null) {
            GPlumDatabaseViewStructureProvider.$$$reportNull$$$0(2);
        }
        if (element instanceof GPlumPartition) {
            return GPlumDatabaseViewStructureProvider.getPartitionChildren((GPlumPartition)element);
        }
        JBIterable children2 = super.getChildren(element, kind, viewOptions);
        JBIterable jBIterable = element instanceof GPlumLocalTable ? children2.filter((Condition)new RootPartitionsFilter((GPlumLocalTable)element)) : children2;
        if (jBIterable == null) {
            GPlumDatabaseViewStructureProvider.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public List<ObjectKind> getFamilyKinds(@NotNull BasicElement element) {
        if (element == null) {
            GPlumDatabaseViewStructureProvider.$$$reportNull$$$0(4);
        }
        List<ObjectKind> list = element instanceof GPlumPartition ? Collections.singletonList(ObjectKind.PARTITION) : super.getFamilyKinds(element);
        if (list == null) {
            GPlumDatabaseViewStructureProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public BasicElement getParent(@NotNull BasicElement element) {
        if (element == null) {
            GPlumDatabaseViewStructureProvider.$$$reportNull$$$0(6);
        }
        if (element instanceof GPlumPartition) {
            GPlumPartition partition = (GPlumPartition)element;
            GPlumPartition parentPartition = partition.getParentPartition();
            return parentPartition == null ? partition.getParent() : parentPartition;
        }
        return super.getParent(element);
    }

    @NotNull
    private static JBIterable<? extends BasicElement> getPartitionChildren(@NotNull GPlumPartition partition) {
        GPlumLocalTable table;
        if (partition == null) {
            GPlumDatabaseViewStructureProvider.$$$reportNull$$$0(7);
        }
        GPlumPartitionTree tree = (table = partition.getLocalTable()) == null ? null : table.getPartitionsTree();
        long[] array = tree == null ? ArrayUtil.EMPTY_LONG_ARRAY : tree.getChildrenAsArray(partition.getObjectId());
        JBIterable jBIterable = JBIterable.from((Iterable)LongStream.of(array).mapToObj(id -> (GPlumPartition)table.getPartitions().getByObjectId(id)).filter(Objects::nonNull).collect(Collectors.toList()));
        if (jBIterable == null) {
            GPlumDatabaseViewStructureProvider.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewOptions";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/greenplum/GPlumDatabaseViewStructureProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/greenplum/GPlumDatabaseViewStructureProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPartitionChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFamilyKinds";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPartitionChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RootPartitionsFilter
    implements Condition<BasicElement> {
        private final GPlumLocalTable myTable;

        RootPartitionsFilter(@NotNull GPlumLocalTable table) {
            if (table == null) {
                RootPartitionsFilter.$$$reportNull$$$0(0);
            }
            this.myTable = table;
        }

        public boolean value(@NotNull BasicElement element) {
            if (element == null) {
                RootPartitionsFilter.$$$reportNull$$$0(1);
            }
            if (!(element instanceof GPlumPartition)) {
                return true;
            }
            GPlumPartition partition = (GPlumPartition)element;
            GPlumPartitionTree tree = this.myTable.getPartitionsTree();
            return tree == null || tree.getParent(partition.getObjectId()) == 0L;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/greenplum/GPlumDatabaseViewStructureProvider$RootPartitionsFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "value";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

