/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic.naming;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.AbstractNamingService;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.util.Casing;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/generic/naming/GenericNamingService;", "Lcom/intellij/database/dialects/base/generator/AbstractNamingService;", "aptNamePattern", "Ljava/util/regex/Pattern;", "aptPlainNamePattern", "(Ljava/util/regex/Pattern;Ljava/util/regex/Pattern;)V", "isPure", "", "name", "", "Companion", "intellij.database.dialects.generic"})
public final class GenericNamingService
extends AbstractNamingService {
    @NotNull
    private static final Pattern aptMixedCaseNamePattern;
    @NotNull
    private static final Pattern aptLowerCaseNamePattern;
    @NotNull
    private static final Pattern aptUpperCaseNamePattern;
    @NotNull
    public static final Companion Companion;

    @Override
    public boolean isPure(@NotNull String name2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (this.getCasing().plain == this.getCasing().quoted) {
            CharSequence charSequence = name2;
            Pattern pattern = this.getPlainNamePattern();
            boolean bl2 = false;
            pattern = new Regex(pattern);
            bl2 = false;
            bl = pattern.matches(charSequence);
        } else {
            CharSequence charSequence = name2;
            Pattern pattern = this.getNamePattern();
            boolean bl3 = false;
            pattern = new Regex(pattern);
            bl3 = false;
            bl = pattern.matches(charSequence);
        }
        return bl;
    }

    public GenericNamingService(@NotNull Pattern aptNamePattern, @NotNull Pattern aptPlainNamePattern) {
        Intrinsics.checkNotNullParameter((Object)aptNamePattern, (String)"aptNamePattern");
        Intrinsics.checkNotNullParameter((Object)aptPlainNamePattern, (String)"aptPlainNamePattern");
        Dbms dbms = Dbms.UNKNOWN;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"Dbms.UNKNOWN");
        Casing casing = CasingProvider.MIXED_CASING;
        Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"CasingProvider.MIXED_CASING");
        super(dbms, aptNamePattern, aptPlainNamePattern, casing);
    }

    static {
        Companion = new Companion(null);
        Pattern pattern = Pattern.compile("\\p{IsAlphabetic}[\\p{IsAlphabetic}\\d_]*");
        Intrinsics.checkNotNull((Object)pattern);
        aptMixedCaseNamePattern = pattern;
        Pattern pattern2 = Pattern.compile("\\p{IsLower}[\\p{IsLower}\\d_]*");
        Intrinsics.checkNotNull((Object)pattern2);
        aptLowerCaseNamePattern = pattern2;
        Pattern pattern3 = Pattern.compile("\\p{IsUpper}[\\p{IsUpper}\\d_]*");
        Intrinsics.checkNotNull((Object)pattern3);
        aptUpperCaseNamePattern = pattern3;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/generic/naming/GenericNamingService$Companion;", "", "()V", "aptLowerCaseNamePattern", "Ljava/util/regex/Pattern;", "getAptLowerCaseNamePattern", "()Ljava/util/regex/Pattern;", "aptMixedCaseNamePattern", "getAptMixedCaseNamePattern", "aptUpperCaseNamePattern", "getAptUpperCaseNamePattern", "intellij.database.dialects.generic"})
    public static final class Companion {
        @NotNull
        public final Pattern getAptMixedCaseNamePattern() {
            return aptMixedCaseNamePattern;
        }

        @NotNull
        public final Pattern getAptLowerCaseNamePattern() {
            return aptLowerCaseNamePattern;
        }

        @NotNull
        public final Pattern getAptUpperCaseNamePattern() {
            return aptUpperCaseNamePattern;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

