/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.exasol.model;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.exasol.model.ExaModelHelper$WhenMappings;
import com.intellij.database.dialects.exasol.model.ExaScript;
import com.intellij.database.dialects.exasol.model.ExaUser;
import com.intellij.database.dialects.exasol.model.ExaVirtualSchema;
import com.intellij.database.dialects.exasol.model.properties.ExaScriptType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ModelHelperCore;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/exasol/model/ExaModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "()V", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "Lcom/intellij/database/model/ModelHelperCore$ObjectKindVariant;", "vars", "", "", "generationVariants", "Lcom/intellij/util/containers/JBIterable;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "getIcon", "Ljavax/swing/Icon;", "o", "Lcom/intellij/database/model/DasObject;", "getName", "kind", "Lcom/intellij/database/model/ObjectKind;", "Companion", "intellij.database.dialects.exasol"})
public final class ExaModelHelper
extends ModelHelper {
    private static final ModelHelperCore.ObjectKindVariant SCRIPTING_SCRIPT;
    private static final ModelHelperCore.ObjectKindVariant UDF_SCRIPT;
    private static final ModelHelperCore.ObjectKindVariant ADAPTER_SCRIPT;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getName(@NotNull ObjectKind kind) {
        String string;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        ObjectKind objectKind = kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.EXTERNAL_SCHEMA)) {
            String string2 = DatabaseBundle.message((String)"ObjectKind.virtual.schema", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DatabaseBundle.message(\"\u2026jectKind.virtual.schema\")");
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_TABLE)) {
            String string3 = super.getName(ObjectKind.TABLE);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"super.getName(TABLE)");
        } else {
            String string4 = super.getName(kind);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"super.getName(kind)");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public Icon getIcon(@NotNull DasObject o2) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        DasObject dasObject = o2;
        if (!(dasObject instanceof ExaScript)) {
            dasObject = null;
        }
        ExaScript exaScript = (ExaScript)dasObject;
        ExaScriptType exaScriptType = exaScript != null ? exaScript.getScriptType() : null;
        if (exaScriptType != null) {
            switch (ExaModelHelper$WhenMappings.$EnumSwitchMapping$0[exaScriptType.ordinal()]) {
                case 1: {
                    icon = DatabaseIcons.Udf_script;
                    return icon;
                }
                case 2: {
                    icon = DatabaseIcons.Adapter_script;
                    return icon;
                }
                case 3: {
                    icon = DatabaseIcons.Scripting_script;
                    return icon;
                }
            }
        }
        icon = super.getIcon(o2);
        return icon;
    }

    @NotNull
    public JBIterable<ModelHelperCore.ObjectKindVariant> generationVariants(@NotNull BasicMetaObject<?> meta) {
        JBIterable jBIterable;
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        ObjectKind objectKind = meta.kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE)) {
            JBIterable jBIterable2 = JBIterable.of((Object)ModelHelper.FUNCTION);
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"JBIterable.of(FUNCTION)");
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SCRIPT)) {
            JBIterable jBIterable3 = JBIterable.of((Object[])new ModelHelperCore.ObjectKindVariant[]{SCRIPTING_SCRIPT, UDF_SCRIPT, ADAPTER_SCRIPT});
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"JBIterable.of(SCRIPTING_\u2026F_SCRIPT, ADAPTER_SCRIPT)");
        } else {
            JBIterable jBIterable4 = super.generationVariants(meta);
            jBIterable = jBIterable4;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"super.generationVariants(meta)");
        }
        return jBIterable;
    }

    public void fillPropertiesWithExamples(@NotNull BasicModElement e2, @NotNull ModelHelperCore.ObjectKindVariant variant, @NotNull Map<String, String> vars) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        super.fillPropertiesWithExamples(e2, variant, vars);
        if (e2 instanceof ExaUser) {
            ((ExaUser)e2).setPassword(new OneTimeString(""));
            vars.put("password", "\"\"");
        }
        if (e2 instanceof ExaScript) {
            ModelHelperCore.ObjectKindVariant objectKindVariant = variant;
            if (Intrinsics.areEqual((Object)objectKindVariant, (Object)ADAPTER_SCRIPT)) {
                ((ExaScript)e2).setScriptType(ExaScriptType.ADAPTER);
            } else if (Intrinsics.areEqual((Object)objectKindVariant, (Object)UDF_SCRIPT)) {
                ((ExaScript)e2).setScriptType(ExaScriptType.UDF);
                BasicModArgument basicModArgument = ((ExaScript)e2).createOrGetReturnArgument();
                Intrinsics.checkNotNullExpressionValue((Object)basicModArgument, (String)"e.createOrGetReturnArgument()");
                basicModArgument.setDataType(DataTypeFactory.of((String)"varchar"));
                vars.put("scalar", "scalar");
                vars.put("return", "varchar");
            } else {
                ((ExaScript)e2).setScriptType(ExaScriptType.SCRIPTING);
                vars.put("args", "arg1");
                vars.put("return", "table");
            }
        }
        if (e2 instanceof ExaVirtualSchema) {
            ((ExaVirtualSchema)e2).setAdapterSchema("MY_SCHEMA");
            ((ExaVirtualSchema)e2).setAdapterName("MY_ADAPTER");
            vars.put("adapter", "MY_SCHEMA.MY_ADAPTER");
        }
    }

    static {
        Companion = new Companion(null);
        SCRIPTING_SCRIPT = new ModelHelperCore.ObjectKindVariant(DatabaseBundle.messagePointer((String)"ObjectKindVariant.scripting.script", (Object[])new Object[0]));
        UDF_SCRIPT = new ModelHelperCore.ObjectKindVariant(DatabaseBundle.messagePointer((String)"ObjectKindVariant.udf.script", (Object[])new Object[0]));
        ADAPTER_SCRIPT = new ModelHelperCore.ObjectKindVariant(DatabaseBundle.messagePointer((String)"ObjectKindVariant.adapter.script", (Object[])new Object[0]));
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/exasol/model/ExaModelHelper$Companion;", "", "()V", "ADAPTER_SCRIPT", "Lcom/intellij/database/model/ModelHelperCore$ObjectKindVariant;", "SCRIPTING_SCRIPT", "UDF_SCRIPT", "intellij.database.dialects.exasol"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

