/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.exasol;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExaDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    protected ExaDialect() {
        super(new TypeHelper.ExaTypeHelper());
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.EXASOL;
        if (dbms == null) {
            ExaDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @NotNull
    public String getDisplayName() {
        return "Exasol";
    }

    @Override
    public boolean supportsTableDefinition() {
        return false;
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            ExaDialect.$$$reportNull$$$0(1);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA && current.kind != ObjectKind.EXTERNAL_SCHEMA) {
            return null;
        }
        String schema = this.getNamingService().catToScript(current.getName(), current.kind, this.getCodeStyle().getQuotesPriority());
        return String.format("open schema %s", schema);
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            ExaDialect.$$$reportNull$$$0(2);
        }
        if (sequence == null) {
            ExaDialect.$$$reportNull$$$0(3);
        }
        throw new UnsupportedOperationException("Unsupported");
    }

    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            ExaDialect.$$$reportNull$$$0(4);
        }
        String name2 = element.getName();
        String schema = DasUtil.getSchema((DasObject)element);
        return Pair.create((Object)("SELECT VIEW_TEXT FROM SYS.EXA_USER_VIEWS WHERE VIEW_SCHEMA = '" + schema.replace("'", "''") + "' AND VIEW_NAME = '" + name2.replace("'", "''") + "'"), (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            ExaDialect.$$$reportNull$$$0(5);
        }
        String name2 = element.getName();
        String schema = DasUtil.getSchema((DasObject)element);
        Pair pair = Pair.create((Object)("SELECT FUNCTION_TEXT FROM SYS.EXA_USER_FUNCTIONS WHERE FUNCTION_SCHEMA = '" + schema.replace("'", "''") + "' AND FUNCTION_NAME = '" + name2.replace("'", "''") + "'"), (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            ExaDialect.$$$reportNull$$$0(6);
        }
        return pair;
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        DasObject schema;
        if (identifier == null) {
            ExaDialect.$$$reportNull$$$0(7);
        }
        if (qualifier == null) {
            ExaDialect.$$$reportNull$$$0(8);
        }
        DasObject schemaOrExternal = (schema = DasUtil.getSchemaObject((DasObject)qualifier)) == null ? DasUtil.getParentOfKind((DasObject)qualifier, (ObjectKind)ObjectKind.EXTERNAL_SCHEMA, (boolean)false) : schema;
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schemaOrExternal, DasUtil.getName((DasObject)schemaOrExternal), null, null, null, null);
        if (ddlBuilder == null) {
            ExaDialect.$$$reportNull$$$0(9);
        }
        return ddlBuilder;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/exasol/ExaDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/exasol/ExaDialect";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

