/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.derby;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.EitherKt;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.AbstractDefinitionProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.util.PairConsumer;
import org.jetbrains.annotations.NotNull;

public class DerbyDefinitionProvider
extends AbstractDefinitionProvider {
    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            DerbyDefinitionProvider.$$$reportNull$$$0(0);
        }
        return (kind = object.getKind()) == ObjectKind.VIEW;
    }

    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnection connection, @NotNull PairConsumer<DasObject, Object> consumer) {
        if (objects == null) {
            DerbyDefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            DerbyDefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            DerbyDefinitionProvider.$$$reportNull$$$0(3);
        }
        String text = "SELECT v.VIEWDEFINITION FROM sys.SYSVIEWS v JOIN sys.SYSTABLES t ON v.TABLEID = t.TABLEID JOIN sys.SYSSCHEMAS s ON s.SCHEMAID = t.SCHEMAID WHERE t.TABLENAME = ? AND s.SCHEMANAME = ?";
        try (ReusableSmartStatement statement = SmartStatements.poweredBy((DatabaseConnection)connection).parameterized().reuse(text);){
            for (DasObject dasObject : objects) {
                consumer.consume((Object)dasObject, EitherKt.any((Either)statement.execute((Object)new StatementParameters().text(dasObject.getName()).text(DasUtil.getSchema((DasObject)dasObject)).asDecoration(), StandardResultsProcessors.FIRST_STRING)));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/derby/DerbyDefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

