/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2.model;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.dialects.db2.model.Db2IndexExtension;
import com.intellij.database.dialects.db2.model.Db2IndexExtensionArgument;
import com.intellij.database.dialects.db2.model.Db2Table;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.sql.dialects.SqlLanguageDialect;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/db2/model/Db2DescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeIndexExtension", "", "project", "Lcom/intellij/openapi/project/Project;", "o", "Lcom/intellij/database/dialects/db2/model/Db2IndexExtension;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "describeTable", "Lcom/intellij/database/dialects/db2/model/Db2Table;", "updatePresentation", "Lcom/intellij/database/model/DasObject;", "intellij.database.dialects.db2"})
public final class Db2DescriptionService
extends DescriptionService {
    public void updatePresentation(@NotNull Project project, @NotNull DasObject o2, @NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        DasObject dasObject = o2;
        if (dasObject instanceof Db2IndexExtension) {
            this.describeIndexExtension(project, (Db2IndexExtension)o2, presentation);
        } else {
            super.updatePresentation(project, o2, presentation);
        }
    }

    @NotNull
    public String content(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e2;
        return basicElement instanceof Db2Table ? this.describeTable((Db2Table)e2, context) : super.content(e2, context);
    }

    private final String describeTable(Db2Table o2, DescriptionService.Context context) {
        Db2Table db2Table = o2;
        if (db2Table == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicTable");
        }
        String res2 = this.describeTable((BasicTable)db2Table, context);
        Collection collection = context.getDescribed();
        Object object = Db2Table.CLUSTERING_INDEX_NAMES;
        boolean bl = false;
        collection.add(object);
        List<String> list = o2.getClusteringIndexNames();
        Intrinsics.checkNotNullExpressionValue(list, (String)"o.clusteringIndexNames");
        List<String> ci = list;
        object = ci;
        bl = false;
        if (!object.isEmpty()) {
            res2 = res2 + " clustering indices (" + CollectionsKt.joinToString$default((Iterable)ci, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(this, o2, context){
                final /* synthetic */ Db2DescriptionService this$0;
                final /* synthetic */ Db2Table $o;
                final /* synthetic */ DescriptionService.Context $context;

                @NotNull
                public final CharSequence invoke(String it) {
                    String string = Db2DescriptionService.access$objectName(this.this$0, it, (BasicElement)this.$o.getIndices().get(it), this.$context);
                    return string != null ? (CharSequence)string : (CharSequence)"";
                }
                {
                    this.this$0 = db2DescriptionService;
                    this.$o = db2Table;
                    this.$context = context;
                    super(1);
                }
            }), (int)31, null) + ')';
        }
        return res2;
    }

    private final void describeIndexExtension(Project project, Db2IndexExtension o2, PresentationData presentation) {
        DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource((DasObject)o2);
        DatabaseDialectEx databaseDialectEx = dataSource != null ? DbImplUtil.getDatabaseDialect((DbElement)((DbElement)dataSource)) : DatabaseDialects.getGenericDialect();
        Intrinsics.checkNotNullExpressionValue((Object)databaseDialectEx, (String)"if (dataSource != null) \u2026lects.getGenericDialect()");
        DatabaseDialectEx dialect = databaseDialectEx;
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect((DbElement)((DbElement)dataSource));
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"DbSqlUtil.getSqlDialect(dataSource)");
        SqlLanguageDialect sqlDialect = sqlLanguageDialect;
        DdlBuilder builder = new DdlBuilder().applyCodeStyle(project, sqlDialect).withDialect(dialect);
        builder.symbol("(");
        boolean first2 = true;
        for (Db2IndexExtensionArgument parameter : o2.getIndexExtensionArguments()) {
            if (first2) {
                first2 = false;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)builder.symbol(",").space(), (String)"builder.symbol(\",\").space()");
            }
            Db2IndexExtensionArgument db2IndexExtensionArgument = parameter;
            Intrinsics.checkNotNullExpressionValue((Object)db2IndexExtensionArgument, (String)"parameter");
            builder.type(db2IndexExtensionArgument.getDataType());
        }
        builder.symbol(")");
        DdlBuilder ddlBuilder = builder;
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"builder");
        presentation.addText(ddlBuilder.getStatement(), DbPresentationCore.INFO_ATTRS);
    }

    public static final /* synthetic */ String access$objectName(Db2DescriptionService $this, String name2, BasicElement obj2, DescriptionService.Context context) {
        return $this.objectName(name2, obj2, context);
    }
}

