/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.NumberDomain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Db2Domains
extends BaseDomainRegistry {
    private static final short MAX_DB2_GRAPHIC = 127;
    private static final short MAX_VARGRAPHIC = 16336;
    private static final short MAX_DECIMAL_PRECISION = 31;
    private static final double MIN_DOUBLE = -7.2E75;
    private static final double MAX_DOUBLE = 7.2E75;
    private static final int DB2_MAX_TS_PRECISION = 12;
    private static final int MAX_VARCHAR_LENGTH = 32672;
    private static final int DBCLOB = 0x3FFFFFFF;

    public Db2Domains() {
        this.add(new BinaryDomain("blob", ConversionPoint.BLOB, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new IntegerDomain("int", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new TextDomain("vargraphic", ConversionPoint.TEXT_GRAPHIC, 16336L, TextDomain.Length.mandatory((long)16336L, (boolean)true)).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new TextDomain("graphic", ConversionPoint.TEXT_GRAPHIC, 127L, -1L, true, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, 31, 31, true));
        this.add((Domain)new Number2Domain("numeric", ConversionPoint.BIG_DECIMAL, 31, 31, true));
        this.add((Domain)new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, -7.2E75, 7.2E75));
        this.add((Domain)new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, -7.2E75, 7.2E75));
        this.add((Domain)new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -7.2E75, 7.2E75));
        this.add(new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 0, -1, false));
        this.add(new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 12, -1, true).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new TextDomain("varchar", ConversionPoint.VARCHAR, 32672L, TextDomain.Length.mandatory((long)32672L, (boolean)true)));
        this.add(new TextDomain("clob", ConversionPoint.CLOB, Integer.MAX_VALUE, -1L, true, true).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new TextDomain("dbclob", ConversionPoint.CLOB, 0x3FFFFFFFL, -1L, true, true).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new TextDomain("char", ConversionPoint.CHAR, 127L, 1L, true, false));
        this.add((Domain)new TextDomain("character", ConversionPoint.CHAR, 127L, 1L, true, false));
        this.add(new TextDomain("xml", ConversionPoint.XML, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new DecfloatDomain(34));
    }

    private static class DecfloatDomain
    extends NumberDomain {
        private static final int DEFAULT_DIGITS = 16;
        private static final int MAX_DIGITS = 34;
        private static final DomainRegistry.Limits LIMITS = new DomainRegistry.Limits(new DomainRegistry.Limit[]{new DomainRegistry.Limit((Number)16, (Number)384, (Number)384), new DomainRegistry.Limit((Number)34, (Number)6143, (Number)6143)});
        private final int myDigits;

        protected DecfloatDomain(int digits) {
            super("decfloat", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE);
            this.myDigits = digits;
        }

        @NotNull
        public Cardinality cardinality() {
            return new Cardinality.ScalableCardinality(this.myDigits);
        }

        @NotNull
        public Domain narrow(@NotNull Domain domain) {
            if (domain == null) {
                DecfloatDomain.$$$reportNull$$$0(0);
            }
            DecfloatDomain decfloatDomain = domain instanceof Number2Domain ? new DecfloatDomain(LIMITS.minParameterValue((Number)((Number2Domain)domain).getMaxPrecision()).intValue()) : (domain instanceof NumberDomain ? new DecfloatDomain(34) : this);
            if (decfloatDomain == null) {
                DecfloatDomain.$$$reportNull$$$0(1);
            }
            return decfloatDomain;
        }

        @NotNull
        public Domain narrow(@NotNull SizeProvider provider) {
            if (provider == null) {
                DecfloatDomain.$$$reportNull$$$0(2);
            }
            return new DecfloatDomain(LIMITS.minParameterValue((Number)provider.getSize()).intValue());
        }

        @NotNull
        public Compatibility getCompatibility(@NotNull Domain domain) {
            if (domain == null) {
                DecfloatDomain.$$$reportNull$$$0(3);
            }
            Compatibility compatibility = domain instanceof DecfloatDomain ? Compatibility.full((Cardinality)this.cardinality(), (LogicalType)domain.getLogicType(), (LogicalType)this.getLogicType()) : (domain instanceof Number2Domain || domain instanceof NumberDomain ? Compatibility.compatibleLossy((Cardinality)this.cardinality(), (LogicalType)domain.getLogicType(), (LogicalType)this.getLogicType()) : Compatibility.incompatible());
            if (compatibility == null) {
                DecfloatDomain.$$$reportNull$$$0(4);
            }
            return compatibility;
        }

        @Nullable
        public Object trim(@NotNull Object o2) {
            if (o2 == null) {
                DecfloatDomain.$$$reportNull$$$0(5);
            }
            return o2;
        }

        @NotNull
        public String name() {
            String string = super.name() + (this.myDigits == 16 ? "" : String.format("(%s)", this.myDigits));
            if (string == null) {
                DecfloatDomain.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domain";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/db2/Db2Domains$DecfloatDomain";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/db2/Db2Domains$DecfloatDomain";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "narrow";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompatibility";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "narrow";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompatibility";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "trim";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

