/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.base.BaseDmlHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/db2/Db2BaseDmlHelper;", "Lcom/intellij/database/dialects/base/BaseDmlHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "needAliasInDeleteStatement", "", "getNeedAliasInDeleteStatement", "()Z", "appendLimit", "Lcom/intellij/database/util/DdlBuilder;", "builder", "dialect", "Lcom/intellij/database/dialects/DatabaseDialectEx;", "limit", "", "offset", "atBeginning", "appendRowId", "alias", "", "isEditableTable", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.dialects.db2"})
public final class Db2BaseDmlHelper
extends BaseDmlHelper {
    private final boolean needAliasInDeleteStatement;

    @Override
    public boolean getNeedAliasInDeleteStatement() {
        return this.needAliasInDeleteStatement;
    }

    @Override
    @NotNull
    public DdlBuilder appendLimit(@NotNull DdlBuilder builder, @NotNull DatabaseDialectEx dialect, int limit, int offset, boolean atBeginning) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        return DbImplUtil.isPageSizeUnlimited((int)limit) ? builder : this.fetchFirst(builder, limit);
    }

    @Override
    @NotNull
    public DdlBuilder appendRowId(@NotNull DdlBuilder builder, @NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        DdlBuilder ddlBuilder = builder.symbol(",").space().identifier("RID").symbol("(").plain(alias).symbol(")").space().keyword("as").space().identifier("RID(" + alias + ')');
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"builder.symbol(\",\").spac\u2026identifier(\"RID($alias)\")");
        return ddlBuilder;
    }

    @Override
    public boolean isEditableTable(@Nullable ObjectKind kind) {
        ObjectKind objectKind = kind;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW) ? true : super.isEditableTable(kind);
    }

    public Db2BaseDmlHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
        this.needAliasInDeleteStatement = true;
    }
}

