/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.EitherKt;
import com.intellij.database.dataSource.connection.statements.CallableSmartStatement;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.DatabaseDialectHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class Db2BaseDialectHelper
extends DatabaseDialectHelper {
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            Db2BaseDialectHelper.$$$reportNull$$$0(0);
        }
        if (connection == null) {
            Db2BaseDialectHelper.$$$reportNull$$$0(1);
        }
        Dbms dbms = connection.getDbms();
        Map map2 = DbImplUtil.resultRowAsMap((DatabaseConnection)connection, (String)String.format("SELECT tabname, card, collationname, create_time FROM syscat.tables WHERE owner = '%s' AND tabname LIKE '%s' ESCAPE '#'", DbImplUtil.escapeStr((String)DasUtil.getSchema((DasObject)element)), DbImplUtil.escapeSql((Object)element.getName(), (boolean)true, (Dbms)dbms)), (String[])new String[]{"CARD", "rows", "COLLATIONNAME", "collation", "CREATE_TIME", "created"});
        if (map2 == null) {
            Db2BaseDialectHelper.$$$reportNull$$$0(2);
        }
        return map2;
    }

    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) throws SQLException {
        Dbms dbms;
        String s;
        if (system == null) {
            Db2BaseDialectHelper.$$$reportNull$$$0(3);
        }
        if (connection == null) {
            Db2BaseDialectHelper.$$$reportNull$$$0(4);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults((DatabaseConnection)connection, (Dbms)(dbms = connection.getDbms()), (String)"select current_schema from sysibm.sysdummy1", (int)1, (DbImplUtilCore.ConcatenationProps)DbImplUtilCore.ConcatenationProps.LINES))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        if (table == null) {
            Db2BaseDialectHelper.$$$reportNull$$$0(5);
        }
        if (connection == null) {
            Db2BaseDialectHelper.$$$reportNull$$$0(6);
        }
        CallableSmartStatement statement = SmartStatements.poweredBy((DatabaseConnection)connection).call();
        CallableStatementData data = new StatementParameters().text(QNameUtil.getQualifiedName((DasObject)table)).parameter(2, 4).asCallData("CALL SYSPROC.DB2LK_GENERATE_DDL('-e -td ; -t ' || ?, ?)");
        Either token = statement.execute((Object)data, (ExecutionMode)StandardExecutionMode.UPDATE, StandardResultsProcessors.parameterRetriever((int)2));
        Dbms dbms = connection.getDbms();
        String string = token.isLeft() ? "Failed to load table definition" : StringUtil.trimEnd((String)DbImplUtil.concatStringResults((DatabaseConnection)connection, (Dbms)dbms, (String)("SELECT SQL_STMT FROM SYSTOOLS.DB2LOOK_INFO WHERE OP_TOKEN = " + EitherKt.tryGet((Either)token)), (int)1, (DbImplUtilCore.ConcatenationProps)DbImplUtilCore.ConcatenationProps.NO_CONCAT), (String)";");
        if (string == null) {
            Db2BaseDialectHelper.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/db2/Db2BaseDialectHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/db2/Db2BaseDialectHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

