/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.couchbase.introspector;

import com.intellij.database.dialects.couchbase.introspector.MapConverter;
import com.intellij.database.dialects.couchbase.introspector.QueryDescriptor;
import com.intellij.database.remote.jdba.core.Layouts;
import com.intellij.database.remote.jdba.core.RowLayout;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u000b\u0018\u0000 '2\u00020\u0001:\b'()*+,-.B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00042\u0006\u0010\u001b\u001a\u00020\u0013J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00042\u0006\u0010\u001e\u001a\u00020\u0013J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00042\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0013J<\u0010\"\u001a,\u0012(\u0012&\u0012\f\u0012\n %*\u0004\u0018\u00010\u00010\u0001 %*\u0012\u0012\f\u0012\n %*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\u00120$0#2\b\b\u0001\u0010&\u001a\u00020\u0013H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006/"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries;", "", "()V", "retrieveIndices", "Lcom/intellij/database/dialects/couchbase/introspector/QueryDescriptor;", "Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneIndex;", "getRetrieveIndices", "()Lcom/intellij/database/dialects/couchbase/introspector/QueryDescriptor;", "retrieveIndicesAdditional", "Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneIndexAdditional;", "getRetrieveIndicesAdditional", "retrieveSchemas", "Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneSchema;", "getRetrieveSchemas", "retrieveTables", "Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneTable;", "getRetrieveTables", "systemKeyspaces", "", "", "getSystemKeyspaces", "()Ljava/util/List;", "systemSchema", "getSystemSchema", "()Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneSchema;", "inferTableSchema", "Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneInferTableInfo;", "bucket", "retrieveTableAdditional", "Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneTableSettings;", "bucketName", "retrieveTableColumns", "Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneTableColumns;", "schema", "sqlQuery", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "", "kotlin.jvm.PlatformType", "sql", "Companion", "OneIndex", "OneIndexAdditional", "OneInferTableInfo", "OneSchema", "OneTable", "OneTableColumns", "OneTableSettings", "intellij.database.dialects.couchbase"})
public final class CouchbaseIntroQueries {
    @NotNull
    private final QueryDescriptor<OneSchema> retrieveSchemas = new QueryDescriptor<OneSchema>(this.sqlQuery("SELECT datastore_id, id, name FROM system:namespaces;"), new MapConverter<OneSchema>(OneSchema.class));
    @NotNull
    private final OneSchema systemSchema;
    @NotNull
    private final QueryDescriptor<OneTable> retrieveTables;
    @NotNull
    private final List<String> systemKeyspaces;
    @NotNull
    private final QueryDescriptor<OneIndex> retrieveIndices;
    @NotNull
    private final QueryDescriptor<OneIndexAdditional> retrieveIndicesAdditional;
    @NotNull
    private static final CouchbaseIntroQueries QUERIES;
    @NotNull
    public static final Companion Companion;

    private final SqlQuery<List<Object>> sqlQuery(@Language(value="SQL") String sql) {
        return new SqlQuery(sql, Layouts.listOf((RowLayout)Layouts.oneOf(Object.class)));
    }

    @NotNull
    public final QueryDescriptor<OneSchema> getRetrieveSchemas() {
        return this.retrieveSchemas;
    }

    @NotNull
    public final OneSchema getSystemSchema() {
        return this.systemSchema;
    }

    @NotNull
    public final QueryDescriptor<OneTable> getRetrieveTables() {
        return this.retrieveTables;
    }

    @NotNull
    public final QueryDescriptor<OneTableSettings> retrieveTableAdditional(@NotNull String bucketName) {
        Intrinsics.checkNotNullParameter((Object)bucketName, (String)"bucketName");
        return new QueryDescriptor<OneTableSettings>(this.sqlQuery("DESCRIBE BUCKET SETTINGS `" + bucketName + '`'), new MapConverter<OneTableSettings>(OneTableSettings.class));
    }

    @NotNull
    public final List<String> getSystemKeyspaces() {
        return this.systemKeyspaces;
    }

    @NotNull
    public final QueryDescriptor<OneTableColumns> retrieveTableColumns(@NotNull String schema, @NotNull String bucket) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        return new QueryDescriptor<OneTableColumns>(this.sqlQuery("DESCRIBE BUCKET COLUMNS " + schema + ":`" + bucket + '`'), new MapConverter<OneTableColumns>(OneTableColumns.class));
    }

    @NotNull
    public final QueryDescriptor<OneInferTableInfo> inferTableSchema(@NotNull String bucket) {
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        return new QueryDescriptor<OneInferTableInfo>(this.sqlQuery("INFER `" + bucket + "` WITH {'num_sample_values': 0, 'similarity_metric': 0}"), new MapConverter<OneInferTableInfo>(OneInferTableInfo.class));
    }

    @NotNull
    public final QueryDescriptor<OneIndex> getRetrieveIndices() {
        return this.retrieveIndices;
    }

    @NotNull
    public final QueryDescriptor<OneIndexAdditional> getRetrieveIndicesAdditional() {
        return this.retrieveIndicesAdditional;
    }

    public CouchbaseIntroQueries() {
        OneSchema oneSchema = new OneSchema();
        boolean bl = false;
        boolean bl2 = false;
        OneSchema oneSchema2 = oneSchema;
        CouchbaseIntroQueries couchbaseIntroQueries = this;
        boolean bl3 = false;
        $this$apply.id = "system";
        $this$apply.name = "system";
        Unit unit = Unit.INSTANCE;
        couchbaseIntroQueries.systemSchema = oneSchema;
        this.retrieveTables = new QueryDescriptor<OneTable>(this.sqlQuery("SELECT datastore_id, id, name, namespace_id FROM system:keyspaces WHERE namespace_id = ?;"), new MapConverter<OneTable>(OneTable.class));
        this.systemKeyspaces = CollectionsKt.listOf((Object[])new String[]{"datastores", "namespaces", "keyspaces", "indexes", "prepareds", "completed_requests", "active_requests", "my_user_info", "user_info", "nodes", "applicable_roles", "dual"});
        this.retrieveIndices = new QueryDescriptor<OneIndex>(this.sqlQuery("SELECT id AS index_id, name, datastore_id, namespace_id, keyspace_id, \n      index_key, `using`, state, condition, is_primary, `partition`\n      FROM system:indexes WHERE namespace_id = ?;"), new MapConverter<OneIndex>(OneIndex.class));
        this.retrieveIndicesAdditional = new QueryDescriptor<OneIndexAdditional>(this.sqlQuery("DESCRIBE INDEXES"), new MapConverter<OneIndexAdditional>(OneIndexAdditional.class));
    }

    static {
        Companion = new Companion(null);
        QUERIES = new CouchbaseIntroQueries();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneSchema;", "", "()V", "datastoreId", "", "getDatastoreId", "()Ljava/lang/String;", "datastore_id", "id", "name", "intellij.database.dialects.couchbase"})
    public static final class OneSchema {
        @JvmField
        @NotNull
        public String id = "";
        @JvmField
        @Nullable
        public String name;
        @JvmField
        @Nullable
        public String datastore_id;

        @Nullable
        public final String getDatastoreId() {
            return this.datastore_id;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0006R\u0014\u0010\f\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneTable;", "", "()V", "datastoreId", "", "getDatastoreId", "()Ljava/lang/String;", "datastore_id", "id", "name", "namespaceId", "getNamespaceId", "namespace_id", "intellij.database.dialects.couchbase"})
    public static final class OneTable {
        @JvmField
        @Nullable
        public String id;
        @JvmField
        @Nullable
        public String name;
        @JvmField
        @Nullable
        public String namespace_id;
        @JvmField
        @Nullable
        public String datastore_id;

        @Nullable
        public final String getDatastoreId() {
            return this.datastore_id;
        }

        @Nullable
        public final String getNamespaceId() {
            return this.namespace_id;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u0012\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneTableSettings;", "", "()V", "bucketType", "", "compressionMode", "conflictResolutionType", "evictionPolicy", "flushEnabled", "", "Ljava/lang/Boolean;", "maxTTL", "", "Ljava/lang/Integer;", "ramQuotaMB", "", "Ljava/lang/Long;", "replicaIndexes", "replicaNumber", "intellij.database.dialects.couchbase"})
    public static final class OneTableSettings {
        @JvmField
        @Nullable
        public Boolean flushEnabled;
        @JvmField
        @Nullable
        public Long ramQuotaMB;
        @JvmField
        @Nullable
        public Integer replicaNumber;
        @JvmField
        @Nullable
        public Boolean replicaIndexes;
        @JvmField
        @Nullable
        public Integer maxTTL;
        @JvmField
        @Nullable
        public String compressionMode;
        @JvmField
        @Nullable
        public String bucketType;
        @JvmField
        @Nullable
        public String conflictResolutionType;
        @JvmField
        @Nullable
        public String evictionPolicy;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneTableColumns;", "", "()V", "name", "", "type", "", "Ljava/lang/Integer;", "typeName", "intellij.database.dialects.couchbase"})
    public static final class OneTableColumns {
        @JvmField
        @Nullable
        public String name;
        @JvmField
        @Nullable
        public Integer type;
        @JvmField
        @Nullable
        public String typeName;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneInferTableInfo;", "", "()V", "properties", "", "intellij.database.dialects.couchbase"})
    public static final class OneInferTableInfo {
        @JvmField
        @Nullable
        public Map<Object, ? extends Object> properties;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0019\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007R\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0007R\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneIndex;", "", "()V", "condition", "", "datastoreId", "getDatastoreId", "()Ljava/lang/String;", "datastore_id", "indexId", "getIndexId", "indexKey", "", "getIndexKey", "()Ljava/util/List;", "index_id", "index_key", "isPrimary", "", "()Z", "is_primary", "keyspaceId", "getKeyspaceId", "keyspace_id", "name", "namespaceId", "getNamespaceId", "namespace_id", "partition", "state", "using", "intellij.database.dialects.couchbase"})
    public static final class OneIndex {
        @JvmField
        @Nullable
        public String index_id;
        @JvmField
        @Nullable
        public String name;
        @JvmField
        @Nullable
        public String keyspace_id;
        @JvmField
        @Nullable
        public String namespace_id;
        @JvmField
        @Nullable
        public String datastore_id;
        @JvmField
        @Nullable
        public List<String> index_key;
        @JvmField
        @Nullable
        public String using;
        @JvmField
        @Nullable
        public String state;
        @JvmField
        @Nullable
        public String condition;
        @JvmField
        public boolean is_primary;
        @JvmField
        @Nullable
        public String partition;

        @Nullable
        public final String getIndexId() {
            return this.index_id;
        }

        @Nullable
        public final String getDatastoreId() {
            return this.datastore_id;
        }

        @Nullable
        public final String getNamespaceId() {
            return this.namespace_id;
        }

        @Nullable
        public final String getKeyspaceId() {
            return this.keyspace_id;
        }

        @Nullable
        public final List<String> getIndexKey() {
            return this.index_key;
        }

        public final boolean isPrimary() {
            return this.is_primary;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneIndexAdditional;", "", "()V", "bucket", "", "definition", "indexName", "numPartition", "", "Ljava/lang/Integer;", "numReplica", "intellij.database.dialects.couchbase"})
    public static final class OneIndexAdditional {
        @JvmField
        @Nullable
        public String indexName;
        @JvmField
        @Nullable
        public Integer numReplica;
        @JvmField
        @Nullable
        public String definition;
        @JvmField
        @Nullable
        public String bucket;
        @JvmField
        @Nullable
        public Integer numPartition;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$Companion;", "", "()V", "QUERIES", "Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries;", "getQUERIES", "()Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries;", "intellij.database.dialects.couchbase"})
    public static final class Companion {
        @NotNull
        public final CouchbaseIntroQueries getQUERIES() {
            return QUERIES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

