/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.couchbase;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CouchbaseDialect
extends AbstractDatabaseDialect {
    public static final String SYSTEM_SCHEMA = "system";
    public static final String DEFAULT_SCHEMA = "default";

    public CouchbaseDialect() {
        super(new TypeHelper(){

            @Override
            public String getTypeName(int code, int length, int precision, int scale) {
                return null;
            }
        });
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.COUCHBASE_QUERY;
        if (dbms == null) {
            CouchbaseDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @NotNull
    public String getDisplayName() {
        return "Couchbase Query";
    }

    @Override
    public boolean hasRowId(@Nullable Version version) {
        return true;
    }

    public boolean hideRowId() {
        return false;
    }

    public boolean isTwoPhaseSelect(@NotNull DasTable table) {
        DasObject parent2;
        if (table == null) {
            CouchbaseDialect.$$$reportNull$$$0(1);
        }
        return (parent2 = table.getDasParent()) != null && StringUtil.equalsIgnoreCase((CharSequence)DEFAULT_SCHEMA, (CharSequence)parent2.getName()) && !DbImplUtil.hasUniqueIndex((DasTable)table);
    }

    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            CouchbaseDialect.$$$reportNull$$$0(2);
        }
        if (sequence == null) {
            CouchbaseDialect.$$$reportNull$$$0(3);
        }
        throw new UnsupportedOperationException(DatabaseBundle.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            CouchbaseDialect.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    public boolean supportsProcedureDefinition() {
        return false;
    }

    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            CouchbaseDialect.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException("Not supported");
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return false;
    }

    public boolean supportsEmptyTables() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return false;
    }

    @Override
    public boolean supportsSchemaChanging() {
        return false;
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        String schemaName;
        if (identifier == null) {
            CouchbaseDialect.$$$reportNull$$$0(6);
        }
        if (qualifier == null) {
            CouchbaseDialect.$$$reportNull$$$0(7);
        }
        if (SYSTEM_SCHEMA.equalsIgnoreCase(schemaName = DasUtil.getName((DasObject)DasUtil.getSchemaObject((DasObject)qualifier)))) {
            builder.plain(schemaName).symbol(":");
        }
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, null, null, null, null, null, null);
        if (ddlBuilder == null) {
            CouchbaseDialect.$$$reportNull$$$0(8);
        }
        return ddlBuilder;
    }

    @Override
    public String quoteIdentifier(String identifier, boolean force, boolean suppress, @NotNull Casing casing, @Nullable ObjectKind kind) {
        if (casing == null) {
            CouchbaseDialect.$$$reportNull$$$0(9);
        }
        if (!force && identifier.contains(".")) {
            return identifier;
        }
        return super.quoteIdentifier(identifier, force, suppress, casing, kind);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/couchbase/CouchbaseDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/couchbase/CouchbaseDialect";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isTwoPhaseSelect";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "quoteIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

