/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.couchbase;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.json.json5.Json5Language;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/couchbase/CouchGridHelper;", "Lcom/intellij/database/datagrid/GridHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "getCellLanguage", "Lcom/intellij/lang/Language;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "row", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/DataConsumer$Row;", "column", "Lcom/intellij/database/datagrid/DataConsumer$Column;", "intellij.database.dialects.couchbase"})
public final class CouchGridHelper
implements GridHelper {
    @NotNull
    private final Dbms dbms;

    @Nullable
    public Language getCellLanguage(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        Object value = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(row, column2);
        return value instanceof Map || value instanceof List ? (Language)Json5Language.INSTANCE : GridHelper.DefaultImpls.getCellLanguage((GridHelper)this, (DataGrid)grid, row, column2);
    }

    @NotNull
    public Dbms getDbms() {
        return this.dbms;
    }

    public CouchGridHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.dbms = dbms;
    }

    @Nullable
    public Language getCellLanguage(@NotNull Domain domain) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        return GridHelper.DefaultImpls.getCellLanguage((GridHelper)this, (Domain)domain);
    }

    @Nullable
    public PsiCodeFragment createCellCodeFragment(@NotNull String text, @NotNull Project project, @NotNull Domain domain) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        return GridHelper.DefaultImpls.createCellCodeFragment((GridHelper)this, (String)text, (Project)project, (Domain)domain);
    }

    @Nullable
    public PsiCodeFragment createCellCodeFragment(@NotNull String text, @NotNull Project project, @NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return GridHelper.DefaultImpls.createCellCodeFragment((GridHelper)this, (String)text, (Project)project, (DataGrid)grid, row, column2);
    }

    @Nullable
    public PsiCodeFragment createFilterCodeFragment(@NotNull Project project, @NotNull String filterText, @Nullable String queryText, @NotNull DbDataSource dataSource, @Nullable DasTable table) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filterText, (String)"filterText");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return GridHelper.DefaultImpls.createFilterCodeFragment((GridHelper)this, (Project)project, (String)filterText, (String)queryText, (DbDataSource)dataSource, (DasTable)table);
    }

    @Nullable
    public PsiCodeFragment createSortingCodeFragment(@NotNull Project project, @NotNull String sortingText, @Nullable String queryText, @NotNull DbDataSource dataSource, @Nullable DasTable table) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sortingText, (String)"sortingText");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return GridHelper.DefaultImpls.createSortingCodeFragment((GridHelper)this, (Project)project, (String)sortingText, (String)queryText, (DbDataSource)dataSource, (DasTable)table);
    }

    @NotNull
    public Set<DataConsumer.Column.Attribute> getAttributes(@NotNull DasColumn column2) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        return GridHelper.DefaultImpls.getAttributes((GridHelper)this, (DasColumn)column2);
    }

    @NotNull
    public Language getFilterLanguage() {
        return GridHelper.DefaultImpls.getFilterLanguage((GridHelper)this);
    }

    public void setFilterText(@NotNull DataGrid grid, @NotNull String text, int caretPosition) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        GridHelper.DefaultImpls.setFilterText((GridHelper)this, (DataGrid)grid, (String)text, (int)caretPosition);
    }
}

