/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ComparePredicateOperation;
import com.intellij.database.data.types.DasColumnRef;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.Placeholder;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.LikeOpType;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.dialects.cassandra.model.CassIndex;
import com.intellij.database.dialects.cassandra.model.CassTable;
import com.intellij.database.dialects.cassandra.model.CassTableColumn;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002JP\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u000b\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010#\u001a\u00020\u000eH\u0014J\u000e\u0010$\u001a\u0004\u0018\u00010%*\u00020\u0019H\u0002\u00a8\u0006'"}, d2={"Lcom/intellij/database/dialects/cassandra/CassPredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "equalsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/data/types/ColumnRef;", "value", "Lcom/intellij/database/data/types/PredicateValue;", "op", "Lcom/intellij/database/data/types/ComparePredicateOperation;", "quote", "", "version", "Lcom/intellij/database/util/Version;", "alias", "", "getBestLikeOp", "Lcom/intellij/database/data/types/domain/LikeOpType;", "columnRef", "wantedLikeOp", "getIndices", "", "Lcom/intellij/database/dialects/cassandra/model/CassIndex;", "c", "Lcom/intellij/database/dialects/cassandra/model/CassTableColumn;", "table", "Lcom/intellij/database/dialects/cassandra/model/CassTable;", "likePredicate", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "Lcom/intellij/database/data/types/LikePredicateOperation;", "canCastToText", "inUpdate", "getMode", "Lcom/intellij/database/dialects/cassandra/CassPredicatesHelper$SASIIndexMode;", "SASIIndexMode", "intellij.database.dialects.cassandra"})
public final class CassPredicatesHelper
extends BasePredicatesHelper {
    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer equalsPredicate(@NotNull ColumnRef column2, @NotNull PredicateValue value, @NotNull ComparePredicateOperation op, boolean quote, @Nullable Version version, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        return super.equalsPredicate(column2, value, op, quote, version, null);
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer likePredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable Domain domain, @NotNull LikePredicateOperation op, boolean canCastToText, @Nullable String alias, @Nullable Version version, boolean inUpdate) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        if (!DbImplUtil.getDatabaseDialect((Dbms)this.getDbms()).getLikeSupport(version).isSupported(inUpdate)) {
            return null;
        }
        if (!(value instanceof StringPredicateValue) && !(value instanceof Placeholder)) {
            return null;
        }
        Domain domain2 = domain;
        if (domain2 == null || !domain2.supports(OperationKt.LIKE_OPERATION)) {
            return null;
        }
        LikeOpType likeOp = this.getBestLikeOp(columnRef, op.getLikeType());
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)columnRef), value, (Function1)new Function1<DdlBuilder, Unit>(this, columnRef, likeOp, value){
            final /* synthetic */ CassPredicatesHelper this$0;
            final /* synthetic */ ColumnRef $columnRef;
            final /* synthetic */ LikeOpType $likeOp;
            final /* synthetic */ PredicateValue $value;

            public final void invoke(@NotNull DdlBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                PredicatesUtilKt.identifier((DdlBuilder)builder, null, (ColumnRef)this.$columnRef).space();
                if (this.$likeOp == LikeOpType.MATCHES) {
                    builder.symbol("=").space();
                } else {
                    builder.keyword("LIKE").space();
                }
                PredicatesUtilKt.value((DdlBuilder)builder, (PredicateValue)this.$value, (ColumnRef)this.$columnRef, (Dbms)this.this$0.getDbms(), (DbImplUtil.StringLiteralDecorator)this.$likeOp.getDecorator());
            }
            {
                this.this$0 = cassPredicatesHelper;
                this.$columnRef = columnRef;
                this.$likeOp = likeOpType;
                this.$value = predicateValue;
                super(1);
            }
        });
    }

    private final LikeOpType getBestLikeOp(ColumnRef columnRef, LikeOpType wantedLikeOp) {
        if (!(columnRef instanceof DasColumnRef)) {
            return LikeOpType.MATCHES;
        }
        DasColumn dasColumn = ((DasColumnRef)columnRef).getCol();
        if (!(dasColumn instanceof CassTableColumn)) {
            dasColumn = null;
        }
        CassTableColumn cassTableColumn = (CassTableColumn)dasColumn;
        if (cassTableColumn == null) {
            return LikeOpType.MATCHES;
        }
        CassTableColumn column2 = cassTableColumn;
        CassTable cassTable = column2.getTable();
        if (cassTable == null) {
            return LikeOpType.MATCHES;
        }
        Intrinsics.checkNotNullExpressionValue((Object)cassTable, (String)"column.table ?: return MATCHES");
        CassTable t = cassTable;
        Collection<CassIndex> indices = this.getIndices(column2, t);
        Object bestOp = LikeOpType.MATCHES;
        for (CassIndex index2 : indices) {
            Object currentBestOp;
            Object object = this.getMode(index2);
            if (object == null || (object = object.getBestOp()) == null || (object = (LikeOpType)object.get(wantedLikeOp)) == null) {
                object = currentBestOp = LikeOpType.MATCHES;
            }
            if (currentBestOp == wantedLikeOp) {
                return wantedLikeOp;
            }
            if (currentBestOp.compareTo((Enum)bestOp) >= 0) continue;
            bestOp = currentBestOp;
        }
        return bestOp;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<CassIndex> getIndices(CassTableColumn c, CassTable table) {
        void $this$filterTo$iv$iv;
        ModNamingFamily<? extends CassIndex> modNamingFamily = table.getIndices();
        Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"table.indices");
        Iterable $this$filter$iv = (Iterable)modNamingFamily;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CassIndex index2 = (CassIndex)element$iv$iv;
            boolean bl = false;
            CassIndex cassIndex = index2;
            Intrinsics.checkNotNullExpressionValue((Object)cassIndex, (String)"index");
            if (!(cassIndex.getColumns().size() == 1 && Intrinsics.areEqual((Object)c.getName(), (Object)index2.getColumns().get(0).getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final SASIIndexMode getMode(CassIndex $this$getMode) {
        if (Intrinsics.areEqual((Object)$this$getMode.getClassName(), (Object)"org.apache.cassandra.index.sasi.SASIIndex") ^ true) {
            return null;
        }
        String string = $this$getMode.getOptions();
        if (string == null) {
            return SASIIndexMode.PREFIX;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.options ?: return SASIIndexMode.PREFIX");
        String options2 = string;
        return StringUtil.containsIgnoreCase((String)options2, (String)"'mode': 'contains'") ? SASIIndexMode.CONTAINS : (StringUtil.containsIgnoreCase((String)options2, (String)"'mode': 'sparse'") ? SASIIndexMode.SPARSE : SASIIndexMode.PREFIX);
    }

    public CassPredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001b\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/cassandra/CassPredicatesHelper$SASIIndexMode;", "", "bestOp", "", "Lcom/intellij/database/data/types/domain/LikeOpType;", "(Ljava/lang/String;ILjava/util/Map;)V", "getBestOp", "()Ljava/util/Map;", "PREFIX", "CONTAINS", "SPARSE", "intellij.database.dialects.cassandra"})
    private static final class SASIIndexMode
    extends Enum<SASIIndexMode> {
        public static final /* enum */ SASIIndexMode PREFIX;
        public static final /* enum */ SASIIndexMode CONTAINS;
        public static final /* enum */ SASIIndexMode SPARSE;
        private static final /* synthetic */ SASIIndexMode[] $VALUES;
        @NotNull
        private final Map<LikeOpType, LikeOpType> bestOp;

        static {
            SASIIndexMode[] sASIIndexModeArray = new SASIIndexMode[3];
            SASIIndexMode[] sASIIndexModeArray2 = sASIIndexModeArray;
            sASIIndexModeArray[0] = PREFIX = new SASIIndexMode(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)LikeOpType.CONTAINS, (Object)LikeOpType.STARTS_WITH), TuplesKt.to((Object)LikeOpType.STARTS_WITH, (Object)LikeOpType.STARTS_WITH), TuplesKt.to((Object)LikeOpType.ENDS_WITH, (Object)LikeOpType.MATCHES), TuplesKt.to((Object)LikeOpType.MATCHES, (Object)LikeOpType.MATCHES), TuplesKt.to((Object)LikeOpType.CUSTOM_LIKE_PATTERN, (Object)LikeOpType.MATCHES)}));
            sASIIndexModeArray[1] = CONTAINS = new SASIIndexMode(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)LikeOpType.CONTAINS, (Object)LikeOpType.CONTAINS), TuplesKt.to((Object)LikeOpType.STARTS_WITH, (Object)LikeOpType.CONTAINS), TuplesKt.to((Object)LikeOpType.ENDS_WITH, (Object)LikeOpType.ENDS_WITH), TuplesKt.to((Object)LikeOpType.MATCHES, (Object)LikeOpType.MATCHES), TuplesKt.to((Object)LikeOpType.CUSTOM_LIKE_PATTERN, (Object)LikeOpType.MATCHES)}));
            sASIIndexModeArray[2] = SPARSE = new SASIIndexMode(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)LikeOpType.CONTAINS, (Object)LikeOpType.MATCHES), TuplesKt.to((Object)LikeOpType.STARTS_WITH, (Object)LikeOpType.MATCHES), TuplesKt.to((Object)LikeOpType.ENDS_WITH, (Object)LikeOpType.MATCHES), TuplesKt.to((Object)LikeOpType.MATCHES, (Object)LikeOpType.MATCHES), TuplesKt.to((Object)LikeOpType.CUSTOM_LIKE_PATTERN, (Object)LikeOpType.MATCHES)}));
            $VALUES = sASIIndexModeArray;
        }

        @NotNull
        public final Map<LikeOpType, LikeOpType> getBestOp() {
            return this.bestOp;
        }

        private SASIIndexMode(Map<LikeOpType, ? extends LikeOpType> bestOp) {
            this.bestOp = bestOp;
        }

        public static SASIIndexMode[] values() {
            return (SASIIndexMode[])$VALUES.clone();
        }

        public static SASIIndexMode valueOf(String string) {
            return Enum.valueOf(SASIIndexMode.class, string);
        }
    }
}

