/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Condition;
import org.jetbrains.annotations.NotNull;

public class CassDomains
extends BaseDomainRegistry {
    private static final Condition<@NotNull Version> CASS_2_2 = v2 -> v2.isOrGreater(new int[]{2, 2});
    private static final Condition<@NotNull Version> CASS_3_10 = v2 -> v2.isOrGreater(new int[]{3, 10});

    public CassDomains() {
        this.add((Domain)new TextDomain("ascii", ConversionPoint.TEXT, Integer.MAX_VALUE));
        this.add((Domain)new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new BinaryDomain("blob", ConversionPoint.BLOB, Integer.MAX_VALUE, Integer.MAX_VALUE, false, true));
        this.add((Domain)new BooleanDomain("boolean", ConversionPoint.BOOLEAN));
        this.add((Domain)new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, Integer.MAX_VALUE, Integer.MAX_VALUE, false));
        this.add((Domain)new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add((Domain)new IntegerDomain("counter", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add((Domain)new SimpleDomain("inet", ConversionPoint.INET, PhysicalDomainType.UNKNOWN));
        this.add((Domain)new IntegerDomain("int", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new TextDomain("text", ConversionPoint.TEXT, Integer.MAX_VALUE));
        this.add((Domain)new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 6));
        this.add((Domain)new SimpleDomain("uuid", ConversionPoint.UUID, PhysicalDomainType.UNKNOWN));
        this.add((Domain)new SimpleDomain("timeuuid", ConversionPoint.UUID, PhysicalDomainType.UNKNOWN));
        this.add((Domain)new TextDomain("varchar", ConversionPoint.VARCHAR, Integer.MAX_VALUE, Integer.MAX_VALUE, false, true));
        this.add((Domain)new IntegerDomain("varint", ConversionPoint.BIG_DECIMAL, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE).withVersion(CASS_2_2));
        this.add(new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 0, -1, false).withVersion(CASS_2_2));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0).withVersion(CASS_2_2));
        this.add(new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0).withVersion(CASS_2_2));
        this.add(new SimpleDomain("duration", ConversionPoint.INTERVAL, PhysicalDomainType.UNKNOWN).withVersion(CASS_3_10));
    }
}

