/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector.jdbc.wrappers;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceInfo;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.AseRoutineArgumentIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.AseRoutineIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ResultSetWrapper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.RoutineArgumentIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.RoutineIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableColumnIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableFKeyColumnIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableIndexColumnIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableKeyColumnIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableVersionColumnIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TypeIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.UserDefinedTypeAttributeIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.UserDefinedTypeIt;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseMetaDataWrapper {
    private static final Logger LOG = Logger.getInstance(DatabaseMetaDataWrapper.class);
    private final DatabaseConnection myConnection;
    private final RemoteDatabaseMetaData myMetaData;
    private String myQuote;
    private String myPatternEscape;
    private PairConsumer<String, Throwable> myErrorSink;

    @NotNull
    public DatabaseMetaDataWrapper withErrorSink(PairConsumer<String, Throwable> errorSink2) {
        this.myErrorSink = errorSink2;
        DatabaseMetaDataWrapper databaseMetaDataWrapper = this;
        if (databaseMetaDataWrapper == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(0);
        }
        return databaseMetaDataWrapper;
    }

    @Nullable
    public PairConsumer<String, Throwable> getErrorSink() {
        return this.myErrorSink;
    }

    public void onError(String title, Throwable e2) {
        this.myErrorSink.consume((Object)title, (Object)e2);
    }

    public DatabaseConnection getConnection() {
        return this.myConnection;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myConnection.getDbms();
        if (dbms == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @NotNull
    public static DatabaseMetaDataWrapper create(@NotNull DatabaseConnection connection, @NotNull RemoteDatabaseMetaData metaData) {
        Dbms dbms;
        if (connection == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(2);
        }
        if (metaData == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(3);
        }
        if ((dbms = connection.getDbms()).isMicrosoft()) {
            return new MsMetadataWrapper(connection, metaData);
        }
        if (dbms.isSybase()) {
            return new AseMetadataWrapper(connection, metaData);
        }
        if (dbms.isPostgres()) {
            return new PgMetadataWrapper(connection, metaData);
        }
        if (dbms.isOracle()) {
            return new OraMetadataWrapper(connection, metaData);
        }
        return new DatabaseMetaDataWrapper(connection, metaData);
    }

    protected DatabaseMetaDataWrapper(@NotNull DatabaseConnection connection, @NotNull RemoteDatabaseMetaData data) {
        if (connection == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(4);
        }
        if (data == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(5);
        }
        this.myConnection = connection;
        this.myMetaData = data;
    }

    @NotNull
    public ClosableIt<String> databases() throws SQLException {
        ClosableIt<String> res2 = this.catalogs();
        res2.map(StringUtil::notNullize);
        ClosableIt<String> closableIt = res2;
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(6);
        }
        return closableIt;
    }

    protected ClosableIt<String> catalogs() throws SQLException {
        try {
            RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.getMetaData().getCatalogs());
            return new ClosableIt.ResultSetDelegateIt<String>(rs, null){

                @Override
                protected String calcValue() throws SQLException {
                    return this.myRs.getString("TABLE_CAT", 1);
                }
            }.withErrorSink(this.getErrorSink());
        }
        catch (RuntimeException | SQLException e2) {
            String catalog = (String)JdbcNativeUtil.computeRemote(() -> this.getConnection().getRemoteConnection().getCatalog());
            return ClosableIt.from(JBIterable.of((Object)catalog).iterator());
        }
    }

    @NotNull
    public ClosableIt<Schema> schemas(@NotNull JBIterable<String> databases) throws SQLException {
        if (databases == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(7);
        }
        final String current = (String)JdbcNativeUtil.computeRemote(() -> this.myConnection.getRemoteConnection().getCatalog());
        return new ClosableIt.DelegateIt<Schema, Schema>(this.schemas(databases, current)){

            @Override
            public void close() {
                try {
                    super.close();
                }
                finally {
                    if (current != null) {
                        JdbcNativeUtil.performSafe(() -> DatabaseMetaDataWrapper.this.myConnection.getRemoteConnection().setCatalog(current));
                    }
                }
            }

            @Override
            protected Schema calcValue(Schema cur) {
                return cur;
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ClosableIt<Schema> schemas(@NotNull JBIterable<String> catalogs, @Nullable String current) {
        ClosableIt.AutoCloseableGuard<ClosableIt<Schema>> it;
        if (catalogs == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(8);
        }
        if (catalogs.isEmpty()) {
            catalogs = JBIterable.from(Collections.singletonList(current));
        }
        try (ClosableIt.AutoCloseableGuard<ClosableIt<Schema>> it2222 = ClosableIt.AutoCloseableGuard.guarded(DatabaseMetaDataWrapper.eachCatalogs((Iterable<String>)catalogs, (Function<String, ? extends ClosableIt<Schema>>)((Function)c -> this.jdbcSchemasInCatalog1((String)c))));){
            if (it2222.get().hasNext()) {
                ClosableIt<Schema> closableIt = it2222.release();
                return closableIt;
            }
        }
        catch (UnsupportedOperationException it2222) {
        }
        catch (AbstractMethodError it2222) {
            // empty catch block
        }
        if (current != null) {
            it = ClosableIt.AutoCloseableGuard.guarded(DatabaseMetaDataWrapper.eachCatalogs((Iterable<String>)catalogs, (Function<String, ? extends ClosableIt<Schema>>)((Function)c -> this.jdbcSchemasInCatalog2((String)c))));
            try {
                if (it.get().hasNext()) {
                    ClosableIt<Schema> closableIt = it.release();
                    return closableIt;
                }
            }
            finally {
                if (it != null) {
                    it.close();
                }
            }
        }
        it = ClosableIt.AutoCloseableGuard.guarded(this.jdbcSchemas3((JBIterable<String>)catalogs, current));
        try {
            if (it.get().hasNext()) {
                ClosableIt<Schema> closableIt = it.release();
                return closableIt;
            }
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
        Object cats = catalogs;
        if (!catalogs.isEmpty()) return (ClosableIt)ClosableIt.from(cats.iterator()).map(catalog -> new Schema("", (String)catalog));
        cats = Collections.singleton(null);
        return (ClosableIt)ClosableIt.from(cats.iterator()).map(catalog -> new Schema("", (String)catalog));
    }

    private ClosableIt<Schema> jdbcSchemas3(final JBIterable<String> catalogs, final String current) {
        try {
            RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.getMetaData().getSchemas());
            return new ClosableIt.ResultSetDelegateIt<Schema>(rs, null){
                private Iterator<String> myCats;
                private Schema myCur;
                {
                    super(rs, hook);
                    this.myCats = null;
                    this.myCur = null;
                }

                @Override
                protected Schema calcValue() throws SQLException {
                    String schema = this.myRs.getString("TABLE_SCHEM", 1);
                    String catalog = this.myRs.getString("TABLE_CATALOG", 2);
                    return new Schema(DbUtil.intern((String)schema), catalog == null ? null : DbUtil.intern((String)catalog));
                }

                @Override
                protected Schema nextImpl() {
                    if (this.myCats != null && this.myCats.hasNext() && this.myCur != null) {
                        return new Schema(this.myCur.schema, this.myCats.next());
                    }
                    Schema schema = (Schema)super.nextImpl();
                    if (schema == null) {
                        return null;
                    }
                    if (schema.database == null && !catalogs.isEmpty()) {
                        this.myCur = schema;
                        this.myCats = catalogs.iterator();
                        return (Schema)this.skip();
                    }
                    if (schema.database == null) {
                        schema.database = current;
                    }
                    return schema;
                }
            }.withErrorSink(this.getErrorSink());
        }
        catch (SQLException e2) {
            this.onError(null, e2);
            return ClosableIt.empty();
        }
    }

    private static ClosableIt<Schema> eachCatalogs(Iterable<String> catalogs, Function<String, ? extends ClosableIt<Schema>> action) {
        Iterator<String> cats = catalogs.iterator();
        if (!cats.hasNext()) {
            return ClosableIt.empty();
        }
        return ClosableIt.lazyAppend(ClosableIt.empty(), () -> cats.hasNext() ? (ClosableIt)action.fun((Object)((String)cats.next())) : null);
    }

    private ClosableIt<Schema> jdbcSchemasInCatalog2(final String catalog) {
        if (catalog == null) {
            return ClosableIt.empty();
        }
        String q = this.getDbms().isTransactSql() ? null : this.getQuote();
        String dbName = q != null ? q + catalog + q : catalog;
        try {
            this.getConnection().getRemoteConnection().setCatalog(dbName);
        }
        catch (Exception ignore) {
            return ClosableIt.empty();
        }
        try {
            return new ClosableIt.ResultSetDelegateIt<Schema>(this.getMetaData().getSchemas(), null){

                @Override
                protected Schema calcValue() throws SQLException {
                    String schema = this.myRs.getString("TABLE_SCHEM", 1);
                    String cat = this.myRs.getString("TABLE_CATALOG", 2);
                    if (cat != null && !cat.equals(catalog)) {
                        return (Schema)this.skip();
                    }
                    return new Schema(DbUtil.intern((String)schema), catalog);
                }
            }.withErrorSink(this.getErrorSink());
        }
        catch (Exception ex) {
            this.onError(null, ex);
            return ClosableIt.empty();
        }
    }

    private ClosableIt<Schema> jdbcSchemasInCatalog1(final String catalog) {
        RemoteResultSet rs = DatabaseMetaDataWrapper.getSchemas(catalog, this);
        if (rs == null) {
            return ClosableIt.empty();
        }
        ClosableIt.AutoCloseableGuard<AutoCloseable> g = ClosableIt.AutoCloseableGuard.guarded(() -> ((RemoteResultSet)rs).close());
        try {
            ClosableIt<Schema> res2 = new ClosableIt.ResultSetDelegateIt<Schema>(rs, null){

                @Override
                protected Schema calcValue() throws SQLException {
                    return new Schema(DbUtil.intern((String)this.myRs.getString("TABLE_SCHEM", 1)), catalog);
                }
            }.withErrorSink(this.getErrorSink());
            g.release();
            ClosableIt<Schema> closableIt = res2;
            if (g != null) {
                g.close();
            }
            return closableIt;
        }
        catch (Throwable throwable) {
            try {
                if (g != null) {
                    try {
                        g.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e2) {
                LOG.warn((Throwable)e2);
                return ClosableIt.empty();
            }
        }
    }

    private static RemoteResultSet getSchemas(String catalog, DatabaseMetaDataWrapper meta) {
        try {
            return (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> meta.getMetaData().getSchemas(catalog, "%"));
        }
        catch (SQLException ex) {
            try {
                String q = meta.getQuote();
                return (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> meta.getMetaData().getSchemas(q + catalog + q, "%"));
            }
            catch (SQLException ex2) {
                return null;
            }
        }
    }

    @NotNull
    public ClosableIt<? extends Table> tables(@NotNull Schema schema, @Nullable String name2, String @Nullable [] types2) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(9);
        }
        ClosableIt<? extends Table> tableIt = this.tablesInner(schema, name2, types2);
        tableIt.filter(tab -> tab.type == null || !StringUtil.containsIgnoreCase((String)tab.type, (String)"TEMPORARY"));
        ClosableIt<? extends Table> closableIt = tableIt;
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(10);
        }
        return closableIt;
    }

    @NotNull
    public ClosableIt<Routine> routines(@NotNull Schema schema, @Nullable String pkg, @Nullable String name2) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(11);
        }
        boolean noCatalog = StringUtil.isEmpty((String)((String)JdbcNativeUtil.computeRemote(() -> ((RemoteDatabaseMetaData)this.myMetaData).getCatalogTerm())));
        String requestCatalog = noCatalog ? pkg : StringUtil.notNullize((String)schema.database);
        ClosableIt<Routine> closableIt = this.append(this.getProceduresInner(requestCatalog, schema, name2, noCatalog), () -> this.getFunctionsInner(requestCatalog, schema, name2, noCatalog));
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(12);
        }
        return closableIt;
    }

    @NotNull
    private ClosableIt<Routine> getProceduresInner(@Nullable String requestCatalog, @NotNull Schema schema, @Nullable String name2, boolean noCatalog) throws SQLException {
        RemoteResultSet rs;
        block6: {
            if (schema == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(13);
            }
            rs = null;
            try {
                rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getProcedures(requestCatalog, this.escapePattern(schema.schema), this.escapePattern(name2)));
            }
            catch (SQLException e2) {
                if (this.isUnimplemented(e2)) break block6;
                throw e2;
            }
        }
        if (rs == null) {
            ClosableIt<Routine> closableIt = ClosableIt.empty();
            if (closableIt == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(14);
            }
            return closableIt;
        }
        ClosableIt closableIt = new RoutineIt(rs, this.getDbms(), schema, noCatalog, true).withErrorSink((PairConsumer)this.myErrorSink);
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(15);
        }
        return closableIt;
    }

    @Nullable
    private ClosableIt<Routine> getFunctionsInner(@Nullable String requestCatalog, @NotNull Schema schema, @Nullable String name2, boolean noCatalog) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(16);
        }
        RemoteResultSet rs = null;
        try {
            rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getFunctions(requestCatalog, this.getDbms() == Dbms.HIVE ? "" : this.escapePattern(schema.schema), StringUtil.notNullize((String)this.escapePattern(name2), (String)"%")));
        }
        catch (SQLException e2) {
            if (!this.isUnimplemented(e2)) {
                throw e2;
            }
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        if (rs == null) {
            return null;
        }
        return new RoutineIt(rs, this.getDbms(), schema, noCatalog, false).withErrorSink((PairConsumer)this.myErrorSink);
    }

    protected <T> ClosableIt<T> append(ClosableIt<T> head, ThrowableComputable<ClosableIt<T>, SQLException> ... tail) {
        ClosableIt<T> res2 = head;
        for (ThrowableComputable<ClosableIt<T>, SQLException> fac : tail) {
            if (fac == null) continue;
            res2 = ClosableIt.lazyAppend(res2, this.handleExceptions(fac));
        }
        return res2;
    }

    private <T> Factory<T> handleExceptions(ThrowableComputable<T, SQLException> fac) {
        return () -> {
            try {
                return fac.compute();
            }
            catch (SQLException e2) {
                this.onError(null, e2);
                return null;
            }
        };
    }

    @NotNull
    public ClosableIt.GroupingIt<TableKey, TableKeyColumn> tableKeys(@NotNull Table table) throws SQLException {
        if (table == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(17);
        }
        RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getPrimaryKeys(table.schema.database, table.schema.schema, table.name));
        return new TableKeyColumnIt.Grouping(new TableKeyColumnIt(rs, table).withErrorSink((PairConsumer)this.myErrorSink));
    }

    @NotNull
    public ClosableIt.GroupingIt<Table, TableColumn> tableColumns(@NotNull Schema schema, @Nullable String tableName, @Nullable Iterable<String> expectedTables) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(18);
        }
        return new TableColumnIt.Grouping(this.getTableColumnsInner(schema, tableName, expectedTables));
    }

    @NotNull
    protected ClosableIt<TableColumn> getTableColumnsInner(@NotNull Schema schema, @Nullable String tableName, @Nullable Iterable<String> expectedTables) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(19);
        }
        if (tableName != null || expectedTables == null) {
            assert (expectedTables == null);
            return this.getTableColumnsInner2(schema, tableName);
        }
        ClosableIt<TableColumn> it = null;
        if (this.getDbms() != Dbms.GITBASE) {
            try {
                it = this.getTableColumnsInner2(schema, null);
            }
            catch (Exception e2) {
                LOG.debug((Throwable)e2);
            }
        }
        Iterator<String> myTableIt = expectedTables.iterator();
        ClosableIt<TableColumn> closableIt = ClosableIt.lazyAppendIfEmpty(it != null ? it : ClosableIt.empty(), () -> ClosableIt.generate(() -> {
            Application app = ApplicationManager.getApplication();
            while (myTableIt.hasNext()) {
                String table = (String)myTableIt.next();
                try {
                    return this.getTableColumnsInner2(schema, table);
                }
                catch (Exception e2) {
                    boolean ignore = (app == null || app.isUnitTestMode()) && e2.getMessage() != null && e2.getMessage().contains("no such table");
                    if (ignore) continue;
                    this.onError("failed to retrieve columns for " + table, e2);
                }
            }
            return null;
        }));
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(20);
        }
        return closableIt;
    }

    @NotNull
    private ClosableIt<TableColumn> getTableColumnsInner2(@NotNull Schema schema, @Nullable String tableName) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(21);
        }
        RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getColumns(StringUtil.notNullize((String)schema.database), this.escapePattern(schema.schema), StringUtil.notNullize((String)this.escapePattern(tableName), (String)"%"), "%"));
        ClosableIt closableIt = new TableColumnIt(rs, this.getDbms(), schema).withErrorSink((PairConsumer)this.myErrorSink);
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(22);
        }
        return closableIt;
    }

    @NotNull
    public ClosableIt.GroupingIt<Routine, RoutineArgument> routineArguments(@NotNull Schema schema, @Nullable String routineName, @NotNull Function<Routine, DasRoutine.Kind> kindProvider) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(23);
        }
        if (kindProvider == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(24);
        }
        return new RoutineArgumentIt.Grouping(this.routineArgumentsInner(schema, routineName, kindProvider));
    }

    @NotNull
    public ClosableIt<RoutineArgument> routineArgumentsInner(@NotNull Schema schema, @Nullable String routineName, @NotNull Function<Routine, DasRoutine.Kind> kindProvider) throws SQLException {
        boolean noCatalog;
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(25);
        }
        if (kindProvider == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(26);
        }
        String requestCatalog = (noCatalog = StringUtil.isEmpty((String)((String)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getCatalogTerm())))) ? schema.database : StringUtil.notNullize((String)schema.database);
        ClosableIt<RoutineArgument> closableIt = this.append(this.getProcedureArgumentsInner(requestCatalog, schema, routineName, kindProvider, noCatalog), () -> this.getFunctionArgumentsInner(requestCatalog, schema, routineName, kindProvider, noCatalog));
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(27);
        }
        return closableIt;
    }

    @NotNull
    private ClosableIt<RoutineArgument> getProcedureArgumentsInner(String requestCatalog, @NotNull Schema schema, @Nullable String routineName, @NotNull Function<Routine, DasRoutine.Kind> kindProvider, boolean noCatalog) throws SQLException {
        RemoteResultSet wrapper;
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(28);
        }
        if (kindProvider == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(29);
        }
        if ((wrapper = this.getRoutineArgumentsWrapper(new Schema(schema.schema, requestCatalog), routineName)) == null) {
            ClosableIt<RoutineArgument> closableIt = ClosableIt.empty();
            if (closableIt == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(30);
            }
            return closableIt;
        }
        ClosableIt closableIt = new RoutineArgumentIt(wrapper, this.getDbms(), schema, noCatalog, kindProvider, true).withErrorSink((PairConsumer)this.myErrorSink);
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(31);
        }
        return closableIt;
    }

    @Nullable
    private ClosableIt<RoutineArgument> getFunctionArgumentsInner(String requestCatalog, @NotNull Schema schema, @Nullable String functionName, @NotNull Function<Routine, DasRoutine.Kind> kindProvider, boolean noCatalog) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(32);
        }
        if (kindProvider == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(33);
        }
        RemoteResultSet rs = null;
        try {
            rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getFunctionColumns(requestCatalog, this.escapePattern(schema.schema), this.escapePattern(functionName), null));
        }
        catch (SQLException e2) {
            if (!this.isUnimplemented(e2)) {
                throw e2;
            }
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        if (rs == null) {
            return null;
        }
        return new RoutineArgumentIt(rs, this.getDbms(), schema, noCatalog, kindProvider, false).withErrorSink((PairConsumer)this.myErrorSink);
    }

    private boolean isUnimplemented(SQLException e2) {
        String message2 = e2.getMessage();
        if (this.getDbms() == Dbms.COCKROACH && message2 != null && message2.contains("pg_function_is_visible")) {
            return true;
        }
        if ((this.getDbms().isSqlite() || this.getDbms() == Dbms.SNOWFLAKE) && message2 == null && e2.getCause() == null) {
            return true;
        }
        if (this.getDbms().isOracle() && this.getConnection().getVersion().eqCoarse(new int[]{10}) && message2 != null && message2.contains("ORA-00904") && ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.warn((Throwable)e2);
            return true;
        }
        return message2 != null && (StringUtil.containsIgnoreCase((String)message2, (String)"implemented") || StringUtil.containsIgnoreCase((String)message2, (String)"unsupported") || StringUtil.containsIgnoreCase((String)message2, (String)"not supported"));
    }

    @NotNull
    public ClosableIt.GroupingIt<TableFKey, TableFKeyColumn> tableFKeyColumns(@NotNull Table table) throws SQLException {
        if (table == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(34);
        }
        RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getImportedKeys(table.schema.database, table.schema.schema, table.name));
        return new TableFKeyColumnIt.Grouping(new TableFKeyColumnIt(rs, table).withErrorSink((PairConsumer)this.myErrorSink));
    }

    @NotNull
    public ClosableIt.GroupingIt<TableIndex, TableIndexColumn> tableIndexColumns(@NotNull Table table) throws SQLException {
        if (table == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(35);
        }
        RemoteResultSet rs = this.getTableIndexColumnsWrapper(table);
        return new TableIndexColumnIt.Grouping(new TableIndexColumnIt(rs, table, this.getDbms()).withErrorSink((PairConsumer)this.myErrorSink));
    }

    @NotNull
    public ClosableIt<TableColumn> tableVersionColumns(@NotNull Table table) throws SQLException {
        if (table == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(36);
        }
        RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getVersionColumns(table.schema.database, table.schema.schema, table.name));
        ClosableIt closableIt = new TableVersionColumnIt(rs, table).withErrorSink((PairConsumer)this.myErrorSink);
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(37);
        }
        return closableIt;
    }

    @Nullable
    private RemoteResultSet getRoutineArgumentsWrapper(@NotNull Schema schema, @Nullable String routineName) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(38);
        }
        try {
            return (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getProcedureColumns(schema.database, this.escapePattern(schema.schema), StringUtil.notNullize((String)this.escapePattern(routineName), (String)"%"), null));
        }
        catch (NullPointerException e2) {
            if (this.getDbms().isSqlite()) {
                LOG.debug((Throwable)e2);
                return null;
            }
            throw e2;
        }
        catch (SQLException e3) {
            if (this.isUnimplemented(e3)) {
                return null;
            }
            return (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getProcedureColumns(schema.database, this.escapePattern(schema.schema), "%", null));
        }
    }

    private RemoteResultSet getTableIndexColumnsWrapper(@NotNull Table table) throws SQLException {
        if (table == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(39);
        }
        try {
            return (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getIndexInfo(table.schema.database, table.schema.schema, table.name, false, true));
        }
        catch (SQLException ex) {
            try {
                String q = this.getQuote();
                return (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getIndexInfo(q + table.schema.database + q, q + table.schema.schema + q, q + table.name + q, false, true));
            }
            catch (SQLException ex2) {
                throw ex;
            }
        }
    }

    public String getQuote() {
        if (this.myQuote == null) {
            try {
                this.myQuote = (String)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getIdentifierQuoteString());
            }
            catch (SQLException e2) {
                this.myQuote = "\"";
                this.onError(null, e2);
            }
        }
        return this.myQuote;
    }

    public String getPatternEscape() {
        if (this.myPatternEscape == null) {
            try {
                if (!this.myConnection.getDbms().in(new Dbms[]{Dbms.MONET, Dbms.ATHENA})) {
                    this.myPatternEscape = (String)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getSearchStringEscape());
                }
                if (this.myPatternEscape == null) {
                    this.myPatternEscape = "";
                }
            }
            catch (SQLException e2) {
                this.myPatternEscape = "";
                this.onError(null, e2);
            }
        }
        return this.myPatternEscape;
    }

    private String escapePattern(String p) {
        if (p == null) {
            return null;
        }
        String e2 = this.getPatternEscape();
        if (StringUtil.isEmpty((String)e2)) {
            return p;
        }
        return p.replace("_", e2 + "_").replace("%", e2 + "%");
    }

    public String[] getAllTableTypes() throws SQLException {
        RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getTableTypes());
        if (rs == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        try {
            while (JdbcNativeUtil.getBooleanSafe(() -> rs.next())) {
                result2.add(StringUtil.trim((String)((String)JdbcNativeUtil.computeRemote(() -> rs.getString("TABLE_TYPE")))));
            }
        }
        catch (SQLException sQLException) {
        }
        catch (Exception e2) {
            this.myErrorSink.consume(null, (Object)e2);
        }
        return result2.isEmpty() ? null : ArrayUtilRt.toStringArray(result2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected ClosableIt<? extends Table> tablesInner(@NotNull Schema schema, @Nullable String name2, String @Nullable [] types2) {
        boolean hasNext;
        ResultSetWrapper rs;
        block10: {
            if (schema == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(40);
            }
            rs = null;
            try {
                try {
                    RemoteResultSet resultSet = this.myMetaData.getTables(schema.database, this.escapePattern(schema.schema), StringUtil.notNullize((String)this.escapePattern(name2), (String)"%"), types2);
                    rs = new ResultSetWrapper(resultSet);
                    hasNext = rs.next();
                }
                catch (Exception e2) {
                    LOG.warn((Throwable)e2);
                    ClosableIt closableIt = types2 == null ? ClosableIt.empty() : this.tablesInner(schema, name2, null);
                    ResultSetWrapper.close(rs);
                    ClosableIt closableIt2 = closableIt;
                    if (closableIt2 == null) {
                        DatabaseMetaDataWrapper.$$$reportNull$$$0(41);
                    }
                    return closableIt2;
                }
            }
            catch (Throwable throwable) {
                ResultSetWrapper.close(rs);
                throw throwable;
            }
            if (hasNext || types2 == null || types2.length == 1) break block10;
            ClosableIt<? extends Table> e2 = this.tablesInner(schema, name2, null);
            ResultSetWrapper.close(rs);
            ClosableIt<? extends Table> closableIt = e2;
            if (closableIt == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(42);
            }
            return closableIt;
        }
        ClosableIt it = new TableIt(rs, this.getDbms(), hasNext, schema).withErrorSink((PairConsumer)this.myErrorSink);
        rs = null;
        ClosableIt closableIt = it;
        ResultSetWrapper.close(rs);
        ClosableIt closableIt3 = closableIt;
        if (closableIt3 == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(43);
        }
        return closableIt3;
    }

    @NotNull
    public ClosableIt<? extends UserDefinedType> userDefinedTypes(@NotNull Schema schema, @Nullable String typeName) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(44);
        }
        RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getUDTs(schema.database, this.escapePattern(schema.schema), StringUtil.notNullize((String)this.escapePattern(typeName), (String)"%"), null));
        return new UserDefinedTypeIt(rs, schema);
    }

    @NotNull
    public ClosableIt<? extends Type> types() throws SQLException {
        RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getTypeInfo());
        return new TypeIt(rs);
    }

    @NotNull
    public ClosableIt.GroupingIt<UserDefinedType, UserDefinedTypeAttribute> userDefinedTypeAttributes(@NotNull Schema schema, @Nullable String attrName, @Nullable Set<String> types2) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(45);
        }
        UserDefinedTypeAttributeIt.Grouping res2 = new UserDefinedTypeAttributeIt.Grouping(this.userDefinedTypeAttributesInner(schema, attrName));
        ClosableIt.GroupingIt groupingIt = types2 != null ? (ClosableIt.GroupingIt)res2.filter(t -> types2.contains(t.name)) : res2;
        if (groupingIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(46);
        }
        return groupingIt;
    }

    @NotNull
    protected ClosableIt<UserDefinedTypeAttribute> userDefinedTypeAttributesInner(@NotNull Schema schema, @Nullable String attrName) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(47);
        }
        try {
            RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getAttributes(schema.database, this.escapePattern(schema.schema), "%", StringUtil.notNullize((String)this.escapePattern(attrName), (String)"%")));
            return new UserDefinedTypeAttributeIt(rs, this.getDbms(), schema);
        }
        catch (SQLException e2) {
            if (this.isUnimplemented(e2)) {
                ClosableIt<UserDefinedTypeAttribute> closableIt = ClosableIt.empty();
                if (closableIt == null) {
                    DatabaseMetaDataWrapper.$$$reportNull$$$0(48);
                }
                return closableIt;
            }
            throw e2;
        }
    }

    @NotNull
    public RemoteDatabaseMetaData getMetaData() {
        RemoteDatabaseMetaData remoteDatabaseMetaData = this.myMetaData;
        if (remoteDatabaseMetaData == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(49);
        }
        return remoteDatabaseMetaData;
    }

    @Nullable
    public Casing getCasing() {
        return DataSourceInfo.getCasing((Dbms)this.getDbms(), (RemoteDatabaseMetaData)this.myMetaData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 47: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 47: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databases";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catalogs";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 32: 
            case 38: 
            case 40: 
            case 44: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 17: 
            case 34: 
            case 35: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 24: 
            case 26: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kindProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "withErrorSink";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "databases";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "tables";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "routines";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProceduresInner";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableColumnsInner";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableColumnsInner2";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "routineArgumentsInner";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcedureArgumentsInner";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "tableVersionColumns";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "tablesInner";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "userDefinedTypeAttributes";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "userDefinedTypeAttributesInner";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaData";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "schemas";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tables";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "routines";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getProceduresInner";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionsInner";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tableKeys";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "tableColumns";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTableColumnsInner";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTableColumnsInner2";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "routineArguments";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "routineArgumentsInner";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getProcedureArgumentsInner";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionArgumentsInner";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "tableFKeyColumns";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "tableIndexColumns";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "tableVersionColumns";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getRoutineArgumentsWrapper";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getTableIndexColumnsWrapper";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "tablesInner";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "userDefinedTypes";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "userDefinedTypeAttributes";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "userDefinedTypeAttributesInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 47: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OraMetadataWrapper
    extends DatabaseMetaDataWrapper {
        public static final List<String> BAD_PREFIXES = ContainerUtil.immutableList((Object[])new String[]{"BIN$", "CREATE$", "JAVA$", "DR$", "XDB$", "DRV$", "RUPD$", "MLOG$"});

        OraMetadataWrapper(@NotNull DatabaseConnection connection, @NotNull RemoteDatabaseMetaData data) {
            if (connection == null) {
                OraMetadataWrapper.$$$reportNull$$$0(0);
            }
            if (data == null) {
                OraMetadataWrapper.$$$reportNull$$$0(1);
            }
            super(connection, data);
        }

        @Override
        public ClosableIt<Schema> schemas(@NotNull JBIterable<String> catalogs, @Nullable String current) {
            if (catalogs == null) {
                OraMetadataWrapper.$$$reportNull$$$0(2);
            }
            return ClosableIt.lazyAppendIfEmpty(OraMetadataWrapper.oracleSchemas(this), () -> super.schemas(catalogs, current));
        }

        /*
         * Loose catch block
         */
        @NotNull
        private static ClosableIt<Schema> oracleSchemas(@NotNull DatabaseMetaDataWrapper meta) {
            if (meta == null) {
                OraMetadataWrapper.$$$reportNull$$$0(3);
            }
            String queryText = "select username                                                       \nfrom sys.all_users U                                                  \nwhere exists (select 1 from sys.all_objects where owner = U.username) \n   or username = user                                                 \n   or username = sys_context('userenv','current_schema')              \n";
            RemoteStatement statement = (RemoteStatement)JdbcNativeUtil.computeSafe(() -> meta.getConnection().getRemoteConnection().createStatement());
            if (statement == null) {
                ClosableIt<Schema> closableIt = ClosableIt.empty();
                if (closableIt == null) {
                    OraMetadataWrapper.$$$reportNull$$$0(4);
                }
                return closableIt;
            }
            ClosableIt.AutoCloseableGuard<AutoCloseable> g = ClosableIt.AutoCloseableGuard.guarded(() -> ((RemoteStatement)statement).close());
            ClosableIt<Schema> res2 = new ClosableIt.ResultSetDelegateIt<Schema>((RemoteResultSet)JdbcNativeUtil.computeRemote(() -> statement.executeQuery(queryText)), g.get()){

                @Override
                protected Schema calcValue() throws SQLException {
                    return new Schema(DbUtil.intern((String)this.myRs.getString("USERNAME", 1)), null);
                }
            }.withErrorSink(meta.getErrorSink());
            g.release();
            ClosableIt<Schema> closableIt = res2;
            if (g != null) {
                g.close();
            }
            ClosableIt<Schema> closableIt2 = closableIt;
            if (closableIt2 == null) {
                OraMetadataWrapper.$$$reportNull$$$0(5);
            }
            return closableIt2;
            {
                catch (Throwable throwable) {
                    try {
                        if (g != null) {
                            try {
                                g.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e2) {
                        LOG.debug((Throwable)e2);
                        ClosableIt<Schema> closableIt3 = ClosableIt.empty();
                        if (closableIt3 == null) {
                            OraMetadataWrapper.$$$reportNull$$$0(6);
                        }
                        return closableIt3;
                    }
                }
            }
        }

        @Override
        @NotNull
        public ClosableIt<? extends Table> tables(@NotNull Schema schema, @Nullable String name2, String @Nullable [] types2) throws SQLException {
            if (schema == null) {
                OraMetadataWrapper.$$$reportNull$$$0(7);
            }
            ClosableIt<? extends Table> tableIt = super.tables(schema, name2, types2);
            tableIt.filter(OraMetadataWrapper::isValidTable);
            ClosableIt<? extends Table> closableIt = tableIt;
            if (closableIt == null) {
                OraMetadataWrapper.$$$reportNull$$$0(8);
            }
            return closableIt;
        }

        @Override
        @NotNull
        public ClosableIt<Routine> routines(@NotNull Schema schema, @Nullable String pkg, @Nullable String name2) throws SQLException {
            if (schema == null) {
                OraMetadataWrapper.$$$reportNull$$$0(9);
            }
            ClosableIt<Routine> routineIt = super.routines(schema, pkg, name2);
            routineIt.filter(OraMetadataWrapper::isValidRoutine);
            ClosableIt<Routine> closableIt = routineIt;
            if (closableIt == null) {
                OraMetadataWrapper.$$$reportNull$$$0(10);
            }
            return closableIt;
        }

        private static boolean startsWithBadPrefix(@Nullable String s) {
            if (s != null) {
                for (String prefix : BAD_PREFIXES) {
                    if (!StringUtil.startsWithIgnoreCase((String)s, (String)prefix)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isSys(@NotNull Schema schema) {
            if (schema == null) {
                OraMetadataWrapper.$$$reportNull$$$0(11);
            }
            return Comparing.equal((String)"sys", (String)schema.schema, (boolean)false) || Comparing.equal((String)"sys", (String)schema.schema, (boolean)true);
        }

        private static boolean isValidSysName(@Nullable String s) {
            return s == null || !s.contains("$");
        }

        private static boolean isValidRoutine(@NotNull Routine routine2) {
            if (routine2 == null) {
                OraMetadataWrapper.$$$reportNull$$$0(12);
            }
            if (OraMetadataWrapper.isSys(routine2.schema)) {
                return OraMetadataWrapper.isValidSysName(routine2.pkg) && OraMetadataWrapper.isValidSysName(routine2.name);
            }
            return !OraMetadataWrapper.startsWithBadPrefix(routine2.pkg) && !OraMetadataWrapper.startsWithBadPrefix(routine2.name);
        }

        private static boolean isValidTable(@NotNull Table table) {
            if (table == null) {
                OraMetadataWrapper.$$$reportNull$$$0(13);
            }
            if (OraMetadataWrapper.isSys(table.schema)) {
                return OraMetadataWrapper.isValidSysName(table.name);
            }
            return !OraMetadataWrapper.startsWithBadPrefix(table.name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "catalogs";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$OraMetadataWrapper";
                    break;
                }
                case 7: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schema";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "routine";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$OraMetadataWrapper";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "oracleSchemas";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tables";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "routines";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "schemas";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "oracleSchemas";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "tables";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "routines";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "isSys";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "isValidRoutine";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "isValidTable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MsMetadataWrapper
    extends DatabaseMetaDataWrapper {
        protected MsMetadataWrapper(@NotNull DatabaseConnection connection, @NotNull RemoteDatabaseMetaData data) {
            if (connection == null) {
                MsMetadataWrapper.$$$reportNull$$$0(0);
            }
            if (data == null) {
                MsMetadataWrapper.$$$reportNull$$$0(1);
            }
            super(connection, data);
        }

        @Override
        public ClosableIt<Schema> schemas(@NotNull JBIterable<String> catalogs, @Nullable String current) {
            if (catalogs == null) {
                MsMetadataWrapper.$$$reportNull$$$0(2);
            }
            return ClosableIt.lazyAppendIfEmpty(MsMetadataWrapper.mssqlSchemas(catalogs.iterator(), this), () -> super.schemas(catalogs, current));
        }

        private static ClosableIt<Schema> mssqlSchemas(Iterator<String> catalogs, DatabaseMetaDataWrapper meta) {
            if (!catalogs.hasNext()) {
                return ClosableIt.empty();
            }
            return ClosableIt.lazyAppend(MsMetadataWrapper.mssqlSchemasInCatalog(DbUtil.intern((String)catalogs.next()), meta), () -> MsMetadataWrapper.mssqlSchemas(catalogs, meta));
        }

        private static ClosableIt<Schema> mssqlSchemasInCatalog(final String catalog, DatabaseMetaDataWrapper meta) {
            RemoteStatement statement = (RemoteStatement)JdbcNativeUtil.computeSafe(() -> meta.getConnection().getRemoteConnection().createStatement());
            if (statement == null) {
                return ClosableIt.empty();
            }
            ClosableIt.AutoCloseableGuard<AutoCloseable> g = ClosableIt.AutoCloseableGuard.guarded(() -> ((RemoteStatement)statement).close());
            try {
                ClosableIt<Schema> res2 = new ClosableIt.ResultSetDelegateIt<Schema>((RemoteResultSet)JdbcNativeUtil.computeRemote(() -> statement.executeQuery("select name from [" + catalog + "].sys.schemas")), g.get()){

                    @Override
                    protected Schema calcValue() throws SQLException {
                        return new Schema(DbUtil.intern((String)this.myRs.getString("name", 1)), catalog);
                    }
                }.withErrorSink(meta.getErrorSink());
                g.release();
                ClosableIt<Schema> closableIt = res2;
                if (g != null) {
                    g.close();
                }
                return closableIt;
            }
            catch (Throwable throwable) {
                try {
                    if (g != null) {
                        try {
                            g.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e2) {
                    LOG.debug((Throwable)e2);
                    return ClosableIt.empty();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "catalogs";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$MsMetadataWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "schemas";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AseMetadataWrapper
    extends DatabaseMetaDataWrapper {
        AseMetadataWrapper(@NotNull DatabaseConnection connection, @NotNull RemoteDatabaseMetaData data) {
            if (connection == null) {
                AseMetadataWrapper.$$$reportNull$$$0(0);
            }
            if (data == null) {
                AseMetadataWrapper.$$$reportNull$$$0(1);
            }
            super(connection, data);
        }

        @Override
        @NotNull
        public ClosableIt<? extends Table> tables(@NotNull Schema schema, @Nullable String name2, String @Nullable [] types2) throws SQLException {
            if (schema == null) {
                AseMetadataWrapper.$$$reportNull$$$0(2);
            }
            ClosableIt<? extends Table> tableIt = super.tables(schema, name2, types2);
            tableIt.filter(tab -> AseRoutineIt.isSybTableName(tab.name, tab.type));
            ClosableIt<? extends Table> closableIt = tableIt;
            if (closableIt == null) {
                AseMetadataWrapper.$$$reportNull$$$0(3);
            }
            return closableIt;
        }

        @Override
        @NotNull
        public ClosableIt<Routine> routines(@NotNull Schema schema, @Nullable String pkg, @Nullable String name2) throws SQLException {
            if (schema == null) {
                AseMetadataWrapper.$$$reportNull$$$0(4);
            }
            ClosableIt<Routine> routineIt = super.routines(schema, pkg, name2);
            ClosableIt<Routine> closableIt = this.append(routineIt, () -> this.sybaseTableRoutines(schema, name2));
            if (closableIt == null) {
                AseMetadataWrapper.$$$reportNull$$$0(5);
            }
            return closableIt;
        }

        @Override
        @NotNull
        public ClosableIt<RoutineArgument> routineArgumentsInner(@NotNull Schema schema, @Nullable String routineName, @NotNull Function<Routine, DasRoutine.Kind> kindProvider) throws SQLException {
            if (schema == null) {
                AseMetadataWrapper.$$$reportNull$$$0(6);
            }
            if (kindProvider == null) {
                AseMetadataWrapper.$$$reportNull$$$0(7);
            }
            ClosableIt<RoutineArgument> argumentIt = super.routineArgumentsInner(schema, routineName, kindProvider);
            ClosableIt<RoutineArgument> closableIt = this.append(argumentIt, () -> this.sybaseRoutineArguments(schema, routineName));
            if (closableIt == null) {
                AseMetadataWrapper.$$$reportNull$$$0(8);
            }
            return closableIt;
        }

        @NotNull
        private ClosableIt<Routine> sybaseTableRoutines(@NotNull Schema schema, @Nullable String name2) throws SQLException {
            if (schema == null) {
                AseMetadataWrapper.$$$reportNull$$$0(9);
            }
            ClosableIt<? extends Table> tables = this.tablesInner(schema, name2, new String[]{"SYSTEM TABLE"});
            tables.filter(tab -> !AseRoutineIt.isSybTableName(tab.name, tab.type));
            return new AseRoutineIt(schema, (Iterator<? extends Table>)((Object)tables));
        }

        private ClosableIt<RoutineArgument> sybaseRoutineArguments(@NotNull Schema schema, @Nullable String name2) throws SQLException {
            if (schema == null) {
                AseMetadataWrapper.$$$reportNull$$$0(10);
            }
            return new AseRoutineArgumentIt(schema, (Iterator<? extends TableColumn>)((Object)this.getTableColumnsInner(schema, name2, null)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schema";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$AseMetadataWrapper";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kindProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$AseMetadataWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tables";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "routines";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "routineArgumentsInner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "tables";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "routines";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "routineArgumentsInner";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "sybaseTableRoutines";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "sybaseRoutineArguments";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PgMetadataWrapper
    extends DatabaseMetaDataWrapper {
        PgMetadataWrapper(@NotNull DatabaseConnection connection, @NotNull RemoteDatabaseMetaData data) {
            if (connection == null) {
                PgMetadataWrapper.$$$reportNull$$$0(0);
            }
            if (data == null) {
                PgMetadataWrapper.$$$reportNull$$$0(1);
            }
            super(connection, data);
        }

        @Override
        protected ClosableIt<String> catalogs() throws SQLException {
            RemoteStatement statement = (RemoteStatement)JdbcNativeUtil.computeRemote(() -> this.getConnection().getRemoteConnection().createStatement());
            if (statement == null) {
                return ClosableIt.empty();
            }
            ClosableIt.AutoCloseableGuard<AutoCloseable> g = ClosableIt.AutoCloseableGuard.guarded(() -> ((RemoteStatement)statement).close());
            try {
                ClosableIt<String> res2 = new ClosableIt.ResultSetDelegateIt<String>((RemoteResultSet)JdbcNativeUtil.computeRemote(() -> statement.executeQuery("select datname as name from pg_catalog.pg_database where not datistemplate")), g.get()){

                    @Override
                    protected String calcValue() throws SQLException {
                        return this.myRs.getString("name", 1);
                    }
                }.withErrorSink(this.getErrorSink());
                g.release();
                ClosableIt<String> closableIt = res2;
                if (g != null) {
                    g.close();
                }
                return closableIt;
            }
            catch (Throwable throwable) {
                try {
                    if (g != null) {
                        try {
                            g.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e2) {
                    LOG.debug((Throwable)e2);
                    return super.catalogs();
                }
            }
        }

        @Override
        @NotNull
        public ClosableIt<? extends Table> tables(@NotNull Schema schema, @Nullable String name2, String @Nullable [] types2) throws SQLException {
            if (schema == null) {
                PgMetadataWrapper.$$$reportNull$$$0(2);
            }
            ClosableIt<? extends Table> tableIt = super.tables(schema, name2, types2);
            tableIt.filter(tab -> !"INDEX".equals(tab.type));
            ClosableIt<? extends Table> closableIt = tableIt;
            if (closableIt == null) {
                PgMetadataWrapper.$$$reportNull$$$0(3);
            }
            return closableIt;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schema";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$PgMetadataWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$PgMetadataWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "tables";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RoutineArgument
    extends TypedElement {
        public final Routine routine;
        public int position;
        @Nullable
        public String name;
        @Nullable
        public String def;
        public ArgumentDirection direction;
        @Nullable
        public String comment;

        public RoutineArgument(@NotNull Routine routine2) {
            if (routine2 == null) {
                RoutineArgument.$$$reportNull$$$0(0);
            }
            this.routine = routine2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$RoutineArgument", "<init>"));
        }
    }

    public static class Routine
    implements Assignable<Routine> {
        public final Schema schema;
        @Nullable
        public String pkg;
        @NotNull
        public String name;
        public short number;
        @NotNull
        public String specificName;
        @Nullable
        public String comment;
        @NotNull
        public DasRoutine.Kind kind;

        public Routine(@NotNull Schema schema, @Nullable String pkg, @NotNull String name2) {
            if (schema == null) {
                Routine.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                Routine.$$$reportNull$$$0(1);
            }
            this.number = 0;
            this.specificName = "";
            this.kind = DasRoutine.Kind.NONE;
            this.schema = schema;
            this.pkg = pkg;
            this.name = name2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "schema";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$Routine";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UserDefinedTypeAttribute
    implements Assignable<UserDefinedTypeAttribute> {
        public final UserDefinedType userDefinedType;
        @Nullable
        public String name;
        public int type;
        @Nullable
        public String typeName;
        @Nullable
        public String comment;
        public int length;
        public int scale;
        public boolean nullable;
        @Nullable
        public String def;
        public int position;

        public UserDefinedTypeAttribute(@NotNull UserDefinedType userDefinedType) {
            if (userDefinedType == null) {
                UserDefinedTypeAttribute.$$$reportNull$$$0(0);
            }
            this.userDefinedType = userDefinedType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userDefinedType", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$UserDefinedTypeAttribute", "<init>"));
        }
    }

    public static class UserDefinedType
    implements Assignable<UserDefinedType> {
        public final Schema schema;
        @Nullable
        public String name;
        @Nullable
        public String comment;

        public UserDefinedType(@NotNull Schema schema) {
            if (schema == null) {
                UserDefinedType.$$$reportNull$$$0(0);
            }
            this.schema = schema;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$UserDefinedType", "<init>"));
        }
    }

    public static class Type
    implements Assignable<Type> {
        @Nullable
        public String name;
    }

    public static class TableIndexColumn
    implements Assignable<TableIndexColumn> {
        public final TableIndex index;
        @Nullable
        public String name;
        public short position;
        public DasIndex.Sorting sorting;

        public TableIndexColumn(@NotNull TableIndex index2) {
            if (index2 == null) {
                TableIndexColumn.$$$reportNull$$$0(0);
            }
            this.index = index2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$TableIndexColumn", "<init>"));
        }
    }

    public static class TableFKeyColumn
    implements Assignable<TableFKeyColumn> {
        public final TableFKey fk;
        @Nullable
        public String name;
        @Nullable
        public String targetName;
        public short position;

        public TableFKeyColumn(@NotNull TableFKey fk) {
            if (fk == null) {
                TableFKeyColumn.$$$reportNull$$$0(0);
            }
            this.fk = fk;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fk", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$TableFKeyColumn", "<init>"));
        }
    }

    public static class TableKeyColumn
    implements Assignable<TableKeyColumn> {
        public final TableKey key;
        @Nullable
        public String name;
        public short position;

        public TableKeyColumn(@NotNull TableKey key2) {
            if (key2 == null) {
                TableKeyColumn.$$$reportNull$$$0(0);
            }
            this.key = key2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$TableKeyColumn", "<init>"));
        }
    }

    public static class TableIndex
    implements Assignable<TableIndex> {
        public final Table table;
        @Nullable
        public String name;
        public boolean nonUnique;
        @Nullable
        public String qualifier;
        public short type;
        @Nullable
        public String condition;

        public TableIndex(@NotNull Table table, @Nullable String name2) {
            if (table == null) {
                TableIndex.$$$reportNull$$$0(0);
            }
            this.table = table;
            this.name = name2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$TableIndex", "<init>"));
        }
    }

    public static class TableFKey
    implements Assignable<TableFKey> {
        public final Table table;
        public final Table targetTable;
        @Nullable
        public String name;
        public boolean surrogateName;
        public short updateRule;
        public short deleteRule;
        public short deferrability;

        public TableFKey(@NotNull Table table, @NotNull Table targetTable, @Nullable String name2) {
            if (table == null) {
                TableFKey.$$$reportNull$$$0(0);
            }
            if (targetTable == null) {
                TableFKey.$$$reportNull$$$0(1);
            }
            this.table = table;
            this.targetTable = targetTable;
            this.name = name2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "table";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetTable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$TableFKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TableKey
    implements Assignable<TableKey> {
        public final Table table;
        @Nullable
        public String name;
        public boolean primary;

        public TableKey(@NotNull Table table, @Nullable String name2) {
            if (table == null) {
                TableKey.$$$reportNull$$$0(0);
            }
            this.table = table;
            this.name = name2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$TableKey", "<init>"));
        }
    }

    public static class TableColumn
    extends TypedElement {
        public final Table table;
        public int position;
        @Nullable
        public String name;
        @Nullable
        public String def;
        public boolean autoIncrement;
        @Nullable
        public String comment;

        public TableColumn(@NotNull Table table) {
            if (table == null) {
                TableColumn.$$$reportNull$$$0(0);
            }
            this.table = table;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$TableColumn", "<init>"));
        }
    }

    public static class Table
    implements Assignable<Table> {
        public final Schema schema;
        @NotNull
        public String name;
        @Nullable
        public String type;
        @Nullable
        public String comment;

        public Table(@NotNull Schema schema, @NotNull String name2) {
            if (schema == null) {
                Table.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                Table.$$$reportNull$$$0(1);
            }
            this.schema = schema;
            this.name = name2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "schema";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$Table";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TypedElement
    extends JdbcHelper.Type
    implements Assignable<TypedElement> {
    }

    public static class Schema
    implements Assignable<Schema> {
        @NotNull
        public String schema;
        @Nullable
        public String database;

        public Schema(@NotNull String schema, @Nullable String database) {
            if (schema == null) {
                Schema.$$$reportNull$$$0(0);
            }
            this.schema = schema;
            this.database = database;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$Schema", "<init>"));
        }
    }

    public static interface Assignable<T extends Assignable<T>> {
        default public void assign(T val) {
            try {
                for (Field field : this.getClass().getFields()) {
                    if (Modifier.isFinal(field.getModifiers())) continue;
                    Object o2 = field.get(val);
                    if (Assignable.class.isAssignableFrom(field.getType())) {
                        ((Assignable)field.get(this)).assign((Assignable)o2);
                        continue;
                    }
                    field.set(this, o2);
                }
            }
            catch (IllegalAccessException e2) {
                ExceptionUtil.rethrow((Throwable)e2);
            }
        }
    }
}

